/*
 * Decompiled with CFR 0.152.
 */
package fr.pasteur.sysbio.rdfscape.cytomapper;

import fr.pasteur.sysbio.rdfscape.AbstractModulePanel;
import fr.pasteur.sysbio.rdfscape.RDFScape;
import fr.pasteur.sysbio.rdfscape.Utilities;
import fr.pasteur.sysbio.rdfscape.cytomapper.CytoMapper;
import fr.pasteur.sysbio.rdfscape.help.HelpManager;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.TitledBorder;

public class CytoMapperPanel
extends AbstractModulePanel {
    private CytoMapper cytoMapper = null;
    private JButton mapButton = null;
    private JButton linkDataButton = null;
    private JProgressBar ontologyCoverage = null;
    private JProgressBar graphCoverage = null;
    JProgressBar ontologyDataCoverage = null;
    JProgressBar dataOntologyCoverage = null;

    public CytoMapperPanel(CytoMapper cytoMapper) {
        this.redLightText = "<html>No ontologies correctly loaded are present</html>";
        this.yellowLightText = "<html>No valid mapping processed</html>";
        this.greenLightText = "<html>You can now plot your ontologies to the network for which you have a valid mapping</html>";
        this.myTabText = "Map ontologies on my network";
        this.myTabTooltip = "<html>Associate ontologies to a generic network in Cytoscape</html>";
        this.cytoMapper = cytoMapper;
        this.mapButton = new JButton("Map");
        this.linkDataButton = new JButton("Link data");
        this.linkDataButton.setEnabled(false);
        this.ontologyCoverage = new JProgressBar();
        this.graphCoverage = new JProgressBar();
        this.ontologyDataCoverage = new JProgressBar();
        this.dataOntologyCoverage = new JProgressBar();
        this.ontologyCoverage.setBorder(new TitledBorder("URIs to nodes"));
        this.graphCoverage.setBorder(new TitledBorder("Nodes to URIs"));
        this.ontologyDataCoverage.setBorder(new TitledBorder("URIs to data"));
        this.dataOntologyCoverage.setBorder(new TitledBorder("data to URIs"));
        this.graphCoverage.setMinimum(0);
        this.graphCoverage.setStringPainted(true);
        this.ontologyDataCoverage.setMinimum(0);
        this.ontologyDataCoverage.setStringPainted(true);
        this.ontologyCoverage.setMinimum(0);
        this.ontologyCoverage.setStringPainted(true);
        this.dataOntologyCoverage.setStringPainted(true);
        this.add(this.mapButton);
        this.add(this.linkDataButton);
        this.add(this.ontologyCoverage);
        this.add(this.graphCoverage);
        this.add(this.ontologyDataCoverage);
        this.add(this.dataOntologyCoverage);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CytoMapperPanel.this.initOntology2GraphBars();
                CytoMapperPanel.this.cytoMapper.map();
                this.updateOntology2GraphBars();
                CytoMapperPanel.this.linkDataButton.setEnabled(true);
            }

            private void updateOntology2GraphBars() {
                CytoMapperPanel.this.ontologyCoverage.setValue(CytoMapperPanel.this.cytoMapper.getNumberOfMatchedURIs());
                CytoMapperPanel.this.graphCoverage.setValue(CytoMapperPanel.this.cytoMapper.getNumberOfMatchedIDs());
            }
        };
        this.mapButton.addActionListener(actionListener);
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (CytoMapperPanel.this.cytoMapper.preLinkData()) {
                    CytoMapperPanel.this.initLinkBars();
                    CytoMapperPanel.this.cytoMapper.linkData();
                    this.updateLinkGraphBars();
                }
            }

            private void updateLinkGraphBars() {
                CytoMapperPanel.this.ontologyDataCoverage.setValue(CytoMapperPanel.this.cytoMapper.getNumberOfURIWithData());
                CytoMapperPanel.this.dataOntologyCoverage.setValue(CytoMapperPanel.this.cytoMapper.getNumberOfDataExtracted());
            }
        };
        this.linkDataButton.addActionListener(actionListener2);
    }

    public void initOntology2GraphBars() {
        this.ontologyCoverage.setMaximum(this.cytoMapper.getNumberOfURIsToBeMatched());
        this.ontologyCoverage.setValue(0);
        this.graphCoverage.setMaximum(this.cytoMapper.getNumberOfNodesToBeMatched());
        this.graphCoverage.setValue(0);
    }

    public void initLinkBars() {
        this.ontologyDataCoverage.setValue(0);
        this.ontologyDataCoverage.setMaximum(this.cytoMapper.getNumberOfURIsToBeMatched());
        this.dataOntologyCoverage.setValue(0);
        this.dataOntologyCoverage.setMaximum(this.cytoMapper.getNumberOfAvailableData());
    }

    public String getHelpLink() {
        return "http://www.bioinformatics.org/rdfscape/wiki/Main/LinkingGraphsInCytoscapeAndOntologies";
    }

    public JPanel getHelpPanel() {
        JPanel jPanel = new JPanel();
        JLabel jLabel = null;
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jLabel = new JLabel("<html><ul><li><b>Map</b> uri for which an association was found in the <b>Mapping ontologies on Cytoscape Networks</b> configuration panel. Note that execution of the configuration settings in this panel is not automatic.</li><li><b>Link</b> ontologies to microarray data in Cytoscape. This opertion is activated after <b>Map</b> is executed. However, data linked to the ontology is the datsa present in Cytoscape, not necessarily visualized in the current network.</li></ul></html>", Utilities.getHelpIcon("cytoMapperExecButtons.png"), 2);
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 200));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jLabel = new JLabel("<html>The percentage of the URIs for which a mapping was specified that found a node in the current network.</html>", Utilities.getHelpIcon("uriToNodes.png"), 2);
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 200));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jLabel = new JLabel("<html>The percentage of nodes in this network to which an URI was associated.</html>", Utilities.getHelpIcon("nodesToURI.png"), 2);
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 200));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jLabel = new JLabel("<html>The percentage of URIs for which a mapping was specified that can be associated to microarray data (<b>note: this does not take into account mapping to the Cytoscape network</b>!!! these two values can potentially be independent)</html>", Utilities.getHelpIcon("uriToData.png"), 2);
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 200));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jLabel = new JLabel("<html>The percentage of available microarray data thatcan be associated to URIs.</html>", Utilities.getHelpIcon("dataToURIs.png"), 2);
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 200));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        return jPanel;
    }

    public String getPanelName() {
        return "Mapping to Cytoscape";
    }

    public int getStatusLevel() {
        if (!RDFScape.getOntologyManager().ontologiesPresentAndCorrectlyLoaded() || this.cytoMapper.getNumberOfMappingRules() == 0) {
            return 1;
        }
        if (this.cytoMapper.getNumberOfMatchedIDs() + this.cytoMapper.getNumberOfMatchedURIs() > 0) {
            return 2;
        }
        return 3;
    }

    public void refresh() {
    }
}

