/*
 * Decompiled with CFR 0.152.
 */
package fr.pasteur.sysbio.rdfscape.cytoscape;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.view.CyNetworkView;
import ding.view.EdgeContextMenuListener;
import ding.view.NodeContextMenuListener;
import fr.pasteur.sysbio.rdfscape.CommonMemory;
import fr.pasteur.sysbio.rdfscape.DefaultSettings;
import fr.pasteur.sysbio.rdfscape.RDFScape;
import fr.pasteur.sysbio.rdfscape.Utilities;
import fr.pasteur.sysbio.rdfscape.cytoscape.MyExtAction;
import fr.pasteur.sysbio.rdfscape.knowledge.KnowledgeWrapper;
import fr.pasteur.sysbio.rdfscape.query.AbstractQueryResultTable;
import fr.pasteur.sysbio.rdfscape.query.GraphQueryAnswerer;
import fr.pasteur.sysbio.rdfscape.query.RDQLQueryAnswerer;
import giny.model.Edge;
import giny.view.EdgeView;
import giny.view.NodeView;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class PatternMenu
implements NodeContextMenuListener,
EdgeContextMenuListener {
    private static int uniqueID = 0;

    public void addNodeContextMenuItems(NodeView nodeView, JPopupMenu jPopupMenu) {
        JMenuItem jMenuItem;
        System.out.println("Node Context Menu Activated");
        if (RDFScape.getCytoscapeDealer().isEditable()) {
            System.out.print("\tbuilding node-edit block : ");
            if (!RDFScape.getCytoscapeDealer().isVariable(nodeView)) {
                jMenuItem = PatternMenu.makeNodeVar(nodeView);
                jPopupMenu.add(jMenuItem);
            } else {
                if (RDFScape.getCommonMemory().cyNodeIsLiteral((CyNode)nodeView.getNode())) {
                    jMenuItem = PatternMenu.makeNodeFilter(nodeView);
                    jPopupMenu.add(jMenuItem);
                }
                jMenuItem = PatternMenu.unMakeNodeVar(nodeView);
                jPopupMenu.add(jMenuItem);
            }
        }
        jMenuItem = PatternMenu.extendNetwork(nodeView);
        jPopupMenu.add(jMenuItem);
        System.out.println("Ok");
    }

    public void addEdgeContextMenuItems(EdgeView edgeView, JPopupMenu jPopupMenu) {
        System.out.println("Edge Context Menu Activated");
        if (RDFScape.getCytoscapeDealer().isEditable()) {
            System.out.print("\tbuilding edge-edit block : ");
            if (!RDFScape.getCytoscapeDealer().isVariable(edgeView)) {
                JMenuItem jMenuItem = PatternMenu.makeEdgeVar(edgeView);
                jPopupMenu.add(jMenuItem);
            } else {
                JMenuItem jMenuItem = PatternMenu.unMakeEdgeVar(edgeView);
                jPopupMenu.add(jMenuItem);
            }
        }
        System.out.println("Ok");
    }

    public static JMenuItem makeNodeVar(NodeView nodeView) {
        System.out.print(" make");
        JMenuItem jMenuItem = new JMenuItem("Make variable");
        CyNode cyNode = (CyNode)nodeView.getNode();
        jMenuItem.addActionListener(new MyMakeNodeVarListener(cyNode));
        System.out.print("Var ");
        return jMenuItem;
    }

    public static JMenuItem unMakeNodeVar(NodeView nodeView) {
        System.out.print("unmake");
        JMenuItem jMenuItem = new JMenuItem("Restore node");
        CyNode cyNode = (CyNode)nodeView.getNode();
        jMenuItem.addActionListener(new MyUnMakeNodeVarListener(cyNode));
        System.out.print("Var ");
        return jMenuItem;
    }

    public static JMenuItem makeNodeFilter(NodeView nodeView) {
        System.out.print("node");
        JMenuItem jMenuItem = new JMenuItem("Add filter");
        CyNode cyNode = (CyNode)nodeView.getNode();
        jMenuItem.addActionListener(new MyMakeNodeFilterListener(cyNode));
        System.out.print("Filter ");
        return jMenuItem;
    }

    public static JMenu extendNetwork(NodeView nodeView) {
        int n;
        Object object;
        JMenu jMenu = new JMenu("Extend");
        CyNetworkView cyNetworkView = RDFScape.getCytoscapeDealer().getCurrentNetworkView();
        CommonMemory commonMemory = RDFScape.getCommonMemory();
        KnowledgeWrapper knowledgeWrapper = RDFScape.getKnowledgeEngine();
        CyNode cyNode = (CyNode)nodeView.getNode();
        CyAttributes cyAttributes = Cytoscape.getNodeAttributes();
        if (cyAttributes.hasAttribute(cyNode.getIdentifier(), "VAR")) {
            System.out.println("This is  a var!!!");
            jMenu.setEnabled(false);
            return jMenu;
        }
        RDQLQueryAnswerer rDQLQueryAnswerer = null;
        GraphQueryAnswerer graphQueryAnswerer = null;
        try {
            rDQLQueryAnswerer = (RDQLQueryAnswerer)((Object)knowledgeWrapper);
        }
        catch (Exception exception) {
            System.out.println("Only RDQL is supported now by extend functionalities");
            return jMenu;
        }
        AbstractQueryResultTable abstractQueryResultTable = null;
        AbstractQueryResultTable abstractQueryResultTable2 = null;
        if (!(commonMemory.cyNodeIsURI(cyNode) || commonMemory.cyNodeIsBlank(cyNode) || commonMemory.cyNodeIsLiteral(cyNode))) {
            System.out.println("This node doesn't come from me... maybe you want to run cytomapper...");
            jMenu.setEnabled(false);
            jMenu.add(new JMenuItem("Unknown to reasoner"));
            return jMenu;
        }
        if (commonMemory.cyNodeIsURI(cyNode)) {
            if (KnowledgeWrapper.hasRDQLSupport(knowledgeWrapper)) {
                rDQLQueryAnswerer = (RDQLQueryAnswerer)((Object)knowledgeWrapper);
                System.out.println("Node is URI");
                object = commonMemory.getURIFromCyNode(cyNode);
                String string = "select ?x ?y\n WHERE (?x ?y <" + (String)object + ">)";
                String string2 = "select ?x ?y\n WHERE (<" + (String)object + "> ?x ?y )";
                abstractQueryResultTable = rDQLQueryAnswerer.makeRDQLQuery(string);
                abstractQueryResultTable2 = rDQLQueryAnswerer.makeRDQLQuery(string2);
            } else {
                System.out.println("Could not find a reasoner I can ask how to move from a URI");
            }
        } else if (commonMemory.cyNodeIsBlank(cyNode)) {
            if (KnowledgeWrapper.hasGraphAccessSupport(knowledgeWrapper)) {
                System.out.println("Node is blank");
                graphQueryAnswerer = (GraphQueryAnswerer)((Object)knowledgeWrapper);
                object = commonMemory.getBNodeForCyNode(cyNode);
                if (object != null) {
                    abstractQueryResultTable = graphQueryAnswerer.getLeftOfNode(object);
                    abstractQueryResultTable2 = graphQueryAnswerer.getRightOfNode(object);
                } else {
                    System.out.println("I don't remember anything about this blank node");
                }
            } else {
                System.out.println("Could not find a reasoner I can ask how to move from a blank node");
            }
        } else if (commonMemory.cyNodeIsLiteral(cyNode)) {
            if (KnowledgeWrapper.hasGraphAccessSupport(knowledgeWrapper)) {
                System.out.println("Node is Literal");
                graphQueryAnswerer = (GraphQueryAnswerer)((Object)knowledgeWrapper);
                object = commonMemory.getLiteralNodeForCyNode(cyNode);
                if (object != null) {
                    abstractQueryResultTable = graphQueryAnswerer.getLeftOfNode(object);
                    abstractQueryResultTable2 = graphQueryAnswerer.getRightOfNode(object);
                } else {
                    System.out.println("I don't remember anything about this Literal");
                }
            } else {
                System.out.println("Could not find a reasoner I can ask how to move from literal");
            }
        }
        System.out.println("Making the menu");
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (abstractQueryResultTable != null) {
            n3 = abstractQueryResultTable.getRowCount();
        }
        if (abstractQueryResultTable2 != null) {
            n4 = abstractQueryResultTable2.getRowCount();
        }
        n2 = n3 + n4;
        int n5 = 40;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = commonMemory.isNamespaceConditionInAnd();
        System.out.println("Namespace selection mode: " + bl4);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        System.out.println("Incoming total " + n3);
        for (int i = 0; i < n3; ++i) {
            if (bl4) {
                if (!abstractQueryResultTable.isNamespaceSelected(i, 0) || !abstractQueryResultTable.isNamespaceSelected(i, 1)) continue;
                arrayList.add(new Integer(i));
                continue;
            }
            if (!abstractQueryResultTable.isNamespaceSelected(i, 0) && !abstractQueryResultTable.isNamespaceSelected(i, 1)) continue;
            arrayList.add(new Integer(i));
        }
        int[] nArray = new int[arrayList.size()];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = (Integer)arrayList.get(n);
        }
        System.out.println("Valid :" + nArray.length);
        abstractQueryResultTable = abstractQueryResultTable.getSubsetByRows(nArray);
        arrayList = new ArrayList();
        System.out.println("Outgoing total " + n4);
        for (n = 0; n < n4; ++n) {
            if (bl4) {
                if (!abstractQueryResultTable2.isNamespaceSelected(n, 0) || !abstractQueryResultTable2.isNamespaceSelected(n, 1)) continue;
                arrayList.add(new Integer(n));
                continue;
            }
            if (!abstractQueryResultTable2.isNamespaceSelected(n, 0) && !abstractQueryResultTable2.isNamespaceSelected(n, 1)) continue;
            arrayList.add(new Integer(n));
        }
        nArray = new int[arrayList.size()];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = (Integer)arrayList.get(n);
        }
        System.out.println("Valid :" + nArray.length);
        abstractQueryResultTable2 = abstractQueryResultTable2.getSubsetByRows(nArray);
        n3 = abstractQueryResultTable.getRowCount();
        n4 = abstractQueryResultTable2.getRowCount();
        n2 = n3 + n4;
        if (n3 > 0) {
            JMenu jMenu2 = PatternMenu.ExtendNetworkItem(abstractQueryResultTable, cyNode, true, commonMemory, knowledgeWrapper);
            jMenu.add(jMenu2);
        }
        if (n4 > 0) {
            JMenu jMenu3 = PatternMenu.ExtendNetworkItem(abstractQueryResultTable2, cyNode, false, commonMemory, knowledgeWrapper);
            jMenu.add(jMenu3);
        }
        return jMenu;
    }

    public static JMenu ExtendNetworkItem(AbstractQueryResultTable abstractQueryResultTable, CyNode cyNode, boolean bl, int n, int n2, CommonMemory commonMemory, KnowledgeWrapper knowledgeWrapper) {
        JMenuItem jMenuItem;
        MyExtAction myExtAction;
        String string;
        int n3;
        String string2 = "->me ";
        if (!bl) {
            string2 = "me->";
        }
        JMenu jMenu = new JMenu(string2 + " (" + n + "," + n2 + ")");
        if (bl) {
            for (n3 = n; n3 < n2; ++n3) {
                System.out.println("->" + n3);
                if ((!commonMemory.isNamespaceConditionInAnd() || !abstractQueryResultTable.isNamespaceSelected(n3, 0) || !abstractQueryResultTable.isNamespaceSelected(n3, 1)) && (commonMemory.isNamespaceConditionInAnd() || !abstractQueryResultTable.isNamespaceSelected(n3, 0) && !abstractQueryResultTable.isNamespaceSelected(n3, 1))) continue;
                System.out.println("Adding");
                string = "<html><font color=" + Utilities.getNameSpaceColorHexString(DefaultSettings.translateColor2String(abstractQueryResultTable.getColor(n3, 0))) + ">" + abstractQueryResultTable.getLabel(n3, 0) + "</font>&nbsp;&nbsp;" + "<font color=" + Utilities.getNameSpaceColorHexString(DefaultSettings.translateColor2String(abstractQueryResultTable.getColor(n3, 1))) + ">" + abstractQueryResultTable.getLabel(n3, 1) + "</font>&nbsp;&nbsp;<b>Me</b></html>";
                System.out.println(string);
                myExtAction = new MyExtAction(string, cyNode, abstractQueryResultTable, true, n3, commonMemory);
                jMenuItem = new JMenuItem(myExtAction);
                jMenu.add(jMenuItem);
            }
        }
        if (!bl) {
            for (n3 = n; n3 < n2; ++n3) {
                System.out.println(n3 + "<-");
                string = "<html><b>Me</b>&nbsp;&nbsp;<font color=" + Utilities.getNameSpaceColorHexString(DefaultSettings.translateColor2String(abstractQueryResultTable.getColor(n3, 0))) + ">" + abstractQueryResultTable.getLabel(n3, 0) + "</font>&nbsp;&nbsp;" + "<font color=" + Utilities.getNameSpaceColorHexString(DefaultSettings.translateColor2String(abstractQueryResultTable.getColor(n3, 1))) + ">" + abstractQueryResultTable.getLabel(n3, 1) + "</font></html>";
                myExtAction = new MyExtAction(string, cyNode, abstractQueryResultTable, false, n3, commonMemory);
                jMenuItem = new JMenuItem(myExtAction);
                jMenu.add(jMenuItem);
            }
        }
        return jMenu;
    }

    public static JMenu ExtendNetworkItem(AbstractQueryResultTable abstractQueryResultTable, CyNode cyNode, boolean bl, CommonMemory commonMemory, KnowledgeWrapper knowledgeWrapper) {
        JMenuItem jMenuItem;
        MyExtAction myExtAction;
        String string;
        JMenu jMenu;
        String string2;
        Object object2;
        Hashtable<Object, JMenu> hashtable;
        String string3 = "";
        if (bl) {
            string3 = "<html><b>Me</b> <i>(object)</i></html>";
        }
        if (!bl) {
            string3 = "<html><b>Me</b> <i>(subject)</i></html>)";
        }
        JMenu jMenu2 = new JMenu(string3);
        if (bl) {
            hashtable = new Hashtable<Object, JMenu>();
            System.out.println("--> Node As Object");
            for (int i = 0; i < abstractQueryResultTable.getRowCount(); ++i) {
                System.out.println("(o) result #" + i);
                object2 = abstractQueryResultTable.getLabel(i, 1);
                string2 = "<font color=" + Utilities.getNameSpaceColorHexString(DefaultSettings.translateColor2String(abstractQueryResultTable.getColor(i, 1))) + ">" + (String)object2 + "</font>";
                jMenu = (JMenu)hashtable.get(object2);
                if (jMenu == null) {
                    jMenu = new JMenu("<html>" + string2 + "</html>");
                    hashtable.put(object2, jMenu);
                }
                string = "<html><font color=" + Utilities.getNameSpaceColorHexString(DefaultSettings.translateColor2String(abstractQueryResultTable.getColor(i, 0))) + ">" + abstractQueryResultTable.getLabel(i, 0) + "</font>&nbsp;&nbsp;" + "<font color=" + Utilities.getNameSpaceColorHexString(DefaultSettings.translateColor2String(abstractQueryResultTable.getColor(i, 1))) + ">" + abstractQueryResultTable.getLabel(i, 1) + "</font>&nbsp;&nbsp;<b>Me</b></html>";
                System.out.println(string);
                myExtAction = new MyExtAction(string, cyNode, abstractQueryResultTable, true, i, commonMemory);
                jMenuItem = new JMenuItem(myExtAction);
                jMenu.add(jMenuItem);
            }
            for (Object object2 : hashtable.values()) {
                if (((JMenu)object2).getItemCount() > 50) {
                    string2 = ((AbstractButton)object2).getText();
                    string2 = string2.substring(0, string2.indexOf("</html>")) + "&nbsp;&nbsp;<font color=red><b>Warning: " + ((JMenu)object2).getItemCount() + " items!!!</b></font></html>";
                    ((AbstractButton)object2).setText(string2);
                }
                jMenu2.add((JMenuItem)object2);
            }
        }
        if (!bl) {
            hashtable = new Hashtable();
            System.out.println("--> Node As Subject");
            for (int i = 0; i < abstractQueryResultTable.getRowCount(); ++i) {
                System.out.println("(s) result # " + i);
                object2 = abstractQueryResultTable.getLabel(i, 0);
                string2 = "<font color=" + Utilities.getNameSpaceColorHexString(DefaultSettings.translateColor2String(abstractQueryResultTable.getColor(i, 0))) + ">" + (String)object2 + "</font>";
                jMenu = (JMenu)hashtable.get(object2);
                if (jMenu == null) {
                    jMenu = new JMenu("<html>" + string2 + "</html>");
                    hashtable.put(object2, jMenu);
                }
                string = "<html><b>Me</b>&nbsp;&nbsp;<font color=" + Utilities.getNameSpaceColorHexString(DefaultSettings.translateColor2String(abstractQueryResultTable.getColor(i, 0))) + ">" + abstractQueryResultTable.getLabel(i, 0) + "</font>&nbsp;&nbsp;" + "<font color=" + Utilities.getNameSpaceColorHexString(DefaultSettings.translateColor2String(abstractQueryResultTable.getColor(i, 1))) + ">" + abstractQueryResultTable.getLabel(i, 1) + "</font></html>";
                myExtAction = new MyExtAction(string, cyNode, abstractQueryResultTable, false, i, commonMemory);
                jMenuItem = new JMenuItem(myExtAction);
                jMenu.add(jMenuItem);
            }
            for (Object object2 : hashtable.values()) {
                if (((JMenu)object2).getItemCount() > 50) {
                    string2 = ((AbstractButton)object2).getText();
                    string2 = string2.substring(0, string2.indexOf("</html>")) + "&nbsp;&nbsp;<font color=red><b>" + ((JMenu)object2).getItemCount() + " items!!!</b></font></html>";
                    ((AbstractButton)object2).setText(string2);
                }
                jMenu2.add((JMenuItem)object2);
            }
        }
        return jMenu2;
    }

    private static int max(int n, int n2) {
        if (n >= n2) {
            return n;
        }
        return n2;
    }

    private static int min(int n, int n2) {
        if (n <= n2) {
            return n;
        }
        return n2;
    }

    public static JMenuItem makeEdgeVar(EdgeView edgeView) {
        JMenuItem jMenuItem = new JMenuItem("Make variable");
        CyNetworkView cyNetworkView = RDFScape.getCytoscapeDealer().getCurrentNetworkView();
        CyNetwork cyNetwork = cyNetworkView.getNetwork();
        CyEdge cyEdge = (CyEdge)edgeView.getEdge();
        jMenuItem.addActionListener(new MyMakeEdgeVarListener(cyEdge));
        return jMenuItem;
    }

    public static JMenuItem unMakeEdgeVar(EdgeView edgeView) {
        JMenuItem jMenuItem = new JMenuItem("Restore edge");
        CyNetworkView cyNetworkView = RDFScape.getCytoscapeDealer().getCurrentNetworkView();
        CommonMemory commonMemory = RDFScape.getCommonMemory();
        CyNetwork cyNetwork = cyNetworkView.getNetwork();
        CyEdge cyEdge = (CyEdge)edgeView.getEdge();
        CyAttributes cyAttributes = Cytoscape.getEdgeAttributes();
        jMenuItem.addActionListener(new MyUnMakeEdgeVarListener(cyEdge));
        return jMenuItem;
    }

    static class MyUnMakeEdgeVarListener
    implements ActionListener {
        Edge myEdge = null;
        CyNetwork myCyNetwork = null;
        CyAttributes myEdgeAttributes = null;
        CommonMemory myMemory = null;

        public MyUnMakeEdgeVarListener(CyEdge cyEdge) {
            this.myEdge = cyEdge;
            this.myCyNetwork = RDFScape.getCytoscapeDealer().getCurrentNetwork();
            this.myEdgeAttributes = Cytoscape.getEdgeAttributes();
            this.myMemory = RDFScape.getCommonMemory();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.myEdgeAttributes.hasAttribute(this.myEdge.getIdentifier(), "VAR")) {
                this.myEdgeAttributes.deleteAttribute(this.myEdge.getIdentifier(), "VAR");
            }
            if (this.myEdgeAttributes.hasAttribute(this.myEdge.getIdentifier(), "FILTER")) {
                this.myEdgeAttributes.deleteAttribute(this.myEdge.getIdentifier(), "FILTER");
            }
            this.myEdgeAttributes.setAttribute(this.myEdge.getIdentifier(), "LABEL", this.myMemory.getLabelForURI(this.myMemory.getURIFromCyEdge((CyEdge)this.myEdge)));
            this.myEdgeAttributes.setAttribute(this.myEdge.getIdentifier(), "COLOR", DefaultSettings.translateColor2String(this.myMemory.getNamespaceColor(this.myMemory.getNamespaceFromURI(this.myMemory.getURIFromCyEdge((CyEdge)this.myEdge)))));
            Cytoscape.getCurrentNetworkView().redrawGraph(true, false);
            Cytoscape.getCurrentNetworkView().updateView();
        }
    }

    static class MyMakeEdgeVarListener
    implements ActionListener {
        Edge myEdge = null;
        CyNetwork myCyNetwork = null;
        CyAttributes myEdgeAttributes = null;

        public MyMakeEdgeVarListener(CyEdge cyEdge) {
            this.myEdge = cyEdge;
            this.myCyNetwork = RDFScape.getCytoscapeDealer().getCurrentNetwork();
            this.myEdgeAttributes = Cytoscape.getEdgeAttributes();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            uniqueID++;
            String string = "?x" + uniqueID;
            this.myEdgeAttributes.setAttribute(this.myEdge.getIdentifier(), "VAR", string);
            String string2 = "?";
            String string3 = this.myEdgeAttributes.getStringAttribute(this.myEdge.getIdentifier(), "FILTER");
            if (string3 != null) {
                string2 = string2 + "_/" + string3 + "/";
            }
            this.myEdgeAttributes.setAttribute(this.myEdge.getIdentifier(), "LABEL", string2);
            this.myEdgeAttributes.setAttribute(this.myEdge.getIdentifier(), "COLOR", "LIGHT_GRAY");
            Cytoscape.getCurrentNetworkView().redrawGraph(true, false);
            Cytoscape.getCurrentNetworkView().updateView();
        }
    }

    static class MyMakeNodeFilterListener
    implements ActionListener {
        CyNode myCyNode = null;
        CyNetwork myCyNetwork = null;
        CommonMemory myMemory = null;
        CyAttributes nodeAttributes;

        public MyMakeNodeFilterListener(CyNode cyNode) {
            this.myCyNode = cyNode;
            this.myCyNetwork = RDFScape.getCytoscapeDealer().getCurrentNetwork();
            this.myMemory = RDFScape.getCommonMemory();
            this.nodeAttributes = Cytoscape.getNodeAttributes();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.myMemory.cyNodeIsLiteral(this.myCyNode)) {
                String string = "";
                if (this.nodeAttributes.hasAttribute(this.myCyNode.getIdentifier(), "FILTER")) {
                    // empty if block
                }
                string = this.nodeAttributes.getStringAttribute(this.myCyNode.getIdentifier(), "FILTER");
                String string2 = JOptionPane.showInputDialog(RDFScape.getPanel(), "please enter your filter\n (/xxx/ format)", string);
                if (string2 != null) {
                    this.nodeAttributes.setAttribute(this.myCyNode.getIdentifier(), "FILTER", string2);
                }
                this.nodeAttributes.setAttribute(this.myCyNode.getIdentifier(), "LABEL", "?_/" + string2 + "/");
                Cytoscape.getCurrentNetworkView().redrawGraph(true, false);
                Cytoscape.getCurrentNetworkView().updateView();
            } else {
                JOptionPane.showMessageDialog(RDFScape.getPanel(), "This node does not support filters");
            }
        }
    }

    static class MyUnMakeNodeVarListener
    implements ActionListener {
        CyNode myCyNode = null;
        CyNetwork myCyNetwork = null;
        CyAttributes nodeAttributes = null;
        CommonMemory myMemory = RDFScape.getCommonMemory();

        public MyUnMakeNodeVarListener(CyNode cyNode) {
            this.myCyNode = cyNode;
            this.myCyNetwork = RDFScape.getCytoscapeDealer().getCurrentNetwork();
            this.nodeAttributes = Cytoscape.getNodeAttributes();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.nodeAttributes.hasAttribute(this.myCyNode.getIdentifier(), "VAR")) {
                this.nodeAttributes.deleteAttribute(this.myCyNode.getIdentifier(), "VAR");
            }
            if (this.nodeAttributes.hasAttribute(this.myCyNode.getIdentifier(), "FILTER")) {
                this.nodeAttributes.deleteAttribute(this.myCyNode.getIdentifier(), "FILTER");
            }
            if (this.myMemory.cyNodeIsURI(this.myCyNode)) {
                this.nodeAttributes.setAttribute(this.myCyNode.getIdentifier(), "LABEL", this.myMemory.getLabelForURI(this.myMemory.getURIFromCyNode(this.myCyNode)));
                this.nodeAttributes.setAttribute(this.myCyNode.getIdentifier(), "COLOR", DefaultSettings.translateColor2String(this.myMemory.getNamespaceColor(this.myMemory.getNamespaceFromURI(this.myMemory.getURIFromCyNode(this.myCyNode)))));
            }
            if (this.myMemory.cyNodeIsBlank(this.myCyNode)) {
                this.nodeAttributes.setAttribute(this.myCyNode.getIdentifier(), "LABEL", "B");
                this.nodeAttributes.setAttribute(this.myCyNode.getIdentifier(), "COLOR", "LIGHT_GRAY");
            }
            if (this.myMemory.cyNodeIsLiteral(this.myCyNode)) {
                Object object = this.myMemory.getLiteralNodeForCyNode(this.myCyNode);
                this.nodeAttributes.setAttribute(this.myCyNode.getIdentifier(), "LABEL", this.myMemory.getLabelForLiteralNode(object));
                this.nodeAttributes.setAttribute(this.myCyNode.getIdentifier(), "COLOR", DefaultSettings.translateColor2String(this.myMemory.getNamespaceColor(this.myMemory.getNamespaceFromURI(this.myMemory.getDatatypeURIFromLiteralNode(object)))));
            }
            Cytoscape.getCurrentNetworkView().redrawGraph(true, false);
            Cytoscape.getCurrentNetworkView().updateView();
        }
    }

    static class MyMakeNodeVarListener
    implements ActionListener {
        CyNode myCyNode = null;
        CyNetwork myCyNetwork = null;
        CyAttributes nodeAttributes = null;
        RDFScape myRDFScapeInstance = null;

        public MyMakeNodeVarListener(CyNode cyNode) {
            this.myCyNode = cyNode;
            this.myCyNetwork = RDFScape.getCytoscapeDealer().getCurrentNetwork();
            this.nodeAttributes = Cytoscape.getNodeAttributes();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            uniqueID++;
            String string = "?x" + uniqueID;
            this.nodeAttributes.setAttribute(this.myCyNode.getIdentifier(), "VAR", string);
            String string2 = "?";
            String string3 = this.nodeAttributes.getStringAttribute(this.myCyNode.getIdentifier(), "FILTER");
            if (string3 != null) {
                string2 = string2 + "_/" + string3 + "/";
            }
            this.nodeAttributes.setAttribute(this.myCyNode.getIdentifier(), "LABEL", string2);
            this.nodeAttributes.setAttribute(this.myCyNode.getIdentifier(), "COLOR", "LIGHT_GRAY");
            Cytoscape.getCurrentNetworkView().redrawGraph(true, false);
            Cytoscape.getCurrentNetworkView().updateView();
        }
    }
}

