/*
 * Decompiled with CFR 0.152.
 */
package fr.pasteur.sysbio.rdfscape.namespacemanagement;

import fr.pasteur.sysbio.rdfscape.AbstractModulePanel;
import fr.pasteur.sysbio.rdfscape.Utilities;
import fr.pasteur.sysbio.rdfscape.help.HelpManager;
import fr.pasteur.sysbio.rdfscape.namespacemanagement.NamespaceManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class NameSpaceManagerPanel
extends AbstractModulePanel {
    NamespaceManager nameSpaceManager = null;
    JTable nameSpaceTable = null;

    public NameSpaceManagerPanel(NamespaceManager namespaceManager) {
        this.nameSpaceManager = namespaceManager;
        this.nameSpaceTable = new JTable(this.nameSpaceManager);
        this.redLightText = "<html>This should not happen! You are experiencing problems here... please report!</html>";
        this.yellowLightText = "<html>This should not happen! You are experiencing problems here... please report!</html>";
        this.greenLightText = "<html>You can always edit namespace settings</html>";
        this.myTabText = "Color and visilibily by namespace";
        this.myTabTooltip = "<html>Select which color associate to which namespaces, prefixes, and whether resources should bevisible or not (selection by namespace)</html>";
        JScrollPane jScrollPane = new JScrollPane(this.nameSpaceTable);
        this.setLayout(new BorderLayout());
        TableColumn tableColumn = this.nameSpaceTable.getColumnModel().getColumn(2);
        JComboBox<Color> jComboBox = new JComboBox<Color>();
        jComboBox.setEditable(false);
        Color[] colorArray = this.nameSpaceManager.getPossibleNameSpaceColors();
        for (int i = 0; i < colorArray.length; ++i) {
            jComboBox.addItem(colorArray[i]);
        }
        jComboBox.setRenderer(new ColorListRenderer());
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        tableColumn.setCellRenderer(new ColorRenderer());
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = JOptionPane.showInputDialog("Insert name space: ");
                NameSpaceManagerPanel.this.nameSpaceManager.addNewNameSpaceToMemory(string);
            }
        };
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (NameSpaceManagerPanel.this.nameSpaceTable.getSelectedRowCount() > 1 || NameSpaceManagerPanel.this.nameSpaceTable.getSelectedRowCount() == 0) {
                    JOptionPane.showMessageDialog(null, "please select only one name space");
                } else {
                    String string = (String)NameSpaceManagerPanel.this.nameSpaceTable.getValueAt(NameSpaceManagerPanel.this.nameSpaceTable.getSelectedRow(), 0);
                    NameSpaceManagerPanel.this.nameSpaceManager.removeNameSpace(string);
                }
            }
        };
        JButton jButton = new JButton("Add namespace");
        JButton jButton2 = new JButton("Remove namespace");
        JPanel jPanel = new JPanel();
        jButton.addActionListener(actionListener);
        jButton2.addActionListener(actionListener2);
        jPanel.add(jButton);
        jPanel.add(new JLabel("Warning"));
        jPanel.add(jButton2);
        this.add((Component)jScrollPane, "Center");
        this.add((Component)jPanel, "South");
    }

    public String getHelpLink() {
        return "http://www.bioinformatics.org/rdfscape/wiki/Main/SelectingNamespaces";
    }

    public JPanel getHelpPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JLabel jLabel = new JLabel("<html>This is the list of namespaces defined in the system. They can be either loaded from a configuration file or can be derived from ontologies. In the second case color and other attributes have default values. You can alter this list with the <b>Add namespace</b> and <b>Remove namespace</b> buttons</html>", Utilities.getHelpIcon("nameSpaceList.png"), 2);
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 200));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jLabel = new JLabel("<html>These are prefixes for namespaces. They are used in sevarl visualization and query panels in RDFScape. You can change a prefix simply by editing its fields. If two prefixes have the same string, one of the two will be changed into a default value.</html>", Utilities.getHelpIcon("nameSpacePrefixSelection.png"), 2);
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 200));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jLabel = new JLabel("<html>These are colors associated to namespaces. Select a color field to edit this association.</html>", Utilities.getHelpIcon("nameSpaceColorSelection.png"), 2);
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 200));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jLabel = new JLabel("<html>Select which namespace should be visible or not. All resources of namespaces not visible will not appear in browsing ontologies or in the result of queries.</html>", Utilities.getHelpIcon("nameSpaceSelection.png"), 2);
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 200));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jLabel = new JLabel("<html>Add a new namespace URL (this is either http:// for web accessible ontologies or <br> file:// for ontologies on the local filesystem) </html>", Utilities.getHelpIcon("addNameSpaceButton.png"), 2);
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 200));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jLabel = new JLabel("<html>Remove the selected namespace.</html>", Utilities.getHelpIcon("removeNameSpaceButton.png"), 2);
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 200));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        return jPanel;
    }

    public String getPanelName() {
        return "Namespace settings";
    }

    public int getStatusLevel() {
        return 3;
    }

    public void refresh() {
    }

    class ColorListRenderer
    extends JLabel
    implements ListCellRenderer {
        public ColorListRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setText("choose this");
            this.setBackground((Color)object);
            return this;
        }
    }

    public class ColorRenderer
    extends JLabel
    implements TableCellRenderer {
        public ColorRenderer() {
            this.setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setBackground((Color)NameSpaceManagerPanel.this.nameSpaceManager.getValueAt(n, n2));
            return this;
        }
    }
}

