/*
 * Decompiled with CFR 0.152.
 */
package fr.pasteur.sysbio.rdfscape.namespacemanagement;

import com.ibm.icu.util.StringTokenizer;
import fr.pasteur.sysbio.rdfscape.Contextualizable;
import fr.pasteur.sysbio.rdfscape.DefaultSettings;
import fr.pasteur.sysbio.rdfscape.MemoryViewer;
import fr.pasteur.sysbio.rdfscape.RDFScape;
import fr.pasteur.sysbio.rdfscape.RDFScapeModuleInterface;
import fr.pasteur.sysbio.rdfscape.namespacemanagement.NameSpaceManagerPanel;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.regex.Pattern;
import javax.swing.table.AbstractTableModel;

public class NamespaceManager
extends AbstractTableModel
implements RDFScapeModuleInterface,
Contextualizable,
MemoryViewer {
    private Pattern nonNamespacePattern = null;
    private NameSpaceManagerPanel myPanel = null;
    private int nsSeed;

    public NamespaceManager() throws Exception {
        System.out.print("\tNamesapaceMAnager... ");
        if (RDFScape.getContextManager() == null) {
            throw new Exception("Cannot build NamespaceManager: Missing Common Memory!");
        }
        if (RDFScape.getCommonMemory() == null) {
            throw new Exception("Cannot build NamespaceManager: Missing Context Manager!");
        }
        RDFScape.getContextManager().addContextualizableElement(this);
        RDFScape.getCommonMemory().addViewerElement(this);
        this.nsSeed = 0;
        this.initialize();
        System.out.println("Ok");
    }

    public boolean initialize() {
        RDFScape.getCommonMemory().initNamespaces();
        return true;
    }

    public void reset() {
        this.initialize();
        this.nsSeed = 0;
    }

    public NameSpaceManagerPanel getNameSpaceManagerPanel() {
        this.myPanel = new NameSpaceManagerPanel(this);
        return this.myPanel;
    }

    public int getColumnCount() {
        return 4;
    }

    public String getColumnName(int n) {
        if (n == 0) {
            return "Namespace";
        }
        if (n == 1) {
            return "Prefix";
        }
        if (n == 2) {
            return "Color";
        }
        if (n == 3) {
            return "View";
        }
        return "";
    }

    public int getRowCount() {
        return RDFScape.getCommonMemory().getNamespaces().length;
    }

    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return RDFScape.getCommonMemory().getNamespaceNumber(n);
        }
        if (n2 == 1) {
            return RDFScape.getCommonMemory().getPrefixFromNs(RDFScape.getCommonMemory().getNamespaceNumber(n));
        }
        if (n2 == 2) {
            return RDFScape.getCommonMemory().getNamespaceColor(RDFScape.getCommonMemory().getNamespaceNumber(n));
        }
        if (n2 == 3) {
            return RDFScape.getCommonMemory().getIsActiveFromNs(RDFScape.getCommonMemory().getNamespaceNumber(n));
        }
        return null;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 1) {
            System.out.println("ns: " + RDFScape.getCommonMemory().getNamespaceNumber(n));
            System.out.println("prefix: " + object);
            RDFScape.getCommonMemory().registerPrefix(RDFScape.getCommonMemory().getNamespaceNumber(n), (String)object);
        }
        if (n2 == 2) {
            RDFScape.getCommonMemory().registerNameSpaceColor(RDFScape.getCommonMemory().getNamespaceNumber(n), (Color)object);
        }
        if (n2 == 3) {
            RDFScape.getCommonMemory().setActive(RDFScape.getCommonMemory().getNamespaceNumber(n), (Boolean)object);
        }
        this.touch();
    }

    public Class getColumnClass(int n) {
        if (n == 2) {
            return Color.class;
        }
        if (n == 3) {
            return Boolean.class;
        }
        return String.class;
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 != 0;
    }

    public Color[] getPossibleNameSpaceColors() {
        return DefaultSettings.getPossibleNameSpaceColors();
    }

    public void removeNameSpace(String string) {
        if (string == null) {
            return;
        }
        RDFScape.getCommonMemory().removeNamespace(string);
        this.fireTableDataChanged();
    }

    public boolean loadFromActiveContext() {
        this.reset();
        String string = RDFScape.getContextManager().getActiveContext().getNamespacesListFileName();
        int n = 0;
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            this.initialize();
            while ((string2 = bufferedReader.readLine()) != null) {
                System.out.println("Counter " + ++n);
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                int n2 = 0;
                String string3 = new String();
                String string4 = null;
                while (stringTokenizer.hasMoreTokens()) {
                    string4 = stringTokenizer.nextToken();
                    if (n2 == 0) {
                        string3 = string4;
                        System.out.println("1-> " + string4);
                        RDFScape.getCommonMemory().registerNameSpace(string3);
                        System.out.println("2-> " + string4);
                    }
                    if (n2 == 1) {
                        if (string4.equalsIgnoreCase("default")) {
                            string4 = "";
                        }
                        RDFScape.getCommonMemory().registerPrefix(string3, string4);
                    }
                    if (n2 == 2) {
                        RDFScape.getCommonMemory().registerNameSpaceColor(string3, string4);
                    }
                    if (n2 == 3) {
                        RDFScape.getCommonMemory().setActive(string3, true);
                    }
                    ++n2;
                }
            }
            bufferedReader.close();
            this.touch();
        }
        catch (IOException iOException) {
            System.out.println("Unable to load namespace file");
            return false;
        }
        return true;
    }

    public boolean saveToContext() {
        String string = RDFScape.getContextManager().getActiveContext().getNamespacesListFileName();
        try {
            FileWriter fileWriter = new FileWriter(new File(string));
            for (String string2 : RDFScape.getCommonMemory().getNamespacesList()) {
                String string3 = RDFScape.getCommonMemory().getPrefixFromNs(string2);
                String string4 = DefaultSettings.translateColor2String(RDFScape.getCommonMemory().getNamespaceColor(string2));
                String string5 = RDFScape.getCommonMemory().getActive(string2) ? "Y" : "N";
                if (string3.equalsIgnoreCase("")) {
                    string3 = "DEFAULT";
                }
                fileWriter.write(string2 + " " + string3 + " " + string4 + " " + string5 + "\n");
            }
            fileWriter.close();
        }
        catch (Exception exception) {
            System.out.println("Unable to write namespace file");
            return false;
        }
        return true;
    }

    public boolean canOperate() {
        return true;
    }

    public void touch() {
        this.nsSeed = 0;
        HashSet<String> hashSet = new HashSet<String>();
        String[] stringArray = RDFScape.getCommonMemory().getNamespaces();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = RDFScape.getCommonMemory().getNamespacePrefix(stringArray[i]);
            if (string == null) {
                string = "";
            }
            if (string.equalsIgnoreCase("")) {
                string = "def";
            }
            if (hashSet.contains(string)) {
                String string2 = "ns" + this.nsSeed;
                while (hashSet.contains(string2)) {
                    ++this.nsSeed;
                    string2 = "ns" + this.nsSeed;
                }
                string = string2;
            }
            hashSet.add(string);
            RDFScape.getCommonMemory().registerPrefixAsync(stringArray[i], string);
            if (RDFScape.getCommonMemory().getNamespaceColor(stringArray[i]) != null) continue;
            RDFScape.getCommonMemory().registerNameSpaceColor(stringArray[i], DefaultSettings.defaultColor);
        }
    }

    public void addNewNameSpaceToMemory(String string) {
        RDFScape.getCommonMemory().registerNameSpace(string);
        if (RDFScape.getCommonMemory().getPrefixFromNs(string) == null) {
            RDFScape.getCommonMemory().registerPrefixAsync(string, "");
        }
        if (RDFScape.getCommonMemory().getNamespaceColor(string) == null) {
            RDFScape.getCommonMemory().registerNameSpaceColorAsync(string, DefaultSettings.defaultColor);
        }
        this.touch();
        RDFScape.getCommonMemory().updateViews();
    }

    public void updateView() {
        this.fireTableDataChanged();
    }

    public void updateNamespaceView(String string) {
        this.fireTableDataChanged();
    }
}

