/*
 * Decompiled with CFR 0.152.
 */
package fr.pasteur.sysbio.rdfscape.patterns;

import fr.pasteur.sysbio.rdfscape.AbstractModulePanel;
import fr.pasteur.sysbio.rdfscape.RDFScape;
import fr.pasteur.sysbio.rdfscape.Utilities;
import fr.pasteur.sysbio.rdfscape.help.HelpManager;
import fr.pasteur.sysbio.rdfscape.patterns.PatternElement;
import fr.pasteur.sysbio.rdfscape.patterns.PatternElementPanel;
import fr.pasteur.sysbio.rdfscape.patterns.PatternManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class PatternManagerPanel
extends AbstractModulePanel {
    PatternManager selectionManager = null;
    JTabbedPane mySelections = null;
    JButton takeButton = null;
    JButton deleteButton = null;
    JButton addButton = null;
    JButton searchButton = null;

    public PatternManagerPanel(PatternManager patternManager) {
        this.selectionManager = patternManager;
        this.setLayout(new BorderLayout());
        this.mySelections = new JTabbedPane();
        this.add((Component)this.mySelections, "Center");
        this.redLightText = "<html>No ontologies are present and correctly loaded</html>";
        this.yellowLightText = "<html>Ontologies are present, but no pattern is defined yet</html>";
        this.greenLightText = "<html>Ontologies are present and " + this.selectionManager.getNumberOfPatterns() + "patterns are defined</html>";
        this.myTabText = "Pattern library";
        this.myTabTooltip = "<html>List of patterns defined, for a each patterns, is a set of features is available (see help)</html>";
    }

    public void addPatternElementPanel(PatternElement patternElement) {
        PatternElementPanel patternElementPanel = patternElement.getPanel();
        this.mySelections.add((Component)patternElementPanel, patternElement.getName());
        this.validate();
    }

    public void removePatternElementPanel(PatternElement patternElement) {
        this.mySelections.remove(patternElement.getPanel());
        this.validate();
    }

    public void removeAll() {
        this.mySelections.removeAll();
    }

    public String getHelpLink() {
        return "http://www.bioinformatics.org/rdfscape/wiki/Main/HowToWorkWithPatterns";
    }

    public JPanel getHelpPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JLabel jLabel = new JLabel("<html>In the pattern library each pattern is presented with a proprt sub-panel. <br>Entering a subpanel present all information, and commands, relative to its pattern.<br>In detail, each pattern panel presents thre panels: <b>Graph</b>, <b>Pattern</b>, <b>Matches</b> and a button bar</html>", Utilities.getHelpIcon("patternList.png"), 2);
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 200));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(20, 20)));
        jLabel = new JLabel(Utilities.getHelpIcon("patternGraphView.png"));
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 200));
        jPanel.add(jLabel);
        jLabel = new JLabel("<html>A graphical representation of the pattern</html>");
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 50));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jLabel = new JLabel(Utilities.getHelpIcon("patternStringView.png"));
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 100));
        jPanel.add(jLabel);
        jLabel = new JLabel("<html>A representation of the pattern as triplets.</html>");
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 50));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jLabel = new JLabel(Utilities.getHelpIcon("patternExpandedView.png"));
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 200));
        jPanel.add(jLabel);
        jLabel = new JLabel("<html>A presentation of all the triplets that matched this pattern in the knowledge base. This patternm is available after a search or plot operation is performed.</html>");
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 50));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jLabel = new JLabel("<html>These commands are active on a pattern:<ul><li><b>Search variables</b> search all variables matching this pattern in the graph</li><li><b>Add variables</b> add all variables matching this pattern to the graph</li><li><b>Search patterns</b> search all matchings of this pattern in the graph (not only the variables in the pattern)</li><li><b>Add patterns</b> adds all the matchings of this pattern to the graph (not only the variables in the pattern)</li><li><b>Delete pattern</b> deletes this pattern</li></ul></html>", Utilities.getHelpIcon("patternButtons.png"), 2);
        jLabel.setPreferredSize(new Dimension(HelpManager.panelWidth, 100));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        return jPanel;
    }

    public String getPanelName() {
        return "Help on Patterns";
    }

    public int getStatusLevel() {
        if (!RDFScape.getOntologyManager().ontologiesPresentAndCorrectlyLoaded()) {
            return 1;
        }
        if (this.selectionManager.getNumberOfPatterns() == 0) {
            return 2;
        }
        return 3;
    }

    public void refresh() {
    }
}

