/*
 * Decompiled with CFR 0.152.
 */
package fr.pasteur.sysbio.rdfscape.query;

import fr.pasteur.sysbio.rdfscape.CommonMemory;
import fr.pasteur.sysbio.rdfscape.RDFScape;
import fr.pasteur.sysbio.rdfscape.patterns.PatternElement;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.table.AbstractTableModel;

public abstract class AbstractQueryResultTable
extends AbstractTableModel {
    CommonMemory commonMemory = null;
    ArrayList resultValues = null;
    Hashtable col2VarName = null;
    Hashtable varName2Col = null;
    Hashtable biteToRows = null;

    public AbstractQueryResultTable() {
        if (RDFScape.getCommonMemory() == null) {
            System.out.println("Missing CommonMemory in QueryResultTaable... we are going to be in trouble!");
        }
        this.commonMemory = RDFScape.getCommonMemory();
        this.resultValues = new ArrayList();
        this.col2VarName = new Hashtable();
        this.varName2Col = new Hashtable();
        this.biteToRows = new Hashtable();
    }

    public void addObject(Object object, int n, int n2) {
        if (n >= this.resultValues.size()) {
            this.resultValues.add(n, null);
        }
        if (this.resultValues.get(n) == null) {
            this.resultValues.add(n, new ArrayList());
        }
        ((ArrayList)this.resultValues.get(n)).add(n2, object);
    }

    public void addVar(String string, int n) {
        this.col2VarName.put(new Integer(n).toString(), string);
        this.varName2Col.put(string, new Integer(n));
    }

    public int getVarColumn(String string) {
        Integer n = (Integer)this.varName2Col.get(string);
        if (n != null) {
            return n;
        }
        return -1;
    }

    public int getColumnCount() {
        if (this.resultValues.size() == 0) {
            return 0;
        }
        ArrayList arrayList = (ArrayList)this.resultValues.get(0);
        if (arrayList != null) {
            return arrayList.size();
        }
        return this.col2VarName.size();
    }

    public String getColumnName(int n) {
        return (String)this.col2VarName.get(new Integer(n).toString());
    }

    public int getRowCount() {
        return this.resultValues.size() - 1;
    }

    public Object getValueAt(int n, int n2) {
        ArrayList arrayList = (ArrayList)this.resultValues.get(n);
        if (arrayList != null) {
            return arrayList.get(n2);
        }
        return null;
    }

    public abstract Color getColor(int var1, int var2);

    public abstract String getLabel(int var1, int var2);

    public abstract boolean isURI(int var1, int var2);

    public abstract boolean isLiteral(int var1, int var2);

    public abstract boolean isBlank(int var1, int var2);

    public abstract String getNamespace(int var1, int var2);

    public abstract String getID(int var1, int var2);

    public abstract String getURI(int var1, int var2);

    public abstract String getDatatypeValue(int var1, int var2);

    public abstract String getDatatypeType(int var1, int var2);

    public abstract String getDatatypeLanguage(int var1, int var2);

    public abstract String getLocalName(int var1, int var2);

    public abstract boolean isNamespaceSelected(int var1, int var2);

    public void setBite(String string, int n) {
        System.out.println("Adding input line " + n + " for output line: " + string);
        if (this.biteToRows.get(string) == null) {
            this.biteToRows.put(string, new ArrayList());
        }
        ((ArrayList)this.biteToRows.get(string)).add(new Integer(n));
    }

    public Class getColumnClass(int n) {
        return String.class;
    }

    public int[] getBiteIndexes(String string) {
        ArrayList arrayList = (ArrayList)this.biteToRows.get(string);
        System.out.println("Bite has taken " + arrayList.size() + " values");
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            nArray[i] = (Integer)arrayList.get(i);
            System.out.println(nArray[i]);
        }
        return nArray;
    }

    public abstract boolean hasGraph();

    public abstract boolean hasTable();

    public abstract AbstractQueryResultTable getSubsetByRows(int[] var1);

    public abstract AbstractQueryResultTable getExpandedInPattern(PatternElement var1);
}

