/*
 * Decompiled with CFR 0.152.
 */
package fr.pasteur.sysbio.rdfscape.query;

import fr.pasteur.sysbio.rdfscape.CommonMemory;
import fr.pasteur.sysbio.rdfscape.RDFScape;
import fr.pasteur.sysbio.rdfscape.query.AbstractQueryResultTable;
import fr.pasteur.sysbio.rdfscape.query.JenaQueryResultTable;
import fr.pasteur.sysbio.rdfscape.query.MyQueryEngine;
import fr.pasteur.sysbio.rdfscape.query.RDQLQueryAnswerer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

public class RDQLQueryEngine
extends MyQueryEngine {
    private RDQLQueryPanel myPanel = null;
    private String query = null;

    public RDQLQueryEngine() throws Exception {
        try {
            RDQLQueryAnswerer rDQLQueryAnswerer = (RDQLQueryAnswerer)((Object)RDFScape.getKnowledgeEngine());
        }
        catch (Exception exception) {
            throw new Exception("RDQL query not supported by this KnowledgeWrapper");
        }
        this.query = this.getDefaultQuery();
    }

    public JPanel getPanel() {
        if (this.myPanel == null) {
            this.myPanel = new RDQLQueryPanel(this);
        }
        return this.myPanel;
    }

    public void setQuery(String string) {
        this.query = string;
        if (this.myPanel != null) {
            this.myPanel.refresh();
        }
    }

    public AbstractQueryResultTable makeQuery() {
        System.out.println("Querying my knowledge...");
        if (this.myPanel != null) {
            this.query = this.myPanel.getQueryText();
        }
        try {
            return ((RDQLQueryAnswerer)((Object)RDFScape.getKnowledgeEngine())).makeRDQLQuery(this.query);
        }
        catch (Exception exception) {
            RDFScape.warn("trying to make an RDQL query, but I can't. This should not happen.\n" + exception.getMessage());
            return new JenaQueryResultTable();
        }
    }

    public String getLabel() {
        return "RDQLQuery";
    }

    public void reset() {
        this.query = this.getDefaultQuery();
        if (this.myPanel != null) {
            this.myPanel.refresh();
        }
    }

    public String getDefaultQuery() {
        String string = new String();
        string = string.concat("SELECT \n WHERE (     ) \n");
        string = string.concat(this.getQueryNameSpacesClause());
        return string;
    }

    public String getQueryNameSpacesClause() {
        CommonMemory commonMemory = RDFScape.getCommonMemory();
        String string = new String();
        ArrayList arrayList = commonMemory.getNamespacesList();
        if (arrayList.size() > 0) {
            string = string.concat("USING ");
            for (int i = 0; i < arrayList.size(); ++i) {
                String string2 = (String)arrayList.get(i);
                System.out.println("Considering tempNameSpace " + string2);
                if (commonMemory.getNamespacePrefix(string2) == null) continue;
                string = string.concat(commonMemory.getNamespacePrefix(string2));
                string = string.concat(" FOR <" + string2 + ">,\n");
            }
            string = string.substring(0, string.length() - 2);
        }
        return string;
    }

    private class RDQLQueryPanel
    extends JPanel {
        private RDQLQueryEngine rdqlQueryManager = null;
        private JTextArea rdqlQueryTextArea = null;

        public RDQLQueryPanel(RDQLQueryEngine rDQLQueryEngine2) {
            this.rdqlQueryManager = rDQLQueryEngine2;
            this.setBorder(new TitledBorder("RDQL query"));
            this.setLayout(new BorderLayout());
            this.rdqlQueryTextArea = new JTextArea(this.rdqlQueryManager.query, 8, 60);
            this.add((Component)this.rdqlQueryTextArea, "Center");
        }

        public String getQueryText() {
            return this.rdqlQueryTextArea.getText();
        }

        public void refresh() {
            this.rdqlQueryTextArea.setText(this.rdqlQueryManager.query);
        }
    }
}

