/*
 * Decompiled with CFR 0.152.
 */
package fr.pasteur.sysbio.rdfscape.reasoning;

import fr.pasteur.sysbio.rdfscape.Contextualizable;
import fr.pasteur.sysbio.rdfscape.RDFScape;
import fr.pasteur.sysbio.rdfscape.RDFScapeModuleInterface;
import fr.pasteur.sysbio.rdfscape.context.ContextManager;
import fr.pasteur.sysbio.rdfscape.knowledge.InfRuleObject;
import fr.pasteur.sysbio.rdfscape.knowledge.JenaWrapper;
import fr.pasteur.sysbio.rdfscape.knowledge.KnowledgeWrapper;
import fr.pasteur.sysbio.rdfscape.knowledge.TripleStoreWrapper;
import fr.pasteur.sysbio.rdfscape.reasoning.ReasonerManagerPanel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.AbstractListModel;

public class ReasonerManager
extends AbstractListModel
implements RDFScapeModuleInterface,
Contextualizable {
    private ReasonerManagerPanel myPanel = null;
    private ArrayList rules = null;
    private String[] optionDefaults = null;
    private String[] reasoningEngines = new String[]{"JENA"};
    private String reasoningEngine = "JENA";

    public ReasonerManager() throws Exception {
        System.out.print("\tReasonerManager... ");
        if (RDFScape.getContextManager() == null) {
            throw new Exception("Unable to build Reasoner Manager : missing ContextManager");
        }
        RDFScape.getContextManager().addContextualizableElement(this);
        this.setActiveEngine("Jena");
        this.initialize();
        System.out.println("Ok");
    }

    public boolean initialize() {
        return this.initializeRules() && this.initializeSettings();
    }

    public boolean initializeRules() {
        int n = 0;
        if (this.rules != null) {
            n = this.rules.size();
        }
        this.rules = new ArrayList();
        if (n != 0) {
            this.fireIntervalRemoved(this, 0, n);
        }
        return true;
    }

    public boolean initializeSettings() {
        this.optionDefaults = RDFScape.getKnowledgeEngine().getReasonerActualOptions();
        return true;
    }

    public boolean canOperate() {
        return true;
    }

    public void buildKnowledge() {
        RDFScape.getKnowledgeEngine().addRuleSet(this.rules);
        RDFScape.getKnowledgeEngine().touch();
    }

    public void touch() {
        this.forwardRules();
        RDFScape.getKnowledgeEngine().touch();
    }

    public String[][] getOptions() {
        return RDFScape.getKnowledgeEngine().getReasonerOptions();
    }

    public String[] getDefaultOptions() {
        return RDFScape.getKnowledgeEngine().getReasonerActualOptions();
    }

    public void setSelectedOptions(String[] stringArray) {
        String[] stringArray2 = RDFScape.getKnowledgeEngine().getReasonerOptionNames();
        for (int i = 0; i < stringArray.length; ++i) {
            RDFScape.getKnowledgeEngine().setReasonerParameter(stringArray2[i], stringArray[i]);
        }
    }

    public void forwardRules() {
        RDFScape.getKnowledgeEngine().addRuleSet(this.rules);
    }

    public void deleteRule(InfRuleObject infRuleObject) {
        int n = this.getIndexOfRuleObject(infRuleObject);
        if (n >= 0) {
            System.out.println("Going to remove " + n);
            this.rules.remove(infRuleObject);
            this.fireIntervalRemoved(this, n, n);
        }
    }

    public void addRuleObject(InfRuleObject infRuleObject) {
        this.rules.add(infRuleObject);
        this.fireIntervalAdded(this, this.getIndexOfRuleObject(infRuleObject), this.getIndexOfRuleObject(infRuleObject));
    }

    public InfRuleObject getRule(int n) {
        System.out.println("get " + n);
        return (InfRuleObject)this.rules.get(n);
    }

    public ReasonerManagerPanel getReasonerManagerPanel() {
        if (this.myPanel == null) {
            this.myPanel = new ReasonerManagerPanel(this);
        }
        return this.myPanel;
    }

    public ArrayList getRules() {
        return this.rules;
    }

    public int getSize() {
        return this.rules.size();
    }

    public Object getElementAt(int n) {
        return (InfRuleObject)this.rules.get(n);
    }

    public int getIndexOfRuleObject(InfRuleObject infRuleObject) {
        return this.rules.indexOf(infRuleObject);
    }

    public void updateRule(int n, String string, String[][] stringArray) {
        System.out.println("Reasoner Manager: updating rule #" + n);
        String string2 = RDFScape.getKnowledgeEngine().validateRule(string);
        if (string2 != null) {
            RDFScape.warn(string2 + " Note: I'm not checking prefixes correctly: You have to check them yourself in the namesace panel! ");
        }
        this.getRule(n).setRule(string);
        System.out.println("Rule ha name: " + this.getRule(n).getName());
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.getRule(n).setParam(stringArray[i][0], stringArray[i][1]);
                System.out.println(stringArray[i][1] + "->" + stringArray[i][0]);
            }
        }
        this.fireContentsChanged(this, n, n);
    }

    public String[] getEngines() {
        return this.reasoningEngines;
    }

    public void setActiveEngine(String string) {
        if (string == null) {
            return;
        }
        KnowledgeWrapper knowledgeWrapper = null;
        try {
            if (string.equalsIgnoreCase("Jena")) {
                knowledgeWrapper = new JenaWrapper();
                this.reasoningEngine = string;
                RDFScape.setKnowledgeEngine(knowledgeWrapper);
                if (this.myPanel != null) {
                    this.myPanel.updateAfterEngineChange();
                }
            } else if (string.equalsIgnoreCase("TripleStore")) {
                knowledgeWrapper = new TripleStoreWrapper();
                this.reasoningEngine = string;
                RDFScape.setKnowledgeEngine(knowledgeWrapper);
                if (this.myPanel != null) {
                    this.myPanel.updateAfterEngineChange();
                }
            } else {
                RDFScape.warn(string + " is unsupported yet... still at " + this.reasoningEngine);
            }
        }
        catch (Exception exception) {
            System.out.println("Unable to build KnowledgeWrapper... going to have troubles!");
        }
    }

    public String getActiveEngine() {
        return this.reasoningEngine;
    }

    private void resetRules() {
        int n = 0;
        int n2 = this.rules.size();
        this.rules = new ArrayList();
        this.fireIntervalRemoved(this, n, n2);
    }

    public void reset() {
        this.initialize();
        RDFScape.getKnowledgeEngine().reset();
        this.myPanel.updateAfterEngineChange();
    }

    public void update() {
    }

    public boolean isInValidState() {
        return true;
    }

    public boolean loadFromActiveContext() {
        this.reset();
        boolean bl = this.loadReasoningSettingFromActiveContext();
        boolean bl2 = this.loadInferenceRulesFromActiveContext();
        return bl && bl2;
    }

    private boolean loadReasoningSettingFromActiveContext() {
        int n = 0;
        String string = RDFScape.getContextManager().getActiveContext().getReasoningSettingsFileName();
        System.out.println("Loading inference settings in : " + string);
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            System.out.println("Got file");
            while ((string2 = bufferedReader.readLine()) != null) {
                ++n;
                System.out.println("Line: " + string2);
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                if (string3 == null || string4 == null) {
                    System.out.println("Incorrect file format");
                    return false;
                }
                if (string3.equalsIgnoreCase("Engine:")) {
                    if (string4.equalsIgnoreCase("Jena")) {
                        this.setActiveEngine(string4);
                    } else {
                        RDFScape.warn("Unable to use other then Jena... check your analysis context");
                    }
                } else {
                    RDFScape.getKnowledgeEngine().setReasonerParameter(string3, string4);
                }
                ++n;
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            System.out.println("Problems while reading inference settings file");
            exception.printStackTrace();
        }
        return true;
    }

    boolean loadInferenceRulesFromActiveContext() {
        boolean bl = false;
        String string = RDFScape.getContextManager().getActiveContext().getReasoningInfRulesDirName();
        File file = new File(string);
        if (!file.isDirectory()) {
            System.out.println("Unable to locate inference rules");
            return false;
        }
        try {
            Object var4_4 = null;
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                Object object;
                InfRuleObject infRuleObject = new InfRuleObject();
                System.out.println("Reading inf rule file: " + fileArray[i]);
                BufferedReader bufferedReader = new BufferedReader(new FileReader(fileArray[i]));
                String string2 = bufferedReader.readLine();
                if (string2 == null) {
                    System.out.println("Empty rule file");
                    break;
                }
                if (string2.equalsIgnoreCase("Y")) {
                    infRuleObject.setActive(true);
                } else {
                    if (!string2.equalsIgnoreCase("N")) {
                        System.out.println("Incorrect rule file format");
                        break;
                    }
                    infRuleObject.setActive(false);
                }
                System.out.println("Y/N :" + string2);
                string2 = bufferedReader.readLine();
                System.out.println("Just read :" + string2);
                while (!string2.equalsIgnoreCase("RULE")) {
                    object = new StringTokenizer(string2);
                    String string3 = ((StringTokenizer)object).nextToken();
                    String string4 = null;
                    string4 = ((StringTokenizer)object).hasMoreTokens() ? ((StringTokenizer)object).nextToken() : "";
                    if (string3 == null || string4 == null) {
                        System.out.println("Incorrect rule format");
                        break;
                    }
                    infRuleObject.setParam(string3, string4);
                    string2 = bufferedReader.readLine();
                    if (string2 != null) continue;
                    System.out.println("Incorrect file format");
                    break;
                }
                System.out.println("Params read");
                object = new String();
                while ((string2 = bufferedReader.readLine()) != null) {
                    object = ((String)object).concat(string2 + "\n");
                }
                System.out.println("Rule was: " + (String)object);
                infRuleObject.setRule((String)object);
                this.addRuleObject(infRuleObject);
            }
        }
        catch (IOException iOException) {
            System.out.println("Unable to load inference rules");
            return false;
        }
        return true;
    }

    public boolean saveToContext() {
        boolean bl = this.saveInfSettingsToActiveContext();
        boolean bl2 = this.saveRulesToActiveContext();
        return bl && bl2;
    }

    private boolean saveRulesToActiveContext() {
        boolean bl = false;
        String string = RDFScape.getContextManager().getActiveContext().getReasoningInfRulesDirName();
        System.out.println("Saving rules to : " + string);
        File file = new File(string);
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray[i].delete();
        }
        System.out.println("Cleaned");
        Iterator iterator = this.rules.iterator();
        while (iterator.hasNext()) {
            try {
                InfRuleObject infRuleObject = (InfRuleObject)iterator.next();
                System.out.println("Rule: " + infRuleObject.getName());
                FileWriter fileWriter = new FileWriter(new File(string + "/" + infRuleObject.getName()));
                if (infRuleObject.isActive()) {
                    fileWriter.write("Y\n");
                } else {
                    fileWriter.write("N\n");
                }
                String[] stringArray = RDFScape.getKnowledgeEngine().getRuleOptionsNames();
                if (stringArray != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        fileWriter.write(stringArray[i] + "\t" + infRuleObject.getParam(stringArray[i]) + "\n");
                    }
                }
                fileWriter.write("RULE\n");
                fileWriter.write(infRuleObject.getRule() + "\n");
                fileWriter.close();
                System.out.println("Ok");
            }
            catch (Exception exception) {
                System.out.println("Unable to write rule");
                exception.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private boolean saveInfSettingsToActiveContext() {
        String string = RDFScape.getContextManager().getActiveContext().getReasoningSettingsFileName();
        System.out.println("Saving inference settings to : " + string);
        File file = new File(string);
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write("Engine: " + this.reasoningEngine + "\n");
            String[] stringArray = RDFScape.getKnowledgeEngine().getReasonerOptionNames();
            String[] stringArray2 = RDFScape.getKnowledgeEngine().getReasonerActualOptions();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    fileWriter.write(stringArray[i] + " " + stringArray2[i] + "\n");
                }
            }
            fileWriter.close();
            return true;
        }
        catch (Exception exception) {
            System.out.println("Unable to write infsetting");
            exception.printStackTrace();
            return false;
        }
    }

    public void registerContextManager(ContextManager contextManager) {
    }

    public String[][] getRuleOptions() {
        return RDFScape.getKnowledgeEngine().getRuleOptions();
    }

    public String[] getRuleDefaultOptions() {
        return RDFScape.getKnowledgeEngine().getRuleOptionDefaultValues();
    }

    public String[] getRuleOptionParams() {
        return RDFScape.getKnowledgeEngine().getRuleOptionsNames();
    }

    public boolean rulesEnabled() {
        return RDFScape.getKnowledgeEngine().canAddRules();
    }

    public boolean hasReasoningOptions() {
        return RDFScape.getKnowledgeEngine().getReasonerOptions() != null;
    }

    public void reason() {
        RDFScape.getKnowledgeEngine().touch();
    }

    public String[] getReasonerOptionNames() {
        return RDFScape.getKnowledgeEngine().getReasonerOptionNames();
    }

    public String[] getReasonerActualOptions() {
        return RDFScape.getKnowledgeEngine().getReasonerActualOptions();
    }
}

