/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATermAppl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.QueueElement;

public class CompletionQueue {
    protected static int GUESSLIST = 0;
    protected static int NOMLIST = 1;
    protected static int MAXLIST = 2;
    protected static int DATATYPELIST = 3;
    protected static int ATOMLIST = 4;
    protected static int ORLIST = 5;
    protected static int SOMELIST = 6;
    protected static int MINLIST = 7;
    protected static int LITERALLIST = 8;
    protected static int ALLLIST = 9;
    protected static int CHOOSELIST = 10;
    protected static int SIZE = 11;
    protected List[] gQueue;
    protected List[] queue;
    protected int[] current;
    protected int[] gCurrent;
    protected int[] cutOff;
    protected List branches;
    protected List branchEffects;
    protected ABox abox;

    protected CompletionQueue(ABox abox) {
        this.abox = abox;
        this.queue = new ArrayList[SIZE];
        this.gQueue = new ArrayList[SIZE];
        this.current = new int[SIZE];
        this.gCurrent = new int[SIZE];
        this.cutOff = new int[SIZE];
        this.branches = new ArrayList();
        this.branchEffects = new ArrayList();
        Object[] initbranches = new Object[SIZE];
        for (int i = 0; i < SIZE; ++i) {
            int[] initial = new int[]{0, 0, 0, 0};
            this.queue[i] = new ArrayList();
            this.gQueue[i] = new ArrayList();
            this.current[i] = 0;
            this.gCurrent[i] = 0;
            this.cutOff[i] = 0;
            initbranches[i] = initial;
        }
        this.branches.add(0, initbranches);
    }

    protected void findNext(int type) {
        Node node;
        QueueElement next;
        boolean found = false;
        while (this.gCurrent[type] < this.gQueue[type].size() && this.gCurrent[type] + this.current[type] < this.cutOff[type]) {
            next = null;
            next = (QueueElement)this.gQueue[type].get(this.gCurrent[type]);
            node = (Node)this.abox.getNodeMap().get(next.getNode());
            if (node != null) {
                node = node.getSame();
                if (type == LITERALLIST && node instanceof Literal && !node.isPruned()) {
                    found = true;
                    break;
                }
                if (node instanceof Individual && !node.isPruned()) {
                    found = true;
                    break;
                }
            }
            int n = type;
            this.gCurrent[n] = this.gCurrent[n] + 1;
        }
        if (found) {
            return;
        }
        while (this.current[type] < this.queue[type].size() && this.gCurrent[type] + this.current[type] < this.cutOff[type]) {
            next = null;
            next = (QueueElement)this.queue[type].get(this.current[type]);
            node = (Node)this.abox.getNodeMap().get(next.getNode());
            if (node != null) {
                node = node.getSame();
                if (type == LITERALLIST && node instanceof Literal && !node.isPruned() || node instanceof Individual && !node.isPruned()) break;
            }
            int n = type;
            this.current[n] = this.current[n] + 1;
        }
    }

    public boolean hasNext(int type) {
        this.findNext(type);
        return (this.current[type] < this.queue[type].size() || this.gCurrent[type] < this.gQueue[type].size()) && this.gCurrent[type] + this.current[type] < this.cutOff[type];
    }

    public void restore(int branch) {
        if (branch + 1 < this.branches.size()) {
            this.branches.subList(branch + 1, this.branches.size()).clear();
        }
        Object[] theBranch = (Object[])this.branches.get(branch);
        for (int i = 0; i < SIZE; ++i) {
            int[] index = (int[])theBranch[i];
            this.current[i] = index[0];
            int branchP = index[1];
            this.cutOff[i] = index[2];
            this.gCurrent[i] = index[3];
            this.queue[i].subList(Math.min(this.queue[i].size(), this.cutOff[i]), this.queue[i].size()).clear();
        }
    }

    public Object getNext(int type) {
        this.findNext(type);
        QueueElement elem = null;
        if (this.gCurrent[type] < this.gQueue[type].size()) {
            int n = type;
            int n2 = this.gCurrent[n];
            this.gCurrent[n] = n2 + 1;
            elem = (QueueElement)this.gQueue[type].get(n2);
        } else {
            int n = type;
            int n3 = this.current[n];
            this.current[n] = n3 + 1;
            elem = (QueueElement)this.queue[type].get(n3);
        }
        return elem;
    }

    public void add(QueueElement x, int type) {
        if (this.abox.isSyntacticUpdate()) {
            this.gQueue[type].add(x);
        } else {
            this.queue[type].add(x);
        }
    }

    public void addAll(List xs, int type) {
        if (this.abox.isSyntacticUpdate()) {
            this.gQueue[type].addAll(xs);
        } else {
            this.queue[type].addAll(xs);
        }
    }

    public void init(int type) {
        this.cutOff[type] = this.gQueue[type].size() + this.queue[type].size();
    }

    public void incrementBranch(int branch) {
        Object[] theBranch = branch < this.branches.size() ? (Object[])this.branches.get(branch) : new Object[SIZE];
        for (int i = 0; i < SIZE; ++i) {
            int[] entry = new int[]{this.current[i], this.gQueue[i].size() + this.queue[i].size(), this.queue[i].size() + 1, this.gCurrent[i]};
            theBranch[i] = entry;
        }
        if (branch < this.branches.size()) {
            this.branches.set(branch, theBranch);
        } else {
            this.branches.add(branch, theBranch);
        }
    }

    public CompletionQueue copy() {
        int i;
        CompletionQueue copy = new CompletionQueue(this.abox);
        for (i = 0; i < SIZE; ++i) {
            copy.queue[i] = new ArrayList(this.queue[i]);
            copy.gQueue[i] = new ArrayList(this.gQueue[i]);
            copy.current[i] = this.current[i];
            copy.cutOff[i] = this.cutOff[i];
            copy.gCurrent[i] = this.gCurrent[i];
        }
        for (i = 0; i < this.branches.size(); ++i) {
            Object[] branchArray = (Object[])this.branches.get(i);
            Object[] newBranchArray = new Object[branchArray.length];
            for (int j = 0; j < branchArray.length; ++j) {
                int[] oldEntry = (int[])branchArray[j];
                int[] newEntry = new int[]{oldEntry[0], oldEntry[1], oldEntry[2], oldEntry[3]};
                newBranchArray[j] = newEntry;
            }
            if (i < copy.branches.size()) {
                copy.branches.set(i, newBranchArray);
                continue;
            }
            copy.branches.add(newBranchArray);
        }
        for (i = 0; i < this.branchEffects.size(); ++i) {
            HashSet cp = new HashSet();
            cp.addAll((Set)this.branchEffects.get(i));
            copy.branchEffects.add(cp);
        }
        return copy;
    }

    public void setABox(ABox ab) {
        this.abox = ab;
    }

    public void print(int type) {
        int i;
        System.out.println("Queue for type: " + type);
        System.out.println("   Global Curr Pointer " + this.gCurrent[type] + "\n Global Queue:");
        for (i = 0; i < this.gQueue[type].size(); ++i) {
            System.out.println("     " + ((QueueElement)this.gQueue[type].get(i)).getNode() + "  " + ((QueueElement)this.gQueue[type].get(i)).getLabel());
        }
        System.out.println("   Queue Curr Pointer " + this.current[type] + "\n Queue:");
        for (i = 0; i < this.queue[type].size(); ++i) {
            System.out.println("     " + ((QueueElement)this.queue[type].get(i)).getNode() + "  " + ((QueueElement)this.queue[type].get(i)).getLabel());
        }
    }

    public void print() {
        int i = 0;
        while (true) {
            if (i >= SIZE) break;
            this.print(i);
            ++i;
        }
        this.printBranchInfo();
    }

    public void printBranchInfo() {
        System.out.println("Branch pointers: ");
        for (int i = 1; i < this.branches.size(); ++i) {
            Object[] theBranch = (Object[])this.branches.get(i);
            System.out.println("Branch: " + i);
            for (int j = 0; j < SIZE; ++j) {
                int[] entry = (int[])theBranch[j];
                System.out.println("  Queue - " + j);
                System.out.println("    Current pointer: " + entry[0]);
                System.out.println("    Total size (gQ + queue i): " + entry[1]);
                System.out.println("    Cutoff: " + entry[2]);
                System.out.println("    gCurrent: " + entry[3]);
            }
        }
    }

    protected void addEffected(int branch, ATermAppl node) {
        if (branch <= 0) {
            return;
        }
        if (branch < this.branchEffects.size()) {
            HashSet inds = (HashSet)this.branchEffects.get(branch);
            inds.add(node);
            this.branchEffects.set(branch, inds);
        } else {
            for (int i = this.branchEffects.size(); i < branch; ++i) {
                this.branchEffects.add(new HashSet());
            }
            HashSet<ATermAppl> inds = new HashSet<ATermAppl>();
            inds.add(node);
            this.branchEffects.add(branch, inds);
        }
    }

    protected Set removeEffects(int branch) {
        HashSet effected = new HashSet();
        for (int i = branch + 1; i < this.branchEffects.size(); ++i) {
            Set next = (Set)this.branchEffects.get(i);
            effected.addAll(next);
            this.branchEffects.set(i, new HashSet());
        }
        return effected;
    }
}

