/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermInt;
import aterm.ATermList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Blocking;
import org.mindswap.pellet.Branch;
import org.mindswap.pellet.ChooseBranch;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.CompletionQueue;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.DisjunctionBranch;
import org.mindswap.pellet.DisjunctionSorting;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.GuessBranch;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.LiteralIterator;
import org.mindswap.pellet.LiteralValueBranch;
import org.mindswap.pellet.MaxBranch;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.NodeMerge;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.QueueElement;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.tbox.TBox;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Pair;
import org.mindswap.pellet.utils.SetUtils;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.Timers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompletionStrategy {
    public static final Log log = LogFactory.getLog(ABox.class);
    protected ABox abox;
    protected TBox tbox;
    protected Blocking blocking;
    protected Timers timers;
    protected Timer completionTimer;
    private boolean merging = false;
    protected List<NodeMerge> mergeList;

    public CompletionStrategy(ABox abox, Blocking blocking) {
        this.abox = abox;
        this.tbox = abox.getTBox();
        this.blocking = blocking;
        this.timers = abox.getKB().timers;
        this.completionTimer = this.timers.createTimer("complete");
    }

    public Iterator getInitializeIterator() {
        return new IndividualIterator(this.abox);
    }

    public void initialize() {
        this.mergeList = new ArrayList<NodeMerge>();
        for (Branch branch : this.abox.getBranches()) {
            branch.setStrategy(this);
        }
        if (this.abox.isInitialized()) {
            boolean first = true;
            Iterator i = this.getInitializeIterator();
            block1: while (i.hasNext()) {
                Individual n = (Individual)i.next();
                if (n.isMerged()) continue;
                if (first) {
                    this.applyUniversalRestrictions(n);
                    first = false;
                }
                this.applyAllValues(n);
                if (n.isMerged()) continue;
                this.applyNominalRule(n);
                if (n.isMerged()) continue;
                this.applySelfRule(n);
                EdgeList allEdges = n.getOutEdges();
                for (int e = 0; e < allEdges.size(); ++e) {
                    Edge edge = allEdges.edgeAt(e);
                    if (edge.getTo().isPruned()) continue;
                    this.applyPropertyRestrictions(edge);
                    if (n.isMerged()) continue block1;
                }
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initialize started");
        }
        this.abox.setBranch(0);
        this.mergeList.addAll(this.abox.toBeMerged);
        if (!this.mergeList.isEmpty()) {
            this.mergeFirst();
        }
        Iterator i = this.getInitializeIterator();
        block3: while (i.hasNext()) {
            Individual n = (Individual)i.next();
            if (n.isMerged()) continue;
            n.setChanged(true);
            this.applyUniversalRestrictions(n);
            this.applyUnfoldingRule(n);
            this.applySelfRule(n);
            EdgeList allEdges = n.getOutEdges();
            for (int e = 0; e < allEdges.size(); ++e) {
                Edge edge = allEdges.edgeAt(e);
                if (edge.getTo().isPruned()) continue;
                this.applyPropertyRestrictions(edge);
                if (n.isMerged()) continue block3;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Merging: " + this.mergeList));
        }
        if (!this.mergeList.isEmpty()) {
            this.mergeFirst();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initialize finished");
        }
        this.abox.setBranch(this.abox.getBranches().size() + 1);
        this.abox.treeDepth = 1;
        this.abox.changed = true;
        this.abox.setComplete(false);
        this.abox.setInitialized(true);
    }

    abstract ABox complete();

    abstract boolean supportsPseudoModelCompletion();

    Individual createFreshIndividual(boolean isNominal) {
        Individual ind = this.abox.addFreshIndividual(isNominal);
        this.applyUniversalRestrictions(ind);
        return ind;
    }

    void applyUniversalRestrictions(Individual node) {
        this.addType(node, ATermUtils.TOP, DependencySet.INDEPENDENT);
        List<Pair<ATermAppl, Set<ATermAppl>>> UC = this.tbox.getUC();
        if (UC != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("UC  : " + node + " " + UC));
            }
            for (Pair<ATermAppl, Set<ATermAppl>> pair : UC) {
                ATermAppl c = (ATermAppl)pair.first;
                Set explain = (Set)pair.second;
                DependencySet ds = new DependencySet(explain);
                this.addType(node, c, ds);
            }
        }
        Set<Role> reflexives = this.abox.getKB().getRBox().getReflexiveRoles();
        for (Role r : reflexives) {
            if (log.isDebugEnabled() && !node.hasRNeighbor(r, node)) {
                log.debug((Object)("REF : " + node + " " + r));
            }
            this.addEdge(node, r, node, r.getExplainReflexive());
        }
    }

    public void addType(Node node, ATermAppl c, DependencySet ds) {
        if (this.abox.isClosed()) {
            return;
        }
        node.addType(c, ds);
        if (PelletOptions.USE_INCREMENTAL_DELETION) {
            this.abox.getKB().getDependencyIndex().addTypeDependency(node.getName(), c, ds);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("ADD: " + node + " " + c + " - " + ds + " " + ds.explain));
        }
        if (c.getAFun().equals(ATermUtils.ANDFUN)) {
            ATermList cs = (ATermList)c.getArgument(0);
            while (!cs.isEmpty()) {
                ATermAppl conj = (ATermAppl)cs.getFirst();
                this.addType(node, conj, ds);
                node = node.getSame();
                cs = cs.getNext();
            }
        } else if (c.getAFun().equals(ATermUtils.ALLFUN)) {
            this.applyAllValues((Individual)node, c, ds);
        } else if (c.getAFun().equals(ATermUtils.SELFFUN)) {
            ATermAppl pred = (ATermAppl)c.getArgument(0);
            Role role = this.abox.getRole(pred);
            if (log.isDebugEnabled() && !((Individual)node).hasRSuccessor(role, node)) {
                log.debug((Object)("SELF: " + node + " " + role + " " + node.getDepends(c)));
            }
            this.addEdge((Individual)node, role, node, ds);
        }
    }

    protected void updateQueueAddEdge(Individual subj, Role pred, Node obj) {
        QueueElement newElement;
        Role r;
        ATermAppl max;
        ATermAppl c;
        int j;
        List<ATermAppl> types = subj.getTypes(5);
        int size = types.size();
        for (j = 0; j < size; ++j) {
            c = types.get(j);
            max = (ATermAppl)c.getArgument(0);
            r = this.abox.getRole(max.getArgument(0));
            if (!pred.isSubRoleOf(r) && pred != r) continue;
            newElement = new QueueElement(subj.getName(), c);
            this.abox.completionQueue.add(newElement, CompletionQueue.MAXLIST);
            this.abox.completionQueue.add(newElement, CompletionQueue.CHOOSELIST);
        }
        if ((pred.hasNamedInverse() || pred.isInverseFunctional()) && obj instanceof Individual) {
            types = ((Individual)obj).getTypes(5);
            size = types.size();
            for (j = 0; j < size; ++j) {
                c = types.get(j);
                max = (ATermAppl)c.getArgument(0);
                r = this.abox.getRole(max.getArgument(0));
                if (!pred.isSubRoleOf(r.getInverse()) && pred != r.getInverse()) continue;
                newElement = new QueueElement(obj.getName(), c);
                this.abox.completionQueue.add(newElement, CompletionQueue.MAXLIST);
                this.abox.completionQueue.add(newElement, CompletionQueue.CHOOSELIST);
            }
        }
    }

    public void addEdge(Individual subj, Role pred, Node obj, DependencySet ds) {
        Edge edge = subj.addEdge(pred, obj, ds);
        if (PelletOptions.USE_INCREMENTAL_DELETION) {
            this.abox.getKB().getDependencyIndex().addEdgeDependency(edge, ds);
        }
        if (PelletOptions.USE_COMPLETION_QUEUE) {
            this.updateQueueAddEdge(subj, pred, obj);
        }
        if (edge != null) {
            Individual o;
            int max;
            if (subj.isBlockable() && obj.isNominal() && !obj.isLiteral() && (max = (o = (Individual)obj).getMaxCard(pred.getInverse())) != Integer.MAX_VALUE && !o.hasDistinctRNeighborsForMin(pred.getInverse(), max, ATermUtils.TOP, true)) {
                int guessMin = o.getMinCard(pred.getInverse());
                if (guessMin == 0) {
                    guessMin = 1;
                }
                if (guessMin > max) {
                    return;
                }
                GuessBranch newBranch = new GuessBranch(this.abox, this, o, pred.getInverse(), guessMin, max, ds);
                this.addBranch(newBranch);
                if (!newBranch.tryNext()) {
                    return;
                }
                if (this.abox.isClosed()) {
                    return;
                }
            }
            this.applyPropertyRestrictions(edge);
        }
    }

    void applyPropertyRestrictions(Edge edge) {
        Individual subj = edge.getFrom();
        Role pred = edge.getRole();
        Node obj = edge.getTo();
        DependencySet ds = edge.getDepends();
        this.applyDomainRange(subj, pred, obj, ds);
        if (subj.isPruned() || obj.isPruned()) {
            return;
        }
        this.applyFunctionality(subj, pred, obj);
        if (subj.isPruned() || obj.isPruned()) {
            return;
        }
        this.applyDisjointness(subj, pred, obj, ds);
        this.applyAllValues(subj, pred, obj, ds);
        if (subj.isPruned() || obj.isPruned()) {
            return;
        }
        if (pred.isObjectRole()) {
            Individual o = (Individual)obj;
            this.applyAllValues(o, pred.getInverse(), subj, ds);
            this.checkReflexivitySymmetry(subj, pred, o, ds);
            this.checkReflexivitySymmetry(o, pred.getInverse(), subj, ds);
        }
    }

    void applyDomainRange(Individual subj, Role pred, Node obj, DependencySet ds) {
        ATermAppl domain = pred.getDomain();
        ATermAppl range = pred.getRange();
        if (domain != null) {
            if (log.isDebugEnabled() && !subj.hasType(domain)) {
                log.debug((Object)("DOM : " + obj + " <- " + pred + " <- " + subj + " : " + domain));
            }
            this.addType(subj, domain, ds.union(pred.getExplainDomain(), this.abox.doExplanation()));
        }
        if (range != null) {
            if (log.isDebugEnabled() && !obj.hasType(range)) {
                log.debug((Object)("RAN : " + subj + " -> " + pred + " -> " + obj + " : " + range));
            }
            this.addType(obj, range, ds.union(pred.getExplainRange(), this.abox.doExplanation()));
        }
    }

    void applyFunctionality(Individual subj, Role pred, Node obj) {
        DependencySet maxCardDS;
        DependencySet dependencySet = maxCardDS = pred.isFunctional() ? pred.getExplainFunctional() : subj.hasMax1(pred);
        if (maxCardDS != null) {
            this.applyFunctionalMaxRule(subj, pred, ATermUtils.getTop(pred), maxCardDS);
        }
        if (pred.isDatatypeRole() && pred.isInverseFunctional()) {
            this.applyFunctionalMaxRule((Literal)obj, pred, DependencySet.INDEPENDENT);
        } else if (pred.isObjectRole()) {
            Individual val = (Individual)obj;
            Role invR = pred.getInverse();
            DependencySet dependencySet2 = maxCardDS = invR.isFunctional() ? invR.getExplainFunctional() : val.hasMax1(invR);
            if (maxCardDS != null) {
                this.applyFunctionalMaxRule(val, invR, ATermUtils.TOP, maxCardDS);
            }
        }
    }

    void applyDisjointness(Individual subj, Role pred, Node obj, DependencySet ds) {
        Set<Role> disjoints = pred.getDisjointRoles();
        if (disjoints.isEmpty()) {
            return;
        }
        EdgeList edges = subj.getEdgesTo(obj);
        int n = edges.size();
        for (int i = 0; i < n; ++i) {
            Edge otherEdge = edges.edgeAt(i);
            if (!disjoints.contains(otherEdge.getRole())) continue;
            this.abox.setClash(Clash.unexplained(subj, ds.union(otherEdge.getDepends(), this.abox.doExplanation()), "Disjoint properties " + pred + " " + otherEdge.getRole()));
            return;
        }
    }

    void checkReflexivitySymmetry(Individual subj, Role pred, Individual obj, DependencySet ds) {
        if (pred.isAntisymmetric() && obj.hasRSuccessor(pred, subj)) {
            EdgeList edges = obj.getEdgesTo(subj, pred);
            ds = ds.union(edges.edgeAt(0).getDepends(), this.abox.doExplanation());
            if (PelletOptions.USE_TRACING) {
                ds = ds.union(pred.getExplainAntisymmetric(), this.abox.doExplanation());
            }
            this.abox.setClash(Clash.unexplained(subj, ds, "Antisymmetric property " + pred));
        } else if (subj.equals(obj)) {
            if (pred.isIrreflexive()) {
                this.abox.setClash(Clash.unexplained(subj, ds.union(pred.getExplainIrreflexive(), this.abox.doExplanation()), "Irreflexive property " + pred));
            } else {
                ATermAppl notSelfP = ATermUtils.makeNot(ATermUtils.makeSelf(pred.getName()));
                if (subj.hasType(notSelfP)) {
                    this.abox.setClash(Clash.unexplained(subj, ds.union(subj.getDepends(notSelfP), this.abox.doExplanation()), "Local irreflexive property " + pred));
                }
            }
        }
    }

    void applyAllValues(Individual subj, Role pred, Node obj, DependencySet ds) {
        List<ATermAppl> allValues = subj.getTypes(3);
        int allValuesSize = allValues.size();
        Iterator<ATermAppl> i = allValues.iterator();
        while (i.hasNext()) {
            DependencySet finalDS;
            ATermAppl av = i.next();
            ATerm p = av.getArgument(0);
            ATermAppl c = (ATermAppl)av.getArgument(1);
            ATermList roleChain = ATermUtils.EMPTY_LIST;
            Role s = null;
            if (p.getType() == 4) {
                roleChain = (ATermList)p;
                s = this.abox.getRole(roleChain.getFirst());
                roleChain = roleChain.getNext();
            } else {
                s = this.abox.getRole(p);
            }
            if (pred.isSubRoleOf(s)) {
                finalDS = subj.getDepends(av).union(ds, this.abox.doExplanation()).union(s.getExplainSub(pred.getName()), this.abox.doExplanation());
                if (roleChain.isEmpty()) {
                    this.applyAllValues(subj, s, obj, c, finalDS);
                } else {
                    ATermAppl allRC = ATermUtils.makeAllValues(roleChain, c);
                    this.applyAllValues(subj, allRC, finalDS);
                }
                if (this.abox.isClosed()) {
                    return;
                }
            }
            if (!s.isSimple()) {
                finalDS = subj.getDepends(av).union(ds, this.abox.doExplanation());
                Set<ATermList> subRoleChains = s.getSubRoleChains();
                for (ATermList chain : subRoleChains) {
                    Role firstRole = this.abox.getRole(chain.getFirst());
                    if (!pred.isSubRoleOf(firstRole)) continue;
                    ATermAppl allRC = ATermUtils.makeAllValues(chain.getNext(), c);
                    this.applyAllValues(subj, pred, obj, allRC, finalDS.union(firstRole.getExplainSub(pred.getName()), this.abox.doExplanation()).union(s.getExplainSub(chain), this.abox.doExplanation()));
                    if (!subj.isMerged() && !this.abox.isClosed()) continue;
                    return;
                }
            }
            if (subj.isMerged()) {
                return;
            }
            obj = obj.getSame();
            if (allValuesSize == allValues.size()) continue;
            i = allValues.iterator();
            allValuesSize = allValues.size();
        }
    }

    protected void applyUnfoldingRule(IndividualIterator i) {
        i.reset();
        while (i.hasNext()) {
            Individual node = i.next();
            this.applyUnfoldingRule(node);
            if (!this.abox.isClosed()) continue;
            return;
        }
    }

    protected final void applySelfRule(Individual node) {
        List<ATermAppl> types = node.getTypes(0);
        int size = types.size();
        for (int j = 0; j < size; ++j) {
            ATermAppl c = types.get(j);
            if (!PelletOptions.MAINTAIN_COMPLETION_QUEUE && node.getDepends(c) == null || !ATermUtils.isSelf(c)) continue;
            ATermAppl pred = (ATermAppl)c.getArgument(0);
            Role role = this.abox.getRole(pred);
            if (log.isDebugEnabled() && !node.hasRSuccessor(role, node)) {
                log.debug((Object)("SELF: " + node + " " + role + " " + node.getDepends(c)));
            }
            this.addEdge(node, role, node, node.getDepends(c));
            if (!this.abox.isClosed()) continue;
            return;
        }
    }

    protected final void applyUnfoldingRule(QueueElement element) {
        Individual nextIn = (Individual)this.abox.getNode(element.getNode());
        if ((nextIn = nextIn.getSame()).isPruned()) {
            return;
        }
        if (this.blocking.isBlocked(nextIn)) {
            this.abox.completionQueue.add(element, CompletionQueue.ATOMLIST);
            return;
        }
        ATermAppl c = element.getLabel();
        this.applyUnfoldingRule(nextIn, c);
    }

    protected final void applyUnfoldingRule(Individual node) {
        if (!node.canApply(0) || this.blocking.isBlocked(node)) {
            return;
        }
        List<ATermAppl> types = node.getTypes(0);
        int size = types.size();
        for (int j = node.applyNext[0]; j < size; ++j) {
            ATermAppl c = types.get(j);
            if (!PelletOptions.MAINTAIN_COMPLETION_QUEUE && node.getDepends(c) == null) continue;
            this.applyUnfoldingRule(node, c);
            if (this.abox.isClosed()) {
                return;
            }
            size = types.size();
        }
        node.applyNext[0] = size;
    }

    protected void applyUnfoldingRule(Individual node, ATermAppl c) {
        List<Pair<ATermAppl, Set<ATermAppl>>> unfoldingList = this.tbox.unfold(c);
        if (unfoldingList != null) {
            DependencySet ds = node.getDepends(c);
            if (!PelletOptions.MAINTAIN_COMPLETION_QUEUE && ds == null) {
                return;
            }
            for (Pair<ATermAppl, Set<ATermAppl>> pair : unfoldingList) {
                ATermAppl unfoldedConcept = (ATermAppl)pair.first;
                Set unfoldingDS = (Set)pair.second;
                DependencySet finalDS = ds.addExplain(unfoldingDS, this.abox.doExplanation());
                if (log.isDebugEnabled() && !node.hasType(unfoldedConcept)) {
                    log.debug((Object)("UNF : " + node + ", " + c + " -> " + unfoldedConcept + " - " + finalDS));
                }
                this.addType(node, unfoldedConcept, finalDS);
            }
        }
    }

    protected void applyFunctionalMaxRule(Individual x, Role s, ATermAppl c, DependencySet ds) {
        Set<Role> functionalSupers = s.getFunctionalSupers();
        if (functionalSupers.isEmpty()) {
            functionalSupers = SetUtils.singleton(s);
        }
        block0: for (Role r : functionalSupers) {
            Edge edge;
            int edgeIndex;
            Set<Node> neighbors;
            EdgeList edges;
            if (PelletOptions.USE_TRACING) {
                ds = ds.union(s.getExplainSuper(r.getName()), this.abox.doExplanation()).union(r.getExplainFunctional(), this.abox.doExplanation());
            }
            if ((edges = x.getRNeighborEdges(r)).size() <= 1 || (neighbors = edges.getFilteredNeighbors(x, c)).size() <= 1) continue;
            Node head = null;
            int edgeCount = edges.size();
            for (edgeIndex = 0; edgeIndex < edgeCount; ++edgeIndex) {
                edge = edges.edgeAt(edgeIndex);
                head = edge.getNeighbor(x);
                if (head.isPruned() || !neighbors.contains(head)) continue;
                ds = ds.union(edge.getDepends(), this.abox.doExplanation());
                ds = ds.union(head.getDepends(c), this.abox.doExplanation());
                break;
            }
            ++edgeIndex;
            while (edgeIndex < edgeCount) {
                edge = edges.edgeAt(edgeIndex);
                Node next = edge.getNeighbor(x);
                if (!next.isPruned() && neighbors.contains(next) && !head.isSame(next)) {
                    ds = ds.union(edge.getDepends(), this.abox.doExplanation());
                    ds = ds.union(next.getDepends(c), this.abox.doExplanation());
                    if (next.isDifferent(head)) {
                        ds = ds.union(head.getDepends(c), this.abox.doExplanation());
                        ds = ds.union(next.getDepends(c), this.abox.doExplanation());
                        ds = ds.union(next.getDifferenceDependency(head), this.abox.doExplanation());
                        if (r.isFunctional()) {
                            this.abox.setClash(Clash.functionalCardinality(x, ds, r.getName()));
                            continue block0;
                        }
                        this.abox.setClash(Clash.maxCardinality(x, ds, r.getName(), 1));
                        continue block0;
                    }
                    if (x.isNominal() && head.isBlockable() && next.isBlockable() && head.hasSuccessor(x) && next.hasSuccessor(x)) {
                        Individual newNominal = this.createFreshIndividual(true);
                        this.addEdge(x, r, newNominal, ds);
                        continue block0;
                    }
                    if (next.getNominalLevel() < head.getNominalLevel() || !head.isNominal() && next.hasSuccessor(x)) {
                        Node temp = head;
                        head = next;
                        next = temp;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("FUNC: " + x + " for prop " + r + " merge " + next + " -> " + head + " " + ds));
                    }
                    this.mergeTo(next, head, ds);
                    if (this.abox.isClosed()) {
                        return;
                    }
                    if (head.isPruned()) {
                        ds = ds.union(head.getMergeDependency(true), this.abox.doExplanation());
                        head = head.getSame();
                    }
                }
                ++edgeIndex;
            }
        }
    }

    protected void applyFunctionalMaxRule(Literal x, Role r, DependencySet ds) {
        Edge edge;
        EdgeList edges = x.getInEdges().getEdges(r);
        if (edges.size() <= 1) {
            return;
        }
        Set<Node> neighbors = edges.getNeighbors(x);
        if (neighbors.size() <= 1) {
            return;
        }
        Individual head = null;
        DependencySet headDS = null;
        for (int edgeIndex = 0; edgeIndex < edges.size(); ++edgeIndex) {
            edge = edges.edgeAt(edgeIndex);
            Individual ind = edge.getFrom();
            if (!ind.isNominal() || head != null && ind.getNominalLevel() >= head.getNominalLevel()) continue;
            head = ind;
            headDS = edge.getDepends();
        }
        if (head == null) {
            head = this.abox.addFreshIndividual(true);
        } else {
            ds = ds.union(headDS, this.abox.doExplanation());
        }
        for (int i = 0; i < edges.size(); ++i) {
            edge = edges.edgeAt(i);
            Individual next = edge.getFrom();
            if (next.isPruned() || head.isSame(next)) continue;
            ds = ds.union(edge.getDepends(), this.abox.doExplanation());
            if (next.isDifferent(head)) {
                ds = ds.union(next.getDifferenceDependency(head), this.abox.doExplanation());
                if (r.isFunctional()) {
                    this.abox.setClash(Clash.functionalCardinality(x, ds, r.getName()));
                    break;
                }
                this.abox.setClash(Clash.maxCardinality(x, ds, r.getName(), 1));
                break;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("FUNC: " + x + " for prop " + r + " merge " + next + " -> " + head + " " + ds));
            }
            this.mergeTo(next, head, ds);
            if (this.abox.isClosed()) {
                return;
            }
            if (!head.isPruned()) continue;
            ds = ds.union(head.getMergeDependency(true), this.abox.doExplanation());
            head = head.getSame();
        }
    }

    void applyAllValues(QueueElement element) {
        Individual x = (Individual)this.abox.getNode(element.getNode());
        if (x.isPruned() || x.isMerged()) {
            x = x.getSame();
        }
        if (x.isPruned()) {
            return;
        }
        this.applyAllValues(x);
    }

    void applyAllValues(Individual x) {
        List<ATermAppl> allValues = x.getTypes(3);
        x.setChanged(3, false);
        Iterator<ATermAppl> i = allValues.iterator();
        while (i.hasNext()) {
            ATermAppl av = i.next();
            DependencySet avDepends = x.getDepends(av);
            if (!PelletOptions.MAINTAIN_COMPLETION_QUEUE && avDepends == null) continue;
            this.applyAllValues(x, av, avDepends);
            if (x.isMerged() || this.abox.isClosed()) {
                return;
            }
            if (!x.isChanged(3)) continue;
            i = allValues.iterator();
            x.setChanged(3, false);
        }
    }

    void applyAllValues(Individual x, ATermAppl av, DependencySet ds) {
        if (av.getArity() == 0) {
            throw new InternalReasonerException();
        }
        ATerm p = av.getArgument(0);
        ATermAppl c = (ATermAppl)av.getArgument(1);
        ATermList roleChain = ATermUtils.EMPTY_LIST;
        Role s = null;
        if (p.getType() == 4) {
            roleChain = (ATermList)p;
            s = this.abox.getRole(roleChain.getFirst());
            roleChain = roleChain.getNext();
        } else {
            s = this.abox.getRole(p);
        }
        EdgeList edges = x.getRNeighborEdges(s);
        for (int e = 0; e < edges.size(); ++e) {
            Edge edgeToY = edges.edgeAt(e);
            Node y = edgeToY.getNeighbor(x);
            DependencySet finalDS = ds.union(edgeToY.getDepends(), this.abox.doExplanation());
            if (roleChain.isEmpty()) {
                this.applyAllValues(x, s, y, c, finalDS);
            } else {
                ATermAppl allRC = ATermUtils.makeAllValues(roleChain, c);
                this.applyAllValues((Individual)y, allRC, finalDS);
            }
            if (!x.isMerged() && !this.abox.isClosed()) continue;
            return;
        }
        if (!s.isSimple()) {
            Set<ATermList> subRoleChains = s.getSubRoleChains();
            for (ATermList chain : subRoleChains) {
                DependencySet subChainDS = s.getExplainSub(chain);
                Role r = this.abox.getRole(chain.getFirst());
                edges = x.getRNeighborEdges(r);
                if (edges.isEmpty()) continue;
                ATermAppl allRC = ATermUtils.makeAllValues(chain.getNext(), c);
                for (int e = 0; e < edges.size(); ++e) {
                    Edge edgeToY = edges.edgeAt(e);
                    Node y = edgeToY.getNeighbor(x);
                    DependencySet finalDS = ds.union(edgeToY.getDepends(), this.abox.doExplanation()).union(subChainDS, this.abox.doExplanation());
                    this.applyAllValues(x, r, y, allRC, finalDS);
                    if (!x.isMerged() && !this.abox.isClosed()) continue;
                    return;
                }
            }
        }
    }

    void applyAllValues(Individual subj, Role pred, Node obj, ATermAppl c, DependencySet ds) {
        if (!obj.hasType(c)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("ALL : " + subj + " -> " + pred + " -> " + obj + " : " + c + " - " + ds));
            }
            this.addType(obj, c, ds);
        }
    }

    protected void applySomeValuesRule(IndividualIterator i) {
        i.reset();
        while (i.hasNext()) {
            Individual x = i.next();
            this.applySomeValuesRule(x);
            if (!this.abox.isClosed() && !x.isMerged()) continue;
            return;
        }
    }

    protected void applySomeValuesRule(QueueElement element) {
        Individual nextIn = (Individual)this.abox.getNode(element.getNode());
        if (this.blocking.isBlocked(nextIn = nextIn.getSame())) {
            this.abox.completionQueue.add(element, CompletionQueue.SOMELIST);
            return;
        }
        if (nextIn.isPruned()) {
            return;
        }
        this.applySomeValuesRule(nextIn, element.getLabel());
    }

    protected void applySomeValuesRule(Individual x) {
        if (!x.canApply(2) || this.blocking.isBlocked(x)) {
            return;
        }
        List<ATermAppl> types = x.getTypes(2);
        int size = types.size();
        for (int j = x.applyNext[2]; j < size; ++j) {
            ATermAppl sv = types.get(j);
            this.applySomeValuesRule(x, sv);
            if (!this.abox.isClosed() && !x.isPruned()) continue;
            return;
        }
        x.applyNext[2] = size;
    }

    protected void applySomeValuesRule(Individual x, ATermAppl sv) {
        ATermAppl a = (ATermAppl)sv.getArgument(0);
        ATermAppl s = (ATermAppl)a.getArgument(0);
        ATermAppl c = (ATermAppl)a.getArgument(1);
        if (!PelletOptions.MAINTAIN_COMPLETION_QUEUE && x.getDepends(sv) == null) {
            return;
        }
        Role role = this.abox.getRole(s);
        c = ATermUtils.negate(c);
        boolean neighborFound = false;
        boolean neighborSafe = x.isBlockable();
        Node y = null;
        Edge edge2 = null;
        EdgeList edges = x.getRNeighborEdges(role);
        for (Edge edge2 : edges) {
            y = edge2.getNeighbor(x);
            if (!y.hasType(c) || !(neighborSafe |= y.isLiteral() || !this.blocking.isBlocked((Individual)y))) continue;
            neighborFound = true;
            break;
        }
        if (neighborFound) {
            return;
        }
        DependencySet ds = x.getDepends(sv).copy();
        if (role.isDatatypeRole()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("SOME: " + x + " -> " + s + " -> " + y + " : " + c + " - " + ds));
            }
            Literal literal = (Literal)y;
            if (ATermUtils.isNominal(c) && !PelletOptions.USE_PSEUDO_NOMINALS) {
                this.abox.copyOnWrite();
                literal = this.abox.addLiteral((ATermAppl)c.getArgument(0));
            } else {
                if (!role.isFunctional() || literal == null) {
                    literal = this.abox.addLiteral();
                }
                literal.addType(c, ds);
            }
            this.addEdge(x, role, literal, ds);
        } else if (ATermUtils.isNominal(c) && !PelletOptions.USE_PSEUDO_NOMINALS) {
            this.abox.copyOnWrite();
            ATermAppl value = (ATermAppl)c.getArgument(0);
            y = this.abox.getIndividual(value);
            if (log.isDebugEnabled()) {
                log.debug((Object)("VAL : " + x + " -> " + s + " -> " + y + " - " + ds));
            }
            if (y == null) {
                if (ATermUtils.isAnonNominal(value)) {
                    y = this.abox.addIndividual(value);
                } else {
                    if (ATermUtils.isLiteral(value)) {
                        throw new InternalReasonerException("Object Property " + role + " is used with a hasValue restriction " + "where the value is a literal: " + ATermUtils.toString(value));
                    }
                    throw new InternalReasonerException("Nominal " + c + " is not found in the KB!");
                }
            }
            if (y.isMerged()) {
                ds = ds.union(y.getMergeDependency(true), this.abox.doExplanation());
                y = (Individual)y.getSame();
            }
            this.addEdge(x, role, y, ds);
        } else {
            DependencySet maxCardDS;
            boolean useExistingNode = false;
            boolean useExistingRole = false;
            DependencySet dependencySet = maxCardDS = role.isFunctional() ? DependencySet.INDEPENDENT : x.hasMax1(role);
            if (maxCardDS != null) {
                ds = ds.union(maxCardDS, this.abox.doExplanation());
                if (edge2 != null) {
                    useExistingNode = true;
                    useExistingRole = true;
                } else {
                    Set<Role> fs = role.isFunctional() ? role.getFunctionalSupers() : role.getSubRoles();
                    for (Role f : fs) {
                        edges = x.getRNeighborEdges(f);
                        if (edges.isEmpty()) continue;
                        if (useExistingNode) {
                            DependencySet fds = DependencySet.INDEPENDENT;
                            if (PelletOptions.USE_TRACING) {
                                fds = role.isFunctional() ? role.getExplainSuper(f.getName()) : role.getExplainSub(f.getName());
                            }
                            Edge otherEdge = edges.edgeAt(0);
                            Node otherNode = otherEdge.getNeighbor(x);
                            DependencySet d = ds.union(edge2.getDepends(), this.abox.doExplanation()).union(otherEdge.getDepends(), this.abox.doExplanation()).union(fds, this.abox.doExplanation());
                            this.mergeTo(y, otherNode, d);
                            continue;
                        }
                        useExistingNode = true;
                        edge2 = edges.edgeAt(0);
                        y = edge2.getNeighbor(x);
                    }
                    if (y != null) {
                        y = y.getSame();
                    }
                }
            }
            if (useExistingNode) {
                ds = ds.union(edge2.getDepends(), this.abox.doExplanation());
            } else {
                y = this.createFreshIndividual(false);
                y.depth = x.depth + 1;
                if (x.depth >= this.abox.treeDepth) {
                    this.abox.treeDepth = x.depth + 1;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("SOME: " + x + " -> " + s + " -> " + y + " : " + c + (useExistingNode ? "" : " (*)") + " - " + ds));
            }
            this.addType(y, c, ds);
            if (!useExistingRole) {
                this.addEdge(x, role, y, ds);
            }
        }
    }

    protected void applyDisjunctionRule(IndividualIterator i) {
        i.reset();
        while (i.hasNext()) {
            Individual node = i.next();
            this.applyDisjunctionRule(node);
            if (!this.abox.isClosed() && !node.isMerged()) continue;
            return;
        }
    }

    protected void applyDisjunctionRule(Individual node) {
        node.setChanged(1, false);
        if (!node.canApply(1) || this.blocking.isIndirectlyBlocked(node)) {
            return;
        }
        List<ATermAppl> types = node.getTypes(1);
        int size = types.size();
        ATermAppl[] disjunctions = new ATermAppl[size - node.applyNext[1]];
        types.subList(node.applyNext[1], size).toArray(disjunctions);
        if (PelletOptions.USE_DISJUNCTION_SORTING != "NO") {
            DisjunctionSorting.sort(node, disjunctions);
        }
        block0: for (ATermAppl disjunction : disjunctions) {
            if (!PelletOptions.MAINTAIN_COMPLETION_QUEUE && node.getDepends(disjunction) == null) continue;
            ATermAppl a = (ATermAppl)disjunction.getArgument(0);
            ATermList disjuncts = (ATermList)a.getArgument(0);
            ATermAppl[] disj = new ATermAppl[disjuncts.getLength()];
            int index = 0;
            while (!disjuncts.isEmpty()) {
                disj[index] = ATermUtils.negate((ATermAppl)disjuncts.getFirst());
                if (node.hasType(disj[index])) continue block0;
                disjuncts = disjuncts.getNext();
                ++index;
            }
            DisjunctionBranch newBranch = new DisjunctionBranch(this.abox, this, node, disjunction, node.getDepends(disjunction), disj);
            this.addBranch(newBranch);
            newBranch.tryNext();
            if (!this.abox.isClosed() && !node.isMerged()) continue;
            return;
        }
        node.applyNext[1] = size;
    }

    protected void applyDisjunctionRule(QueueElement element) {
        Individual nextIn = (Individual)this.abox.getNode(element.getNode());
        if ((nextIn = nextIn.getSame()).isPruned()) {
            return;
        }
        if (this.blocking.isIndirectlyBlocked(nextIn)) {
            this.abox.completionQueue.add(element, CompletionQueue.ORLIST);
            return;
        }
        ATermAppl disjunction = element.getLabel();
        if (!PelletOptions.MAINTAIN_COMPLETION_QUEUE && nextIn.getDepends(disjunction) == null) {
            return;
        }
        ATermAppl a = (ATermAppl)disjunction.getArgument(0);
        ATermList disjuncts = (ATermList)a.getArgument(0);
        ATermAppl[] disj = new ATermAppl[disjuncts.getLength()];
        int index = 0;
        while (!disjuncts.isEmpty()) {
            disj[index] = ATermUtils.negate((ATermAppl)disjuncts.getFirst());
            if (nextIn.hasType(disj[index])) {
                return;
            }
            disjuncts = disjuncts.getNext();
            ++index;
        }
        DisjunctionBranch newBranch = new DisjunctionBranch(this.abox, this, nextIn, disjunction, nextIn.getDepends(disjunction), disj);
        this.addBranch(newBranch);
        newBranch.tryNext();
    }

    protected boolean applyMaxRule(Individual x, Role r, ATermAppl c, int k, DependencySet ds) {
        EdgeList edges = x.getRNeighborEdges(r);
        Set<Node> neighbors = edges.getFilteredNeighbors(x, c);
        int n = neighbors.size();
        if (k == 0 && n > 0) {
            for (int e = 0; e < edges.size(); ++e) {
                Edge edge = edges.edgeAt(e);
                Node neighbor = edge.getNeighbor(x);
                DependencySet typeDS = neighbor.getDepends(c);
                if (typeDS == null) continue;
                DependencySet subDS = r.getExplainSub(edge.getRole().getName());
                if (subDS != null) {
                    ds = ds.union(subDS, this.abox.doExplanation());
                }
                ds = ds.union(edge.getDepends(), this.abox.doExplanation());
                ds = ds.union(typeDS, this.abox.doExplanation());
            }
            this.abox.setClash(Clash.maxCardinality(x, ds, r.getName(), 0));
            return false;
        }
        if (n <= k) {
            return false;
        }
        ArrayList<NodeMerge> mergePairs = new ArrayList<NodeMerge>();
        DependencySet differenceDS = this.findMergeNodes(neighbors, x, mergePairs);
        ds = ds.union(differenceDS, this.abox.doExplanation());
        if (mergePairs.size() == 0) {
            DependencySet dsEdges = x.hasDistinctRNeighborsForMax(r, k + 1, c);
            if (dsEdges == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Cannot determine the exact clash dependency for " + x));
                }
                this.abox.setClash(Clash.maxCardinality(x, ds));
                return false;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Early clash detection for max rule worked " + x + " has more than " + k + " " + r + " edges " + ds.union(dsEdges, this.abox.doExplanation()) + " " + x.getRNeighborEdges(r).getNeighbors(x)));
            }
            if (this.abox.doExplanation()) {
                this.abox.setClash(Clash.maxCardinality(x, ds.union(dsEdges, this.abox.doExplanation()), r.getName(), k));
            } else {
                this.abox.setClash(Clash.maxCardinality(x, ds.union(dsEdges, this.abox.doExplanation())));
            }
            return false;
        }
        MaxBranch newBranch = new MaxBranch(this.abox, this, x, r, k, c, mergePairs, ds);
        this.addBranch(newBranch);
        if (!newBranch.tryNext()) {
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("hasMore: " + (n > k + 1)));
        }
        return n > k + 1;
    }

    protected void applyChooseRule(IndividualIterator i) {
        i.reset();
        while (i.hasNext()) {
            Individual x = i.next();
            this.applyChooseRule(x);
            if (!this.abox.isClosed()) continue;
            return;
        }
    }

    protected void applyChooseRule(QueueElement element) {
        Individual nextIn = (Individual)this.abox.getNode(element.getNode());
        if ((nextIn = nextIn.getSame()).isPruned()) {
            return;
        }
        this.applyChooseRule(nextIn, element.getLabel());
    }

    protected void applyChooseRule(Individual x) {
        if (!x.canApply(5) || this.blocking.isIndirectlyBlocked(x)) {
            return;
        }
        List<ATermAppl> maxCardinality = x.getTypes(5);
        for (ATermAppl maxCard : maxCardinality) {
            this.applyChooseRule(x, maxCard);
        }
    }

    protected void applyChooseRule(Individual x, ATermAppl maxCard) {
        ATermAppl max = (ATermAppl)maxCard.getArgument(0);
        Role r = this.abox.getRole(max.getArgument(0));
        ATermAppl c = (ATermAppl)max.getArgument(2);
        if (ATermUtils.isTop(c)) {
            return;
        }
        if (!PelletOptions.MAINTAIN_COMPLETION_QUEUE && x.getDepends(maxCard) == null) {
            return;
        }
        EdgeList edges = x.getRNeighborEdges(r);
        for (Edge edge : edges) {
            Node neighbor = edge.getNeighbor(x);
            if (neighbor.hasType(c) || neighbor.hasType(ATermUtils.negate(c))) continue;
            ChooseBranch newBranch = new ChooseBranch(this.abox, this, neighbor, c, x.getDepends(maxCard));
            this.addBranch(newBranch);
            newBranch.tryNext();
            if (!this.abox.isClosed()) continue;
            return;
        }
    }

    protected void applyGuessingRule(IndividualIterator i) {
        i.reset();
        block0: while (i.hasNext()) {
            Individual x = i.next();
            if (x.isBlockable()) continue;
            List<ATermAppl> types = x.getTypes(5);
            int size = types.size();
            for (int j = 0; j < size; ++j) {
                ATermAppl mc = types.get(j);
                this.applyGuessingRule(x, mc);
                if (this.abox.isClosed()) {
                    return;
                }
                if (x.isPruned()) break block0;
            }
        }
    }

    protected void applyGuessingRule(QueueElement element) {
        Individual x = (Individual)this.abox.getNode(element.getNode());
        if ((x = x.getSame()).isBlockable()) {
            this.abox.completionQueue.add(element, CompletionQueue.GUESSLIST);
            return;
        }
        if (x.isPruned()) {
            return;
        }
        this.applyGuessingRule(x, element.getLabel());
    }

    private void applyGuessingRule(Individual x, ATermAppl mc) {
        ATermAppl max = (ATermAppl)mc.getArgument(0);
        Role r = this.abox.getRole(max.getArgument(0));
        int n = ((ATermInt)max.getArgument(1)).getInt() - 1;
        if (r.isDatatypeRole()) {
            return;
        }
        boolean apply = false;
        EdgeList edges = x.getRPredecessorEdges(r.getInverse());
        for (int e = 0; e < edges.size(); ++e) {
            Edge edge = edges.edgeAt(e);
            Individual pred = edge.getFrom();
            if (!pred.isBlockable()) continue;
            apply = true;
            break;
        }
        if (!apply) {
            return;
        }
        if (x.getMaxCard(r) < n) {
            return;
        }
        if (x.hasDistinctRNeighborsForMin(r, n, ATermUtils.TOP, true)) {
            return;
        }
        int guessMin = x.getMinCard(r);
        if (guessMin == 0) {
            guessMin = 1;
        }
        DependencySet ds = x.getDepends(mc);
        edges = x.getRNeighborEdges(r);
        for (int e = 0; e < edges.size(); ++e) {
            Edge edge = edges.edgeAt(e);
            ds = ds.union(edge.getDepends(), this.abox.doExplanation());
        }
        GuessBranch newBranch = new GuessBranch(this.abox, this, x, r, guessMin, n, ds);
        this.addBranch(newBranch);
        newBranch.tryNext();
    }

    protected void applyMaxRule(IndividualIterator i) {
        i.reset();
        while (i.hasNext()) {
            Individual x = i.next();
            this.applyMaxRule(x);
            if (!this.abox.isClosed()) continue;
            return;
        }
    }

    protected void applyMaxRule(Individual x) {
        if (!x.canApply(5) || this.blocking.isIndirectlyBlocked(x)) {
            return;
        }
        List<ATermAppl> maxCardinality = x.getTypes(5);
        for (int i = 0; i < maxCardinality.size(); ++i) {
            ATermAppl mc = maxCardinality.get(i);
            this.applyMaxRule(x, mc);
            if (this.abox.isClosed()) {
                return;
            }
            if (!x.isMerged()) continue;
            return;
        }
        x.setChanged(5, false);
    }

    protected void applyMaxRule(Individual x, ATermAppl mc) {
        ATermAppl max = (ATermAppl)mc.getArgument(0);
        Role r = this.abox.getRole(max.getArgument(0));
        int n = ((ATermInt)max.getArgument(1)).getInt() - 1;
        ATermAppl c = (ATermAppl)max.getArgument(2);
        DependencySet ds = x.getDepends(mc);
        if (!PelletOptions.MAINTAIN_COMPLETION_QUEUE && ds == null) {
            return;
        }
        if (n == 1) {
            this.applyFunctionalMaxRule(x, r, c, ds);
            if (this.abox.isClosed()) {
                return;
            }
        } else {
            boolean hasMore = true;
            while (hasMore) {
                hasMore = this.applyMaxRule(x, r, c, n, ds);
                if (this.abox.isClosed()) {
                    return;
                }
                if (x.isMerged()) {
                    return;
                }
                if (!hasMore) continue;
                ds = ds.union(new DependencySet(this.abox.getBranches().size()), this.abox.doExplanation());
            }
        }
    }

    protected void applyMaxRule(QueueElement element) {
        Individual nextIn = (Individual)this.abox.getNode(element.getNode());
        if (this.blocking.isIndirectlyBlocked(nextIn = nextIn.getSame())) {
            this.abox.completionQueue.add(element, CompletionQueue.MAXLIST);
            return;
        }
        if (nextIn.isPruned()) {
            return;
        }
        this.applyMaxRule(nextIn, element.getLabel());
    }

    protected void applyMinRule(IndividualIterator i) {
        i.reset();
        while (i.hasNext()) {
            Individual x = i.next();
            this.applyMinRule(x);
            if (!this.abox.isClosed()) continue;
            return;
        }
    }

    protected void applyMinRule(Individual x) {
        if (!x.canApply(4) || this.blocking.isBlocked(x)) {
            return;
        }
        List<ATermAppl> types = x.getTypes(4);
        int size = types.size();
        for (int j = x.applyNext[4]; j < size; ++j) {
            ATermAppl mc = types.get(j);
            this.applyMinRule(x, mc);
            if (!this.abox.isClosed()) continue;
            return;
        }
        x.applyNext[4] = size;
    }

    protected void applyMinRule(Individual x, ATermAppl mc) {
        ATermAppl c;
        int n;
        Role r = this.abox.getRole(mc.getArgument(0));
        if (x.hasDistinctRNeighborsForMin(r, n = ((ATermInt)mc.getArgument(1)).getInt(), c = (ATermAppl)mc.getArgument(2))) {
            return;
        }
        DependencySet ds = x.getDepends(mc);
        if (!PelletOptions.MAINTAIN_COMPLETION_QUEUE && ds == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("MIN : " + x + " -> " + r + " -> anon" + (n == 1 ? "" : this.abox.anonCount + 1 + " - anon") + (this.abox.anonCount + n) + " " + c + " " + ds));
        }
        Node[] y = new Node[n];
        for (int c1 = 0; c1 < n; ++c1) {
            if (r.isDatatypeRole()) {
                y[c1] = this.abox.addLiteral();
            } else {
                y[c1] = this.createFreshIndividual(false);
                y[c1].depth = x.depth + 1;
                if (x.depth >= this.abox.treeDepth) {
                    this.abox.treeDepth = x.depth + 1;
                }
            }
            Node succ = y[c1];
            DependencySet finalDS = ds;
            this.addEdge(x, r, succ, ds);
            if (succ.isPruned()) {
                succ = succ.getMergedTo();
                finalDS = finalDS.union(succ.getMergeDependency(true), this.abox.doExplanation());
            }
            this.addType(succ, c, finalDS);
            for (int c2 = 0; c2 < c1; ++c2) {
                succ.setDifferent(y[c2], ds);
            }
        }
    }

    protected void applyMinRule(QueueElement element) {
        Individual x = (Individual)this.abox.getNode(element.getNode());
        if (this.blocking.isBlocked(x = x.getSame())) {
            this.abox.completionQueue.add(element, CompletionQueue.MINLIST);
            return;
        }
        if (x.isPruned()) {
            return;
        }
        ATermAppl mc = element.getLabel();
        this.applyMinRule(x, mc);
    }

    protected void applyLiteralRule(QueueElement element) {
        Node node = this.abox.getNode(element.getNode());
        if (!(node instanceof Literal)) {
            return;
        }
        Literal lit = (Literal)node;
        if ((lit = lit.getSame()).isPruned()) {
            return;
        }
        if (lit.getValue() != null) {
            return;
        }
        LiteralValueBranch newBranch = new LiteralValueBranch(this.abox, this, lit, lit.getDatatype());
        this.addBranch(newBranch);
        newBranch.tryNext();
        if (this.abox.isClosed()) {
            return;
        }
    }

    protected void applyLiteralRule() {
        LiteralIterator i = new LiteralIterator(this.abox);
        while (i.hasNext()) {
            Literal lit = (Literal)i.next();
            if (lit.getValue() != null) continue;
            LiteralValueBranch newBranch = new LiteralValueBranch(this.abox, this, lit, lit.getDatatype());
            this.addBranch(newBranch);
            newBranch.tryNext();
            if (!this.abox.isClosed()) continue;
            return;
        }
    }

    protected void applyNominalRule(IndividualIterator i) {
        i.reset();
        while (i.hasNext()) {
            Individual y = i.next();
            if (!y.canApply(6) || this.blocking.isBlocked(y)) continue;
            this.applyNominalRule(y);
            y.setChanged(6, false);
            if (this.abox.isClosed()) {
                return;
            }
            if (!y.isMerged()) continue;
            this.applyNominalRule(y.getSame());
        }
    }

    void applyNominalRule(Individual y) {
        if (PelletOptions.USE_PSEUDO_NOMINALS) {
            return;
        }
        List<ATermAppl> types = y.getTypes(6);
        int size = types.size();
        for (int j = 0; j < size; ++j) {
            ATermAppl nc = types.get(j);
            DependencySet ds = y.getDepends(nc);
            if (!PelletOptions.MAINTAIN_COMPLETION_QUEUE && ds == null) continue;
            this.applyNominalRule(y, nc, ds);
            if (!this.abox.isClosed() && !y.isMerged()) continue;
            return;
        }
    }

    void applyNominalRule(QueueElement element) {
        if (PelletOptions.USE_PSEUDO_NOMINALS) {
            return;
        }
        Individual y = (Individual)this.abox.getNode(element.getNode());
        if (this.blocking.isBlocked(y = y.getSame())) {
            this.abox.completionQueue.add(element, CompletionQueue.NOMLIST);
            return;
        }
        if (y.isPruned()) {
            return;
        }
        ATermAppl nc = element.getLabel();
        DependencySet ds = y.getDepends(nc);
        if (!PelletOptions.MAINTAIN_COMPLETION_QUEUE && ds == null) {
            return;
        }
        this.applyNominalRule(y, nc, ds);
    }

    void applyNominalRule(Individual y, ATermAppl nc, DependencySet ds) {
        this.abox.copyOnWrite();
        ATermAppl nominal = (ATermAppl)nc.getArgument(0);
        Individual z = this.abox.getIndividual(nominal);
        if (z == null) {
            if (ATermUtils.isAnonNominal(nominal)) {
                z = this.abox.addIndividual(nominal);
            } else {
                throw new InternalReasonerException("Nominal " + nominal + " not found in KB!");
            }
        }
        if (z.isMerged()) {
            ds = ds.union(z.getMergeDependency(true), this.abox.doExplanation());
            z = z.getSame();
            if (this.abox.getBranch() > 0 && PelletOptions.USE_COMPLETION_QUEUE) {
                this.abox.completionQueue.addEffected(this.abox.getBranch(), z.getName());
            }
        }
        if (y.isSame(z)) {
            return;
        }
        if (y.isDifferent(z)) {
            ds = ds.union(y.getDifferenceDependency(z), this.abox.doExplanation());
            if (this.abox.doExplanation()) {
                this.abox.setClash(Clash.nominal(y, ds, z.getName()));
            } else {
                this.abox.setClash(Clash.nominal(y, ds));
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("NOM:  " + y + " -> " + z));
        }
        this.mergeTo(y, z, ds);
    }

    private void mergeLater(Node y, Node z, DependencySet ds) {
        this.mergeList.add(new NodeMerge(y, z, ds));
    }

    protected void mergeFirst() {
        NodeMerge merge = this.mergeList.remove(0);
        Node y = this.abox.getNode(merge.y);
        Node z = this.abox.getNode(merge.z);
        DependencySet ds = merge.ds;
        if (y.isMerged()) {
            ds = ds.union(y.getMergeDependency(true), this.abox.doExplanation());
            y = y.getSame();
        }
        if (z.isMerged()) {
            ds = ds.union(z.getMergeDependency(true), this.abox.doExplanation());
            z = z.getSame();
        }
        if (y.isPruned() || z.isPruned()) {
            return;
        }
        this.mergeTo(y, z, ds);
    }

    public void mergeTo(Node y, Node z, DependencySet ds) {
        if (this.abox.getBranch() >= 0 && PelletOptions.USE_COMPLETION_QUEUE) {
            this.abox.completionQueue.addEffected(this.abox.getBranch(), y.getName());
            this.abox.completionQueue.addEffected(this.abox.getBranch(), z.getName());
        }
        if (PelletOptions.USE_INCREMENTAL_DELETION) {
            this.abox.getKB().getDependencyIndex().addMergeDependency(y.getName(), z.getName(), ds);
        }
        if (y.isSame(z)) {
            return;
        }
        if (y.isDifferent(z)) {
            this.abox.setClash(Clash.nominal(y, y.getDifferenceDependency(z).union(ds, this.abox.doExplanation())));
            return;
        }
        if (!y.isSame(z)) {
            this.abox.changed = true;
            if (this.merging) {
                this.mergeLater(y, z, ds);
                return;
            }
            this.merging = true;
            if (log.isDebugEnabled()) {
                log.debug((Object)("MERG: " + y + " -> " + z + " " + ds));
            }
            ds = ds.copy();
            ds.branch = this.abox.getBranch();
            if (y instanceof Literal && z instanceof Literal) {
                this.mergeLiterals((Literal)y, (Literal)z, ds);
            } else if (y instanceof Individual && z instanceof Individual) {
                this.mergeIndividuals((Individual)y, (Individual)z, ds);
            } else {
                throw new InternalReasonerException("Invalid merge operation!");
            }
        }
        this.merging = false;
        if (!this.mergeList.isEmpty()) {
            if (this.abox.isClosed()) {
                return;
            }
            this.mergeFirst();
        }
    }

    protected void mergeIndividuals(Individual y, Individual x, DependencySet ds) {
        y.setSame(x, ds);
        x.setNominalLevel(Math.min(x.getNominalLevel(), y.getNominalLevel()));
        Map types = y.getDepends();
        for (Map.Entry entry : types.entrySet()) {
            ATermAppl yType = (ATermAppl)entry.getKey();
            DependencySet finalDS = ds.union((DependencySet)entry.getValue(), this.abox.doExplanation());
            this.addType(x, yType, finalDS);
        }
        EdgeList inEdges = y.getInEdges();
        for (int e = 0; e < inEdges.size(); ++e) {
            Edge edge = inEdges.edgeAt(e);
            Individual z = edge.getFrom();
            Role r = edge.getRole();
            DependencySet finalDS = ds.union(edge.getDepends(), this.abox.doExplanation());
            if (y.equals(z)) {
                this.addEdge(x, r, x, finalDS);
            } else if (x.hasSuccessor(z)) {
                this.addEdge(x, r.getInverse(), z, finalDS);
            } else {
                this.addEdge(z, r, x, finalDS);
            }
            z.removeEdge(edge);
            if (this.abox.getBranch() < 0 || !PelletOptions.USE_COMPLETION_QUEUE) continue;
            this.abox.completionQueue.addEffected(this.abox.getBranch(), z.getName());
        }
        x.inheritDifferents(y, ds);
        y.prune(ds);
        EdgeList outEdges = y.getOutEdges();
        for (int e = 0; e < outEdges.size(); ++e) {
            Edge edge = outEdges.edgeAt(e);
            Node z = edge.getTo();
            if (!z.isNominal() || y.equals(z)) continue;
            Role r = edge.getRole();
            DependencySet finalDS = ds.union(edge.getDepends(), this.abox.doExplanation());
            this.addEdge(x, r, z, finalDS);
            if (this.abox.getBranch() < 0 || !PelletOptions.USE_COMPLETION_QUEUE) continue;
            this.abox.completionQueue.addEffected(this.abox.getBranch(), z.getName());
        }
    }

    protected void mergeLiterals(Literal y, Literal x, DependencySet ds) {
        y.setSame(x, ds);
        x.addAllTypes(y.getDepends(), ds);
        EdgeList inEdges = y.getInEdges();
        for (int e = 0; e < inEdges.size(); ++e) {
            Edge edge = inEdges.edgeAt(e);
            Individual z = edge.getFrom();
            Role r = edge.getRole();
            DependencySet finalDS = ds.union(edge.getDepends(), this.abox.doExplanation());
            this.addEdge(z, r, x, finalDS);
            z.removeEdge(edge);
            if (this.abox.getBranch() < 0 || !PelletOptions.USE_COMPLETION_QUEUE) continue;
            this.abox.completionQueue.addEffected(this.abox.getBranch(), z.getName());
        }
        x.inheritDifferents(y, ds);
        y.prune(ds);
    }

    DependencySet findMergeNodes(Set<Node> neighbors, Individual node, List<NodeMerge> pairs) {
        Timer t = this.timers.startTimer("findMergeNodes");
        DependencySet ds = DependencySet.INDEPENDENT;
        ArrayList<Node> nodes = new ArrayList<Node>(neighbors);
        for (int i = 0; i < nodes.size(); ++i) {
            Node y = (Node)nodes.get(i);
            for (int j = i + 1; j < nodes.size(); ++j) {
                Node x = (Node)nodes.get(j);
                if (y.isDifferent(x)) {
                    ds = ds.union(y.getDifferenceDependency(x), this.abox.doExplanation());
                    continue;
                }
                if (x.getNominalLevel() < y.getNominalLevel()) {
                    pairs.add(new NodeMerge(y, x));
                    continue;
                }
                if (y.isNominal()) {
                    pairs.add(new NodeMerge(x, y));
                    continue;
                }
                if (y.hasSuccessor(node)) {
                    pairs.add(new NodeMerge(x, y));
                    continue;
                }
                pairs.add(new NodeMerge(y, x));
            }
        }
        t.stop();
        return ds;
    }

    public void restore(Branch br) {
        this.abox.setBranch(br.branch);
        this.abox.setClash(null);
        this.abox.anonCount = br.anonCount;
        this.abox.rulesNotApplied = true;
        this.mergeList.clear();
        List nodeList = this.abox.getNodeNames();
        Map nodes = this.abox.getNodeMap();
        if (log.isDebugEnabled()) {
            log.debug((Object)("RESTORE: Branch " + br.branch));
            if (br.nodeCount < nodeList.size()) {
                log.debug((Object)("Remove nodes " + nodeList.subList(br.nodeCount, nodeList.size())));
            }
        }
        if (PelletOptions.USE_COMPLETION_QUEUE) {
            Set effected = this.abox.completionQueue.removeEffects(br.branch);
            for (int i = br.nodeCount; i < nodeList.size(); ++i) {
                ATermAppl next = (ATermAppl)nodeList.get(i);
                nodes.remove(next);
                effected.remove(next);
            }
            for (ATerm x : effected) {
                Node node = this.abox.getNode(x);
                node.restore(br.branch);
            }
        } else {
            for (int i = 0; i < nodeList.size(); ++i) {
                ATerm x = (ATerm)nodeList.get(i);
                Node node = this.abox.getNode(x);
                if (i >= br.nodeCount) {
                    nodes.remove(x);
                    continue;
                }
                node.restore(br.branch);
            }
        }
        nodeList.subList(br.nodeCount, nodeList.size()).clear();
        if (PelletOptions.USE_COMPLETION_QUEUE) {
            this.abox.completionQueue.restore(br.branch);
            this.abox.completionQueue.init(CompletionQueue.ALLLIST);
            while (this.abox.completionQueue.hasNext(CompletionQueue.ALLLIST)) {
                QueueElement next = (QueueElement)this.abox.completionQueue.getNext(CompletionQueue.ALLLIST);
                this.applyAllValues(next);
                if (!this.abox.isClosed()) continue;
                break;
            }
        } else {
            IndividualIterator i = this.abox.getIndIterator();
            while (i.hasNext()) {
                Individual ind = (Individual)i.next();
                this.applyAllValues(ind);
            }
        }
        if (log.isDebugEnabled()) {
            this.abox.printTree();
        }
        if (!this.abox.isClosed()) {
            this.abox.validate();
        }
    }

    void addBranch(Branch newBranch) {
        this.abox.getBranches().add(newBranch);
        if (newBranch.branch != this.abox.getBranches().size()) {
            throw new RuntimeException("Invalid branch created!");
        }
        this.completionTimer.check();
        if (this.supportsPseudoModelCompletion() && PelletOptions.USE_INCREMENTAL_DELETION) {
            this.abox.getKB().getDependencyIndex().addBranchAddDependency(newBranch);
        }
    }

    void printBlocked() {
        int blockedCount = 0;
        String blockedNodes = "";
        IndividualIterator n = this.abox.getIndIterator();
        while (n.hasNext()) {
            Individual node = (Individual)n.next();
            ATermAppl x = node.getName();
            if (!this.blocking.isBlocked(node)) continue;
            ++blockedCount;
            blockedNodes = blockedNodes + x + " ";
        }
        log.debug((Object)("Blocked nodes " + blockedCount + " [" + blockedNodes + "]"));
    }

    void checkDatatypeCount(IndividualIterator it) {
        this.timers.startTimer("clashDatatype");
        it.reset();
        while (it.hasNext()) {
            Individual x = it.next();
            this.checkDatatypeCount(x);
            if (!this.abox.isClosed()) continue;
            return;
        }
        this.timers.stopTimer("clashDatatype");
    }

    void checkDatatypeCount(QueueElement element) {
        this.timers.startTimer("clashDatatype");
        Individual x = (Individual)this.abox.getNode(element.getNode());
        x = x.getSame();
        if (x.isPruned() || !x.isChanged(3) && !x.isChanged(4)) {
            return;
        }
        this.checkDatatypeCount(x);
    }

    void checkDatatypeCount(Individual x) {
        ATermAppl r;
        if (!x.isChanged(3) && !x.isChanged(4)) {
            return;
        }
        HashMap allValues = new HashMap();
        HashMap<ATermAppl, DependencySet> depends = new HashMap<ATermAppl, DependencySet>();
        for (ATermAppl av : x.getTypes(3)) {
            r = (ATermAppl)av.getArgument(0);
            ATermAppl c = (ATermAppl)av.getArgument(1);
            Role role = this.abox.getRole(r);
            if (!role.isDatatypeRole()) continue;
            DependencySet ds = (DependencySet)depends.get(r);
            if (!PelletOptions.MAINTAIN_COMPLETION_QUEUE && x.getDepends(av) == null) continue;
            ArrayList<ATermAppl> ranges = (ArrayList<ATermAppl>)allValues.get(r);
            if (ranges == null) {
                ranges = new ArrayList<ATermAppl>();
                ds = DependencySet.EMPTY;
            }
            if (ATermUtils.isAnd(c)) {
                ATermList types = (ATermList)c.getArgument(0);
                while (types.isEmpty()) {
                    ranges.add((ATermAppl)types.getFirst());
                    types = types.getNext();
                }
            } else {
                ranges.add(c);
            }
            ds = ds.union(x.getDepends(av), this.abox.doExplanation());
            allValues.put(r, ranges);
            depends.put(r, ds);
        }
        for (ATermAppl mc : x.getTypes(4)) {
            r = (ATermAppl)mc.getArgument(0);
            Role role = this.abox.getRole(r);
            ATermAppl range = role.getRange();
            if (!role.isDatatypeRole() || range == null || !PelletOptions.MAINTAIN_COMPLETION_QUEUE && x.getDepends(mc) == null) continue;
            ArrayList<ATermAppl> ranges = (ArrayList<ATermAppl>)allValues.get(r);
            if (ranges == null) {
                ranges = new ArrayList<ATermAppl>();
                allValues.put(r, ranges);
                depends.put(r, DependencySet.INDEPENDENT);
            }
            ranges.add(range);
        }
        for (ATermAppl r2 : allValues.keySet()) {
            Role role = this.abox.getRole(r2);
            List ranges = (List)allValues.get(r2);
            ATermAppl[] dt = new ATermAppl[ranges.size()];
            ranges.toArray(dt);
            this.timers.startTimer("getMaxCount");
            int n = this.abox.getDatatypeReasoner().intersection(dt).size();
            this.timers.stopTimer("getMaxCount");
            if (n == -1 || n == Integer.MAX_VALUE) continue;
            boolean clash = x.checkMaxClash(ATermUtils.makeNormalizedMax(r2, n, ATermUtils.TOP_LIT), DependencySet.INDEPENDENT);
            if (clash) {
                return;
            }
            DependencySet dsEdges = x.hasDistinctRNeighborsForMax(role, n + 1, ATermUtils.TOP_LIT);
            if (dsEdges == null) continue;
            DependencySet ds = (DependencySet)depends.get(r2);
            ds = ds.union(dsEdges, this.abox.doExplanation());
            if (log.isDebugEnabled()) {
                log.debug((Object)("CLASH: literal restriction " + x + " has " + ranges + " and more neighbors -> " + ds));
            }
            this.abox.setClash(Clash.unexplained(x, ds));
            return;
        }
    }

    public String toString() {
        String name = this.getClass().getName();
        int lastIndex = name.lastIndexOf(46);
        return name.substring(lastIndex + 1);
    }
}

