/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.List;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Branch;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.CompletionQueue;
import org.mindswap.pellet.CompletionStrategy;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.NodeMerge;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.QueueElement;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.ATermUtils;

class MaxBranch
extends Branch {
    List mergePairs;
    Role r;
    int n;
    ATermAppl qualification;
    DependencySet[] prevDS;

    MaxBranch(ABox abox, CompletionStrategy strategy, Individual x, Role r, int n, ATermAppl qualification, List mergePairs, DependencySet ds) {
        super(abox, strategy, x, ds, mergePairs.size());
        this.r = r;
        this.n = n;
        this.mergePairs = mergePairs;
        this.qualification = qualification;
        this.prevDS = new DependencySet[mergePairs.size()];
    }

    protected Branch copyTo(ABox abox) {
        Individual x = abox.getIndividual(this.ind.getName());
        MaxBranch b = new MaxBranch(abox, null, x, this.r, this.n, this.qualification, this.mergePairs, this.termDepends);
        b.anonCount = this.anonCount;
        b.nodeCount = this.nodeCount;
        b.branch = this.branch;
        b.nodeName = this.ind.getName();
        b.strategy = this.strategy;
        b.tryNext = this.tryNext;
        b.prevDS = new DependencySet[this.prevDS.length];
        System.arraycopy(this.prevDS, 0, b.prevDS, 0, this.tryNext);
        return b;
    }

    protected void tryBranch() {
        this.abox.incrementBranch();
        ATermAppl maxCon = ATermUtils.makeMax((ATerm)this.r.getName(), this.n, (ATerm)this.qualification);
        maxCon = ATermUtils.normalize(maxCon);
        QueueElement qElement = new QueueElement(this.ind.getName(), maxCon);
        CompletionQueue cfr_ignored_0 = this.abox.completionQueue;
        this.abox.completionQueue.add(qElement, CompletionQueue.MAXLIST);
        CompletionQueue cfr_ignored_1 = this.abox.completionQueue;
        this.abox.completionQueue.add(qElement, CompletionQueue.CHOOSELIST);
        DependencySet ds = this.termDepends;
        while (this.tryNext < this.tryCount) {
            DependencySet clashDepends;
            Branch branch;
            if (PelletOptions.USE_SEMANTIC_BRANCHING) {
                for (int m = 0; m < this.tryNext; ++m) {
                    NodeMerge nm = (NodeMerge)this.mergePairs.get(m);
                    Node y = this.abox.getNode(nm.y);
                    Node z = this.abox.getNode(nm.z);
                    y.setDifferent(z, this.prevDS[m]);
                }
            }
            NodeMerge nm = (NodeMerge)this.mergePairs.get(this.tryNext);
            Node y = this.abox.getNode(nm.y);
            Node z = this.abox.getNode(nm.z);
            if (log.isDebugEnabled()) {
                log.debug((Object)("MAX : (" + (this.tryNext + 1) + "/" + this.mergePairs.size() + ") at branch (" + this.branch + ") to  " + this.ind + " for prop " + this.r + " qualification " + this.qualification + " merge " + y + " -> " + z + " " + ds));
            }
            ds = ds.union(new DependencySet(this.branch), this.abox.doExplanation());
            EdgeList rNeighbors = this.ind.getRNeighborEdges(this.r);
            boolean yEdge = false;
            boolean zEdge = false;
            for (Edge edge : rNeighbors) {
                Node neighbor = edge.getNeighbor(this.ind);
                if (neighbor.equals(y)) {
                    ds = ds.union(edge.getDepends(), this.abox.doExplanation());
                    yEdge = true;
                    continue;
                }
                if (!neighbor.equals(z)) continue;
                ds = ds.union(edge.getDepends(), this.abox.doExplanation());
                zEdge = true;
            }
            if (!yEdge || !zEdge) {
                throw new InternalReasonerException("An error occurred related to the max cardinality restriction about " + this.r);
            }
            ds = ds.union(y.getDepends(this.qualification), this.abox.doExplanation());
            ds = ds.union(z.getDepends(this.qualification), this.abox.doExplanation());
            for (int b = this.abox.getBranches().size() - 2; b >= 0 && (branch = this.abox.getBranches().get(b)) instanceof MaxBranch; --b) {
                MaxBranch prevBranch = (MaxBranch)branch;
                if (!prevBranch.ind.equals(this.ind) || !prevBranch.r.equals(this.r) || !prevBranch.qualification.equals(this.qualification)) break;
                ds.add(prevBranch.branch);
            }
            this.strategy.mergeTo(y, z, ds);
            boolean earlyClash = this.abox.isClosed();
            if (earlyClash) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CLASH: Branch " + this.branch + " " + this.abox.getClash() + "!"));
                }
                if (!(clashDepends = this.abox.getClash().depends).contains(this.branch)) {
                    return;
                }
            } else {
                return;
            }
            this.strategy.restore(this);
            this.abox.incrementBranch();
            this.setLastClash(clashDepends);
            ++this.tryNext;
        }
        ds = this.getCombinedClash();
        if (!PelletOptions.USE_INCREMENTAL_DELETION) {
            ds.remove(this.branch);
        }
        if (this.abox.doExplanation()) {
            this.abox.setClash(Clash.maxCardinality(this.ind, ds, this.r.getName(), this.n));
        } else {
            this.abox.setClash(Clash.maxCardinality(this.ind, ds));
        }
    }

    public void setLastClash(DependencySet ds) {
        super.setLastClash(ds);
        if (this.tryNext >= 0) {
            this.prevDS[this.tryNext] = ds;
        }
    }

    public String toString() {
        if (this.tryNext < this.mergePairs.size()) {
            return "Branch " + this.branch + " max rule on " + this.ind + " merged  " + this.mergePairs.get(this.tryNext);
        }
        return "Branch " + this.branch + " max rule on " + this.ind + " exhausted merge possibilities";
    }

    protected void shiftTryNext(int openIndex) {
        DependencySet preDS = this.prevDS[openIndex];
        NodeMerge nm = (NodeMerge)this.mergePairs.remove(openIndex);
        this.mergePairs.add(nm);
        for (int i = openIndex; i < this.mergePairs.size(); ++i) {
            this.prevDS[i] = this.prevDS[i + 1];
        }
        this.prevDS[this.mergePairs.size() - 1] = null;
        --this.tryNext;
    }
}

