/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.examples;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ValidityReport;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.Iterator;
import org.mindswap.pellet.jena.PelletReasonerFactory;

public class JenaReasoner {
    public static void main(String[] args) {
        JenaReasoner.usageWithDefaultModel();
        JenaReasoner.usageWithOntModel();
    }

    public static void usageWithDefaultModel() {
        System.out.println("Results with plain RDF Model");
        System.out.println("----------------------------");
        System.out.println();
        String ont = "http://protege.cim3.net/file/pub/ontologies/koala/koala.owl#";
        Reasoner reasoner = PelletReasonerFactory.theInstance().create();
        Model emptyModel = ModelFactory.createDefaultModel();
        InfModel model = ModelFactory.createInfModel((Reasoner)reasoner, (Model)emptyModel);
        model.read(ont);
        ValidityReport report = model.validate();
        JenaReasoner.printIterator(report.getReports(), "Validation Results");
        Resource c = model.getResource(ont + "MaleStudentWith3Daughters");
        JenaReasoner.printIterator((Iterator)model.listObjectsOfProperty(c, RDFS.subClassOf), "All super classes of " + c.getLocalName());
        System.out.println();
    }

    public static void usageWithOntModel() {
        System.out.println("Results with OntModel");
        System.out.println("---------------------");
        System.out.println();
        String ont = "http://protege.cim3.net/file/pub/ontologies/koala/koala.owl#";
        String ns = "http://protege.stanford.edu/plugins/owl/owl-library/koala.owl#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(ont);
        ValidityReport report = model.validate();
        JenaReasoner.printIterator(report.getReports(), "Validation Results");
        OntClass c = model.getOntClass(ns + "MaleStudentWith3Daughters");
        JenaReasoner.printIterator((Iterator)c.listSuperClasses(), "All super classes of " + c.getLocalName());
        JenaReasoner.printIterator((Iterator)c.listSuperClasses(true), "Direct superclasses of " + c.getLocalName());
        System.out.println();
    }

    public static void printIterator(Iterator i, String header) {
        System.out.println(header);
        for (int c = 0; c < header.length(); ++c) {
            System.out.print("=");
        }
        System.out.println();
        if (i.hasNext()) {
            while (i.hasNext()) {
                System.out.println(i.next());
            }
        } else {
            System.out.println("<EMPTY>");
        }
        System.out.println();
    }
}

