/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.examples;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import java.util.ArrayList;
import java.util.List;
import org.mindswap.pellet.exceptions.UnsupportedFeatureException;
import org.mindswap.pellet.jena.NodeFormatter;
import org.mindswap.pellet.jena.PelletQueryExecution;
import org.mindswap.pellet.jena.PelletReasonerFactory;
import org.mindswap.pellet.output.TableData;
import org.mindswap.pellet.utils.QNameProvider;

public class PelletQueryExample {
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.out.println("usage: java PelletQueryExample <sparqlQuery>");
            System.out.println();
            return;
        }
        PelletQueryExample base = new PelletQueryExample();
        base.run(args[0], false);
    }

    public void run(String queryStr, boolean formatHTML) throws Exception {
        Query query = QueryFactory.create((String)queryStr);
        if (!query.isSelectType()) {
            throw new UnsupportedFeatureException("Only SELECT supported for this example");
        }
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.setStrictMode(false);
        if (query.getGraphURIs().size() == 0) {
            throw new UnsupportedFeatureException("SPARQL query must have a FROM clause for this example");
        }
        for (String sourceURI : query.getGraphURIs()) {
            model.read(sourceURI);
        }
        PelletQueryExecution qexec = new PelletQueryExecution(query, (Model)model);
        ResultSet results = qexec.execSelect();
        NodeFormatter formatter = new NodeFormatter((Model)model, formatHTML);
        PelletQueryExample.addDefaultQNames(formatter.getQNames());
        List resultVars = query.getResultVars();
        TableData table = new TableData(resultVars);
        while (results.hasNext()) {
            QuerySolution binding = results.nextSolution();
            ArrayList<String> formattedBinding = new ArrayList<String>();
            for (int i = 0; i < resultVars.size(); ++i) {
                String var = (String)resultVars.get(i);
                RDFNode result = binding.get(var);
                formattedBinding.add(formatter.format(result));
            }
            table.add(formattedBinding);
        }
        table.print(System.out, formatHTML);
    }

    private static void addDefaultQNames(QNameProvider qnames) {
        qnames.setMapping("tce-service", "http://www.flacp.fujitsulabs.com/tce/ontologies/2004/03/service.owl#");
        qnames.setMapping("tce-object", "http://www.flacp.fujitsulabs.com/tce/ontologies/2004/03/object.owl#");
        String owls = "http://www.daml.org/services/owl-s/";
        String[] versions = new String[]{"0.9", "1.0", "1.1"};
        String[] add = new String[]{"-0.9", "-1.0", ""};
        String[] files = new String[]{"Service", "Profile", "Process", "Grounding"};
        for (int version = 0; version < versions.length; ++version) {
            for (int file = 0; file < files.length; ++file) {
                String prefix = files[file].toLowerCase() + add[version];
                String uri = owls + versions[version] + "/" + files[file] + ".owl#";
                qnames.setMapping(prefix, uri);
            }
        }
    }
}

