/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.jena;

import aterm.ATermAppl;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.compose.Union;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.exceptions.UnsupportedFeatureException;
import org.mindswap.pellet.exceptions.UnsupportedQueryException;
import org.mindswap.pellet.jena.DisjointMultiUnion;
import org.mindswap.pellet.jena.JenaUtils;
import org.mindswap.pellet.jena.ModelExtractor;
import org.mindswap.pellet.jena.ModelReader;
import org.mindswap.pellet.jena.OWLLoader;
import org.mindswap.pellet.jena.OWLSpecies;
import org.mindswap.pellet.jena.OWLSpeciesValidator;
import org.mindswap.pellet.jena.PelletResultSet;
import org.mindswap.pellet.query.Query;
import org.mindswap.pellet.query.QueryEngine;
import org.mindswap.pellet.query.impl.ARQParser;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Timer;

public class OWLReasoner {
    public static Log log = LogFactory.getLog(OWLReasoner.class);
    public static boolean DEBUG = false;
    private KnowledgeBase kb = new KnowledgeBase();
    private OWLLoader loader;
    private boolean econnEnabled;
    private ModelExtractor modelExtractor;
    private OWLSpecies species;
    private DisjointMultiUnion graph = new DisjointMultiUnion(true, this.kb, null);
    private Model model = ModelFactory.createModelForGraph((Graph)this.graph);
    private boolean discardJenaGraph;
    public static final List SKIP = Arrays.asList(RDF.first, RDF.rest, OWL.hasValue, OWL.onProperty, OWL.allValuesFrom, OWL.someValuesFrom, OWL.minCardinality, OWL.maxCardinality, OWL.cardinality);

    public OWLReasoner() {
        this.loader = new OWLLoader();
        this.loader.setGraph((Graph)this.graph);
        this.modelExtractor = new ModelExtractor(this);
        this.graph.setLoader(this.loader);
        this.econnEnabled = false;
        this.discardJenaGraph = false;
    }

    public void clear() {
        this.graph.releaseListeners();
        this.graph = new DisjointMultiUnion(true, this.kb, null);
        this.model = ModelFactory.createModelForGraph((Graph)this.graph);
        this.kb.clear();
        this.loader.clear();
        this.loader.setGraph((Graph)this.graph);
        this.graph.setLoader(this.loader);
    }

    public void load(String uri) {
        this.load(uri, true);
    }

    public void load(String uri, boolean withImports) {
        ModelReader reader = new ModelReader();
        Model model = reader.read(uri, withImports);
        this.load(model.getGraph());
    }

    public void load(Model newModel) {
        DisjointMultiUnion newGraph = new DisjointMultiUnion(newModel.getGraph(), this.kb, this.getLoader());
        this.load(newGraph);
    }

    public void load(Graph graph) {
        DisjointMultiUnion newGraph = null;
        newGraph = graph instanceof DisjointMultiUnion ? (DisjointMultiUnion)graph : new DisjointMultiUnion(graph, this.kb, this.getLoader());
        this.load(newGraph);
    }

    public void load(DisjointMultiUnion newGraph) {
        if (newGraph.isEmpty()) {
            return;
        }
        Timer t = this.kb.timers.startTimer("Loading");
        if (!this.discardJenaGraph) {
            this.graph.addGraph((Graph)newGraph);
            this.model = ModelFactory.createModelForGraph((Graph)this.graph);
        }
        List allGraphs = newGraph.getSubGraphs();
        allGraphs.add(newGraph.getBaseGraph());
        for (Graph subG : allGraphs) {
            this.loader.load(subG, this.kb);
        }
        if (this.discardJenaGraph) {
            this.loader.clear();
        } else {
            this.loader.setGraph((Graph)this.graph);
        }
        t.stop();
    }

    public KnowledgeBase getKB() {
        return this.kb;
    }

    public Model getModel() {
        return this.model;
    }

    public OWLSpecies getSpecies() throws UnsupportedFeatureException {
        if (this.model == null) {
            throw new UnsupportedFeatureException("No ontology loaded, reasoner cannot find the species!");
        }
        if (this.species == null) {
            OWLSpeciesValidator validator = new OWLSpeciesValidator();
            this.species = validator.validate(this.model);
        }
        return this.species;
    }

    public String getLevel() {
        return this.getSpecies().toString();
    }

    public boolean isConsistent() {
        return this.kb.isConsistent();
    }

    public void classify() {
        this.kb.classify();
    }

    public void realize() {
        this.kb.realize();
    }

    public ModelExtractor getModelExtractor() {
        return this.modelExtractor;
    }

    public Model extractModel(boolean verbose) {
        this.modelExtractor.setVerbose(verbose);
        return this.modelExtractor.extractModel();
    }

    public Model extractClassModel(boolean verbose) {
        this.modelExtractor.setVerbose(verbose);
        return this.modelExtractor.extractClassModel();
    }

    public Model extractPropertyModel(boolean verbose) {
        this.modelExtractor.setVerbose(verbose);
        return this.modelExtractor.extractPropertyModel();
    }

    public Model extractIndividualModel(boolean verbose) {
        this.modelExtractor.setVerbose(verbose);
        return this.modelExtractor.extractIndividualModel();
    }

    public Set getClasses() {
        return this.toJenaSet(this.kb.getClasses());
    }

    public Set getIndividuals() {
        return this.toJenaSet(this.kb.getIndividuals());
    }

    public ATermAppl node2term(RDFNode r) {
        return this.loader.node2term(r.asNode());
    }

    public boolean isClass(Resource c) {
        return this.kb.isClass(this.node2term((RDFNode)c));
    }

    public boolean isSatisfiable(Resource r) {
        return this.kb.isSatisfiable(this.node2term((RDFNode)r));
    }

    public boolean isSubTypeOf(String d1, String d2) {
        return this.kb.isSubTypeOf(ATermUtils.makeTermAppl(d1), ATermUtils.makeTermAppl(d2));
    }

    public boolean isSubTypeOf(RDFDatatype d1, RDFDatatype d2) {
        return this.kb.isSubTypeOf(ATermUtils.makeTermAppl(d1.getURI()), ATermUtils.makeTermAppl(d2.getURI()));
    }

    public boolean isSubclassOf(Resource r1, Resource r2) {
        return this.isSubClassOf(r1, r2);
    }

    public boolean isSubClassOf(Resource r1, Resource r2) {
        return this.kb.isSubClassOf(this.node2term((RDFNode)r1), this.node2term((RDFNode)r2));
    }

    public boolean isEquivalentClass(Resource r1, Resource r2) {
        return this.kb.isEquivalentClass(this.node2term((RDFNode)r1), this.node2term((RDFNode)r2));
    }

    public boolean isDisjoint(Resource c1, Resource c2) {
        return this.kb.isDisjoint(this.node2term((RDFNode)c1), this.node2term((RDFNode)c2));
    }

    public boolean isComplement(Resource c1, Resource c2) {
        return this.kb.isComplement(this.node2term((RDFNode)c1), this.node2term((RDFNode)c2));
    }

    public boolean isProperty(Resource p) {
        return this.kb.isProperty(this.node2term((RDFNode)p));
    }

    public boolean isDatatypeProperty(Resource p) {
        return this.kb.isDatatypeProperty(this.node2term((RDFNode)p));
    }

    public boolean isObjectProperty(Resource p) {
        return this.kb.isObjectProperty(this.node2term((RDFNode)p));
    }

    public boolean isAnnotationProperty(Resource p) {
        return this.kb.isAnnotationProperty(this.node2term((RDFNode)p));
    }

    public boolean isTransitiveProperty(Resource p) {
        return this.kb.isTransitiveProperty(this.node2term((RDFNode)p));
    }

    public boolean isSymmetricProperty(Resource p) {
        return this.kb.isInverse(this.node2term((RDFNode)p), this.node2term((RDFNode)p));
    }

    public boolean isFunctionalProperty(Resource p) {
        return this.kb.isFunctionalProperty(this.node2term((RDFNode)p));
    }

    public boolean isInverseFunctionalProperty(Resource p) {
        return this.kb.isInverseFunctionalProperty(this.node2term((RDFNode)p));
    }

    public boolean isSubPropertyOf(Resource p1, Resource p2) {
        return this.kb.isSubPropertyOf(this.node2term((RDFNode)p1), this.node2term((RDFNode)p2));
    }

    public boolean isEquivalentProperty(Resource p1, Resource p2) {
        return this.kb.isEquivalentProperty(this.node2term((RDFNode)p1), this.node2term((RDFNode)p2));
    }

    public boolean isInverse(Resource p1, Resource p2) {
        return this.kb.isInverse(this.node2term((RDFNode)p1), this.node2term((RDFNode)p2));
    }

    public boolean hasDomain(Resource p, Resource c) {
        return this.kb.hasDomain(this.node2term((RDFNode)p), this.node2term((RDFNode)c));
    }

    public boolean hasRange(Resource p, Resource c) {
        return this.kb.hasRange(this.node2term((RDFNode)p), this.node2term((RDFNode)c));
    }

    public boolean isIndividual(Resource ind) {
        return this.kb.isIndividual(this.node2term((RDFNode)ind));
    }

    public boolean isSameAs(Resource i1, Resource i2) {
        return this.kb.isSameAs(this.node2term((RDFNode)i1), this.node2term((RDFNode)i2));
    }

    public boolean isDifferentFrom(Resource i1, Resource i2) {
        return this.kb.isDifferentFrom(this.node2term((RDFNode)i1), this.node2term((RDFNode)i2));
    }

    public boolean isType(Resource ind, Resource c) {
        if (ind.isAnon()) {
            return this.kb.isSatisfiable(this.node2term((RDFNode)c));
        }
        return this.kb.isType(this.node2term((RDFNode)ind), this.node2term((RDFNode)c));
    }

    public boolean hasPropertyValue(Resource s, Resource p, RDFNode o) {
        if (s.isAnon() || o instanceof Resource && ((Resource)o).isAnon()) {
            return false;
        }
        return this.kb.hasPropertyValue(this.node2term((RDFNode)s), this.node2term((RDFNode)p), this.node2term(o));
    }

    public boolean isEntailed(Model model) throws UnsupportedFeatureException {
        this.loader.setGraph((Graph)new Union((Graph)this.graph, model.getGraph()));
        StmtIterator i = model.listStatements();
        if (!i.hasNext()) {
            log.warn((Object)"Empty ontologies are entailed by any premise document!");
        } else {
            while (i.hasNext()) {
                Statement stmt = (Statement)i.next();
                if (this.isEntailed(stmt)) continue;
                return false;
            }
        }
        this.loader.setGraph((Graph)this.graph);
        return true;
    }

    public boolean isEntailed(Statement stmt) throws UnsupportedFeatureException {
        boolean isEntailed;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Check entailment " + stmt));
        }
        if (!(isEntailed = this.isEntailed(stmt.getSubject(), stmt.getPredicate(), stmt.getObject())) && log.isDebugEnabled()) {
            log.debug((Object)("Does not entail: (" + stmt + ")"));
        }
        return isEntailed;
    }

    public boolean isEntailed(Resource s, Property p, RDFNode ox) {
        Resource o;
        if (SKIP.contains(p)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Skip syntax related triple");
            }
            return true;
        }
        Resource resource = o = ox instanceof Resource ? (Resource)ox : null;
        if (p.equals(RDF.type)) {
            if (o.equals(OWL.Class) || o.equals(RDFS.Class)) {
                return this.isClass(s);
            }
            if (o.equals(RDF.List)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Skip type triple for rdf:List");
                }
                return true;
            }
            if (o.equals(OWL.Restriction)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Skip type triple for owl:Different");
                }
                return true;
            }
            if (o.equals(OWL.AllDifferent)) {
                throw new UnsupportedFeatureException("owl:AllDifferent is not supported");
            }
            if (o.equals(RDF.Property)) {
                return this.isProperty(s);
            }
            if (o.equals(OWL.ObjectProperty)) {
                return this.isObjectProperty(s);
            }
            if (o.equals(OWL.DatatypeProperty)) {
                return this.isDatatypeProperty(s);
            }
            if (o.equals(OWL.AnnotationProperty)) {
                return this.isAnnotationProperty(s);
            }
            if (o.equals(OWL.Ontology)) {
                return true;
            }
            if (o.equals(OWL.TransitiveProperty)) {
                return this.isTransitiveProperty(s);
            }
            if (o.equals(OWL.SymmetricProperty)) {
                return this.isSymmetricProperty(s);
            }
            if (o.equals(OWL.FunctionalProperty)) {
                return this.isFunctionalProperty(s);
            }
            if (o.equals(OWL.InverseFunctionalProperty)) {
                return this.isInverseFunctionalProperty(s);
            }
            return this.isType(s, o);
        }
        if (p.equals(OWL.intersectionOf)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Skip intersection of triple");
            }
            return true;
        }
        if (p.equals(OWL.unionOf)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Skip union of triple");
            }
            return true;
        }
        if (p.equals(OWL.complementOf)) {
            return this.isComplement(s, o);
        }
        if (p.equals(RDFS.subClassOf)) {
            return this.isSubClassOf(s, o);
        }
        if (p.equals(OWL.equivalentClass)) {
            return this.isEquivalentClass(s, o);
        }
        if (p.equals(OWL.disjointWith)) {
            return this.isDisjoint(s, o);
        }
        if (p.equals(OWL.equivalentProperty)) {
            return this.isEquivalentProperty(s, o);
        }
        if (p.equals(RDFS.subPropertyOf)) {
            return this.isSubPropertyOf(s, o);
        }
        if (p.equals(OWL.inverseOf)) {
            return this.isInverse(s, o);
        }
        if (p.equals(OWL.sameAs)) {
            return this.isSameAs(s, o);
        }
        if (p.equals(OWL.differentFrom)) {
            return this.isDifferentFrom(s, o);
        }
        if (p.equals(RDFS.domain)) {
            return this.hasDomain(s, o);
        }
        if (p.equals(RDFS.range)) {
            return this.hasRange(s, o);
        }
        if (p.equals(OWL.distinctMembers)) {
            throw new UnsupportedFeatureException("owl:distinctMembers is not supported yet");
        }
        if (p.equals(OWL.oneOf)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Skip oneOf triple");
            }
            return true;
        }
        if (p.equals(OWL.imports)) {
            throw new UnsupportedFeatureException("owl:imports is not supported yet");
        }
        if (p.getURI().startsWith(OWL.getURI())) {
            System.err.println("Warning: " + p + " does not belong to OWL namespace");
            if (p.getLocalName().equals("differentIndividualFrom")) {
                System.err.println("Warning: Renaming the predicate to owl:differentFrom");
                return this.isDifferentFrom(s, o);
            }
            if (p.getLocalName().equals("samePropertyAs")) {
                System.err.println("Warning: Renaming the predicate to owl:equivalentProperty");
                return this.isEquivalentProperty(s, o);
            }
            if (p.getLocalName().equals("sameClassAs")) {
                System.err.println("Warning: Renaming the predicate to owl:equivalentClass");
                return this.isEquivalentClass(s, o);
            }
            throw new UnsupportedFeatureException(p + " does not belong to OWL namespace");
        }
        return this.hasPropertyValue(s, (Resource)p, ox);
    }

    public Set getSuperClasses(Resource c, boolean direct) {
        return this.toJenaSetOfSet(this.kb.getSuperClasses(this.node2term((RDFNode)c), direct));
    }

    public Set getSuperClasses(Resource c) {
        return this.toJenaSetOfSet(this.kb.getSuperClasses(this.node2term((RDFNode)c)));
    }

    public Set getSubClasses(Resource c) {
        return this.toJenaSetOfSet(this.kb.getSubClasses(this.node2term((RDFNode)c)));
    }

    public Set getSubClasses(Resource c, boolean direct) {
        return this.toJenaSetOfSet(this.kb.getSubClasses(this.node2term((RDFNode)c), direct));
    }

    public Set getEquivalentClasses(Resource c) {
        return this.toJenaSet(this.kb.getEquivalentClasses(this.node2term((RDFNode)c)));
    }

    public boolean isInstanceOf(Resource ind, Resource c) {
        return this.kb.isType(this.node2term((RDFNode)ind), this.node2term((RDFNode)c));
    }

    public Set getInstances(Resource c) {
        return this.toJenaSet(this.kb.getInstances(this.node2term((RDFNode)c)));
    }

    public Set getInstances(Resource c, boolean direct) {
        return this.toJenaSet(this.kb.getInstances(this.node2term((RDFNode)c), direct));
    }

    public Set getTypes(Resource ind) {
        return this.toJenaSetOfSet(this.kb.getTypes(this.node2term((RDFNode)ind)));
    }

    public Set getTypes(Resource ind, boolean direct) {
        return this.toJenaSetOfSet(this.kb.getTypes(this.node2term((RDFNode)ind), direct));
    }

    public Resource getType(Resource ind) {
        return this.toJenaResource(this.kb.getType(this.node2term((RDFNode)ind)));
    }

    public Resource getType(Resource ind, boolean direct) {
        return this.toJenaResource(this.kb.getType(this.node2term((RDFNode)ind), direct));
    }

    public Set getIndividualsWithProperty(Property p, Resource r) {
        return this.toJenaSet(this.kb.getIndividualsWithProperty(this.node2term((RDFNode)p), this.node2term((RDFNode)r)));
    }

    public Set getPropertyValues(Property p, RDFNode r) {
        return this.toJenaSet(this.kb.getPropertyValues(this.node2term((RDFNode)p), this.node2term(r)));
    }

    public RDFNode getPropertyValue(Property p, RDFNode r) {
        List<ATermAppl> values = this.kb.getPropertyValues(this.node2term((RDFNode)p), this.node2term(r));
        if (values.isEmpty()) {
            return null;
        }
        return this.toJenaNode(values.iterator().next());
    }

    public RDFNode toJenaNode(ATermAppl term) {
        RDFNode r = JenaUtils.makeRDFNode(term, this.model);
        if (r == null) {
            throw new RuntimeException("Cannot find Jena resource for term " + term);
        }
        return r;
    }

    public Resource toJenaResource(ATermAppl term) {
        Resource r = JenaUtils.makeResource(term, this.model);
        if (r == null) {
            throw new RuntimeException("Cannot find Jena resource for term " + term);
        }
        return r;
    }

    public Resource toJenaProperty(ATermAppl term) {
        Property r = JenaUtils.makeProperty(term, this.model);
        if (r == null) {
            throw new RuntimeException("Cannot find Jena resource for term " + term);
        }
        return r;
    }

    protected Set toJenaSetOfSet(Set set) {
        HashSet<Set> results = new HashSet<Set>();
        Iterator i = set.iterator();
        while (i.hasNext()) {
            results.add(this.toJenaSet((Set)i.next()));
        }
        return results;
    }

    protected Set toJenaSet(Collection set) {
        HashSet<RDFNode> results = new HashSet<RDFNode>();
        Iterator i = set.iterator();
        while (i.hasNext()) {
            RDFNode r = this.toJenaNode((ATermAppl)i.next());
            results.add(r);
        }
        return results;
    }

    public ResultSet execQuery(String queryStr) throws UnsupportedQueryException {
        PelletResultSet results = new PelletResultSet(QueryEngine.exec(queryStr, this.kb), this.model);
        return results;
    }

    public ResultSet execQuery(com.hp.hpl.jena.query.Query sparql) throws UnsupportedQueryException {
        ARQParser parser = (ARQParser)QueryEngine.createParser();
        Query query = parser.parse(sparql, this.kb);
        PelletResultSet results = new PelletResultSet(QueryEngine.exec(query), this.model);
        return results;
    }

    public boolean isEconnEnabled() {
        return this.econnEnabled;
    }

    public void setEconnEnabled(boolean econnEnabled) {
        this.econnEnabled = econnEnabled;
    }

    public OWLLoader getLoader() {
        return this.loader;
    }

    public boolean isDiscardJenaGraph() {
        return this.discardJenaGraph;
    }

    public void setDiscardJenaGraph(boolean discardJenaGraph) {
        this.discardJenaGraph = discardJenaGraph;
    }

    public boolean isComplete(Model coModel) {
        boolean complete = true;
        this.kb.realize();
        Model m = this.extractModel(true);
        StmtIterator i = m.listStatements();
        while (i.hasNext()) {
            Statement stmt = (Statement)i.next();
            Resource subj = stmt.getSubject();
            RDFNode obj = stmt.getObject();
            Property prop = stmt.getPredicate();
            if (subj.equals(obj) && prop.equals(OWL.equivalentClass) || subj.equals(obj) && prop.equals(OWL.equivalentProperty) || subj.equals(obj) && prop.equals(RDFS.subClassOf) || subj.equals(obj) && prop.equals(RDFS.subPropertyOf) || obj.equals(OWL.ObjectProperty) || obj.equals(RDF.Property) || subj.equals(OWL.Thing) || obj.equals(OWL.Thing) || subj.equals(OWL.Nothing)) continue;
            if (prop.equals(RDF.type) && obj.equals(OWL.TransitiveProperty)) {
                if (coModel.listStatements(subj, prop, (RDFNode)OWL.InverseFunctionalProperty).hasNext()) {
                    System.out.println("Property error: " + subj + " cannot be both trans and ifp!");
                }
                if (coModel.listStatements(subj, prop, (RDFNode)OWL.FunctionalProperty).hasNext()) {
                    System.out.println("Property error: " + subj + " cannot be both trans and fp!");
                }
            }
            if (obj.equals(OWL.Nothing) && !prop.equals(RDFS.subClassOf) || obj.equals(OWL.Class) || coModel.listStatements(stmt.getSubject(), stmt.getPredicate(), stmt.getObject()).hasNext()) continue;
            System.out.println("Incomplete:" + stmt);
            complete = false;
        }
        this.kb.realize();
        for (ATermAppl ind1 : this.kb.getIndividuals()) {
            for (ATermAppl ind2 : this.kb.getIndividuals()) {
                if (ind1.equals(ind2)) continue;
                if (this.kb.isSameAs(ind1, ind2) && !coModel.listStatements(this.toJenaResource(ind1), OWL.sameAs, this.toJenaNode(ind2)).hasNext()) {
                    System.out.println("Incomplete:" + ind1 + " sameAs " + ind2);
                    complete = false;
                }
                if (!this.kb.isDifferentFrom(ind1, ind2) || coModel.listStatements(this.toJenaResource(ind1), OWL.differentFrom, this.toJenaNode(ind2)).hasNext()) continue;
                System.out.println("Incomplete:" + ind1 + " differentfrom " + ind2);
                complete = false;
            }
        }
        return complete;
    }
}

