/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.jena;

import aterm.ATermAppl;
import java.util.Arrays;
import org.mindswap.pellet.output.ATermRenderer;
import org.mindswap.pellet.utils.HashCodeUtil;

public class OWLSpeciesMessage
implements Comparable {
    String header;
    String msg;
    ATermAppl[] terms;
    int hashCode;

    public OWLSpeciesMessage(String header, String msg, ATermAppl[] terms) {
        this.header = header;
        this.msg = msg;
        this.terms = terms;
        this.computeHashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OWLSpeciesMessage)) {
            return false;
        }
        OWLSpeciesMessage that = (OWLSpeciesMessage)other;
        return this.header.equals(that.header) && this.msg.equals(that.msg) && Arrays.equals(this.terms, that.terms);
    }

    private void computeHashCode() {
        this.hashCode = 23;
        this.hashCode = HashCodeUtil.hash(this.hashCode, this.header);
        this.hashCode = HashCodeUtil.hash(this.hashCode, this.msg);
        this.hashCode = HashCodeUtil.hash(this.hashCode, this.terms);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public int compareTo(Object o) {
        OWLSpeciesMessage other = (OWLSpeciesMessage)o;
        int cmp = this.header.compareTo(other.header);
        if (cmp == 0) {
            cmp = this.msg.compareTo(other.msg);
        }
        if (cmp == 0) {
            cmp = this.hashCode - other.hashCode;
        }
        return cmp;
    }

    public void print(ATermRenderer renderer) {
        renderer.getWriter().printItalic(this.header).print(": ");
        String[] parts = this.msg.split("%");
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (part.length() == 1 && Character.isDigit(part.charAt(0))) {
                int index = part.charAt(0) - 49;
                renderer.visit(this.terms[index]);
                continue;
            }
            renderer.getWriter().print(part);
        }
    }
}

