/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.jena;

import aterm.ATermAppl;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.QuerySolutionMap;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingUtils;
import java.util.ArrayList;
import java.util.List;
import org.mindswap.pellet.jena.JenaUtils;
import org.mindswap.pellet.query.QueryResultBinding;
import org.mindswap.pellet.query.QueryResults;
import org.mindswap.pellet.query.QueryUtils;

public class PelletResultSet
implements ResultSet {
    private Model model;
    private List<String> resultVars;
    private List<ATermAppl> varTerms;
    private QueryResults answers;
    private int index;
    private int size;

    public PelletResultSet(QueryResults answers, Model model) {
        this.answers = answers;
        this.model = model;
        this.index = 0;
        this.size = answers.size();
        this.varTerms = answers.getResultVars();
    }

    public QueryResults getAnswers() {
        return this.answers;
    }

    public boolean hasNext() {
        return this.index < this.size;
    }

    public Binding nextBinding() {
        return BindingUtils.asBinding((QuerySolution)this.nextSolution());
    }

    public QuerySolution nextSolution() {
        QueryResultBinding binding = this.answers.get(this.index++);
        QuerySolutionMap result = new QuerySolutionMap();
        for (ATermAppl var : this.varTerms) {
            String varName = QueryUtils.getVarName(var);
            ATermAppl value = binding.getValue(var);
            RDFNode node = JenaUtils.makeRDFNode(value, this.model);
            result.add(varName, node);
        }
        return result;
    }

    public Object next() {
        return this.nextSolution();
    }

    public boolean isDistinct() {
        return false;
    }

    public boolean isOrdered() {
        return false;
    }

    public int getRowNumber() {
        return this.index;
    }

    public List getResultVars() {
        if (this.resultVars == null) {
            this.resultVars = new ArrayList<String>(this.varTerms.size());
            for (ATermAppl var : this.varTerms) {
                String varName = QueryUtils.getVarName(var);
                this.resultVars.add(varName);
            }
        }
        return this.resultVars;
    }

    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot remove from QueryResults");
    }

    public String toString() {
        return this.answers.toString();
    }
}

