/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.jena;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.util.iterator.Map1;
import org.mindswap.pellet.exceptions.InternalReasonerException;

class TripleFiller
implements Map1 {
    private Node node1;
    private Node node2;
    private byte fill;

    private TripleFiller(Node node1, Node node2, byte fill) {
        this.node1 = node1;
        this.node2 = node2;
        this.fill = fill;
    }

    public static TripleFiller fillAny(Node node1, Node node2, byte fill) {
        return new TripleFiller(node1, node2, fill);
    }

    public static TripleFiller fillSubjObj(Node pred, Node node, byte fill) {
        return fill == 0 ? new TripleFiller(pred, node, 0) : new TripleFiller(node, pred, 2);
    }

    public static TripleFiller fillSubj(Node pred, Node obj) {
        return new TripleFiller(pred, obj, 0);
    }

    public static TripleFiller fillPred(Node subj, Node obj) {
        return new TripleFiller(subj, obj, 1);
    }

    public static TripleFiller fillObj(Node subj, Node pred) {
        return new TripleFiller(subj, pred, 2);
    }

    public Object map1(Object o) {
        switch (this.fill) {
            case 0: {
                return new Triple((Node)o, this.node1, this.node2);
            }
            case 1: {
                return new Triple(this.node1, (Node)o, this.node2);
            }
            case 2: {
                return new Triple(this.node1, this.node2, (Node)o);
            }
        }
        throw new InternalReasonerException("Invalid triple filler!");
    }
}

