/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.rete;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mindswap.pellet.rete.AlphaNode;
import org.mindswap.pellet.rete.Utils;
import org.mindswap.pellet.rete.Variable;

public class AlphaStore {
    List<AlphaNode> nodes = new ArrayList<AlphaNode>();
    Map<Variable, List<AlphaNode>> sharedIndex = new HashMap<Variable, List<AlphaNode>>();

    public void addNode(AlphaNode node) {
        if (!this.nodes.contains(node)) {
            this.nodes.add(node);
            for (Variable var : node.vars) {
                List<Object> l;
                if (!this.sharedIndex.containsKey(var)) {
                    l = new ArrayList<AlphaNode>();
                    l.add(node);
                    this.sharedIndex.put(var, l);
                    continue;
                }
                l = this.sharedIndex.get(var);
                l.add(node);
                this.sharedIndex.put(var, l);
            }
        }
    }

    public void sort() {
        List<AlphaNode> sortedNonBuiltins = new ArrayList();
        for (AlphaNode node : this.nodes) {
            for (Variable var : node.vars) {
                List<AlphaNode> nodesThatShare = this.sharedIndex.get(var);
                if (nodesThatShare.size() <= 0) continue;
                sortedNonBuiltins.addAll(nodesThatShare);
                sortedNonBuiltins.add(node);
            }
        }
        sortedNonBuiltins = Utils.removeDups(sortedNonBuiltins);
        this.nodes.addAll(0, sortedNonBuiltins);
        this.nodes = Utils.removeDups(this.nodes);
    }

    public String toString() {
        String tmp = "";
        for (AlphaNode node : this.nodes) {
            tmp = tmp + ((Object)node).toString() + "\n";
        }
        return tmp;
    }
}

