/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.rete;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.rete.Constant;
import org.mindswap.pellet.rete.Fact;
import org.mindswap.pellet.rete.Node;
import org.mindswap.pellet.rete.RuleNode;
import org.mindswap.pellet.rete.Term;
import org.mindswap.pellet.rete.TermTuple;
import org.mindswap.pellet.rete.Utils;
import org.mindswap.pellet.rete.Variable;
import org.mindswap.pellet.utils.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BetaNode
extends Node {
    public List<BetaNode> children;
    private boolean doExplanation;
    public Node lnode;
    public List<BetaNode> parents;
    public Node rnode;
    public RuleNode rule;

    public BetaNode(Node lnode, Node rnode, boolean doExplanation) {
        this.doExplanation = doExplanation;
        this.lnode = lnode;
        this.rnode = rnode;
        List<Variable> shared = Utils.getSharedVars(lnode, rnode);
        Collections.sort(shared);
        lnode.svars = shared;
        rnode.svars = shared;
        this.vars = Utils.concat(shared, lnode.vars);
        this.vars = Utils.concat(this.vars, rnode.vars);
        this.vars = Utils.removeDups(this.vars);
        this.parents = new ArrayList<BetaNode>();
        this.children = new ArrayList<BetaNode>();
    }

    public HashMap<Variable, Constant> getBindings(List<Constant> row) {
        HashMap<Variable, Constant> bindings = new HashMap<Variable, Constant>();
        for (int i = 0; i < this.vars.size(); ++i) {
            bindings.put((Variable)this.vars.get(i), row.get(i));
        }
        return bindings;
    }

    private Constant getVar(Variable var, List<Constant> fact) {
        if (this.vars.contains(var)) {
            int index = this.getKey().indexOf(var);
            return fact.get(index);
        }
        System.err.println("Unbound rule variable: " + var + this.vars);
        return null;
    }

    private int[] getVarPermutation() {
        List<Variable> joinVars = new ArrayList<Variable>(this.lnode.getKey());
        joinVars.addAll(this.rnode.getKey());
        joinVars = Utils.removeDups(joinVars);
        int[] perm = new int[this.vars.size()];
        for (int i = 0; i < joinVars.size(); ++i) {
            perm[i] = this.getKeyPosition(joinVars.get(i));
        }
        return perm;
    }

    public List<Fact> join() {
        int[] permutation = this.getVarPermutation();
        ArrayList<Fact> facts = new ArrayList<Fact>();
        for (Pair<Fact, Fact> match : this.lnode.index.join(this.rnode.index, this.lnode.svars.size())) {
            ArrayList constants = new ArrayList(permutation.length);
            constants.addAll(((Fact)match.first).getElements());
            constants.addAll(((Fact)match.second).getElements().subList(this.lnode.svars.size(), this.rnode.vars.size()));
            Constant[] factParts = new Constant[permutation.length];
            for (int i = 0; i < permutation.length; ++i) {
                factParts[permutation[i]] = (Constant)constants.get(i);
            }
            DependencySet ds = ((Fact)match.first).getDependencySet();
            ds = ds.union(((Fact)match.second).getDependencySet(), this.doExplanation);
            List<Constant> orderedConstants = Arrays.asList(factParts);
            Fact fact = new Fact(ds, orderedConstants);
            facts.add(fact);
            this.index.add(orderedConstants, fact);
        }
        return facts;
    }

    public Set<Fact> matchingFacts(TermTuple rhs, List<Fact> facts) {
        HashSet<Fact> results = new HashSet<Fact>();
        for (Fact f : facts) {
            ArrayList<Constant> constants = new ArrayList<Constant>(rhs.getElements().size());
            for (Term term : rhs.getElements()) {
                if (term.isVariable()) {
                    constants.add(this.getVar((Variable)term, f.getElements()));
                    continue;
                }
                constants.add((Constant)term);
            }
            DependencySet ds = f.getDependencySet();
            ds = ds.union(rhs.getDependencySet(), this.doExplanation);
            results.add(new Fact(ds, (List<Constant>)constants));
        }
        return results;
    }

    public String toString() {
        return "BetaNode vars: " + this.vars.toString();
    }
}

