/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.rete;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.rete.AlphaNode;
import org.mindswap.pellet.rete.BetaNode;
import org.mindswap.pellet.rete.Compiler;
import org.mindswap.pellet.rete.Constant;
import org.mindswap.pellet.rete.Fact;
import org.mindswap.pellet.rete.TermTuple;
import org.mindswap.pellet.utils.SetUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Interpreter {
    private static final Fact EMPTY_FACT = new Fact(DependencySet.INDEPENDENT, new Constant[0]);
    private Set<Fact> fta;
    public Set<Fact> inferredFacts;
    private Set<Fact> initialFacts;
    private Set<BetaNode> joinedBetaNodes;
    public Compiler rete;
    private Set<Fact> totalFacts;

    public Interpreter(ABox abox) {
        this.rete = new Compiler(abox);
        this.totalFacts = new HashSet<Fact>();
        this.joinedBetaNodes = new HashSet<BetaNode>();
        this.inferredFacts = new HashSet<Fact>();
        this.fta = new HashSet<Fact>();
        this.initialFacts = new HashSet<Fact>();
    }

    public boolean addFacts(Set<Fact> facts, boolean initialSet) {
        boolean status = false;
        if (initialSet) {
            this.initialFacts = facts;
        }
        for (Fact f : facts) {
            this.totalFacts.add(f);
            for (AlphaNode a : this.rete.alphaIndex.match(f)) {
                if (!a.add(f)) continue;
                status = true;
            }
        }
        return status;
    }

    private void processBetaNode(BetaNode betaNode) {
        block4: {
            List<Fact> inferences = betaNode.join();
            if (inferences == null || inferences.size() <= 0) break block4;
            this.joinedBetaNodes.add(betaNode);
            if (betaNode.rule != null) {
                for (TermTuple triple : betaNode.rule.rhs) {
                    Set<Fact> results = betaNode.matchingFacts(triple, inferences);
                    this.fta.addAll(results);
                }
            } else {
                for (int i = 0; i < betaNode.children.size(); ++i) {
                    this.processBetaNode(betaNode.children.get(i));
                }
            }
        }
    }

    public void run() {
        this.addFacts(Collections.singleton(EMPTY_FACT), false);
        this.fta = new HashSet<Fact>();
        for (AlphaNode alphaNode : this.rete.alphaNodeStore.nodes) {
            for (BetaNode betaNode : alphaNode.betaNodes) {
                if (this.joinedBetaNodes.contains(betaNode)) continue;
                this.processBetaNode(betaNode);
            }
        }
        if (!this.fta.isEmpty()) {
            this.fta.removeAll(this.initialFacts);
            this.fta.remove(EMPTY_FACT);
            Set<Fact> newInferredFacts = SetUtils.difference(this.fta, this.inferredFacts);
            if (newInferredFacts.size() > 0) {
                this.inferredFacts.addAll(newInferredFacts);
                if (this.addFacts(newInferredFacts, false)) {
                    this.joinedBetaNodes.clear();
                    this.run();
                }
            }
        }
    }
}

