/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.rete;

import java.util.ArrayList;
import java.util.List;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.rete.Compiler;
import org.mindswap.pellet.rete.Term;
import org.mindswap.pellet.rete.Tuple;
import org.mindswap.pellet.rete.Variable;
import org.mindswap.pellet.utils.URIUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TermTuple
extends Tuple<Term> {
    private static String format(Term term) {
        StringBuffer sb = new StringBuffer();
        if (term == null) {
            sb.append("<null>");
        } else {
            if (term instanceof Variable) {
                sb.append("?");
            }
            sb.append(URIUtils.getLocalName(term.toString()));
        }
        return sb.toString();
    }

    public TermTuple(DependencySet ds, List<Term> terms) {
        super(ds, terms);
    }

    public TermTuple(DependencySet ds, Term ... terms) {
        super(ds, terms);
    }

    public boolean equals(Object other) {
        if (other instanceof TermTuple) {
            TermTuple otherFact = (TermTuple)other;
            return ((Object)this.getElements()).equals(otherFact.getElements());
        }
        return false;
    }

    public List<Variable> getVars() {
        ArrayList<Variable> v = new ArrayList<Variable>();
        for (Term term : this.getElements()) {
            if (!term.isVariable()) continue;
            v.add((Variable)term);
        }
        return v;
    }

    public String toString() {
        if (this.getElements().size() == 3) {
            Term pred = (Term)this.getElements().get(0);
            Term subj = (Term)this.getElements().get(1);
            Term obj = (Term)this.getElements().get(2);
            if (pred.equals(Compiler.TYPE)) {
                return TermTuple.format(obj) + "(" + TermTuple.format(subj) + ")";
            }
            if (pred.equals(Compiler.SAME_AS)) {
                return TermTuple.format(subj) + " = " + TermTuple.format(obj);
            }
            if (pred.equals(Compiler.DIFF_FROM)) {
                return TermTuple.format(subj) + " != " + TermTuple.format(obj);
            }
            return TermTuple.format(pred) + "(" + TermTuple.format(subj) + "," + TermTuple.format(obj) + ")";
        }
        return super.toString();
    }
}

