/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.rete.Constant;
import org.mindswap.pellet.rete.Fact;
import org.mindswap.pellet.rete.Term;
import org.mindswap.pellet.rete.TermTuple;
import org.mindswap.pellet.rete.Variable;
import org.mindswap.pellet.rules.RulesToReteTranslator;
import org.mindswap.pellet.rules.VariableBinding;
import org.mindswap.pellet.rules.VariableUtils;
import org.mindswap.pellet.rules.model.AtomDVariable;
import org.mindswap.pellet.rules.model.AtomIVariable;
import org.mindswap.pellet.rules.model.AtomVariable;
import org.mindswap.pellet.rules.model.BuiltInAtom;
import org.mindswap.pellet.rules.model.ClassAtom;
import org.mindswap.pellet.rules.model.DataRangeAtom;
import org.mindswap.pellet.rules.model.DatavaluedPropertyAtom;
import org.mindswap.pellet.rules.model.DefaultAtomObjectVisitor;
import org.mindswap.pellet.rules.model.DifferentIndividualsAtom;
import org.mindswap.pellet.rules.model.IndividualPropertyAtom;
import org.mindswap.pellet.rules.model.Rule;
import org.mindswap.pellet.rules.model.RuleAtom;
import org.mindswap.pellet.rules.model.RuleAtomVisitor;
import org.mindswap.pellet.rules.model.SameIndividualAtom;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContinuousReteTransformer {
    private static final String PREFIX = "tag:clarkparsia.info,2007:pellet:dl-safe-rules:continuous-rete:";
    private static final Constant DUMMY = new Constant(ATermUtils.makeTermAppl("tag:clarkparsia.info,2007:pellet:dl-safe-rules:continuous-rete:slot-filler"));
    private static final int RULEPOS = 1;
    private static final int VARSTARTPOS = 4;
    public static final Constant VARBINDING = new Constant(ATermUtils.makeTermAppl("tag:clarkparsia.info,2007:pellet:dl-safe-rules:continuous-rete:variable-binding"));
    private static int ruleNumber = 0;
    private ABox abox;
    private AtomFilter filter;
    private Map<Rule, Constant> reverseRuleMap;
    private Map<Constant, Pair<Rule, List<AtomVariable>>> ruleMap;
    private RulesToReteTranslator translator;

    public ContinuousReteTransformer(ABox abox) {
        this.abox = abox;
        this.filter = new AtomFilter();
        this.ruleMap = new HashMap<Constant, Pair<Rule, List<AtomVariable>>>();
        this.reverseRuleMap = new HashMap<Rule, Constant>();
        this.translator = new RulesToReteTranslator(abox);
    }

    protected Constant getRuleID(Rule rule) {
        Constant id = this.reverseRuleMap.get(rule);
        if (id == null) {
            id = new Constant(ATermUtils.makeTermAppl("tag:clarkparsia.info,2007:pellet:dl-safe-rules:continuous-rete:rule-" + ruleNumber++));
            this.reverseRuleMap.put(rule, id);
        }
        return id;
    }

    public org.mindswap.pellet.rete.Rule transformRule(Rule rule) {
        Constant ruleID = this.getRuleID(rule);
        DependencySet ds = DependencySet.INDEPENDENT;
        TreeSet<Variable> vars = new TreeSet<Variable>(new Comparator<Variable>(){

            @Override
            public int compare(Variable arg0, Variable arg1) {
                return arg0.getName().compareTo(arg1.getName());
            }
        });
        ArrayList<TermTuple> body = new ArrayList<TermTuple>();
        HashMap<Variable, AtomVariable> varToVar = new HashMap<Variable, AtomVariable>();
        for (RuleAtom atom : rule.getBody()) {
            TermTuple bodyTerm;
            atom.accept(this.filter);
            if (!this.filter.isSafe() || (bodyTerm = this.translator.translateAtom(atom, ds)) == null) continue;
            body.add(bodyTerm);
            for (AtomVariable atomVar : VariableUtils.getVars(atom)) {
                Pair<Term, DependencySet> translatedVar = this.translator.translateAtomObject(atomVar);
                Variable var = (Variable)translatedVar.first;
                varToVar.put(var, atomVar);
                vars.add(var);
            }
        }
        ArrayList<Term> headTerms = new ArrayList<Term>();
        headTerms.add(VARBINDING);
        headTerms.add(ruleID);
        headTerms.add(DUMMY);
        headTerms.add(DUMMY);
        headTerms.addAll(vars);
        List<TermTuple> head = Collections.singletonList(new TermTuple(DependencySet.INDEPENDENT, (List<Term>)headTerms));
        ArrayList ruleVars = new ArrayList(vars.size());
        for (Variable var : vars) {
            ruleVars.add(varToVar.get(var));
        }
        this.ruleMap.put(ruleID, new Pair(rule, ruleVars));
        return new org.mindswap.pellet.rete.Rule(body, head);
    }

    public Pair<Rule, VariableBinding> translateFact(Fact fact) {
        Pair<Rule, VariableBinding> partialApplication = null;
        if (fact.getElements().size() >= 4 && ((Constant)fact.getElements().get(0)).equals(VARBINDING)) {
            Pair<Rule, List<AtomVariable>> ruleVarPair = this.ruleMap.get(fact.getElements().get(1));
            Rule rule = (Rule)ruleVarPair.first;
            List vars = (List)ruleVarPair.second;
            List constants = fact.getElements().subList(4, fact.getElements().size());
            if (vars.size() != constants.size()) {
                throw new InternalReasonerException("Variable list doesn't match constants!");
            }
            VariableBinding binding = new VariableBinding(this.abox);
            for (int i = 0; i < vars.size(); ++i) {
                ((AtomVariable)vars.get(i)).accept(new BindingSetter(binding, (Constant)constants.get(i)));
            }
            partialApplication = new Pair<Rule, VariableBinding>(rule, binding);
        }
        return partialApplication;
    }

    private static class BindingSetter
    extends DefaultAtomObjectVisitor {
        private VariableBinding binding;
        private Constant constant;

        public BindingSetter(VariableBinding binding, Constant constant) {
            this.binding = binding;
            this.constant = constant;
        }

        public void visit(AtomDVariable variable) {
            this.binding.set(variable, this.constant.getValue());
        }

        public void visit(AtomIVariable variable) {
            this.binding.set(variable, this.constant.getValue());
        }
    }

    private static class AtomFilter
    implements RuleAtomVisitor {
        private boolean result = false;

        private AtomFilter() {
        }

        public boolean isSafe() {
            return this.result;
        }

        public void visit(BuiltInAtom atom) {
            this.result = false;
        }

        public void visit(ClassAtom atom) {
            this.result = false;
        }

        public void visit(DataRangeAtom atom) {
            this.result = false;
        }

        public void visit(DatavaluedPropertyAtom atom) {
            this.result = true;
        }

        public void visit(DifferentIndividualsAtom atom) {
            this.result = false;
        }

        public void visit(IndividualPropertyAtom atom) {
            this.result = true;
        }

        public void visit(SameIndividualAtom atom) {
            this.result = false;
        }
    }
}

