/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.rules;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.rules.AllNamedIndividualsIterator;
import org.mindswap.pellet.rules.BindingHelper;
import org.mindswap.pellet.rules.VariableBinding;
import org.mindswap.pellet.rules.model.AtomIObject;
import org.mindswap.pellet.rules.model.AtomIVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectVariableBindingHelper
implements BindingHelper {
    private ABox abox;
    private Individual currentIndividual;
    private Iterator<Individual> individualIterator;
    private AtomIVariable var;

    public ObjectVariableBindingHelper(ABox abox, AtomIVariable var) {
        this.abox = abox;
        this.var = var;
    }

    public Collection<AtomIVariable> getBindableVars() {
        return Collections.singleton(this.var);
    }

    public Collection<AtomIVariable> getPrerequisiteVars() {
        return Collections.emptyList();
    }

    @Override
    public void rebind(VariableBinding newBinding) {
        this.individualIterator = newBinding.containsKey(this.var) ? Collections.singleton(newBinding.get(this.var)).iterator() : new AllNamedIndividualsIterator(this.abox);
    }

    @Override
    public boolean selectNextBinding() {
        if (this.individualIterator == null || !this.individualIterator.hasNext()) {
            return false;
        }
        this.currentIndividual = this.individualIterator.next();
        return true;
    }

    @Override
    public void setCurrentBinding(VariableBinding currentBinding) {
        currentBinding.set((AtomIObject)this.var, this.currentIndividual);
    }

    public String toString() {
        return "individuals(" + this.var + ")";
    }
}

