/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.rules;

import aterm.ATermAppl;
import java.util.ArrayList;
import java.util.Collection;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.rete.Compiler;
import org.mindswap.pellet.rete.Constant;
import org.mindswap.pellet.rete.Term;
import org.mindswap.pellet.rete.TermTuple;
import org.mindswap.pellet.rete.Variable;
import org.mindswap.pellet.rules.model.AtomDConstant;
import org.mindswap.pellet.rules.model.AtomDObject;
import org.mindswap.pellet.rules.model.AtomDVariable;
import org.mindswap.pellet.rules.model.AtomIConstant;
import org.mindswap.pellet.rules.model.AtomIObject;
import org.mindswap.pellet.rules.model.AtomIVariable;
import org.mindswap.pellet.rules.model.ClassAtom;
import org.mindswap.pellet.rules.model.DatavaluedPropertyAtom;
import org.mindswap.pellet.rules.model.DifferentIndividualsAtom;
import org.mindswap.pellet.rules.model.IndividualPropertyAtom;
import org.mindswap.pellet.rules.model.Rule;
import org.mindswap.pellet.rules.model.RuleAtom;
import org.mindswap.pellet.rules.model.RuleAtomImpl;
import org.mindswap.pellet.rules.model.SameIndividualAtom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReteToRulesTranslator {
    private ABox abox;

    public ReteToRulesTranslator(ABox abox) {
        this.abox = abox;
    }

    public AtomDObject translateDTerm(Term term) {
        if (term.isVariable()) {
            return new AtomDVariable(((Variable)term).getName());
        }
        return new AtomDConstant(((Constant)term).getValue());
    }

    public AtomIObject translateITerm(Term term) {
        if (term.isVariable()) {
            return new AtomIVariable(((Variable)term).getName());
        }
        return new AtomIConstant(((Constant)term).getValue());
    }

    public Rule translateRule(org.mindswap.pellet.rete.Rule reteRule) {
        Collection<RuleAtom> headAtoms = this.translateTriples(reteRule.getHead());
        Collection<RuleAtom> bodyAtoms = this.translateTriples(reteRule.getBody());
        Rule rule = new Rule(headAtoms, bodyAtoms);
        return rule;
    }

    public RuleAtom translateTriple(TermTuple tuple) {
        RuleAtomImpl atom = null;
        if (tuple.getElements().size() == 3) {
            Term pred = (Term)tuple.getElements().get(0);
            Term subj = (Term)tuple.getElements().get(1);
            Term obj = (Term)tuple.getElements().get(2);
            AtomIObject argument1 = this.translateITerm(subj);
            if (pred.equals(Compiler.TYPE)) {
                ATermAppl description = ((Constant)obj).getValue();
                atom = new ClassAtom(description, argument1);
            } else if (pred.equals(Compiler.SAME_AS)) {
                AtomIObject argument2 = this.translateITerm(obj);
                atom = new SameIndividualAtom(argument1, argument2);
            } else if (pred.equals(Compiler.DIFF_FROM)) {
                AtomIObject argument2 = this.translateITerm(obj);
                atom = new DifferentIndividualsAtom(argument1, argument2);
            } else {
                ATermAppl predicate = ((Constant)pred).getValue();
                Role r = this.abox.getRole(predicate);
                if (r != null && r.isObjectRole()) {
                    AtomIObject argument2 = this.translateITerm(obj);
                    atom = new IndividualPropertyAtom(predicate, argument1, argument2);
                } else if (r != null && r.isDatatypeRole()) {
                    AtomDObject argument2 = this.translateDTerm(obj);
                    atom = new DatavaluedPropertyAtom(predicate, argument1, argument2);
                }
            }
        }
        if (atom == null) {
            throw new InternalReasonerException("Can't translate triple to rule atom!: " + tuple);
        }
        return atom;
    }

    public Collection<RuleAtom> translateTriples(Collection<TermTuple> triples) {
        ArrayList<RuleAtom> atoms = new ArrayList<RuleAtom>(triples.size());
        for (TermTuple triple : triples) {
            atoms.add(this.translateTriple(triple));
        }
        return atoms;
    }
}

