/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.rules;

import java.util.Collection;
import java.util.HashSet;
import org.mindswap.pellet.rules.model.AtomDVariable;
import org.mindswap.pellet.rules.model.AtomIVariable;
import org.mindswap.pellet.rules.model.AtomObject;
import org.mindswap.pellet.rules.model.AtomVariable;
import org.mindswap.pellet.rules.model.DefaultAtomObjectVisitor;
import org.mindswap.pellet.rules.model.RuleAtom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableUtils {
    public static Collection<AtomDVariable> getDVars(RuleAtom atom) {
        VisitingDCollector collector = new VisitingDCollector();
        for (AtomObject atomObject : atom.getAllArguments()) {
            atomObject.accept(collector);
        }
        return collector.getVariables();
    }

    public static Collection<AtomIVariable> getIVars(RuleAtom atom) {
        VisitingICollector collector = new VisitingICollector();
        for (AtomObject atomObject : atom.getAllArguments()) {
            atomObject.accept(collector);
        }
        return collector.getVariables();
    }

    public static Collection<AtomVariable> getVars(RuleAtom atom) {
        VisitingCollector collector = new VisitingCollector();
        for (AtomObject atomObject : atom.getAllArguments()) {
            atomObject.accept(collector);
        }
        return collector.getVariables();
    }

    public static boolean isVariable(AtomObject obj) {
        VisitingCollector collector = new VisitingCollector();
        obj.accept(collector);
        return collector.getVariables().size() == 1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VisitingICollector
    extends DefaultAtomObjectVisitor {
        private Collection<AtomIVariable> variables = new HashSet<AtomIVariable>();

        public Collection<AtomIVariable> getVariables() {
            return this.variables;
        }

        @Override
        public void visit(AtomIVariable var) {
            this.variables.add(var);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VisitingDCollector
    extends DefaultAtomObjectVisitor {
        private Collection<AtomDVariable> variables = new HashSet<AtomDVariable>();

        public Collection<AtomDVariable> getVariables() {
            return this.variables;
        }

        @Override
        public void visit(AtomDVariable var) {
            this.variables.add(var);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VisitingCollector
    extends DefaultAtomObjectVisitor {
        private Collection<AtomVariable> variables = new HashSet<AtomVariable>();

        public Collection<AtomVariable> getVariables() {
            return this.variables;
        }

        @Override
        public void visit(AtomDVariable var) {
            this.variables.add(var);
        }

        @Override
        public void visit(AtomIVariable var) {
            this.variables.add(var);
        }
    }
}

