/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.rules.builtins;

import java.util.Collection;
import java.util.Collections;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.rules.BindingHelper;
import org.mindswap.pellet.rules.VariableBinding;
import org.mindswap.pellet.rules.VariableUtils;
import org.mindswap.pellet.rules.builtins.BuiltIn;
import org.mindswap.pellet.rules.builtins.Test;
import org.mindswap.pellet.rules.model.AtomDObject;
import org.mindswap.pellet.rules.model.AtomVariable;
import org.mindswap.pellet.rules.model.BuiltInAtom;

public class TestBuiltIn
implements BuiltIn {
    private Test test;

    public TestBuiltIn(Test test) {
        this.test = test;
    }

    public BindingHelper createHelper(BuiltInAtom atom) {
        return new TestHelper(atom);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TestHelper
    implements BindingHelper {
        private BuiltInAtom atom;
        private boolean result;

        public TestHelper(BuiltInAtom atom) {
            this.atom = atom;
            this.result = false;
        }

        @Override
        public Collection<? extends AtomVariable> getBindableVars() {
            return Collections.emptySet();
        }

        @Override
        public Collection<? extends AtomVariable> getPrerequisiteVars() {
            return VariableUtils.getVars(this.atom);
        }

        @Override
        public void rebind(VariableBinding newBinding) {
            Literal[] arguments = new Literal[this.atom.getAllArguments().size()];
            int i = 0;
            for (AtomDObject obj : this.atom.getAllArguments()) {
                arguments[i++] = newBinding.get(obj);
            }
            this.result = TestBuiltIn.this.test.test(arguments);
        }

        @Override
        public boolean selectNextBinding() {
            if (this.result) {
                this.result = false;
                return true;
            }
            return false;
        }

        @Override
        public void setCurrentBinding(VariableBinding currentBinding) {
        }
    }
}

