/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.rules.builtins;

import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.datatypes.Datatype;
import org.mindswap.pellet.datatypes.XSDAtomicType;
import org.mindswap.pellet.rules.builtins.BinaryTest;
import org.mindswap.pellet.rules.builtins.Test;

public class TestComparison
extends BinaryTest {
    public static final Test greaterThan = new TestComparison(true, false);
    public static final Test greaterThanOrEqual = new TestComparison(true, true);
    public static final Test lessThan = new TestComparison(false, false);
    public static final Test lessThanOrEqual = new TestComparison(false, true);
    private boolean flip;
    private boolean inclusive;

    private TestComparison(boolean flip, boolean inclusive) {
        this.flip = flip;
        this.inclusive = inclusive;
    }

    public boolean test(Literal l1, Literal l2) {
        Literal b;
        Literal a;
        if (!this.flip) {
            a = l1;
            b = l2;
        } else {
            a = l2;
            b = l1;
        }
        Datatype datatype = b.getABox().getKB().getDatatypeReasoner().getDatatype(b.getDatatypeURI());
        if (a.getValue() != null && b.getValue() != null && datatype.contains(a.getValue()) && datatype instanceof XSDAtomicType) {
            XSDAtomicType maxType;
            XSDAtomicType xsdType = (XSDAtomicType)((XSDAtomicType)datatype).getPrimitiveType();
            try {
                maxType = xsdType.restrictMax(this.inclusive, b.getValue());
            }
            catch (Exception e) {
                ABox.log.info((Object)("Cannot compare literals " + l1 + " and " + l2), (Throwable)e);
                return false;
            }
            return maxType.contains(a.getValue());
        }
        return false;
    }
}

