/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.taxonomy;

import aterm.ATermAppl;
import aterm.ATermList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.output.OutputFormatter;
import org.mindswap.pellet.output.TaxonomyPrinter;
import org.mindswap.pellet.output.TreeTaxonomyPrinter;
import org.mindswap.pellet.taxonomy.TaxonomyNode;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Bool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Taxonomy {
    public static boolean DEBUG = false;
    public static boolean DETAILED_DEBUG = false;
    public static final Log log = LogFactory.getLog(Taxonomy.class);
    public static final boolean SUB = true;
    public static final boolean SUPER = false;
    public static final boolean TOP_DOWN = true;
    public static final boolean BOTTOM_UP = false;
    protected Map<ATermAppl, TaxonomyNode> nodes;
    protected TaxonomyNode TOP_NODE;
    protected TaxonomyNode BOTTOM_NODE;
    protected TaxonomyPrinter printer = new TreeTaxonomyPrinter();
    private boolean hideAnonTerms = true;

    public Taxonomy() {
        this(null, false);
    }

    public Taxonomy(Collection<ATermAppl> classes) {
        this(classes, false);
    }

    public Taxonomy(boolean hideTopBottom) {
        this(null, hideTopBottom);
    }

    public Taxonomy(Collection<ATermAppl> classes, boolean hideTopBottom) {
        this.nodes = new HashMap<ATermAppl, TaxonomyNode>();
        this.TOP_NODE = this.addNode(ATermUtils.TOP);
        this.BOTTOM_NODE = this.addNode(ATermUtils.BOTTOM);
        this.TOP_NODE.setHidden(hideTopBottom);
        this.BOTTOM_NODE.setHidden(hideTopBottom);
        if (classes == null) {
            this.TOP_NODE.addSub(this.BOTTOM_NODE);
        } else {
            ArrayList<TaxonomyNode> nodes = new ArrayList<TaxonomyNode>(classes.size());
            for (ATermAppl c : classes) {
                TaxonomyNode node = this.addNode(c);
                node.getSupers().add(this.TOP_NODE);
                node.getSubs().add(this.BOTTOM_NODE);
                nodes.add(node);
            }
            this.TOP_NODE.setSubs(nodes);
            this.BOTTOM_NODE.setSupers((List)nodes.clone());
        }
    }

    public void assertValid() {
        assert (this.TOP_NODE.getSupers().isEmpty()) : "Top node in the taxonomy has parents";
        assert (this.BOTTOM_NODE.getSubs().isEmpty()) : "Bottom node in the taxonomy has children";
    }

    public TaxonomyNode getBottom() {
        return this.BOTTOM_NODE;
    }

    public TaxonomyNode getTop() {
        return this.TOP_NODE;
    }

    public Set<ATermAppl> getClasses() {
        return this.nodes.keySet();
    }

    public Collection<TaxonomyNode> getNodes() {
        return this.nodes.values();
    }

    public boolean contains(ATermAppl c) {
        return this.nodes.containsKey(c);
    }

    public TaxonomyNode addNode(ATermAppl c) {
        boolean hide = this.hideAnonTerms && !ATermUtils.isPrimitive(c);
        TaxonomyNode node = new TaxonomyNode(c, hide);
        this.nodes.put(c, node);
        return node;
    }

    public void addEquivalentNode(ATermAppl c, TaxonomyNode node) {
        boolean hide;
        boolean bl = hide = !ATermUtils.isPrimitive(c);
        if (!hide) {
            node.addEquivalent(c);
        }
        this.nodes.put(c, node);
    }

    public TaxonomyNode getNode(ATermAppl c) {
        return this.nodes.get(c);
    }

    public void removeNode(TaxonomyNode node) {
        node.disconnect();
        this.nodes.remove(node.getName());
    }

    public Set<ATermAppl> getInstances(ATermAppl c) {
        return this.getInstances(c, false);
    }

    public Set<ATermAppl> getInstances(ATermAppl c, boolean direct) {
        TaxonomyNode node = this.nodes.get(c);
        if (node == null) {
            throw new RuntimeException(c + " is an unknown class!");
        }
        Set<ATermAppl> instances = null;
        if (direct) {
            instances = node.getInstances();
        } else {
            instances = new HashSet<ATermAppl>();
            this.getInstancesHelper(node, instances);
        }
        return instances;
    }

    private void getInstancesHelper(TaxonomyNode node, Set<ATermAppl> instances) {
        instances.addAll(node.getInstances());
        for (TaxonomyNode sub : node.getSubs()) {
            this.getInstancesHelper(sub, instances);
        }
    }

    public boolean isType(ATermAppl ind, ATermAppl c) {
        TaxonomyNode node = this.nodes.get(c);
        if (node == null) {
            throw new RuntimeException(c + " is an unknown class!");
        }
        return this.isType(node, ind);
    }

    private boolean isType(TaxonomyNode node, ATermAppl ind) {
        if (node.getInstances().contains(ind)) {
            return true;
        }
        for (TaxonomyNode sub : node.getSubs()) {
            if (!this.isType(sub, ind)) continue;
            return true;
        }
        return false;
    }

    public Set<Set<ATermAppl>> getSuperExplanations(ATermAppl sub, ATermAppl sup) {
        TaxonomyNode subNode = this.nodes.get(sub);
        if (subNode == null) {
            return null;
        }
        TaxonomyNode supNode = this.nodes.get(sup);
        if (supNode == null) {
            return null;
        }
        if (subNode.getEquivalents().size() > 1 || supNode.getEquivalents().size() > 1) {
            return null;
        }
        return subNode.getSuperExplanations(supNode);
    }

    public Bool isEquivalent(ATermAppl x, ATermAppl y) {
        TaxonomyNode nodeX = this.nodes.get(x);
        TaxonomyNode nodeY = this.nodes.get(y);
        if (nodeX == null || nodeY == null) {
            return Bool.UNKNOWN;
        }
        if (nodeX.equals(nodeY)) {
            return Bool.TRUE;
        }
        return Bool.FALSE;
    }

    public Bool isSubNodeOf(ATermAppl x, ATermAppl y) {
        TaxonomyNode nodeX = this.nodes.get(x);
        TaxonomyNode nodeY = this.nodes.get(y);
        if (nodeX == null || nodeY == null) {
            return Bool.UNKNOWN;
        }
        if (nodeX.equals(nodeY)) {
            return Bool.TRUE;
        }
        if (nodeX.isHidden()) {
            if (nodeY.isHidden()) {
                return Bool.UNKNOWN;
            }
            return this.getSupers(x, false, true).contains(y) ? Bool.TRUE : Bool.FALSE;
        }
        return this.getSubs(y, false, true).contains(x) ? Bool.TRUE : Bool.FALSE;
    }

    public Set<Set<ATermAppl>> getSubs(ATermAppl c) {
        return this.getSubs(c, false);
    }

    public Set<Set<ATermAppl>> getSubs(ATermAppl c, boolean direct) {
        return this.getSubSupers(c, direct, true);
    }

    public Set<Set<ATermAppl>> getSupers(ATermAppl c) {
        return this.getSupers(c, false);
    }

    public Set getSupers(ATermAppl c, boolean direct, boolean flat) {
        return this.getSubSupers(c, direct, false, flat);
    }

    public Set getSubs(ATermAppl c, boolean direct, boolean flat) {
        return this.getSubSupers(c, direct, true, flat);
    }

    public Set<Set<ATermAppl>> getSupers(ATermAppl c, boolean direct) {
        return this.getSubSupers(c, direct, false);
    }

    public Set getSubSupers(ATermAppl c, boolean direct, boolean subOrSuper, boolean flat) {
        if (flat) {
            return this.getFlattenedSubSupers(c, direct, subOrSuper);
        }
        return this.getSubSupers(c, direct, subOrSuper);
    }

    public Set<Set<ATermAppl>> getSubSupers(ATermAppl c, boolean direct, boolean subOrSuper) {
        TaxonomyNode node = this.nodes.get(c);
        if (node == null) {
            return Collections.emptySet();
        }
        HashSet<Set<ATermAppl>> result = new HashSet<Set<ATermAppl>>();
        ArrayList<TaxonomyNode> visit = new ArrayList<TaxonomyNode>();
        visit.addAll(subOrSuper ? node.getSubs() : node.getSupers());
        for (int i = 0; i < visit.size(); ++i) {
            node = (TaxonomyNode)visit.get(i);
            if (node.isHidden()) continue;
            HashSet<ATermAppl> add = new HashSet<ATermAppl>(node.getEquivalents());
            if (this.hideAnonTerms) {
                this.removeAnonTerms(add);
            }
            if (!add.isEmpty()) {
                result.add(add);
            }
            if (direct) continue;
            visit.addAll(subOrSuper ? node.getSubs() : node.getSupers());
        }
        return result;
    }

    public Set<ATermAppl> getFlattenedSubSupers(ATermAppl c, boolean direct, boolean subOrSuper) {
        TaxonomyNode node = this.nodes.get(c);
        HashSet<ATermAppl> result = new HashSet<ATermAppl>();
        ArrayList<TaxonomyNode> visit = new ArrayList<TaxonomyNode>();
        visit.addAll(subOrSuper ? node.getSubs() : node.getSupers());
        for (int i = 0; i < visit.size(); ++i) {
            node = (TaxonomyNode)visit.get(i);
            if (node.isHidden()) continue;
            Set<ATermAppl> add = node.getEquivalents();
            result.addAll(add);
            if (direct) continue;
            visit.addAll(subOrSuper ? node.getSubs() : node.getSupers());
        }
        if (this.hideAnonTerms) {
            this.removeAnonTerms(result);
        }
        return result;
    }

    public Set<ATermAppl> getEquivalents(ATermAppl c) {
        TaxonomyNode node = this.nodes.get(c);
        if (node == null) {
            throw new RuntimeException(c + " is an unknown class!");
        }
        if (node.isHidden()) {
            return Collections.emptySet();
        }
        HashSet<ATermAppl> result = new HashSet<ATermAppl>(node.getEquivalents());
        result.remove(c);
        if (this.hideAnonTerms) {
            this.removeAnonTerms(result);
        }
        return result;
    }

    public Set<ATermAppl> getAllEquivalents(ATermAppl c) {
        TaxonomyNode node = this.nodes.get(c);
        if (node == null) {
            throw new RuntimeException(c + " is an unknown class!");
        }
        if (node.isHidden()) {
            return Collections.emptySet();
        }
        HashSet<ATermAppl> result = new HashSet<ATermAppl>(node.getEquivalents());
        if (this.hideAnonTerms) {
            this.removeAnonTerms(result);
        }
        return result;
    }

    private void removeAnonTerms(Set<ATermAppl> terms) {
        Iterator<ATermAppl> i = terms.iterator();
        while (i.hasNext()) {
            ATermAppl term = i.next();
            if (ATermUtils.isPrimitive(term) || term == ATermUtils.BOTTOM) continue;
            i.remove();
        }
    }

    public Set<Set<ATermAppl>> getDirectTypes(ATermAppl ind) {
        HashSet<Set<ATermAppl>> result = new HashSet<Set<ATermAppl>>();
        for (TaxonomyNode node : this.nodes.values()) {
            if (!node.getInstances().contains(ind)) continue;
            result.add(node.getEquivalents());
        }
        return result;
    }

    public Set<Set<ATermAppl>> getTypes(ATermAppl ind) {
        HashSet<Set<ATermAppl>> result = new HashSet<Set<ATermAppl>>();
        for (TaxonomyNode node : this.nodes.values()) {
            if (!node.getInstances().contains(ind)) continue;
            result.add(node.getEquivalents());
            Set<Set<ATermAppl>> supers = this.getSupers(node.getName());
            result.addAll(supers);
        }
        return result;
    }

    public Set<Set<ATermAppl>> getTypes(ATermAppl ind, boolean direct) {
        if (direct) {
            return this.getDirectTypes(ind);
        }
        return this.getTypes(ind);
    }

    public List<ATermAppl> topologocialSort(boolean includeEquivalents) {
        HashMap<TaxonomyNode, Integer> degrees = new HashMap<TaxonomyNode, Integer>();
        LinkedHashSet<TaxonomyNode> nodesPending = new LinkedHashSet<TaxonomyNode>();
        HashSet<TaxonomyNode> nodesLeft = new HashSet<TaxonomyNode>();
        ArrayList<ATermAppl> nodesSorted = new ArrayList<ATermAppl>();
        log.debug((Object)"Topological sort...");
        for (TaxonomyNode node : this.nodes.values()) {
            nodesLeft.add(node);
            int degree = node.getSupers().size();
            if (degree == 0) {
                nodesPending.add(node);
                degrees.put(node, 0);
                continue;
            }
            degrees.put(node, new Integer(degree));
        }
        if (nodesPending.size() != 1) {
            throw new InternalReasonerException("More than one node with no incoming edges " + nodesPending);
        }
        int size = nodesLeft.size();
        for (int i = 0; i < size; ++i) {
            if (nodesPending.isEmpty()) {
                throw new InternalReasonerException("Cycle detected in the taxonomy!");
            }
            TaxonomyNode node = (TaxonomyNode)nodesPending.iterator().next();
            int deg = (Integer)degrees.get(node);
            if (deg != 0) {
                throw new InternalReasonerException("Cycle detected in the taxonomy " + node + " " + deg + " " + nodesSorted.size() + " " + this.nodes.size());
            }
            nodesPending.remove(node);
            nodesLeft.remove(node);
            if (includeEquivalents) {
                nodesSorted.addAll(node.getEquivalents());
            } else {
                nodesSorted.add(node.getName());
            }
            for (TaxonomyNode sub : node.getSubs()) {
                int degree = (Integer)degrees.get(sub);
                if (degree == 1) {
                    nodesPending.add(sub);
                    degrees.put(sub, 0);
                    continue;
                }
                degrees.put(sub, degree - 1);
            }
        }
        if (!nodesLeft.isEmpty()) {
            throw new InternalReasonerException("Failed to sort elements: " + nodesLeft);
        }
        log.debug((Object)"done");
        return nodesSorted;
    }

    public void removeCycles(TaxonomyNode node) {
        if (!this.nodes.get(node.getName()).equals(node)) {
            throw new InternalReasonerException("This node does not exist in the taxonomy: " + node.getName());
        }
        this.removeCycles(node, new ArrayList<TaxonomyNode>());
    }

    private boolean removeCycles(TaxonomyNode node, List<TaxonomyNode> path) {
        if (path.contains(node)) {
            this.mergeNodes(path);
            return true;
        }
        path.add(node);
        List<TaxonomyNode> supers = node.getSupers();
        int i = 0;
        while (i < supers.size()) {
            TaxonomyNode sup = supers.get(i);
            this.removeCycles(sup, path);
            path.remove(sup);
            if (i >= supers.size() || !supers.get(i).equals(sup)) continue;
            ++i;
        }
        return false;
    }

    public void merge(TaxonomyNode node1, TaxonomyNode node2) {
        ArrayList<TaxonomyNode> mergeList = new ArrayList<TaxonomyNode>(2);
        mergeList.add(node1);
        mergeList.add(node2);
        TaxonomyNode node = this.mergeNodes(mergeList);
        this.removeCycles(node);
    }

    private TaxonomyNode mergeExternal(TaxonomyNode node1, TaxonomyNode node2) {
        ArrayList<TaxonomyNode> mergeList = new ArrayList<TaxonomyNode>(2);
        mergeList.add(node1);
        mergeList.add(node2);
        TaxonomyNode mergedNode = this.mergeNodesExternal(mergeList);
        return mergedNode;
    }

    private TaxonomyNode mergeNodesExternal(List mergeList) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Merge " + mergeList));
        }
        if (mergeList.size() == 1) {
            log.warn((Object)"Merge one node?");
        }
        TaxonomyNode node = null;
        node = mergeList.contains(this.TOP_NODE) ? this.TOP_NODE : (mergeList.contains(this.BOTTOM_NODE) ? this.BOTTOM_NODE : (TaxonomyNode)mergeList.get(0));
        HashSet<TaxonomyNode> merged = new HashSet<TaxonomyNode>();
        merged.add(node);
        for (TaxonomyNode other : mergeList) {
            if (merged.contains(other)) continue;
            merged.add(other);
            for (TaxonomyNode sub : other.getSubs()) {
                if (mergeList.contains(sub)) continue;
                node.addSub(sub);
            }
            for (TaxonomyNode sup : other.getSupers()) {
                if (mergeList.contains(sup)) continue;
                sup.addSub(node);
            }
            for (ATermAppl c : other.getEquivalents()) {
                this.addEquivalentNode(c, node);
            }
        }
        return node;
    }

    private TaxonomyNode mergeNodes(List<TaxonomyNode> mergeList) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Merge " + mergeList));
        }
        if (mergeList.size() == 1) {
            log.warn((Object)"Merge one node?");
        }
        TaxonomyNode node = null;
        node = mergeList.contains(this.TOP_NODE) ? this.TOP_NODE : (mergeList.contains(this.BOTTOM_NODE) ? this.BOTTOM_NODE : mergeList.get(0));
        HashSet<TaxonomyNode> merged = new HashSet<TaxonomyNode>();
        merged.add(node);
        for (TaxonomyNode other : mergeList) {
            if (merged.contains(other)) continue;
            merged.add(other);
            for (TaxonomyNode sub : other.getSubs()) {
                if (mergeList.contains(sub)) continue;
                node.addSub(sub);
            }
            for (TaxonomyNode sup : other.getSupers()) {
                if (mergeList.contains(sup)) continue;
                sup.addSub(node);
                Set<Set<ATermAppl>> exps = other.getSuperExplanations(sup);
                if (exps == null) continue;
                for (Set<ATermAppl> exp : exps) {
                    node.addSuperExplanation(sup, exp);
                }
            }
            this.removeNode(other);
            for (ATermAppl c : other.getEquivalents()) {
                this.addEquivalentNode(c, node);
            }
        }
        return node;
    }

    public List computeLCA(ATermList list) {
        boolean allSupers = false;
        boolean flat = true;
        ATermAppl c2 = (ATermAppl)list.getFirst();
        ArrayList ancestors = new ArrayList(this.getSupers(c2, allSupers, flat));
        while (!list.isEmpty()) {
            c2 = (ATermAppl)list.getFirst();
            ancestors.retainAll(this.getSupers(c2, allSupers, flat));
            if (ancestors.size() == 1) {
                ATermUtils.assertTrue(ancestors.contains(ATermUtils.TOP));
                return ancestors;
            }
            list = list.getNext();
        }
        HashSet toBeRemoved = new HashSet();
        for (ATermAppl c2 : ancestors) {
            if (toBeRemoved.contains(c2)) continue;
            Set supers = this.getSupers(c2, allSupers, flat);
            toBeRemoved.addAll(supers);
        }
        ancestors.removeAll(toBeRemoved);
        return ancestors;
    }

    public void print() {
        this.printer.print(this);
    }

    public void print(OutputFormatter out) {
        this.printer.print(this, out);
    }

    public Taxonomy merge(Taxonomy tax) {
        TaxonomyNode oldnode;
        Taxonomy newtax = new Taxonomy();
        HashMap conversion = new HashMap();
        newtax = (Taxonomy)tax.clone();
        HashMap<ATermAppl, TaxonomyNode> auxMap = new HashMap<ATermAppl, TaxonomyNode>();
        for (ATermAppl a : this.nodes.keySet()) {
            if (!newtax.contains(a)) {
                TaxonomyNode oldnode2 = this.nodes.get(a);
                TaxonomyNode newnode = oldnode2.copy(conversion);
                newtax.nodes.put(a, newnode);
                continue;
            }
            TaxonomyNode oldnode2 = newtax.nodes.get(a);
            oldnode = this.nodes.get(a);
            TaxonomyNode newnode = this.mergeExternal(oldnode, oldnode2);
            auxMap.put(a, newnode);
        }
        for (ATermAppl a : auxMap.keySet()) {
            oldnode = (TaxonomyNode)auxMap.get(a);
            newtax.nodes.remove(a);
            newtax.nodes.put(a, oldnode);
        }
        return newtax;
    }

    public int compareTaxonomy(Taxonomy tax) {
        int discrepancies = 0;
        for (ATermAppl a : this.nodes.keySet()) {
            TaxonomyNode node2;
            if (!tax.contains(a)) {
                return discrepancies++;
            }
            TaxonomyNode node1 = this.nodes.get(a);
            if (node1.compareTo(node2 = tax.nodes.get(a))) continue;
            ++discrepancies;
        }
        return discrepancies;
    }

    public Object clone() {
        HashMap conversion = new HashMap();
        Iterator<ATermAppl> i = this.nodes.keySet().iterator();
        Taxonomy newtax = new Taxonomy();
        newtax.nodes = new HashMap<ATermAppl, TaxonomyNode>();
        while (i.hasNext()) {
            TaxonomyNode newnode;
            ATermAppl a = i.next();
            TaxonomyNode oldnode = this.nodes.get(a);
            if (conversion.containsKey(oldnode)) {
                newnode = (TaxonomyNode)conversion.get(oldnode);
                oldnode.copy(newnode, conversion);
            } else {
                newnode = oldnode.copy(conversion);
            }
            newtax.nodes.put(a, newnode);
        }
        newtax.TOP_NODE = (TaxonomyNode)conversion.get(this.TOP_NODE);
        newtax.BOTTOM_NODE = (TaxonomyNode)conversion.get(this.BOTTOM_NODE);
        return newtax;
    }

    public boolean isHideAnonTerms() {
        return this.hideAnonTerms;
    }

    public void setHideAnonTerms(boolean hideAnonTerms) {
        this.hideAnonTerms = hideAnonTerms;
    }
}

