/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tbox.impl;

import aterm.ATermAppl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.tbox.TBox;
import org.mindswap.pellet.tbox.impl.TermDefinition;
import org.mindswap.pellet.tbox.impl.TgBox;
import org.mindswap.pellet.tbox.impl.TuBox;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.MultiValueMap;
import org.mindswap.pellet.utils.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TBoxExpImpl
implements TBox {
    public static Log log = LogFactory.getLog(TBox.class);
    protected KnowledgeBase kb;
    protected Set<ATermAppl> classes = new HashSet<ATermAppl>();
    private Set<ATermAppl> allClasses;
    private MultiValueMap<ATermAppl, Set<ATermAppl>> tboxAxioms = new MultiValueMap();
    private MultiValueMap<ATermAppl, ATermAppl> reverseExplain = new MultiValueMap();
    public TuBox Tu = null;
    public TgBox Tg = null;

    public TBoxExpImpl(KnowledgeBase kb) {
        this.kb = kb;
        this.Tu = new TuBox(kb);
        this.Tg = new TgBox(kb);
        this.kb = kb;
    }

    @Override
    public Set<ATermAppl> getAllClasses() {
        if (this.allClasses == null) {
            this.allClasses = new HashSet<ATermAppl>(this.classes);
            this.allClasses.add(ATermUtils.TOP);
            this.allClasses.add(ATermUtils.BOTTOM);
        }
        return this.allClasses;
    }

    @Override
    public Set<Set<ATermAppl>> getAxiomExplanations(ATermAppl axiom) {
        return (Set)this.tboxAxioms.get(axiom);
    }

    @Override
    public Set<ATermAppl> getAxiomExplanation(ATermAppl axiom) {
        Set explains = (Set)this.tboxAxioms.get(axiom);
        if (explains == null || explains.isEmpty()) {
            log.warn((Object)("No explanation for " + axiom));
        }
        Set explain = (Set)explains.iterator().next();
        return explain;
    }

    @Override
    public boolean addAxiomExplanation(ATermAppl axiom, Set<ATermAppl> explain) {
        boolean added;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Axiom: " + axiom + "\nExplanation: " + explain));
        }
        if (added = this.tboxAxioms.add(axiom, explain)) {
            for (ATermAppl explainAxiom : explain) {
                if (axiom.equals(explainAxiom)) continue;
                this.reverseExplain.add(explainAxiom, axiom);
            }
        }
        return added;
    }

    @Override
    public boolean addAxiom(ATermAppl axiom, Set<ATermAppl> explain) {
        if (PelletOptions.USE_NOMINAL_ABSORPTION || PelletOptions.USE_PSEUDO_NOMINALS) {
            ATermAppl sub;
            if (axiom.getAFun().equals(ATermUtils.EQCLASSFUN)) {
                ATermAppl c1 = (ATermAppl)axiom.getArgument(0);
                ATermAppl c2 = (ATermAppl)axiom.getArgument(1);
                if (ATermUtils.isOneOf(c1)) {
                    this.Tg.absorbOneOf(c1, c2, explain);
                    if (ATermUtils.isOneOf(c2)) {
                        this.Tg.absorbOneOf(c2, c1, explain);
                        return true;
                    }
                    axiom = ATermUtils.makeSub(c2, c1);
                } else if (ATermUtils.isOneOf(c2)) {
                    this.Tg.absorbOneOf(c2, c1, explain);
                    axiom = ATermUtils.makeSub(c1, c2);
                }
            } else if (axiom.getAFun().equals(ATermUtils.SUBFUN) && ATermUtils.isOneOf(sub = (ATermAppl)axiom.getArgument(0))) {
                ATermAppl sup = (ATermAppl)axiom.getArgument(1);
                this.Tg.absorbOneOf(sub, sup, explain);
                return true;
            }
        }
        return this.addAxiom(axiom, explain, false);
    }

    public boolean addAxiom(ATermAppl axiom, Set<ATermAppl> explain, boolean forceAddition) {
        boolean added = this.addAxiomExplanation(axiom, explain);
        if ((added || forceAddition) && !this.Tu.addIfUnfoldable(axiom)) {
            if (axiom.getAFun().equals(ATermUtils.EQCLASSFUN)) {
                ATermAppl name = (ATermAppl)axiom.getArgument(0);
                ATermAppl desc = (ATermAppl)axiom.getArgument(1);
                ATermAppl reversedAxiom = ATermUtils.makeEqClasses(desc, name);
                if (!this.Tu.addIfUnfoldable(reversedAxiom)) {
                    this.Tg.addDef(axiom);
                } else {
                    this.addAxiomExplanation(reversedAxiom, explain);
                }
            } else {
                this.Tg.addDef(axiom);
            }
        }
        return added;
    }

    @Override
    public boolean removeAxiom(ATermAppl axiom) {
        if (!PelletOptions.USE_TRACING) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Cannot remove axioms when PelletOptions.USE_TRACING is false");
            }
            return false;
        }
        if (this.Tg.absorbedOutsideTBox.contains(axiom)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Cannot remove axioms that have been absorbed outside TBox");
            }
            return false;
        }
        HashSet<ATermAppl> sideEffects = new HashSet<ATermAppl>();
        boolean removed = this.removeExplanation(axiom, axiom, sideEffects);
        for (ATermAppl readdAxiom : sideEffects) {
            Set explanations = (Set)this.tboxAxioms.get(readdAxiom);
            if (explanations == null) continue;
            Iterator i = explanations.iterator();
            this.addAxiom(readdAxiom, (Set)i.next(), true);
            while (i.hasNext()) {
                this.addAxiomExplanation(readdAxiom, (Set)i.next());
            }
        }
        return removed;
    }

    private boolean removeExplanation(ATermAppl dependantAxiom, ATermAppl explanationAxiom, Set<ATermAppl> sideEffects) {
        boolean removed = false;
        if (!PelletOptions.USE_TRACING) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Cannot remove axioms when PelletOptions.USE_TRACING is false");
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing " + explanationAxiom));
        }
        this.reverseExplain.remove(explanationAxiom, dependantAxiom);
        Set explains = (Set)this.tboxAxioms.get(dependantAxiom);
        HashSet<Set> newExplains = new HashSet<Set>();
        if (explains != null) {
            for (Set explain : explains) {
                if (!explain.contains(explanationAxiom)) {
                    newExplains.add(explain);
                    continue;
                }
                sideEffects.addAll(explain);
                sideEffects.remove(explanationAxiom);
            }
        }
        if (!newExplains.isEmpty()) {
            this.tboxAxioms.put(dependantAxiom, (Set<Set<ATermAppl>>)newExplains);
            this.Tu.updateDef(dependantAxiom);
            return true;
        }
        this.tboxAxioms.remove(dependantAxiom);
        removed |= this.Tu.removeDef(dependantAxiom);
        removed |= this.Tg.removeDef(dependantAxiom);
        Set otherDependants = (Set)this.reverseExplain.remove(dependantAxiom);
        if (otherDependants != null) {
            for (ATermAppl otherDependant : otherDependants) {
                if (otherDependant.equals(dependantAxiom)) continue;
                removed |= this.removeExplanation(otherDependant, dependantAxiom, sideEffects);
            }
        }
        return removed;
    }

    @Override
    public Collection<ATermAppl> getAxioms() {
        return this.tboxAxioms.keySet();
    }

    public boolean containsAxiom(ATermAppl axiom) {
        return this.tboxAxioms.containsKey(axiom);
    }

    @Override
    public void split() {
    }

    @Override
    public void absorb() {
        this.Tg.absorb(this.Tu, this);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("Tu: [\n");
        for (ATermAppl aTermAppl : this.getClasses()) {
            ATermAppl notC;
            List<Pair<ATermAppl, Set<ATermAppl>>> unfoldedList = this.Tu.unfold(aTermAppl);
            if (unfoldedList != null) {
                str.append(aTermAppl).append(" -> ");
                for (Pair<ATermAppl, Set<ATermAppl>> pair : unfoldedList) {
                    str.append(pair.first).append(", ");
                }
                str.append("\n");
            }
            if ((unfoldedList = this.Tu.unfold(notC = ATermUtils.makeNot(aTermAppl))) == null) continue;
            str.append(notC).append(" -> ");
            for (Pair<ATermAppl, Set<ATermAppl>> pair : unfoldedList) {
                str.append(pair.first).append(", ");
            }
            str.append("\n");
        }
        if (this.getUC() != null) {
            str.append("\nTg: [\n");
            for (Pair pair : this.getUC()) {
                str.append(pair.first).append(", ");
            }
            str.append("\n");
        }
        str.append("]\nExplain: [\n");
        for (ATermAppl aTermAppl : this.tboxAxioms.keySet()) {
            str.append(aTermAppl).append(" -> ").append(this.tboxAxioms.get(aTermAppl)).append("\n");
        }
        str.append("]\nReverseExplain: [\n");
        for (ATermAppl aTermAppl : this.reverseExplain.keySet()) {
            str.append(aTermAppl).append(" -> ").append(this.reverseExplain.get(aTermAppl)).append("\n");
        }
        str.append("]\n");
        return str.toString();
    }

    @Override
    public List<Pair<ATermAppl, Set<ATermAppl>>> getUC() {
        if (this.Tg == null) {
            return null;
        }
        return this.Tg.getUC();
    }

    @Override
    public boolean addClass(ATermAppl term) {
        boolean added = this.classes.add(term);
        if (added) {
            this.allClasses = null;
        }
        return added;
    }

    @Override
    public Set<ATermAppl> getClasses() {
        return this.classes;
    }

    @Override
    public Collection<ATermAppl> getAxioms(ATermAppl term) {
        ArrayList<ATermAppl> axioms = new ArrayList<ATermAppl>();
        TermDefinition def = this.Tg.getTD(term);
        if (def != null) {
            axioms.addAll(def.getSubClassAxioms());
            axioms.addAll(def.getEqClassAxioms());
        }
        if ((def = this.Tu.getTD(term)) != null) {
            axioms.addAll(def.getSubClassAxioms());
            axioms.addAll(def.getEqClassAxioms());
        }
        return axioms;
    }

    @Override
    public void normalize() {
        this.Tu.normalize(this);
    }

    @Override
    public void internalize() {
        this.Tg.internalize(this);
        if (log.isDebugEnabled()) {
            log.debug((Object)this);
        }
    }

    @Override
    public List<Pair<ATermAppl, Set<ATermAppl>>> unfold(ATermAppl c) {
        return this.Tu.unfold(c);
    }
}

