/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test.utils;

import aterm.ATermAppl;
import junit.framework.TestCase;
import org.mindswap.pellet.CachedNode;
import org.mindswap.pellet.ConceptCache;
import org.mindswap.pellet.ConceptCacheLRU;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.utils.ATermUtils;

public class ConceptCacheTest
extends TestCase {
    private ConceptCache cache;
    private ATermAppl p1 = ATermUtils.makeTermAppl("p1");
    private ATermAppl p2 = ATermUtils.makeTermAppl("p2");
    private ATermAppl p3 = ATermUtils.makeNot(this.p1);
    private ATermAppl p4 = ATermUtils.makeNot(this.p2);
    private ATermAppl np1 = ATermUtils.makeAnd(this.p1, this.p2);
    private ATermAppl np2 = ATermUtils.makeOr(this.p1, this.p2);
    private ATermAppl np3 = ATermUtils.makeAnd(this.p3, this.p4);
    private ATermAppl np4 = ATermUtils.makeOr(this.p3, this.p4);
    private CachedNode DUMMY = CachedNode.createNode(null, DependencySet.INDEPENDENT);

    public void setUp() {
        this.cache = new ConceptCacheLRU(3);
    }

    public void testPut() {
        this.cache.put(this.p1, this.DUMMY);
        this.cache.put(this.p2, this.DUMMY);
        this.cache.put(this.p3, this.DUMMY);
        this.cache.put(this.p4, this.DUMMY);
        this.cache.put(this.np1, this.DUMMY);
        this.cache.put(this.np2, this.DUMMY);
        this.cache.put(this.np3, this.DUMMY);
        ConceptCacheTest.assertEquals((int)7, (int)this.cache.size());
        this.cache.get(this.np1);
        this.cache.get(this.np3);
        this.cache.put(this.np4, this.DUMMY);
        ConceptCacheTest.assertEquals((int)7, (int)this.cache.size());
        ConceptCacheTest.assertFalse((boolean)this.cache.containsKey(this.np2));
        ConceptCacheTest.assertTrue((boolean)this.cache.containsKey(this.np4));
    }
}

