/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.n3.test;

import com.hp.hpl.jena.n3.N3Parser;
import com.hp.hpl.jena.n3.N3ParserEventHandler;
import com.hp.hpl.jena.n3.NullN3EventHandler;
import com.hp.hpl.jena.n3.test.N3ExternalTestsCom;
import com.hp.hpl.jena.shared.JenaException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import junit.framework.TestCase;

public class N3ExternalTests
extends N3ExternalTestsCom {
    public static boolean VERBOSE = false;

    public N3ExternalTests() {
        this("n3-parser-tests");
    }

    public N3ExternalTests(String filename) {
        super("N3 Parser tests", filename);
    }

    protected void makeTest(String n3File, String resultsFile) {
        String testName = n3File + "::" + resultsFile;
        if (this.basedir != null) {
            n3File = this.basedir + "/" + n3File;
        }
        if (this.basedir != null && resultsFile != null && !resultsFile.equals("")) {
            resultsFile = this.basedir + "/" + resultsFile;
        }
        this.addTest((junit.framework.Test)new Test(testName, n3File, this.basedir + "/" + resultsFile));
    }

    static class Test
    extends TestCase {
        N3Parser parser = null;
        String n3File = null;
        String resultsFile = null;
        Reader rData = null;

        Test(String testName, String _n3File, String _resultsFile) {
            super("N3 Parser test: " + testName);
            this.n3File = _n3File;
            this.resultsFile = _resultsFile;
            try {
                this.rData = new FileReader(this.n3File);
                this.parser = new N3Parser(new BufferedReader(this.rData), (N3ParserEventHandler)new NullN3EventHandler());
            }
            catch (IOException ioEx) {
                System.err.println("IO Exception: " + ioEx);
            }
        }

        protected void runTest() throws Throwable {
            try {
                this.parser.parse();
                if (VERBOSE) {
                    PrintWriter pw = new PrintWriter(System.out);
                    BufferedReader r = new BufferedReader(new FileReader(this.n3File));
                    pw.println("+++++++ " + this.getName());
                    String s = r.readLine();
                    while (s != null) {
                        pw.println(s);
                        s = r.readLine();
                    }
                    pw.println("+++++++");
                    pw.flush();
                }
            }
            catch (Exception ex) {
                throw new JenaException((Throwable)ex);
            }
        }
    }
}

