#include <stdio.h>
#include <stdlib.h> 
#include <string.h> 

#include <time.h>
#include <sys/time.h> 
#include <sys/times.h> 
#include <profile.h>
#include <sys/param.h>

#include <spu_mfcio.h>
#include "../swsse2.h" 
#include "matrix.h"
#include "fastalib.h"

#include "swstriped.h"

typedef enum { SCALAR, 
               WOZNIAK, 
#ifdef WITH_ROGNES
               ROGNES, 
#endif
               STRIPED 
} SW_TYPES;

const char *SW_IMPLEMENATION[] = {
    "Non-optimized",
    "Wozniak",
#ifdef WITH_ROGNES
    "Rognes",
#endif
    "Striped",
};

typedef struct {
    SW_DATA *(*init) (unsigned char   *querySeq,
                      int              queryLength,
                      signed char     *matrix);
    void     (*scan) (unsigned char   *querySeq,
                      int              queryLength,
                      FASTA_LIB       *dbLib,
                      void            *swData,
                      SEARCH_OPTIONS  *options,
                      SCORE_LIST      *scores);
    void     (*done) (SW_DATA         *pSwData);
} SW_FUNCT_DEFS;

const char AMINO_ACIDS[ALPHA_SIZE] = {
    'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 
    'I', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 
    'S', 'T', 'V', 'W', 'X', 'Y', 'Z'
};

const int AMINO_ACID_VALUE[256] = {
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1,  0,  1,  2,  3,  4,  5,  6,  7,  8, -1,  9, 10, 11, 12, -1,
    13, 14, 15, 16, 17, -1, 18, 19, 20, 21, 22, -1, -1, -1, -1, -1,
    -1,  0,  1,  2,  3,  4,  5,  6,  7,  8, -1,  9, 10, 11, 12, -1,
    13, 14, 15, 16, 17, -1, 18, 19, 20, 21, 22, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1
};

SCORE_LIST *initList (int count);
void freeList (SCORE_LIST *list);

int
swStripedWord (unsigned char   *querySeq,
               int              queryLength,
               unsigned char   *dbSeq,
               int              dbLength,
               unsigned short   gapOpen,
               unsigned short   gapExtend,
               vector signed short         *queryProf,
               vector signed short         *pvH1,
               vector signed short         *pvH2,
               vector signed short         *pvE);


void printResults (SCORE_LIST *list);

volatile context ctx;
 
int main (unsigned long long spe_id, addr64 argp, addr64 envp) 
{
    int i;
	SCORE_LIST *list;
    int rptCount = 100;
    list = initList (rptCount);
	
	SW_TYPES swType = STRIPED; 

    char *dbFile = "../db.fasta";
    char *queryFile = "../ptest1.fasta";
    char *matrixFile = "../blosum45.mat";

    signed char *matrix;

    unsigned char *querySeq;
    int queryLen;

    FASTA_LIB *queryLib;
    FASTA_LIB *dbLib;


    SEARCH_OPTIONS options;

    /* set the default options */
    options.gapInit = -10;
    options.gapExt = -2;
    //options.threshold = 20;
    options.threshold = 80;

    i = 1;
    matrix = readMatrix (matrixFile);
    if (matrix == NULL) {
        fprintf (stderr, "Error reading matrix\n");
        exit (-1);
    }	
	
	//modefied - mar 3
	mfc_get(&ctx, argp.ui[1], sizeof(ctx), 31, 0, 0);
 	mfc_write_tag_mask(1<<31); 
  	mfc_read_tag_status_all();
	
	void *swData;
	//SwStripedData *swData __attribute__ ((aligned (128)));
	//swData = (SwStripedData *)malloc(sizeof(SwDataPPE)+127);
	//size_t tmp = ((size_t) swData + 127) & ~(0x7f);
    //swData = (SwStripedData *) tmp;  	
	
	/*-Adri
	mfc_get(swData, ctx.swData, sizeof(SwDataPPE), 31, 0, 0); 
 	mfc_write_tag_mask(1<<31);
  	mfc_read_tag_status_all();  
  	*/
  	
  	/*
  	swData->pData = (unsigned char *) calloc (ctx.nCount+1, 16);
    if (!swData->pData) {
        fprintf (stderr, "SPE: Unable to allocate memory for SW data buffers\n");
        exit (-1);
    }*/
    
    //tmp = ((size_t) (swData->pData) + 127) & ~(0x7f);    
    //swData->pData = (unsigned char *) tmp;
    
    dbLib = openLib (dbFile, swType == WOZNIAK);

	dbLib->pos = 0;
	unsigned int max_pos = 0x0FFFFFFF;
	
    queryLib = openLib (queryFile, 0);

    querySeq = nextSeq (queryLib, &queryLen);
    if (queryLen == 0) {
        fprintf (stderr, "Empty query sequence\n");
        exit (-1);
    }

	//prof_clear();
	//prof_start();
  	
	swData = swStripedInit (querySeq, queryLen, matrix);//add - Mar 3
	
	//TIMER
	//spu_write_decrementer(0xFFFFFFFF); // initialization
	//uint32_t t1,t2; 
	//t1= spu_read_decrementer();

	swStripedScan (querySeq, queryLen, dbLib, swData, &options, list, ctx.pos, max_pos);
	
	//TIMER
	//t2 = spu_read_decrementer();
    //printf("SPU %d, Time:%7.2fus\n", ctx.pos,(float)((t1-t2)/79.8));
    
    swStripedComplete (swData);

	//prof_stop();

	//skip printResults - Hieu
    printResults (list);

    closeLib (queryLib);
    closeLib (dbLib);

    free (matrix);
	
    freeList (list);
    
    //added - Hieu
    return 0;
}

void swStripedScan (unsigned char   *querySeq,
                    int              queryLength,
                    FASTA_LIB       *dbLib,
                    void            *swData,
                    SEARCH_OPTIONS  *options,
                    SCORE_LIST      *scores,
                    int pos,
                    int max_pos)
{
    int score;
	int NUM_SPES = 6;
    int threshold = options->threshold;

    int gapInit = -(options->gapInit + options->gapExt);
    int gapExt  = -options->gapExt;

    SwStripedData *stripedData = (SwStripedData *) swData;

/* -
    int *dbLenPos = (int *) malloc(NUM_DB_SEQS * sizeof(int) + 127);
    if (!dbLenPos) {
        fprintf (stderr, "Unable to allocate memory for dbLenPos\n");
        exit (-1);
    }    
    size_t tmp = ((size_t) dbLenPos + 127) & ~(0x7f);
    dbLenPos = (int *)tmp;      	
    mfc_get(dbLenPos, (int)ctx.dbLenPos, NUM_DB_SEQS * sizeof(int), 31, 0, 0); 
 	mfc_write_tag_mask(1<<31); 
  	mfc_read_tag_status_all();   
  	
  	
  	int *dbPos = (int *) malloc(NUM_DB_SEQS * sizeof(int) + 127);    
  	if (!dbPos) {
        fprintf (stderr, "Unable to allocate memory for dbPos\n");
        exit (-1);
    }
    
    tmp = ((size_t) dbPos + 127) & ~(0x7f);
    dbPos = (int *)tmp;
    mfc_get(dbPos, (int)ctx.dbPos, NUM_DB_SEQS * sizeof(int), 31, 0, 0); 
 	mfc_write_tag_mask(1<<31); 
  	mfc_read_tag_status_all();
  	
 	
    unsigned char *dbSeq = (unsigned char *) malloc(MAX_SEQ_LENGTH +127);
    if (!dbSeq) {
        fprintf (stderr, "Unable to allocate memory for dbSeq\n");
        exit (-1);
    }
    tmp = ((size_t) dbSeq + 127) & ~(0x7f);
    dbSeq = (unsigned char *)tmp;  
    int count = ctx.pos;	
         
    int tmp1 = *(dbPos+count);
    int tmp2 = (*(dbLenPos+count) + 15)& ~0x0f;    

    mfc_get(dbSeq, tmp1, tmp2, 31, 0, 0);
 	mfc_write_tag_mask(1<<31); 
  	mfc_read_tag_status_all();
  	//count += NUM_SPES;//since there are 6 SPEs
    //printf("count=%d, dbLib->pos=%d\n", count, dbLib->pos);
    //printf("dbLenPos[count]=%d, max_pos=%d\n", dbLenPos[count], max_pos);
    //printf(" %d %d seq = %d \n", *dbPos, *dbLenPos, (int)(*dbSeq));
     */
    
    int i=0;
    int dbLen;   
    unsigned char *dbSeq;
    
    //printf ("%d\n", MAX_SEQ_LENGTH);
    if (pos==0){
    	dbSeq = nextSeq(dbLib, &dbLen);
    }
    else{ 
    	while (i<=pos) {
    		dbSeq = nextSeq(dbLib, &dbLen);
    		i++;
    	}
    }
    
    //spu_write_decrementer(0xFFFFFFFF); // initialization
	//uint32_t t1,t2; 
	//t1= spu_read_decrementer();
	 
    //while ((dbLenPos[count] > 0)&&(dbLib->pos < max_pos)) {
    while (dbLen > 0){
		
		score = swStripedWord (querySeq, queryLength, 
                                   dbSeq, dbLen, 
                                   gapInit, gapExt, 
                                   stripedData->pvsQueryProf,
                                   stripedData->pvH1,
                                   stripedData->pvH2,
                                   stripedData->pvE);
		//printf("score = %d\n", score);
        //printf ("SPE%d, dbLen=%d, dbSeq=%d, score=%d\n",pos,dbLen,(int)*dbSeq, score);
        
        if (score >= threshold) {
            int minScore = insertList (scores, score, seqName (dbLib));
            if (minScore >= threshold) {
                threshold = minScore;
            }
        }

		/*-
		count += NUM_SPES;//6 SPEs
        tmp2 = (*(dbLenPos+count) + 15)& ~0x0f;
        mfc_get(dbSeq, *(dbPos+count), tmp2, 31, 0, 0);
	 	mfc_write_tag_mask(1<<31); 
	  	mfc_read_tag_status_all();
	  	*/
	  	
	  	for (i=0;i<NUM_SPES; i++) dbSeq = nextSeq(dbLib, &dbLen);

//	  	printf("dbLenPos[%d] = %d\n", count, dbLenPos[count]);    
	  	//count += NUM_SPES;//6 SPEs
    }
    
    //t2 = spu_read_decrementer();
    //spu_write_out_mbox((float)((t1-t2)/79.8));
    //printf("SPU %d, Time:%2.2fus\n", ctx.pos,(float)((t1-t2)/79.8));
    
}

SCORE_LIST *
initList (int count)
{
    int i;

    SCORE_LIST *hdr;
    SCORE_NODE *list;
    SCORE_NODE *prev;

    hdr = (SCORE_LIST *) malloc (sizeof (SCORE_LIST));
    if (hdr == NULL) {
        fprintf (stderr, "Cannot allocate storage for score header\n");
        exit (-1);
    }

    list = (SCORE_NODE *) calloc (count, sizeof (SCORE_NODE));
    if (list == NULL) {
        fprintf (stderr, "Cannot allocate storage for scores\n");
        exit (-1);
    }

    /* initialize the scores list */
    hdr->minScore = 0;
    hdr->first = NULL;
    hdr->last = NULL;
    hdr->free = list;
    hdr->buffer = list;

    prev = NULL;
    for (i = 0; i < count; ++i) {
        list[i].name[0] = '\0';//null character - Hieu
        list[i].score = 0;

        if (i == 0) {
            list[i].prev = NULL;
        } else {
            list[i].prev = &list[i-1];
        }

        if (i == count - 1) {
            list[i].next = NULL;
        } else {
            list[i].next = &list[i+1];
        }
    }

    return hdr;
}

void freeList (SCORE_LIST *list)
{
    free (list->buffer);
    free (list);
}

int insertList (SCORE_LIST *list, int score, char *name)
{
    SCORE_NODE *node;
    SCORE_NODE *ptr = list->first;

    if (list->free != NULL) {
        node = list->free;
        list->free = list->free->next;
    } else if (score > list->last->score) {
        node = list->last;
        list->last = node->prev;
        list->last->next = NULL;
    } else {
        /* should never happen */
        return list->minScore + 1;
    }

    strncpy (node->name, name, MAX_SCORE_NAME);
    node->name[MAX_SCORE_NAME - 1] = '\0';
    node->score = score;

    while (ptr && ptr->score >= score) {
        ptr = ptr->next;
    }

    if (list->first == NULL) {
        list->first = node;
        list->last = node;
        node->prev = NULL;
        node->next = NULL;
    } else if (ptr == NULL) {
        node->prev = list->last;
        node->next = NULL;
        node->prev->next  = node;
        list->last = node;
    } else {
        node->prev = ptr->prev;
        node->next = ptr;

        if (node->prev == NULL) {
            list->first = node;
        } else {
            node->prev->next = node;
        }
        ptr->prev = node;
    }

    if (list->free == NULL) {
        list->minScore = list->last->score + 1;
    }

    return list->minScore;
}

void printResults (SCORE_LIST *list)
{
    SCORE_NODE *ptr = list->first;

    printf ("\nScore  Description\n");

    while (ptr) {
        printf ("%5d  %s\n", ptr->score, ptr->name);
        ptr = ptr->next;
    }
}

