#ifndef INCLUDE_SWSTRIPED_H
#define INCLUDE_SWSTRIPED_H

#include "../swsse2.h"
#include "fastalib.h"

//added
#include <spu_intrinsics.h>

typedef struct {
    vector signed short        *pvbQueryProf;
    vector signed short        *pvsQueryProf;
    vector signed short        *pvH1;
    vector signed short        *pvH2;
    vector signed short        *pvE;
    unsigned char  *pData;
    unsigned short  bias;
    char padding[102];
} SwStripedData; 

SW_DATA *
swStripedInit (unsigned char   *querySeq,
               int              queryLength,
               signed char     *matrix);


void 
swStripedScan (unsigned char   *querySeq,
               int              queryLength,
               FASTA_LIB       *dbLib,
               void            *swData,
               SEARCH_OPTIONS  *options,
               SCORE_LIST      *scores,
               int pos,
               int max_pos);
 
void
swStripedComplete (SW_DATA *pSwData);


#endif /* INCLUDE_SWSTRIPED_H */
