/*
 * Decompiled with CFR 0.152.
 */
package pdb_editor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Stack;
import java.util.TreeSet;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.filechooser.FileFilter;
import pdb_editor.coordinate.CoordinateTable;
import pdb_editor.coordinate.EditColumnListDialog;
import pdb_editor.coordinate.EditCoordinateDialog;
import pdb_editor.coordinate.SearchSelectDialog;
import pdb_editor.dialogs.AtomSelectorDialog;
import pdb_editor.dialogs.CalculateNumberStatisticsDialog;
import pdb_editor.dialogs.EditConnectivityDialog;
import pdb_editor.dialogs.EditResidueNumberDialog;
import pdb_editor.dialogs.EditSpacegroupDialog;
import pdb_editor.dialogs.ExtractSequenceDialog;
import pdb_editor.dialogs.FindClosestAtomDistancesDialog;
import pdb_editor.dialogs.GenerateSymmetryMateDialog;
import pdb_editor.dialogs.OpenCoordinateErrorDialog;
import pdb_editor.dialogs.RotateTranslateAtomsDialog;
import pdb_editor.dialogs.SortAtomsDialog;
import pdb_reader.DataSet;
import pdb_reader.DataSetDataChangeEvent;
import pdb_reader.DataSetDataChangeEventListener;
import pdb_reader.Global;
import pdb_reader.data.Atom;
import pdb_reader.data.AtomPDB;
import pdb_reader.data.AtomSelector;
import pdb_reader.data.spacegroup.SpaceGroup;

public class EditorFrame
extends JFrame
implements ClipboardOwner {
    private DataSet maindata = null;
    private CoordinateTable coordinateTable = null;
    private JScrollPane jScrollPane = null;
    private String statusLabelText = "";
    public boolean dataChangeNotSaved = false;
    private Stack<Object[]> undoStack = new Stack();
    private Stack<Object[]> redoStack = new Stack();
    private ArrayList<Object> undoEventRecord = null;
    private DataSetDataChangeEventListener undoEventListener = new DataSetDataChangeEventListener(){

        public void dataChanged(DataSetDataChangeEvent e) {
            EditorFrame.this.undoEventRecord.add(e);
        }
    };
    private DataSetDataChangeEventListener dataChangeNotSavedListener = new DataSetDataChangeEventListener(){

        public void dataChanged(DataSetDataChangeEvent e) {
            EditorFrame.this.dataChangeNotSaved = true;
        }
    };
    private DataSetDataChangeEventListener eventLoggerListener = new DataSetDataChangeEventListener(){

        public void dataChanged(DataSetDataChangeEvent e) {
            StringBuilder output = new StringBuilder();
            output.append(new Date().toString());
            output.append(" : ");
            switch (e.eventCode) {
                case 1: {
                    output.append("Added Atom#" + e.atomChanged.AtomNumber());
                    break;
                }
                case 2: {
                    output.append("Deleted Atom#" + e.atomChanged.AtomNumber());
                    break;
                }
                case 0: {
                    output.append("Changed Atom#" + e.atomChanged.AtomNumber());
                    output.append(' ' + Atom.DataToolTip[e.atomChangeEvent.dataEntryAffected] + " from " + e.atomChangeEvent.oldValue);
                }
            }
            output.append('\n');
            EditorFrame.this.jEventLoggerTextArea.append(output.toString());
        }
    };
    private JButton jButton1;
    private JDialog jDialogAbout;
    private JDialog jDialogEventLogger;
    private JButton jEventLoggerButtonClear;
    private JButton jEventLoggerButtonClose;
    private JTextArea jEventLoggerTextArea;
    private JFileChooser jFileChooser;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JMenuBar jMenuBar;
    private JMenu jMenuCalculate;
    private JMenu jMenuDelete;
    private JMenu jMenuEdit;
    private JMenu jMenuFile;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItemAbout;
    private JMenuItem jMenuItemAltConfAtoms;
    private JMenuItem jMenuItemCalculateNumberStatistics;
    private JMenuItem jMenuItemColumnDisplayed;
    private JMenuItem jMenuItemCopy;
    private JMenuItem jMenuItemCopyPDB;
    private JMenuItem jMenuItemCopySpacegroup;
    private JMenuItem jMenuItemCorrectAtomOrdering;
    private JMenuItem jMenuItemCutPDB;
    private JMenuItem jMenuItemDelete;
    private JMenuItem jMenuItemDeleteAllAltConfAtoms;
    private JMenuItem jMenuItemDeleteAllAnisoB;
    private JMenuItem jMenuItemDeleteAllHAtoms;
    private JMenuItem jMenuItemDeleteAllSigmaU;
    private JMenuItem jMenuItemDeleteAllSigmaXYZ;
    private JMenuItem jMenuItemDeleteAllZeroOccpAtoms;
    private JMenuItem jMenuItemDeleteHAtoms;
    private JMenuItem jMenuItemDeleteSelectedAnisoB;
    private JMenuItem jMenuItemDeleteSelectedSigmaU;
    private JMenuItem jMenuItemDeleteSelectedSigmaXYZ;
    private JMenuItem jMenuItemEdit;
    private JMenuItem jMenuItemEditAtomConnectivity;
    private JMenuItem jMenuItemEditResNumChainID;
    private JMenuItem jMenuItemEditSpacegroupUnitcell;
    private JMenuItem jMenuItemExit;
    private JMenuItem jMenuItemExtractSequence;
    private JMenuItem jMenuItemFindClosestAtomDistances;
    private JMenuItem jMenuItemFixElement;
    private JMenuItem jMenuItemGenerateSymmetryMates;
    private JMenuItem jMenuItemInsertEmptyAtom;
    private JMenuItem jMenuItemInvertSelection;
    private JMenuItem jMenuItemMoveBottom;
    private JMenuItem jMenuItemMoveDown;
    private JMenuItem jMenuItemMoveTop;
    private JMenuItem jMenuItemMoveUp;
    private JMenuItem jMenuItemNew;
    private JMenuItem jMenuItemOpen;
    private JMenuItem jMenuItemPaste;
    private JMenuItem jMenuItemRedo;
    private JMenuItem jMenuItemReduceToCa;
    private JMenuItem jMenuItemReduceToPolyALA;
    private JMenuItem jMenuItemResetAtomNumber;
    private JMenuItem jMenuItemRotateTranslateAtoms;
    private JMenuItem jMenuItemSave;
    private JMenuItem jMenuItemSaveAs;
    private JMenuItem jMenuItemSelectAll;
    private JMenuItem jMenuItemSelectAllDNAAtoms;
    private JMenuItem jMenuItemSelectAllProteinAtoms;
    private JMenuItem jMenuItemSelectAllRNAAtoms;
    private JMenuItem jMenuItemSelectAllSolventAtoms;
    private JMenuItem jMenuItemSelectAllUncategorizedAtoms;
    private JMenuItem jMenuItemSelectChain;
    private JMenuItem jMenuItemSelectColumn;
    private JMenuItem jMenuItemSelectResidue;
    private JMenuItem jMenuItemSelectRow;
    private JMenuItem jMenuItemSelectSearch;
    private JMenuItem jMenuItemSortAtoms;
    private JMenuItem jMenuItemUndo;
    private JMenuItem jMenuItemZeroOccpAtoms;
    private JMenu jMenuModify;
    private JMenu jMenuOption;
    private JMenu jMenuSelect;
    private JMenu jMenuSortAscending;
    private JMenu jMenuSortDescending;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JSeparator jSeparator10;
    private JToolBar.Separator jSeparator11;
    private JToolBar.Separator jSeparator12;
    private JSeparator jSeparator13;
    private JSeparator jSeparator14;
    private JSeparator jSeparator15;
    private JSeparator jSeparator16;
    private JSeparator jSeparator17;
    private JSeparator jSeparator18;
    private JSeparator jSeparator19;
    private JSeparator jSeparator2;
    private JSeparator jSeparator20;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JToolBar.Separator jSeparator5;
    private JSeparator jSeparator6;
    private JSeparator jSeparator7;
    private JSeparator jSeparator8;
    private JSeparator jSeparator9;
    private JLabel jStatusLabel;
    private JLabel jStatusLabelIndent;
    private JTabbedPane jTabbedPane;
    private JTextArea jTextArea1;
    private JToolBar jToolBarMain;
    private JToolBar jToolBarStatus;
    private JButton jToolButtonCalculateStatistics;
    private JButton jToolButtonColumnDisplayed;
    private JButton jToolButtonCopy;
    private JButton jToolButtonCopyPDB;
    private JButton jToolButtonCutPDB;
    private JButton jToolButtonEditCoordinate;
    private JButton jToolButtonExtractSequence;
    private JButton jToolButtonNew;
    private JButton jToolButtonOpen;
    private JButton jToolButtonPaste;
    private JButton jToolButtonSave;
    private JButton jToolButtonSaveAs;
    private JButton jToolButtonSearchSelect;

    public EditorFrame() {
        this.InitializeCommon();
    }

    public EditorFrame(boolean b) {
        this.InitializeCommon();
        this.NewData();
    }

    public EditorFrame(String FileName) {
        this.InitializeCommon();
        this.LoadData(FileName);
    }

    private void InitializeCommon() {
        this.initComponents();
        this.setFiltersForFileChooser();
        this.InitializeSortMenuItems();
    }

    private void InitializeSortMenuItems() {
        ActionListener ascendingAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                class SortMenuItem
                extends JMenuItem {
                    public int dataIndex;

                    public SortMenuItem(int index) {
                        this.dataIndex = index;
                    }
                }
                EditorFrame.this.performAtomSort(((SortMenuItem)e.getSource()).dataIndex, false);
            }
        };
        ActionListener descendingAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditorFrame.this.performAtomSort(((SortMenuItem)e.getSource()).dataIndex, true);
            }
        };
        for (int i = 0; i < 35; ++i) {
            SortMenuItem asc = new SortMenuItem(i);
            SortMenuItem des = new SortMenuItem(i);
            String name = Atom.DataToolTip[i];
            asc.setText(name);
            des.setText(name);
            asc.addActionListener(ascendingAction);
            des.addActionListener(descendingAction);
            this.jMenuSortAscending.add(asc);
            this.jMenuSortDescending.add(des);
        }
    }

    private void performAtomSort(int dataIndex, boolean descending) {
        if (this.coordinateTable != null) {
            String name = "Sort " + (descending ? "descending " : "ascending ") + Atom.DataToolTip[dataIndex];
            this.listenForUndoStart(name);
            this.maindata.Sort(dataIndex, descending);
            this.coordinateTable.fireTableDataChanged();
            this.listenForUndoStop();
        }
    }

    public void listenForUndoStart(String undoName) {
        this.undoEventRecord = new ArrayList();
        this.undoEventRecord.add(undoName);
        this.maindata.addDataChangeListener(this.undoEventListener);
    }

    public void listenForUndoStop(boolean redo) {
        this.maindata.removeDataChangeListener(this.undoEventListener);
        if (this.undoEventRecord.size() > 1) {
            this.undoStack.push(this.undoEventRecord.toArray(new Object[this.undoEventRecord.size()]));
            this.jMenuItemUndo.setText("Undo - " + this.undoStack.peek()[0].toString());
            this.jMenuItemUndo.setEnabled(true);
            if (!redo) {
                this.redoStack.clear();
                this.jMenuItemRedo.setText("Redo");
                this.jMenuItemRedo.setEnabled(false);
            }
        }
    }

    public void listenForUndoStop() {
        this.listenForUndoStop(false);
    }

    private void listenForRedoStop() {
        this.maindata.removeDataChangeListener(this.undoEventListener);
        this.redoStack.push(this.undoEventRecord.toArray(new Object[this.undoEventRecord.size()]));
        this.jMenuItemRedo.setText("Redo - " + this.redoStack.peek()[0].toString());
        this.jMenuItemRedo.setEnabled(true);
    }

    private void undoPerform() {
        Object[] undoList = this.undoStack.pop();
        if (this.undoStack.empty()) {
            this.jMenuItemUndo.setText("Undo");
            this.jMenuItemUndo.setEnabled(false);
        } else {
            this.jMenuItemUndo.setText("Undo - " + this.undoStack.peek()[0].toString());
            this.jMenuItemUndo.setEnabled(true);
        }
        this.listenForUndoStart(undoList[0].toString());
        int numberaffected = this.undoPerform(undoList);
        this.StatusLabelChange("Undo : " + undoList[0].toString() + " - " + numberaffected + " atoms changed");
        this.coordinateTable.fireTableDataChanged();
        this.listenForRedoStop();
    }

    private void redoPerform() {
        Object[] redoList = this.redoStack.pop();
        if (this.redoStack.empty()) {
            this.jMenuItemRedo.setText("Redo");
            this.jMenuItemRedo.setEnabled(false);
        } else {
            this.jMenuItemRedo.setText("Redo - " + this.redoStack.peek()[0].toString());
            this.jMenuItemRedo.setEnabled(true);
        }
        this.listenForUndoStart(redoList[0].toString());
        int numberaffected = this.undoPerform(redoList);
        this.StatusLabelChange("Redo : " + redoList[0].toString() + " - " + numberaffected + " atoms changed");
        this.coordinateTable.fireTableDataChanged();
        this.listenForUndoStop(true);
    }

    private int undoPerform(Object[] undoList) {
        LinkedHashSet<Atom> count = new LinkedHashSet<Atom>();
        block6: for (int i = undoList.length - 1; i > 0; --i) {
            DataSetDataChangeEvent d = (DataSetDataChangeEvent)undoList[i];
            switch (d.eventCode) {
                case 1: {
                    if (!this.maindata.Atoms().contains(d.atomChanged)) continue block6;
                    this.maindata.Atoms().remove(d.atomChanged);
                    count.add(d.atomChanged);
                    continue block6;
                }
                case 2: {
                    if (this.maindata.Atoms().contains(d.atomChanged)) continue block6;
                    this.maindata.Atoms().add(d.lastIndex, d.atomChanged);
                    count.add(d.atomChanged);
                    continue block6;
                }
                case 0: {
                    d.atomChanged.TableData(d.atomChangeEvent.dataEntryAffected, d.atomChangeEvent.oldValue);
                    count.add(d.atomChanged);
                    continue block6;
                }
                case 3: {
                    this.maindata.fireDataChangeEvent(new DataSetDataChangeEvent((Object)this.maindata, 3));
                    this.maindata.Atoms(d.oldData);
                }
            }
        }
        return count.size();
    }

    private void setFiltersForFileChooser() {
        this.jFileChooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String Ext = Global.GetFileExtension(f);
                if (Ext == null) {
                    return false;
                }
                return Ext.equals("PDB");
            }

            public String getDescription() {
                return "RCSB Protein Data Bank File (*.pdb)";
            }
        });
    }

    private void StatusLabelChange(String Text) {
        this.statusLabelText = Text;
        this.jStatusLabel.setText(Text);
    }

    private void StatusLabelTemporary(String Text) {
        this.statusLabelText = this.jStatusLabel.getText();
        this.jStatusLabel.setText(Text);
    }

    private void StatusLabelTemporaryEnd() {
        this.jStatusLabel.setText(this.statusLabelText);
    }

    private void StatusLabelClear() {
        this.jStatusLabel.setText("");
    }

    public void StatusLabelReportCellSelectionChange() {
        int atomnumber = this.coordinateTable.getSelectedRowCount();
        int columnnumber = this.coordinateTable.getSelectedColumnCount();
        if (atomnumber != 0 && columnnumber != 0) {
            if (atomnumber > 1 || columnnumber > 1) {
                String atom = " atoms ";
                if (atomnumber == 1) {
                    atom = " atom ";
                }
                String column = " columns ";
                if (columnnumber == 1) {
                    column = " column ";
                }
                this.StatusLabelChange(atomnumber + atom + "and " + columnnumber + column + "selected");
            } else {
                Atom a = this.maindata.Atoms().get(this.coordinateTable.getSelectedRow());
                String atomtext = "Atom " + a.AtomNumber() + ' ' + a.AtomType() + ' ' + a.ChainID() + a.ResidueNumber() + " : ";
                this.StatusLabelChange(atomtext + this.coordinateTable.getColumnName(this.coordinateTable.getSelectedColumn()) + " = " + this.coordinateTable.getModel().getValueAt(this.coordinateTable.getSelectedRow(), this.coordinateTable.getSelectedColumn()));
            }
        }
    }

    private void NewCoordinateFile() {
        if (this.maindata == null) {
            this.NewData();
        } else {
            EditorFrame nw = new EditorFrame(true);
            nw.setVisible(true);
        }
    }

    private void NewData() {
        this.maindata = new DataSet();
        this.maindata.addDataChangeListener(this.dataChangeNotSavedListener);
        this.DisplayPDBData();
    }

    private void SaveCoordinateFileAs() {
        int retValue;
        if (this.maindata != null && (retValue = this.jFileChooser.showSaveDialog(this)) == 0) {
            String filename = Global.AddFileExtension(this.jFileChooser.getSelectedFile().getPath(), "pdb");
            String message = this.maindata.SaveFile(filename);
            if (message == null) {
                this.setTitle("PDB Editor by JL - " + Global.TrimFileName(this.maindata.FileName(), 2));
                this.StatusLabelChange("File successfully saved");
                this.dataChangeNotSaved = false;
            } else {
                JOptionPane.showMessageDialog(this, message, "Error Saving File", 0);
            }
        }
    }

    private void SaveCoordinateFile() {
        if (this.maindata != null) {
            if (this.maindata.FileName() == null) {
                this.SaveCoordinateFileAs();
            } else {
                String message = this.maindata.SaveFile();
                if (message == null) {
                    this.StatusLabelChange("File successfully saved");
                    this.dataChangeNotSaved = false;
                } else {
                    JOptionPane.showMessageDialog(this, message, "Error Saving File", 0);
                }
            }
        }
    }

    public void DeleteRecord() {
        if (this.maindata != null && this.coordinateTable.getSelectedRowCount() > 0) {
            this.listenForUndoStart("Delete selected atoms");
            this.maindata.DeleteAtoms(this.coordinateTable.getSelectedRows());
            this.listenForUndoStop();
            this.coordinateTable.clearSelection();
            this.coordinateTable.fireTableDataChanged();
        }
    }

    private void SelectAllRecord() {
        if (this.coordinateTable != null) {
            this.coordinateTable.selectAll();
        }
    }

    private void LoadCoordinateFile() {
        int retValue = this.jFileChooser.showOpenDialog(this);
        if (retValue == 0) {
            if (this.maindata == null) {
                this.LoadData(this.jFileChooser.getSelectedFile().getPath());
            } else {
                EditorFrame nw = new EditorFrame(this.jFileChooser.getSelectedFile().getPath());
                nw.setVisible(true);
            }
        }
    }

    private void LoadData(String FileName) {
        this.maindata = new DataSet(FileName);
        this.DisplayPDBData();
        String message = this.maindata.getReadingError();
        if (!message.equals("")) {
            OpenCoordinateErrorDialog errordialog = new OpenCoordinateErrorDialog((Frame)this, true, message);
            errordialog.show();
        }
        this.StatusLabelChange("Read and loaded " + this.maindata.Atoms().size() + " atom coordinates");
        this.maindata.addDataChangeListener(this.dataChangeNotSavedListener);
    }

    private void DisplayPDBData() {
        if (this.maindata.FileName() != null) {
            this.setTitle("PDB Editor by JL - " + Global.TrimFileName(this.maindata.FileName(), 2));
        } else {
            this.setTitle("PDB Editor by JL - Untitled Coordinate");
        }
        this.jTabbedPane.addTab("Coordinates", this.getJScrollPane());
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.coordinateTable = new CoordinateTable(this, this.maindata);
            this.jScrollPane = new JScrollPane(this.coordinateTable);
            this.jScrollPane.setHorizontalScrollBarPolicy(30);
            this.coordinateTable.setAutoResizeMode(0);
        }
        return this.jScrollPane;
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    private void setClipboardContent(String s) {
        StringSelection stringSelection = new StringSelection(s);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, this);
    }

    private String getClipboardString() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            Object c = clipboard.getData(DataFlavor.stringFlavor);
            return (String)c;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void PasteToCoordinateTable() {
        this.listenForUndoStart("Paste");
        String s = this.getClipboardString().trim();
        if ((this.coordinateTable.getSelectedColumnCount() > 0 && this.coordinateTable.getSelectedRowCount() > 0 || this.maindata.Atoms().size() == 0) && s != null) {
            switch (this.FindClipboardStringType(s)) {
                case 0: {
                    this.coordinateTable.PasteText(s);
                    break;
                }
                case 1: {
                    this.AppendPDBData(s);
                    break;
                }
                case 2: {
                    this.PasteSpaceGroupData(s);
                }
            }
        }
        this.listenForUndoStop();
    }

    private int FindClipboardStringType(String s) {
        if (s.length() > 5) {
            String sub = s.substring(0, 6);
            if (Global.StringArrayContains(AtomPDB.Headers, sub) || Global.StringArrayContains(AtomPDB.ContinueHeaders, sub)) {
                return 1;
            }
            if (sub.equals(SpaceGroup.Headers[0] + '1')) {
                return 2;
            }
        }
        return 0;
    }

    private void PasteSpaceGroupData(String s) {
        SpaceGroup sg = new SpaceGroup(s);
        EditSpacegroupDialog esd = new EditSpacegroupDialog((Frame)this, true, this.maindata, sg);
        esd.show();
        this.coordinateTable.fireTableDataChanged();
    }

    private void AppendPDBData(String s) {
        int rowstart = 0;
        rowstart = this.coordinateTable.getSelectedRow() != -1 && this.maindata.Atoms().size() != 0 ? this.coordinateTable.getSelectedRows()[this.coordinateTable.getSelectedRows().length - 1] + 1 : this.maindata.Atoms().size() - 1;
        if (rowstart < 0) {
            rowstart = 0;
        }
        int PDBadd = this.maindata.AppendPDBInformation(s, rowstart);
        this.coordinateTable.clearSelection();
        this.coordinateTable.addRowSelectionInterval(rowstart, rowstart + PDBadd - 1);
        this.coordinateTable.addColumnSelectionInterval(0, this.coordinateTable.getColumnCount() - 1);
    }

    private void EditCoordinateData() {
        EditCoordinateDialog ecd = new EditCoordinateDialog(this, false, this.coordinateTable);
        ecd.show();
    }

    private void CoordinateTypeSelectedDelete(AtomSelector selector) {
        if (this.coordinateTable != null) {
            int count = this.maindata.deleteSelectorAtoms(selector, this.coordinateTable.getSelectedRows());
            this.StatusLabelChange(count + " coordinates deleted");
            this.coordinateTable.fireTableDataChanged();
        }
    }

    private void CoordinateTypeDelete(AtomSelector selector) {
        if (this.coordinateTable != null) {
            int count = this.maindata.deleteSelectorAtoms(selector);
            this.StatusLabelChange(count + " coordinates deleted");
            this.coordinateTable.fireTableDataChanged();
        }
    }

    private void selectCoordinateTableRows(Integer[] indicies) {
        this.coordinateTable.removeRowSelectionInterval(0, this.maindata.Atoms().size() - 1);
        for (int i = 0; i < indicies.length; ++i) {
            this.coordinateTable.addRowSelectionInterval(indicies[i], indicies[i]);
        }
        this.coordinateTable.editingCanceled(null);
    }

    private void setColumnValueToNull(int columnIndex, String undoName, boolean AllRows) {
        if (this.coordinateTable != null) {
            if (undoName != null) {
                this.listenForUndoStart(undoName);
            }
            int[] indicies = this.coordinateTable.getSelectedRows();
            int length = AllRows ? this.maindata.Atoms().size() : indicies.length;
            for (int i = 0; i < length; ++i) {
                int index = AllRows ? i : indicies[i];
                this.maindata.Atoms().get(index).TableData(columnIndex, null);
            }
            if (undoName != null) {
                this.listenForUndoStop();
                this.StatusLabelChange(undoName + " - " + length + " atoms changed");
            }
            this.coordinateTable.fireTableDataChanged();
        }
    }

    public void dispose() {
        this.jDialogAbout.dispose();
        this.jDialogEventLogger.dispose();
        super.dispose();
    }

    private void initComponents() {
        this.jFileChooser = new JFileChooser();
        this.jDialogAbout = new JDialog();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jButton1 = new JButton();
        this.jDialogEventLogger = new JDialog();
        this.jScrollPane2 = new JScrollPane();
        this.jEventLoggerTextArea = new JTextArea();
        this.jEventLoggerButtonClose = new JButton();
        this.jEventLoggerButtonClear = new JButton();
        this.jToolBarMain = new JToolBar();
        this.jToolButtonNew = new JButton();
        this.jToolButtonOpen = new JButton();
        this.jToolButtonSave = new JButton();
        this.jToolButtonSaveAs = new JButton();
        this.jSeparator5 = new JToolBar.Separator();
        this.jToolButtonCopy = new JButton();
        this.jToolButtonCopyPDB = new JButton();
        this.jToolButtonCutPDB = new JButton();
        this.jToolButtonPaste = new JButton();
        this.jSeparator11 = new JToolBar.Separator();
        this.jToolButtonSearchSelect = new JButton();
        this.jToolButtonEditCoordinate = new JButton();
        this.jToolButtonCalculateStatistics = new JButton();
        this.jToolButtonExtractSequence = new JButton();
        this.jSeparator12 = new JToolBar.Separator();
        this.jToolButtonColumnDisplayed = new JButton();
        this.jToolBarStatus = new JToolBar();
        this.jStatusLabelIndent = new JLabel();
        this.jStatusLabel = new JLabel();
        this.jTabbedPane = new JTabbedPane();
        this.jMenuBar = new JMenuBar();
        this.jMenuFile = new JMenu();
        this.jMenuItemNew = new JMenuItem();
        this.jMenuItemOpen = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.jMenuItemSave = new JMenuItem();
        this.jMenuItemSaveAs = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.jMenuItemExit = new JMenuItem();
        this.jMenuEdit = new JMenu();
        this.jMenuItemUndo = new JMenuItem();
        this.jMenuItemRedo = new JMenuItem();
        this.jSeparator14 = new JSeparator();
        this.jMenuItemCopy = new JMenuItem();
        this.jMenuItemCopyPDB = new JMenuItem();
        this.jMenuItemCopySpacegroup = new JMenuItem();
        this.jMenuItemCutPDB = new JMenuItem();
        this.jMenuItemPaste = new JMenuItem();
        this.jSeparator3 = new JSeparator();
        this.jMenuItemEdit = new JMenuItem();
        this.jSeparator17 = new JSeparator();
        this.jMenuItemInsertEmptyAtom = new JMenuItem();
        this.jSeparator20 = new JSeparator();
        this.jMenuItemMoveTop = new JMenuItem();
        this.jMenuItemMoveUp = new JMenuItem();
        this.jMenuItemMoveDown = new JMenuItem();
        this.jMenuItemMoveBottom = new JMenuItem();
        this.jMenuDelete = new JMenu();
        this.jMenuItemDelete = new JMenuItem();
        this.jSeparator8 = new JSeparator();
        this.jMenuItemDeleteHAtoms = new JMenuItem();
        this.jMenuItemZeroOccpAtoms = new JMenuItem();
        this.jMenuItemAltConfAtoms = new JMenuItem();
        this.jSeparator15 = new JSeparator();
        this.jMenuItemDeleteSelectedAnisoB = new JMenuItem();
        this.jMenuItemDeleteSelectedSigmaXYZ = new JMenuItem();
        this.jMenuItemDeleteSelectedSigmaU = new JMenuItem();
        this.jSeparator7 = new JSeparator();
        this.jMenuItemDeleteAllHAtoms = new JMenuItem();
        this.jMenuItemDeleteAllZeroOccpAtoms = new JMenuItem();
        this.jMenuItemDeleteAllAltConfAtoms = new JMenuItem();
        this.jSeparator16 = new JSeparator();
        this.jMenuItemDeleteAllAnisoB = new JMenuItem();
        this.jMenuItemDeleteAllSigmaXYZ = new JMenuItem();
        this.jMenuItemDeleteAllSigmaU = new JMenuItem();
        this.jMenuSelect = new JMenu();
        this.jMenuItemSelectSearch = new JMenuItem();
        this.jMenuItemInvertSelection = new JMenuItem();
        this.jSeparator6 = new JSeparator();
        this.jMenuItemSelectAll = new JMenuItem();
        this.jMenuItemSelectRow = new JMenuItem();
        this.jMenuItemSelectColumn = new JMenuItem();
        this.jMenuItemSelectChain = new JMenuItem();
        this.jMenuItemSelectResidue = new JMenuItem();
        this.jSeparator4 = new JSeparator();
        this.jMenuItemSelectAllProteinAtoms = new JMenuItem();
        this.jMenuItemSelectAllDNAAtoms = new JMenuItem();
        this.jMenuItemSelectAllRNAAtoms = new JMenuItem();
        this.jMenuItemSelectAllSolventAtoms = new JMenuItem();
        this.jMenuItemSelectAllUncategorizedAtoms = new JMenuItem();
        this.jMenuModify = new JMenu();
        this.jMenuItemEditSpacegroupUnitcell = new JMenuItem();
        this.jMenuItemEditResNumChainID = new JMenuItem();
        this.jMenuItemEditAtomConnectivity = new JMenuItem();
        this.jSeparator10 = new JSeparator();
        this.jMenuItemResetAtomNumber = new JMenuItem();
        this.jMenuItemFixElement = new JMenuItem();
        this.jMenuItemCorrectAtomOrdering = new JMenuItem();
        this.jSeparator19 = new JSeparator();
        this.jMenuItemSortAtoms = new JMenuItem();
        this.jMenuSortAscending = new JMenu();
        this.jMenuSortDescending = new JMenu();
        this.jMenuCalculate = new JMenu();
        this.jMenuItemGenerateSymmetryMates = new JMenuItem();
        this.jMenuItemRotateTranslateAtoms = new JMenuItem();
        this.jSeparator18 = new JSeparator();
        this.jMenuItemCalculateNumberStatistics = new JMenuItem();
        this.jMenuItemExtractSequence = new JMenuItem();
        this.jMenuItemFindClosestAtomDistances = new JMenuItem();
        this.jSeparator9 = new JSeparator();
        this.jMenuItemReduceToCa = new JMenuItem();
        this.jMenuItemReduceToPolyALA = new JMenuItem();
        this.jMenuOption = new JMenu();
        this.jMenuItemColumnDisplayed = new JMenuItem();
        this.jMenuItem1 = new JMenuItem();
        this.jSeparator13 = new JSeparator();
        this.jMenuItemAbout = new JMenuItem();
        this.jDialogAbout.setTitle("About PDB Editor by JL");
        this.jDialogAbout.setMinimumSize(new Dimension(500, 500));
        this.jDialogAbout.setModal(true);
        this.jDialogAbout.setResizable(false);
        this.jLabel1.setFont(new Font("Tahoma", 1, 14));
        this.jLabel1.setText("PDB Editor by JL");
        this.jLabel2.setFont(new Font("Tahoma", 0, 14));
        this.jLabel2.setText("Fix : 080529");
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setRows(5);
        this.jTextArea1.setText("    Protein Data Bank File Editor by JL\n    Copyright (C)   2008   Jonas Lee\n\n    This program is free software: you can redistribute it and/or modify\n    it under the terms of the GNU General Public License as published by\n    the Free Software Foundation, either version 3 of the License, or\n    (at your option) any later version.\n\n    This program is distributed in the hope that it will be useful,\n    but WITHOUT ANY WARRANTY; without even the implied warranty of\n    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n    GNU General Public License for more details.\n\n    You should have received a copy of the GNU General Public License\n    along with this program.  If not, see <http://www.gnu.org/licenses/>.\n\n\nAuthor : Jonas Lee\nUniversity of California - Berkeley\nDepartment of Chemistry\n\nAcknowledgments\n- Crystal Project : Icons\n- CCP4 : Scale matrix calc, Crystal symm library\n- RCSB PDB\n- wwPDB Format v2.3");
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setFocusable(false);
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.jButton1.setText("Close");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout jDialogAboutLayout = new GroupLayout(this.jDialogAbout.getContentPane());
        this.jDialogAbout.getContentPane().setLayout(jDialogAboutLayout);
        jDialogAboutLayout.setHorizontalGroup(jDialogAboutLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialogAboutLayout.createSequentialGroup().addGroup(jDialogAboutLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialogAboutLayout.createSequentialGroup().addContainerGap().addGroup(jDialogAboutLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2))).addGroup(jDialogAboutLayout.createSequentialGroup().addContainerGap(209, Short.MAX_VALUE).addComponent(this.jButton1)).addGroup(GroupLayout.Alignment.TRAILING, jDialogAboutLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 258, Short.MAX_VALUE))).addContainerGap()));
        jDialogAboutLayout.setVerticalGroup(jDialogAboutLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialogAboutLayout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 139, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jButton1).addGap(11, 11, 11)));
        this.jDialogEventLogger.setTitle("Data Change Event Log");
        this.jDialogEventLogger.setMinimumSize(new Dimension(500, 500));
        this.jEventLoggerTextArea.setColumns(20);
        this.jEventLoggerTextArea.setRows(5);
        this.jScrollPane2.setViewportView(this.jEventLoggerTextArea);
        this.jEventLoggerButtonClose.setText("Close");
        this.jEventLoggerButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jEventLoggerButtonCloseActionPerformed(evt);
            }
        });
        this.jEventLoggerButtonClear.setText("Clear");
        this.jEventLoggerButtonClear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jEventLoggerButtonClearActionPerformed(evt);
            }
        });
        GroupLayout jDialogEventLoggerLayout = new GroupLayout(this.jDialogEventLogger.getContentPane());
        this.jDialogEventLogger.getContentPane().setLayout(jDialogEventLoggerLayout);
        jDialogEventLoggerLayout.setHorizontalGroup(jDialogEventLoggerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jDialogEventLoggerLayout.createSequentialGroup().addContainerGap().addGroup(jDialogEventLoggerLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane2, GroupLayout.Alignment.LEADING, -1, 499, Short.MAX_VALUE).addGroup(jDialogEventLoggerLayout.createSequentialGroup().addComponent(this.jEventLoggerButtonClear).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jEventLoggerButtonClose))).addContainerGap()));
        jDialogEventLoggerLayout.setVerticalGroup(jDialogEventLoggerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jDialogEventLoggerLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, 379, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jDialogEventLoggerLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jEventLoggerButtonClose).addComponent(this.jEventLoggerButtonClear)).addContainerGap()));
        this.setDefaultCloseOperation(2);
        this.setTitle("PDB Editor by JL");
        this.setMinimumSize(new Dimension(800, 800));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                EditorFrame.this.formWindowClosing(evt);
            }
        });
        this.jToolBarMain.setRollover(true);
        this.jToolBarMain.setMaximumSize(new Dimension(24, 24));
        this.jToolBarMain.setMinimumSize(new Dimension(24, 24));
        this.jToolButtonNew.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/filenew.png")));
        this.jToolButtonNew.setToolTipText("New Coordinate File");
        this.jToolButtonNew.setBorderPainted(false);
        this.jToolButtonNew.setContentAreaFilled(false);
        this.jToolButtonNew.setFocusable(false);
        this.jToolButtonNew.setHorizontalTextPosition(0);
        this.jToolButtonNew.setMargin(new Insets(0, 0, 0, 0));
        this.jToolButtonNew.setMaximumSize(new Dimension(25, 25));
        this.jToolButtonNew.setMinimumSize(new Dimension(25, 25));
        this.jToolButtonNew.setVerticalTextPosition(3);
        this.jToolButtonNew.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent evt) {
                EditorFrame.this.jToolButtonNewMouseEntered(evt);
            }

            public void mouseExited(MouseEvent evt) {
                EditorFrame.this.jToolButtonNewMouseExited(evt);
            }
        });
        this.jToolButtonNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jToolButtonNewActionPerformed(evt);
            }
        });
        this.jToolBarMain.add(this.jToolButtonNew);
        this.jToolButtonOpen.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/fileopen.png")));
        this.jToolButtonOpen.setToolTipText("Open Coordinate File");
        this.jToolButtonOpen.setBorderPainted(false);
        this.jToolButtonOpen.setContentAreaFilled(false);
        this.jToolButtonOpen.setFocusable(false);
        this.jToolButtonOpen.setHorizontalTextPosition(0);
        this.jToolButtonOpen.setVerticalTextPosition(3);
        this.jToolButtonOpen.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent evt) {
                EditorFrame.this.jToolButtonOpenMouseEntered(evt);
            }

            public void mouseExited(MouseEvent evt) {
                EditorFrame.this.jToolButtonOpenMouseExited(evt);
            }
        });
        this.jToolButtonOpen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jToolButtonOpenActionPerformed(evt);
            }
        });
        this.jToolBarMain.add(this.jToolButtonOpen);
        this.jToolButtonSave.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/filesave.png")));
        this.jToolButtonSave.setToolTipText("Save Coordinate File");
        this.jToolButtonSave.setBorderPainted(false);
        this.jToolButtonSave.setContentAreaFilled(false);
        this.jToolButtonSave.setFocusable(false);
        this.jToolButtonSave.setHorizontalTextPosition(0);
        this.jToolButtonSave.setVerticalTextPosition(3);
        this.jToolButtonSave.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent evt) {
                EditorFrame.this.jToolButtonSaveMouseEntered(evt);
            }

            public void mouseExited(MouseEvent evt) {
                EditorFrame.this.jToolButtonSaveMouseExited(evt);
            }
        });
        this.jToolButtonSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jToolButtonSaveActionPerformed(evt);
            }
        });
        this.jToolBarMain.add(this.jToolButtonSave);
        this.jToolButtonSaveAs.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/filesaveas.png")));
        this.jToolButtonSaveAs.setToolTipText("Save Coordinate File As");
        this.jToolButtonSaveAs.setBorderPainted(false);
        this.jToolButtonSaveAs.setContentAreaFilled(false);
        this.jToolButtonSaveAs.setFocusable(false);
        this.jToolButtonSaveAs.setHorizontalTextPosition(0);
        this.jToolButtonSaveAs.setVerticalTextPosition(3);
        this.jToolButtonSaveAs.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent evt) {
                EditorFrame.this.jToolButtonSaveAsMouseEntered(evt);
            }

            public void mouseExited(MouseEvent evt) {
                EditorFrame.this.jToolButtonSaveAsMouseExited(evt);
            }
        });
        this.jToolButtonSaveAs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jToolButtonSaveAsActionPerformed(evt);
            }
        });
        this.jToolBarMain.add(this.jToolButtonSaveAs);
        this.jToolBarMain.add(this.jSeparator5);
        this.jToolButtonCopy.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/editcopy24.png")));
        this.jToolButtonCopy.setToolTipText("Copy cell data");
        this.jToolButtonCopy.setBorderPainted(false);
        this.jToolButtonCopy.setContentAreaFilled(false);
        this.jToolButtonCopy.setFocusable(false);
        this.jToolButtonCopy.setHorizontalTextPosition(0);
        this.jToolButtonCopy.setVerticalTextPosition(3);
        this.jToolButtonCopy.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent evt) {
                EditorFrame.this.jToolButtonCopyMouseEntered(evt);
            }

            public void mouseExited(MouseEvent evt) {
                EditorFrame.this.jToolButtonCopyMouseExited(evt);
            }
        });
        this.jToolButtonCopy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemCopyActionPerformed(evt);
            }
        });
        this.jToolBarMain.add(this.jToolButtonCopy);
        this.jToolButtonCopyPDB.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/editcopyPDB24.png")));
        this.jToolButtonCopyPDB.setToolTipText("Copy atoms in PDB format");
        this.jToolButtonCopyPDB.setBorderPainted(false);
        this.jToolButtonCopyPDB.setContentAreaFilled(false);
        this.jToolButtonCopyPDB.setFocusable(false);
        this.jToolButtonCopyPDB.setHorizontalTextPosition(0);
        this.jToolButtonCopyPDB.setVerticalTextPosition(3);
        this.jToolButtonCopyPDB.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent evt) {
                EditorFrame.this.jToolButtonCopyPDBMouseEntered(evt);
            }

            public void mouseExited(MouseEvent evt) {
                EditorFrame.this.jToolButtonCopyPDBMouseExited(evt);
            }
        });
        this.jToolButtonCopyPDB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemCopyPDBActionPerformed(evt);
            }
        });
        this.jToolBarMain.add(this.jToolButtonCopyPDB);
        this.jToolButtonCutPDB.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/editcut24.png")));
        this.jToolButtonCutPDB.setToolTipText("Cut atoms in PDB format");
        this.jToolButtonCutPDB.setBorderPainted(false);
        this.jToolButtonCutPDB.setContentAreaFilled(false);
        this.jToolButtonCutPDB.setFocusable(false);
        this.jToolButtonCutPDB.setHorizontalTextPosition(0);
        this.jToolButtonCutPDB.setVerticalTextPosition(3);
        this.jToolButtonCutPDB.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent evt) {
                EditorFrame.this.jToolButtonCutPDBMouseEntered(evt);
            }

            public void mouseExited(MouseEvent evt) {
                EditorFrame.this.jToolButtonCutPDBMouseExited(evt);
            }
        });
        this.jToolButtonCutPDB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jToolButtonCutPDBjMenuItemCopyPDBActionPerformed(evt);
            }
        });
        this.jToolBarMain.add(this.jToolButtonCutPDB);
        this.jToolButtonPaste.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/editpaste24.png")));
        this.jToolButtonPaste.setToolTipText("Paste data from clipboard");
        this.jToolButtonPaste.setBorderPainted(false);
        this.jToolButtonPaste.setContentAreaFilled(false);
        this.jToolButtonPaste.setFocusable(false);
        this.jToolButtonPaste.setHorizontalTextPosition(0);
        this.jToolButtonPaste.setVerticalTextPosition(3);
        this.jToolButtonPaste.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent evt) {
                EditorFrame.this.jToolButtonPasteMouseEntered(evt);
            }

            public void mouseExited(MouseEvent evt) {
                EditorFrame.this.jToolButtonPasteMouseExited(evt);
            }
        });
        this.jToolButtonPaste.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemPasteActionPerformed(evt);
            }
        });
        this.jToolBarMain.add(this.jToolButtonPaste);
        this.jToolBarMain.add(this.jSeparator11);
        this.jToolButtonSearchSelect.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/search24.png")));
        this.jToolButtonSearchSelect.setToolTipText("Search and Select Coordinate");
        this.jToolButtonSearchSelect.setBorderPainted(false);
        this.jToolButtonSearchSelect.setContentAreaFilled(false);
        this.jToolButtonSearchSelect.setFocusable(false);
        this.jToolButtonSearchSelect.setHorizontalTextPosition(0);
        this.jToolButtonSearchSelect.setVerticalTextPosition(3);
        this.jToolButtonSearchSelect.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent evt) {
                EditorFrame.this.jToolButtonSearchSelectMouseEntered(evt);
            }

            public void mouseExited(MouseEvent evt) {
                EditorFrame.this.jToolButtonSearchSelectMouseExited(evt);
            }
        });
        this.jToolButtonSearchSelect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jToolButtonSearchSelectActionPerformed(evt);
            }
        });
        this.jToolBarMain.add(this.jToolButtonSearchSelect);
        this.jToolButtonEditCoordinate.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/edit24.png")));
        this.jToolButtonEditCoordinate.setToolTipText("Edit Selected Record");
        this.jToolButtonEditCoordinate.setBorderPainted(false);
        this.jToolButtonEditCoordinate.setContentAreaFilled(false);
        this.jToolButtonEditCoordinate.setFocusable(false);
        this.jToolButtonEditCoordinate.setHorizontalTextPosition(0);
        this.jToolButtonEditCoordinate.setVerticalTextPosition(3);
        this.jToolButtonEditCoordinate.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent evt) {
                EditorFrame.this.jToolButtonEditCoordinateMouseEntered(evt);
            }

            public void mouseExited(MouseEvent evt) {
                EditorFrame.this.jToolButtonEditCoordinateMouseExited(evt);
            }
        });
        this.jToolButtonEditCoordinate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jToolButtonEditCoordinateActionPerformed(evt);
            }
        });
        this.jToolBarMain.add(this.jToolButtonEditCoordinate);
        this.jToolButtonCalculateStatistics.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/calc24.png")));
        this.jToolButtonCalculateStatistics.setToolTipText("Calculate atom statistics");
        this.jToolButtonCalculateStatistics.setBorderPainted(false);
        this.jToolButtonCalculateStatistics.setContentAreaFilled(false);
        this.jToolButtonCalculateStatistics.setFocusable(false);
        this.jToolButtonCalculateStatistics.setHorizontalTextPosition(0);
        this.jToolButtonCalculateStatistics.setVerticalTextPosition(3);
        this.jToolButtonCalculateStatistics.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent evt) {
                EditorFrame.this.jToolButtonCalculateStatisticsMouseEntered(evt);
            }

            public void mouseExited(MouseEvent evt) {
                EditorFrame.this.jToolButtonCalculateStatisticsMouseExited(evt);
            }
        });
        this.jToolButtonCalculateStatistics.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemCalculateNumberStatisticsActionPerformed(evt);
            }
        });
        this.jToolBarMain.add(this.jToolButtonCalculateStatistics);
        this.jToolButtonExtractSequence.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/view_text24.png")));
        this.jToolButtonExtractSequence.setToolTipText("Extract sequence");
        this.jToolButtonExtractSequence.setBorderPainted(false);
        this.jToolButtonExtractSequence.setContentAreaFilled(false);
        this.jToolButtonExtractSequence.setFocusable(false);
        this.jToolButtonExtractSequence.setHorizontalTextPosition(0);
        this.jToolButtonExtractSequence.setVerticalTextPosition(3);
        this.jToolButtonExtractSequence.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent evt) {
                EditorFrame.this.jToolButtonExtractSequenceMouseEntered(evt);
            }

            public void mouseExited(MouseEvent evt) {
                EditorFrame.this.jToolButtonExtractSequenceMouseExited(evt);
            }
        });
        this.jToolButtonExtractSequence.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemExtractSequenceActionPerformed(evt);
            }
        });
        this.jToolBarMain.add(this.jToolButtonExtractSequence);
        this.jToolBarMain.add(this.jSeparator12);
        this.jToolButtonColumnDisplayed.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/table24.png")));
        this.jToolButtonColumnDisplayed.setToolTipText("Change Column Displayed");
        this.jToolButtonColumnDisplayed.setBorderPainted(false);
        this.jToolButtonColumnDisplayed.setContentAreaFilled(false);
        this.jToolButtonColumnDisplayed.setFocusable(false);
        this.jToolButtonColumnDisplayed.setHorizontalTextPosition(0);
        this.jToolButtonColumnDisplayed.setVerticalTextPosition(3);
        this.jToolButtonColumnDisplayed.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent evt) {
                EditorFrame.this.jToolButtonColumnDisplayedMouseEntered(evt);
            }

            public void mouseExited(MouseEvent evt) {
                EditorFrame.this.jToolButtonColumnDisplayedMouseExited(evt);
            }
        });
        this.jToolButtonColumnDisplayed.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jToolButtonColumnDisplayedActionPerformed(evt);
            }
        });
        this.jToolBarMain.add(this.jToolButtonColumnDisplayed);
        this.getContentPane().add((Component)this.jToolBarMain, "First");
        this.jToolBarStatus.setFloatable(false);
        this.jToolBarStatus.setRollover(true);
        this.jStatusLabelIndent.setText("   ");
        this.jToolBarStatus.add(this.jStatusLabelIndent);
        this.jToolBarStatus.add(this.jStatusLabel);
        this.getContentPane().add((Component)this.jToolBarStatus, "Last");
        this.getContentPane().add((Component)this.jTabbedPane, "Center");
        this.jMenuFile.setText("File");
        this.jMenuItemNew.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.jMenuItemNew.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/filenew16.png")));
        this.jMenuItemNew.setText("New Coordinate File");
        this.jMenuItemNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemNewActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemNew);
        this.jMenuItemOpen.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.jMenuItemOpen.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/fileopen16.png")));
        this.jMenuItemOpen.setText("Open Coordinate File");
        this.jMenuItemOpen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemOpenActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemOpen);
        this.jMenuFile.add(this.jSeparator1);
        this.jMenuItemSave.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.jMenuItemSave.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/filesave16.png")));
        this.jMenuItemSave.setText("Save Coordinate File");
        this.jMenuItemSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemSaveActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemSave);
        this.jMenuItemSaveAs.setAccelerator(KeyStroke.getKeyStroke(83, 3));
        this.jMenuItemSaveAs.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/filesaveas16.png")));
        this.jMenuItemSaveAs.setText("Save Coordinate File As");
        this.jMenuItemSaveAs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemSaveAsActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemSaveAs);
        this.jMenuFile.add(this.jSeparator2);
        this.jMenuItemExit.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        this.jMenuItemExit.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/exit16.png")));
        this.jMenuItemExit.setText("Exit");
        this.jMenuItemExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemExitActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemExit);
        this.jMenuBar.add(this.jMenuFile);
        this.jMenuEdit.setText("Edit");
        this.jMenuItemUndo.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.jMenuItemUndo.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/undo16.png")));
        this.jMenuItemUndo.setText("Undo");
        this.jMenuItemUndo.setEnabled(false);
        this.jMenuItemUndo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemUndoActionPerformed(evt);
            }
        });
        this.jMenuEdit.add(this.jMenuItemUndo);
        this.jMenuItemRedo.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        this.jMenuItemRedo.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/redo16.png")));
        this.jMenuItemRedo.setText("Redo");
        this.jMenuItemRedo.setEnabled(false);
        this.jMenuItemRedo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemRedoActionPerformed(evt);
            }
        });
        this.jMenuEdit.add(this.jMenuItemRedo);
        this.jMenuEdit.add(this.jSeparator14);
        this.jMenuItemCopy.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.jMenuItemCopy.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/editcopy16.png")));
        this.jMenuItemCopy.setText("Copy Selected Cells");
        this.jMenuItemCopy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemCopyActionPerformed(evt);
            }
        });
        this.jMenuEdit.add(this.jMenuItemCopy);
        this.jMenuItemCopyPDB.setAccelerator(KeyStroke.getKeyStroke(67, 3));
        this.jMenuItemCopyPDB.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/editcopy16.png")));
        this.jMenuItemCopyPDB.setText("Copy Selected Atoms in PDB Format");
        this.jMenuItemCopyPDB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemCopyPDBActionPerformed(evt);
            }
        });
        this.jMenuEdit.add(this.jMenuItemCopyPDB);
        this.jMenuItemCopySpacegroup.setAccelerator(KeyStroke.getKeyStroke(67, 11));
        this.jMenuItemCopySpacegroup.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/editcopy16.png")));
        this.jMenuItemCopySpacegroup.setText("Copy Spacegroup  in PDB Format");
        this.jMenuItemCopySpacegroup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemCopySpacegroupActionPerformed(evt);
            }
        });
        this.jMenuEdit.add(this.jMenuItemCopySpacegroup);
        this.jMenuItemCutPDB.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.jMenuItemCutPDB.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/editcut16.png")));
        this.jMenuItemCutPDB.setText("Cut Selected Atoms in PDB Format");
        this.jMenuItemCutPDB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemCutPDBActionPerformed(evt);
            }
        });
        this.jMenuEdit.add(this.jMenuItemCutPDB);
        this.jMenuItemPaste.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.jMenuItemPaste.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/editpaste16.png")));
        this.jMenuItemPaste.setText("Paste");
        this.jMenuItemPaste.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemPasteActionPerformed(evt);
            }
        });
        this.jMenuEdit.add(this.jMenuItemPaste);
        this.jMenuEdit.add(this.jSeparator3);
        this.jMenuItemEdit.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.jMenuItemEdit.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/edit16.png")));
        this.jMenuItemEdit.setText("Edit Selected Atoms");
        this.jMenuItemEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemEditActionPerformed(evt);
            }
        });
        this.jMenuEdit.add(this.jMenuItemEdit);
        this.jMenuEdit.add(this.jSeparator17);
        this.jMenuItemInsertEmptyAtom.setAccelerator(KeyStroke.getKeyStroke(73, 3));
        this.jMenuItemInsertEmptyAtom.setText("Insert Empty Atom");
        this.jMenuItemInsertEmptyAtom.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemInsertEmptyAtomActionPerformed(evt);
            }
        });
        this.jMenuEdit.add(this.jMenuItemInsertEmptyAtom);
        this.jMenuEdit.add(this.jSeparator20);
        this.jMenuItemMoveTop.setAccelerator(KeyStroke.getKeyStroke(38, 3));
        this.jMenuItemMoveTop.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/3uparrow16.png")));
        this.jMenuItemMoveTop.setText("Move Selected Atoms to Top");
        this.jMenuItemMoveTop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemMoveTopActionPerformed(evt);
            }
        });
        this.jMenuEdit.add(this.jMenuItemMoveTop);
        this.jMenuItemMoveUp.setAccelerator(KeyStroke.getKeyStroke(38, 2));
        this.jMenuItemMoveUp.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/1downarrow16.png")));
        this.jMenuItemMoveUp.setText("Move Selected Atoms Up");
        this.jMenuItemMoveUp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemMoveUpActionPerformed(evt);
            }
        });
        this.jMenuEdit.add(this.jMenuItemMoveUp);
        this.jMenuItemMoveDown.setAccelerator(KeyStroke.getKeyStroke(40, 2));
        this.jMenuItemMoveDown.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/1uparrow16.png")));
        this.jMenuItemMoveDown.setText("Move Selected Atoms Down");
        this.jMenuItemMoveDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemMoveDownActionPerformed(evt);
            }
        });
        this.jMenuEdit.add(this.jMenuItemMoveDown);
        this.jMenuItemMoveBottom.setAccelerator(KeyStroke.getKeyStroke(40, 3));
        this.jMenuItemMoveBottom.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/3downarrow16.png")));
        this.jMenuItemMoveBottom.setText("Move Selected Atom to Bottom");
        this.jMenuItemMoveBottom.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemMoveBottomActionPerformed(evt);
            }
        });
        this.jMenuEdit.add(this.jMenuItemMoveBottom);
        this.jMenuBar.add(this.jMenuEdit);
        this.jMenuDelete.setText("Delete");
        this.jMenuItemDelete.setAccelerator(KeyStroke.getKeyStroke(127, 2));
        this.jMenuItemDelete.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/delete_table_row16.png")));
        this.jMenuItemDelete.setText("Delete Selected Records");
        this.jMenuItemDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemDeleteActionPerformed(evt);
            }
        });
        this.jMenuDelete.add(this.jMenuItemDelete);
        this.jMenuDelete.add(this.jSeparator8);
        this.jMenuItemDeleteHAtoms.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/delete_table_row16.png")));
        this.jMenuItemDeleteHAtoms.setText("Delete Hydrogen Atoms from Selected");
        this.jMenuItemDeleteHAtoms.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemDeleteHAtomsActionPerformed(evt);
            }
        });
        this.jMenuDelete.add(this.jMenuItemDeleteHAtoms);
        this.jMenuItemZeroOccpAtoms.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/delete_table_row16.png")));
        this.jMenuItemZeroOccpAtoms.setText("Delete Zero Occupancy Atoms from Selected");
        this.jMenuItemZeroOccpAtoms.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemZeroOccpAtomsActionPerformed(evt);
            }
        });
        this.jMenuDelete.add(this.jMenuItemZeroOccpAtoms);
        this.jMenuItemAltConfAtoms.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/delete_table_row16.png")));
        this.jMenuItemAltConfAtoms.setText("Delete Alternate Conformation Atoms from Selected");
        this.jMenuItemAltConfAtoms.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemAltConfAtomsActionPerformed(evt);
            }
        });
        this.jMenuDelete.add(this.jMenuItemAltConfAtoms);
        this.jMenuDelete.add(this.jSeparator15);
        this.jMenuItemDeleteSelectedAnisoB.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/delete_table_col16.png")));
        this.jMenuItemDeleteSelectedAnisoB.setText("Delete Anisotropic Temp Factor from Selected Atoms");
        this.jMenuItemDeleteSelectedAnisoB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemDeleteSelectedAnisoBActionPerformed(evt);
            }
        });
        this.jMenuDelete.add(this.jMenuItemDeleteSelectedAnisoB);
        this.jMenuItemDeleteSelectedSigmaXYZ.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/delete_table_col16.png")));
        this.jMenuItemDeleteSelectedSigmaXYZ.setText("Delete Sigma Coordinate from Selected Atoms");
        this.jMenuItemDeleteSelectedSigmaXYZ.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemDeleteSelectedSigmaXYZActionPerformed(evt);
            }
        });
        this.jMenuDelete.add(this.jMenuItemDeleteSelectedSigmaXYZ);
        this.jMenuItemDeleteSelectedSigmaU.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/delete_table_col16.png")));
        this.jMenuItemDeleteSelectedSigmaU.setText("Delete Sigma U from Selected Atoms");
        this.jMenuItemDeleteSelectedSigmaU.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemDeleteSelectedSigmaUActionPerformed(evt);
            }
        });
        this.jMenuDelete.add(this.jMenuItemDeleteSelectedSigmaU);
        this.jMenuDelete.add(this.jSeparator7);
        this.jMenuItemDeleteAllHAtoms.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/delete16.png")));
        this.jMenuItemDeleteAllHAtoms.setText("Delete All Hydrogen Atoms");
        this.jMenuItemDeleteAllHAtoms.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemDeleteAllHAtomsActionPerformed(evt);
            }
        });
        this.jMenuDelete.add(this.jMenuItemDeleteAllHAtoms);
        this.jMenuItemDeleteAllZeroOccpAtoms.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/delete16.png")));
        this.jMenuItemDeleteAllZeroOccpAtoms.setText("Delete All Zero Occupancy Atoms");
        this.jMenuItemDeleteAllZeroOccpAtoms.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemDeleteAllZeroOccpAtomsActionPerformed(evt);
            }
        });
        this.jMenuDelete.add(this.jMenuItemDeleteAllZeroOccpAtoms);
        this.jMenuItemDeleteAllAltConfAtoms.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/delete16.png")));
        this.jMenuItemDeleteAllAltConfAtoms.setText("Delete All Alternate Conformation Atoms");
        this.jMenuItemDeleteAllAltConfAtoms.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemDeleteAllAltConfAtomsActionPerformed(evt);
            }
        });
        this.jMenuItemDeleteAllAltConfAtoms.addAncestorListener(new AncestorListener(){

            public void ancestorMoved(AncestorEvent evt) {
            }

            public void ancestorAdded(AncestorEvent evt) {
                EditorFrame.this.jMenuItemDeleteAllAltConfAtomsAncestorAdded(evt);
            }

            public void ancestorRemoved(AncestorEvent evt) {
            }
        });
        this.jMenuDelete.add(this.jMenuItemDeleteAllAltConfAtoms);
        this.jMenuDelete.add(this.jSeparator16);
        this.jMenuItemDeleteAllAnisoB.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/removecell16.png")));
        this.jMenuItemDeleteAllAnisoB.setText("Delete Anisotropic Temp Factor from All Atoms");
        this.jMenuItemDeleteAllAnisoB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemDeleteAllAnisoBActionPerformed(evt);
            }
        });
        this.jMenuDelete.add(this.jMenuItemDeleteAllAnisoB);
        this.jMenuItemDeleteAllSigmaXYZ.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/removecell16.png")));
        this.jMenuItemDeleteAllSigmaXYZ.setText("Delete Sigma Coordinate from All Atoms");
        this.jMenuItemDeleteAllSigmaXYZ.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemDeleteAllSigmaXYZActionPerformed(evt);
            }
        });
        this.jMenuDelete.add(this.jMenuItemDeleteAllSigmaXYZ);
        this.jMenuItemDeleteAllSigmaU.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/removecell16.png")));
        this.jMenuItemDeleteAllSigmaU.setText("Delete Sigma U from All Atoms");
        this.jMenuItemDeleteAllSigmaU.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemDeleteAllSigmaUActionPerformed(evt);
            }
        });
        this.jMenuDelete.add(this.jMenuItemDeleteAllSigmaU);
        this.jMenuBar.add(this.jMenuDelete);
        this.jMenuSelect.setText("Select");
        this.jMenuItemSelectSearch.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.jMenuItemSelectSearch.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/search16.png")));
        this.jMenuItemSelectSearch.setText("Search and Select");
        this.jMenuItemSelectSearch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemSelectSearchActionPerformed(evt);
            }
        });
        this.jMenuSelect.add(this.jMenuItemSelectSearch);
        this.jMenuItemInvertSelection.setAccelerator(KeyStroke.getKeyStroke(73, 2));
        this.jMenuItemInvertSelection.setText("Invert Selected Rows");
        this.jMenuItemInvertSelection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemInvertSelectionActionPerformed(evt);
            }
        });
        this.jMenuSelect.add(this.jMenuItemInvertSelection);
        this.jMenuSelect.add(this.jSeparator6);
        this.jMenuItemSelectAll.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.jMenuItemSelectAll.setText("Select All Cells");
        this.jMenuItemSelectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemSelectAllActionPerformed(evt);
            }
        });
        this.jMenuSelect.add(this.jMenuItemSelectAll);
        this.jMenuItemSelectRow.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.jMenuItemSelectRow.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/show_table_column16.png")));
        this.jMenuItemSelectRow.setText("Select All Rows in Selected Columns");
        this.jMenuItemSelectRow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemSelectRowActionPerformed(evt);
            }
        });
        this.jMenuSelect.add(this.jMenuItemSelectRow);
        this.jMenuItemSelectColumn.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        this.jMenuItemSelectColumn.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/show_table_row16.png")));
        this.jMenuItemSelectColumn.setText("Select All Columns in Selected Rows");
        this.jMenuItemSelectColumn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemSelectColumnActionPerformed(evt);
            }
        });
        this.jMenuSelect.add(this.jMenuItemSelectColumn);
        this.jMenuItemSelectChain.setAccelerator(KeyStroke.getKeyStroke(67, 10));
        this.jMenuItemSelectChain.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/select16.png")));
        this.jMenuItemSelectChain.setText("Select All Atoms in Selected Chains");
        this.jMenuItemSelectChain.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemSelectChainActionPerformed(evt);
            }
        });
        this.jMenuSelect.add(this.jMenuItemSelectChain);
        this.jMenuItemSelectResidue.setAccelerator(KeyStroke.getKeyStroke(82, 10));
        this.jMenuItemSelectResidue.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/select16.png")));
        this.jMenuItemSelectResidue.setText("Select All Atoms in Selected Residues");
        this.jMenuItemSelectResidue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemSelectResidueActionPerformed(evt);
            }
        });
        this.jMenuSelect.add(this.jMenuItemSelectResidue);
        this.jMenuSelect.add(this.jSeparator4);
        this.jMenuItemSelectAllProteinAtoms.setAccelerator(KeyStroke.getKeyStroke(80, 10));
        this.jMenuItemSelectAllProteinAtoms.setText("Select All Protein Atoms");
        this.jMenuItemSelectAllProteinAtoms.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemSelectAllProteinAtomsActionPerformed(evt);
            }
        });
        this.jMenuSelect.add(this.jMenuItemSelectAllProteinAtoms);
        this.jMenuItemSelectAllDNAAtoms.setAccelerator(KeyStroke.getKeyStroke(68, 10));
        this.jMenuItemSelectAllDNAAtoms.setText("Select All DNA Atoms");
        this.jMenuItemSelectAllDNAAtoms.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemSelectAllDNAAtomsActionPerformed(evt);
            }
        });
        this.jMenuSelect.add(this.jMenuItemSelectAllDNAAtoms);
        this.jMenuItemSelectAllRNAAtoms.setAccelerator(KeyStroke.getKeyStroke(78, 10));
        this.jMenuItemSelectAllRNAAtoms.setText("Select All RNA Atoms");
        this.jMenuItemSelectAllRNAAtoms.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemSelectAllRNAAtomsActionPerformed(evt);
            }
        });
        this.jMenuSelect.add(this.jMenuItemSelectAllRNAAtoms);
        this.jMenuItemSelectAllSolventAtoms.setAccelerator(KeyStroke.getKeyStroke(83, 10));
        this.jMenuItemSelectAllSolventAtoms.setText("Select All Solvent Atoms");
        this.jMenuItemSelectAllSolventAtoms.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemSelectAllSolventAtomsActionPerformed(evt);
            }
        });
        this.jMenuSelect.add(this.jMenuItemSelectAllSolventAtoms);
        this.jMenuItemSelectAllUncategorizedAtoms.setAccelerator(KeyStroke.getKeyStroke(85, 10));
        this.jMenuItemSelectAllUncategorizedAtoms.setText("Select All Unrecognized Residue Atoms");
        this.jMenuItemSelectAllUncategorizedAtoms.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemSelectAllUncategorizedAtomsActionPerformed(evt);
            }
        });
        this.jMenuSelect.add(this.jMenuItemSelectAllUncategorizedAtoms);
        this.jMenuBar.add(this.jMenuSelect);
        this.jMenuModify.setText("Modify");
        this.jMenuItemEditSpacegroupUnitcell.setText("Edit Spacegroup & Unit Cell");
        this.jMenuItemEditSpacegroupUnitcell.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemEditSpacegroupUnitcellActionPerformed(evt);
            }
        });
        this.jMenuModify.add(this.jMenuItemEditSpacegroupUnitcell);
        this.jMenuItemEditResNumChainID.setText("Edit Residue Number & Chain ID");
        this.jMenuItemEditResNumChainID.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemEditResNumChainIDActionPerformed(evt);
            }
        });
        this.jMenuModify.add(this.jMenuItemEditResNumChainID);
        this.jMenuItemEditAtomConnectivity.setText("Edit Atom Connectivity");
        this.jMenuItemEditAtomConnectivity.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemEditAtomConnectivityActionPerformed(evt);
            }
        });
        this.jMenuModify.add(this.jMenuItemEditAtomConnectivity);
        this.jMenuModify.add(this.jSeparator10);
        this.jMenuItemResetAtomNumber.setText("Reset Atom Nuimber");
        this.jMenuItemResetAtomNumber.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemResetAtomNumberActionPerformed(evt);
            }
        });
        this.jMenuModify.add(this.jMenuItemResetAtomNumber);
        this.jMenuItemFixElement.setText("Fix Element from Atom Name");
        this.jMenuItemFixElement.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemFixElementActionPerformed(evt);
            }
        });
        this.jMenuModify.add(this.jMenuItemFixElement);
        this.jMenuItemCorrectAtomOrdering.setText("Correct Atom Ordering");
        this.jMenuItemCorrectAtomOrdering.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemCorrectAtomOrderingActionPerformed(evt);
            }
        });
        this.jMenuModify.add(this.jMenuItemCorrectAtomOrdering);
        this.jMenuModify.add(this.jSeparator19);
        this.jMenuItemSortAtoms.setText("Sort Atoms with Multiple Criteria");
        this.jMenuItemSortAtoms.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemSortAtomsActionPerformed(evt);
            }
        });
        this.jMenuModify.add(this.jMenuItemSortAtoms);
        this.jMenuSortAscending.setText("Sort Atoms Ascending");
        this.jMenuModify.add(this.jMenuSortAscending);
        this.jMenuSortDescending.setText("Sort Atoms Descending");
        this.jMenuModify.add(this.jMenuSortDescending);
        this.jMenuBar.add(this.jMenuModify);
        this.jMenuCalculate.setText("Calculate");
        this.jMenuItemGenerateSymmetryMates.setText("Generate Symmetry Mates");
        this.jMenuItemGenerateSymmetryMates.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemGenerateSymmetryMatesActionPerformed(evt);
            }
        });
        this.jMenuCalculate.add(this.jMenuItemGenerateSymmetryMates);
        this.jMenuItemRotateTranslateAtoms.setText("Rotate / Translate Atoms");
        this.jMenuItemRotateTranslateAtoms.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemRotateTranslateAtomsActionPerformed(evt);
            }
        });
        this.jMenuCalculate.add(this.jMenuItemRotateTranslateAtoms);
        this.jMenuCalculate.add(this.jSeparator18);
        this.jMenuItemCalculateNumberStatistics.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/calc16.png")));
        this.jMenuItemCalculateNumberStatistics.setText("Calculate Number Statistics");
        this.jMenuItemCalculateNumberStatistics.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemCalculateNumberStatisticsActionPerformed(evt);
            }
        });
        this.jMenuCalculate.add(this.jMenuItemCalculateNumberStatistics);
        this.jMenuItemExtractSequence.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/view_text16.png")));
        this.jMenuItemExtractSequence.setText("Extract Sequence");
        this.jMenuItemExtractSequence.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemExtractSequenceActionPerformed(evt);
            }
        });
        this.jMenuCalculate.add(this.jMenuItemExtractSequence);
        this.jMenuItemFindClosestAtomDistances.setText("Find Closest Atom Distances");
        this.jMenuItemFindClosestAtomDistances.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemFindClosestAtomDistancesActionPerformed(evt);
            }
        });
        this.jMenuCalculate.add(this.jMenuItemFindClosestAtomDistances);
        this.jMenuCalculate.add(this.jSeparator9);
        this.jMenuItemReduceToCa.setText("Reduce Protein to Ca");
        this.jMenuItemReduceToCa.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemReduceToCaActionPerformed(evt);
            }
        });
        this.jMenuCalculate.add(this.jMenuItemReduceToCa);
        this.jMenuItemReduceToPolyALA.setText("Reduce Protein to Poly Ala");
        this.jMenuItemReduceToPolyALA.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemReduceToPolyALAActionPerformed(evt);
            }
        });
        this.jMenuCalculate.add(this.jMenuItemReduceToPolyALA);
        this.jMenuBar.add(this.jMenuCalculate);
        this.jMenuOption.setText("Option");
        this.jMenuItemColumnDisplayed.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/table16.png")));
        this.jMenuItemColumnDisplayed.setText("Change Columns Displayed");
        this.jMenuItemColumnDisplayed.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemColumnDisplayedActionPerformed(evt);
            }
        });
        this.jMenuOption.add(this.jMenuItemColumnDisplayed);
        this.jMenuItem1.setText("Event Logger");
        this.jMenuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jMenuOption.add(this.jMenuItem1);
        this.jMenuOption.add(this.jSeparator13);
        this.jMenuItemAbout.setText("About");
        this.jMenuItemAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorFrame.this.jMenuItemAboutActionPerformed(evt);
            }
        });
        this.jMenuOption.add(this.jMenuItemAbout);
        this.jMenuBar.add(this.jMenuOption);
        this.setJMenuBar(this.jMenuBar);
        this.pack();
    }

    private void jMenuItemOpenActionPerformed(ActionEvent evt) {
        this.LoadCoordinateFile();
        if (this.coordinateTable != null) {
            this.coordinateTable.editingCanceled(null);
        }
    }

    private void jMenuItemNewActionPerformed(ActionEvent evt) {
        this.NewCoordinateFile();
        if (this.coordinateTable != null) {
            this.coordinateTable.editingCanceled(null);
        }
    }

    private void jMenuItemSaveActionPerformed(ActionEvent evt) {
        this.SaveCoordinateFile();
        if (this.coordinateTable != null) {
            this.coordinateTable.editingCanceled(null);
        }
    }

    private void jMenuItemSaveAsActionPerformed(ActionEvent evt) {
        this.SaveCoordinateFileAs();
        if (this.coordinateTable != null) {
            this.coordinateTable.editingCanceled(null);
        }
    }

    private void jMenuItemExitActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jToolButtonNewActionPerformed(ActionEvent evt) {
        this.NewCoordinateFile();
    }

    private void jToolButtonOpenActionPerformed(ActionEvent evt) {
        this.LoadCoordinateFile();
    }

    private void jToolButtonSaveActionPerformed(ActionEvent evt) {
        this.SaveCoordinateFile();
    }

    private void jMenuItemSelectAllActionPerformed(ActionEvent evt) {
        this.SelectAllRecord();
    }

    private void jMenuItemDeleteActionPerformed(ActionEvent evt) {
        this.DeleteRecord();
    }

    private void jMenuItemEditActionPerformed(ActionEvent evt) {
        if (this.coordinateTable != null) {
            this.EditCoordinateData();
            this.coordinateTable.editingCanceled(null);
        }
    }

    private void jMenuItemSelectRowActionPerformed(ActionEvent evt) {
        if (this.coordinateTable != null) {
            this.coordinateTable.addColumnSelectionInterval(0, this.coordinateTable.getColumnCount() - 1);
            this.coordinateTable.editingCanceled(null);
        }
    }

    private void jMenuItemSelectColumnActionPerformed(ActionEvent evt) {
        if (this.coordinateTable != null) {
            this.coordinateTable.addRowSelectionInterval(0, this.coordinateTable.getRowCount() - 1);
            this.coordinateTable.editingCanceled(null);
        }
    }

    private void jMenuItemCopyActionPerformed(ActionEvent evt) {
        if (this.coordinateTable != null) {
            this.setClipboardContent(Global.FormatTabbedTextFromSelected(this.coordinateTable));
            this.StatusLabelChange(this.coordinateTable.getSelectedColumnCount() * this.coordinateTable.getSelectedRowCount() + " cells copied onto the clipboard");
        }
    }

    private void jMenuItemCopyPDBActionPerformed(ActionEvent evt) {
        if (this.coordinateTable != null) {
            this.setClipboardContent(this.coordinateTable.GetPDBTextFromSelectedRows());
            this.StatusLabelChange(this.coordinateTable.getSelectedRowCount() + " atoms copied onto the clipboard in PDB format");
            this.coordinateTable.editingCanceled(null);
        }
    }

    private void jMenuItemResetAtomNumberActionPerformed(ActionEvent evt) {
        if (this.coordinateTable != null) {
            this.listenForUndoStart("Reset atom numbers");
            this.maindata.ResetAtomNumbers();
            this.listenForUndoStop();
            this.coordinateTable.clearSelection();
            this.coordinateTable.addColumnSelectionInterval(this.coordinateTable.GetColumnIndex(1), this.coordinateTable.GetColumnIndex(1));
            this.coordinateTable.addRowSelectionInterval(0, this.coordinateTable.getRowCount() - 1);
        }
    }

    private void jMenuItemColumnDisplayedActionPerformed(ActionEvent evt) {
        if (this.maindata != null) {
            EditColumnListDialog ecd = new EditColumnListDialog((Frame)this, true, Atom.DataToolTip, this.coordinateTable.ListColumnDisplayed());
            ecd.show();
            if (ecd.returnValue() == 1) {
                int[] newcolumnlist = ecd.selectedColumnIndicies();
                this.coordinateTable.setColumnIndex(newcolumnlist);
            }
            ecd.dispose();
        }
    }

    private void jToolButtonColumnDisplayedActionPerformed(ActionEvent evt) {
        this.jMenuItemColumnDisplayedActionPerformed(null);
    }

    private void jMenuItemPasteActionPerformed(ActionEvent evt) {
        if (this.maindata != null) {
            this.PasteToCoordinateTable();
        }
    }

    private void jMenuItemSelectChainActionPerformed(ActionEvent evt) {
        if (this.coordinateTable != null && this.coordinateTable.getSelectedRowCount() != 0) {
            int[] rows = this.coordinateTable.getSelectedRows();
            HashMap m = new HashMap();
            for (int i = 0; i < rows.length; ++i) {
                m.put(Character.valueOf(this.maindata.Atoms().get(rows[i]).ChainID()), null);
            }
            char[] chains = new char[m.keySet().size()];
            Iterator it = m.keySet().iterator();
            int j = 0;
            while (it.hasNext()) {
                chains[j++] = ((Character)it.next()).charValue();
            }
            for (int i = 0; i < this.maindata.Atoms().size(); ++i) {
                if (!Global.CharArrayContains(chains, this.maindata.Atoms().get(i).ChainID())) continue;
                this.coordinateTable.addRowSelectionInterval(i, i);
            }
            this.coordinateTable.editingCanceled(null);
        }
    }

    private void jMenuItemSelectResidueActionPerformed(ActionEvent evt) {
        if (this.coordinateTable != null && this.coordinateTable.getSelectedRowCount() != 0) {
            int[] rows = this.coordinateTable.getSelectedRows();
            TreeSet<String> list = new TreeSet<String>();
            for (int i = 0; i < rows.length; ++i) {
                list.add(Integer.valueOf(this.maindata.Atoms().get(rows[i]).ResidueNumber()).toString() + ' ' + Character.valueOf(this.maindata.Atoms().get(rows[i]).ChainID()).toString());
            }
            Atom a = null;
            String s = null;
            for (int i = 0; i < this.maindata.Atoms().size(); ++i) {
                a = this.maindata.Atoms().get(i);
                s = Integer.valueOf(a.ResidueNumber()).toString() + ' ' + Character.valueOf(a.ChainID()).toString();
                if (!list.contains(s)) continue;
                this.coordinateTable.addRowSelectionInterval(i, i);
            }
            this.coordinateTable.editingCanceled(null);
        }
    }

    private void jToolButtonEditCoordinateActionPerformed(ActionEvent evt) {
        if (this.coordinateTable != null) {
            this.EditCoordinateData();
        }
    }

    private void jMenuItemSelectSearchActionPerformed(ActionEvent evt) {
        if (this.coordinateTable != null) {
            SearchSelectDialog ssd = new SearchSelectDialog((Frame)this, false, this.coordinateTable);
            ssd.show();
            this.coordinateTable.editingCanceled(null);
        }
    }

    private void jToolButtonSearchSelectActionPerformed(ActionEvent evt) {
        this.jMenuItemSelectSearchActionPerformed(null);
    }

    private void jMenuItemDeleteHAtomsActionPerformed(ActionEvent evt) {
        if (this.coordinateTable != null) {
            this.listenForUndoStart("Delete selected H atoms");
            this.CoordinateTypeSelectedDelete(new AtomSelector(){

                public boolean selectAtom(Atom a) {
                    return a.Element().equals("H");
                }

                public boolean selectAtom(Atom a, Object Value) {
                    return false;
                }
            });
            this.listenForUndoStop();
        }
    }

    private void jMenuItemZeroOccpAtomsActionPerformed(ActionEvent evt) {
        if (this.coordinateTable != null) {
            this.listenForUndoStart("Delete selected zero occupancies");
            this.CoordinateTypeSelectedDelete(new AtomSelector(){

                public boolean selectAtom(Atom a) {
                    return a.Occupancy() == 0.0;
                }

                public boolean selectAtom(Atom a, Object Value) {
                    return false;
                }
            });
            this.listenForUndoStop();
        }
    }

    private void jMenuItemDeleteAllAltConfAtomsActionPerformed(ActionEvent evt) {
        if (this.coordinateTable != null) {
            this.listenForUndoStart("Delete all alternate conformation");
            int count = this.maindata.deleteAlternateConformation();
            this.listenForUndoStop();
            this.coordinateTable.fireTableDataChanged();
            this.StatusLabelChange(count + " coordinates deleted");
        }
    }

    private void jMenuItemDeleteAllHAtomsActionPerformed(ActionEvent evt) {
        if (this.coordinateTable != null) {
            this.listenForUndoStart("Delete all H atoms");
            this.CoordinateTypeDelete(new AtomSelector(){

                public boolean selectAtom(Atom a) {
                    return a.Element().equals("H");
                }

                public boolean selectAtom(Atom a, Object Value) {
                    return false;
                }
            });
            this.listenForUndoStop();
        }
    }

    private void jMenuItemDeleteAllZeroOccpAtomsActionPerformed(ActionEvent evt) {
        if (this.coordinateTable != null) {
            this.listenForUndoStart("Delete all zero occupancies");
            this.CoordinateTypeDelete(new AtomSelector(){

                public boolean selectAtom(Atom a) {
                    return a.Occupancy() == 0.0;
                }

                public boolean selectAtom(Atom a, Object Value) {
                    return false;
                }
            });
            this.listenForUndoStop();
        }
    }

    private void jMenuItemAltConfAtomsActionPerformed(ActionEvent evt) {
        if (this.coordinateTable != null) {
            this.listenForUndoStart("Delete selected alternate conformation");
            this.maindata.deleteAlternateConformation(this.coordinateTable.getSelectedRows());
            this.listenForUndoStop();
            this.coordinateTable.fireTableDataChanged();
        }
    }

    private void jMenuItemDeleteAllAltConfAtomsAncestorAdded(AncestorEvent evt) {
    }

    private void jMenuItemFixElementActionPerformed(ActionEvent evt) {
        if (this.coordinateTable != null) {
            this.listenForUndoStart("Fix element from atom name");
            Integer[] list = this.maindata.fixElementInformation();
            this.listenForUndoStop();
            if (list != null) {
                this.coordinateTable.clearSelection();
                this.coordinateTable.addColumnSelectionInterval(this.coordinateTable.GetColumnIndex(3), this.coordinateTable.GetColumnIndex(3));
                for (int i = 0; i < list.length; ++i) {
                    this.coordinateTable.fireTableRowUpdated(list[i], list[i]);
                    this.coordinateTable.addRowSelectionInterval(list[i], list[i]);
                }
            }
        }
    }

    private void jMenuItemCalculateNumberStatisticsActionPerformed(ActionEvent evt) {
        if (this.coordinateTable != null) {
            CalculateNumberStatisticsDialog d = new CalculateNumberStatisticsDialog((Frame)this, true, this.maindata.calculateStatistics(), this.maindata.calculateStatistics(this.coordinateTable.getSelectedRows()));
            d.show();
        }
    }

    private void jMenuItemSelectAllProteinAtomsActionPerformed(ActionEvent evt) {
        if (this.coordinateTable != null) {
            this.selectCoordinateTableRows(this.maindata.getIndicesOfResidueType("Protein"));
        }
    }

    private void jMenuItemSelectAllDNAAtomsActionPerformed(ActionEvent evt) {
        if (this.coordinateTable != null) {
            this.selectCoordinateTableRows(this.maindata.getIndicesOfResidueType("DNA"));
        }
    }

    private void jMenuItemSelectAllRNAAtomsActionPerformed(ActionEvent evt) {
        if (this.coordinateTable != null) {
            this.selectCoordinateTableRows(this.maindata.getIndicesOfResidueType("RNA"));
        }
    }

    private void jMenuItemSelectAllSolventAtomsActionPerformed(ActionEvent evt) {
        if (this.coordinateTable != null) {
            this.selectCoordinateTableRows(this.maindata.getIndicesOfResidueType("Solvent"));
        }
    }

    private void jMenuItemSelectAllUncategorizedAtomsActionPerformed(ActionEvent evt) {
        if (this.coordinateTable != null) {
            this.selectCoordinateTableRows(this.maindata.getIndicesOfUnclassifiedType());
        }
    }

    private void jMenuItemRotateTranslateAtomsActionPerformed(ActionEvent evt) {
        if (this.coordinateTable != null) {
            RotateTranslateAtomsDialog rtad = new RotateTranslateAtomsDialog((Frame)this, false, this.coordinateTable);
            rtad.show();
        }
    }

    private void jMenuItemEditSpacegroupUnitcellActionPerformed(ActionEvent evt) {
        if (this.coordinateTable != null) {
            EditSpacegroupDialog esd = new EditSpacegroupDialog((Frame)this, true, this.maindata);
            esd.show();
            this.coordinateTable.fireTableDataChanged();
        }
    }

    private void jMenuItemGenerateSymmetryMatesActionPerformed(ActionEvent evt) {
        if (this.coordinateTable != null) {
            if (this.maindata.Spacegroup().symmetryOperators() != null) {
                GenerateSymmetryMateDialog gsmd = new GenerateSymmetryMateDialog((Frame)this, false, this.coordinateTable);
                gsmd.show();
            } else {
                JOptionPane.showMessageDialog(this, "No spacegroup information available\nDo Edit Spacegroup Unit Cell first", "Error", 0);
            }
        }
    }

    private void jToolButtonNewMouseEntered(MouseEvent evt) {
        this.StatusLabelTemporary("Create new coordinate file");
    }

    private void jToolButtonNewMouseExited(MouseEvent evt) {
        this.StatusLabelTemporaryEnd();
    }

    private void jToolButtonOpenMouseEntered(MouseEvent evt) {
        this.StatusLabelTemporary("Open coordinate file");
    }

    private void jToolButtonOpenMouseExited(MouseEvent evt) {
        this.StatusLabelTemporaryEnd();
    }

    private void jToolButtonSaveMouseEntered(MouseEvent evt) {
        this.StatusLabelTemporary("Save coordinate file");
    }

    private void jToolButtonSaveMouseExited(MouseEvent evt) {
        this.StatusLabelTemporaryEnd();
    }

    private void jToolButtonSearchSelectMouseEntered(MouseEvent evt) {
        this.StatusLabelTemporary("Search and select atoms");
    }

    private void jToolButtonSearchSelectMouseExited(MouseEvent evt) {
        this.StatusLabelTemporaryEnd();
    }

    private void jToolButtonEditCoordinateMouseEntered(MouseEvent evt) {
        this.StatusLabelTemporary("Edit selected atoms");
    }

    private void jToolButtonEditCoordinateMouseExited(MouseEvent evt) {
        this.StatusLabelTemporaryEnd();
    }

    private void jToolButtonColumnDisplayedMouseEntered(MouseEvent evt) {
        this.StatusLabelTemporary("Change columns displayed");
    }

    private void jToolButtonColumnDisplayedMouseExited(MouseEvent evt) {
        this.StatusLabelTemporaryEnd();
    }

    private void jMenuItemFindClosestAtomDistancesActionPerformed(ActionEvent evt) {
        if (this.coordinateTable != null) {
            FindClosestAtomDistancesDialog fcad = new FindClosestAtomDistancesDialog((Frame)this, false, this.coordinateTable);
            fcad.show();
        }
    }

    private void jMenuItemExtractSequenceActionPerformed(ActionEvent evt) {
        if (this.coordinateTable != null) {
            ExtractSequenceDialog ESD = new ExtractSequenceDialog((Frame)this, false, this.coordinateTable);
            ESD.show();
        }
    }

    private void jToolButtonCopyMouseEntered(MouseEvent evt) {
        this.StatusLabelTemporary("Copy selected cell entries in line/tab delimited format");
    }

    private void jToolButtonCopyMouseExited(MouseEvent evt) {
        this.StatusLabelTemporaryEnd();
    }

    private void jToolButtonCopyPDBMouseEntered(MouseEvent evt) {
        this.StatusLabelTemporary("Copy selected atoms in PDB text format");
    }

    private void jToolButtonCopyPDBMouseExited(MouseEvent evt) {
        this.StatusLabelTemporaryEnd();
    }

    private void jToolButtonPasteMouseEntered(MouseEvent evt) {
        this.StatusLabelTemporary("Paste data from the clipboard - line/tab delimited or PDB text");
    }

    private void jToolButtonPasteMouseExited(MouseEvent evt) {
        this.StatusLabelTemporaryEnd();
    }

    private void jToolButtonCalculateStatisticsMouseEntered(MouseEvent evt) {
        this.StatusLabelTemporary("Calculate average/standard deviation of numerical data");
    }

    private void jToolButtonCalculateStatisticsMouseExited(MouseEvent evt) {
        this.StatusLabelTemporaryEnd();
    }

    private void jToolButtonExtractSequenceMouseEntered(MouseEvent evt) {
        this.StatusLabelTemporary("Extract and display residue sequence");
    }

    private void jToolButtonExtractSequenceMouseExited(MouseEvent evt) {
        this.StatusLabelTemporaryEnd();
    }

    private void jMenuItemAboutActionPerformed(ActionEvent evt) {
        this.jDialogAbout.show(true);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.jDialogAbout.hide();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.setDefaultCloseOperation(2);
        if (this.dataChangeNotSaved) {
            Object[] options = new Object[]{"Yes", "No", "Cancel"};
            int n = JOptionPane.showOptionDialog(this, "Save changes before closing?", "Changes have not been saved", 1, 3, null, options, options[2]);
            switch (n) {
                case 0: {
                    this.SaveCoordinateFile();
                    break;
                }
                case 2: {
                    this.setDefaultCloseOperation(0);
                }
            }
        }
    }

    private void jEventLoggerButtonCloseActionPerformed(ActionEvent evt) {
        this.maindata.removeDataChangeListener(this.eventLoggerListener);
        this.jDialogEventLogger.hide();
    }

    private void jEventLoggerButtonClearActionPerformed(ActionEvent evt) {
        this.jEventLoggerTextArea.setText("");
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        if (this.coordinateTable != null) {
            this.jDialogEventLogger.show();
            this.maindata.addDataChangeListener(this.eventLoggerListener);
        }
    }

    private void jMenuItemUndoActionPerformed(ActionEvent evt) {
        if (this.coordinateTable != null) {
            this.undoPerform();
            this.coordinateTable.editingCanceled(null);
        }
    }

    private void jMenuItemRedoActionPerformed(ActionEvent evt) {
        if (this.coordinateTable != null) {
            this.redoPerform();
            this.coordinateTable.editingCanceled(null);
        }
    }

    private void jMenuItemDeleteSelectedAnisoBActionPerformed(ActionEvent evt) {
        this.setColumnValueToNull(15, "Delete selected anisotropic temp factor", false);
    }

    private void jMenuItemDeleteSelectedSigmaXYZActionPerformed(ActionEvent evt) {
        this.setColumnValueToNull(21, "Delete selected sigma coordinates", false);
    }

    private void jMenuItemDeleteSelectedSigmaUActionPerformed(ActionEvent evt) {
        this.setColumnValueToNull(26, "Delete selected sigma U", false);
    }

    private void jMenuItemDeleteAllAnisoBActionPerformed(ActionEvent evt) {
        this.setColumnValueToNull(15, "Delete all anisotropic temp factor", true);
    }

    private void jMenuItemDeleteAllSigmaXYZActionPerformed(ActionEvent evt) {
        this.setColumnValueToNull(21, "Delete all sigma coordinates", true);
    }

    private void jMenuItemDeleteAllSigmaUActionPerformed(ActionEvent evt) {
        this.setColumnValueToNull(26, "Delete all sigma U", true);
    }

    private void jMenuItemMoveUpActionPerformed(ActionEvent evt) {
        this.MoveUpSelectedAtoms();
    }

    public void MoveUpSelectedAtoms() {
        if (this.coordinateTable != null) {
            int[] columnselection = this.coordinateTable.getSelectedColumns();
            this.listenForUndoStart("Move atoms up");
            int[] rowselection = this.maindata.MoveUpIndex(this.coordinateTable.getSelectedRows());
            this.listenForUndoStop();
            this.coordinateTable.fireTableDataChanged();
            this.coordinateTable.addRowSelectionIndicies(rowselection);
            this.coordinateTable.addColumnSelectionIndicies(columnselection);
        }
    }

    private void jMenuItemMoveDownActionPerformed(ActionEvent evt) {
        this.MoveDownSelectedAtoms();
    }

    public void MoveDownSelectedAtoms() {
        if (this.coordinateTable != null) {
            int[] columnselection = this.coordinateTable.getSelectedColumns();
            this.listenForUndoStart("Move atoms down");
            int[] rowselection = this.maindata.MoveDownIndex(this.coordinateTable.getSelectedRows());
            this.listenForUndoStop();
            this.coordinateTable.fireTableDataChanged();
            this.coordinateTable.addRowSelectionIndicies(rowselection);
            this.coordinateTable.addColumnSelectionIndicies(columnselection);
        }
    }

    private void jMenuItemMoveTopActionPerformed(ActionEvent evt) {
        this.MoveTopSelectedAtoms();
    }

    public void MoveTopSelectedAtoms() {
        if (this.coordinateTable != null) {
            int[] columnselection = this.coordinateTable.getSelectedColumns();
            this.listenForUndoStart("Move atoms to top");
            int[] rowselection = this.maindata.MoveTopIndex(this.coordinateTable.getSelectedRows());
            this.listenForUndoStop();
            this.coordinateTable.fireTableDataChanged();
            this.coordinateTable.addRowSelectionIndicies(rowselection);
            this.coordinateTable.addColumnSelectionIndicies(columnselection);
        }
    }

    private void jMenuItemMoveBottomActionPerformed(ActionEvent evt) {
        this.MoveBottomSelectedAtoms();
    }

    public void MoveBottomSelectedAtoms() {
        if (this.coordinateTable != null) {
            int[] columnselection = this.coordinateTable.getSelectedColumns();
            this.listenForUndoStart("Move atoms to bottom");
            int[] rowselection = this.maindata.MoveBottomIndex(this.coordinateTable.getSelectedRows());
            this.listenForUndoStop();
            this.coordinateTable.fireTableDataChanged();
            this.coordinateTable.addRowSelectionIndicies(rowselection);
            this.coordinateTable.addColumnSelectionIndicies(columnselection);
        }
    }

    private void jToolButtonCutPDBMouseEntered(MouseEvent evt) {
        this.StatusLabelTemporary("Cut selected atoms in PDB text format");
    }

    private void jToolButtonCutPDBMouseExited(MouseEvent evt) {
        this.StatusLabelTemporaryEnd();
    }

    private void jToolButtonCutPDBjMenuItemCopyPDBActionPerformed(ActionEvent evt) {
        this.jMenuItemCutPDBActionPerformed(null);
    }

    public void CutAsPDBAtom() {
        if (this.coordinateTable != null) {
            this.listenForUndoStart("Cut as PDB");
            this.jMenuItemCopyPDBActionPerformed(null);
            this.maindata.DeleteAtoms(this.coordinateTable.getSelectedRows());
            this.listenForUndoStop();
            this.coordinateTable.fireTableDataChanged();
        }
    }

    private void jMenuItemCutPDBActionPerformed(ActionEvent evt) {
        this.CutAsPDBAtom();
    }

    private void jMenuItemSortAtomsActionPerformed(ActionEvent evt) {
        if (this.coordinateTable != null) {
            SortAtomsDialog SAD = new SortAtomsDialog((Frame)this, false, this.coordinateTable);
            SAD.show();
        }
    }

    private void jMenuItemCorrectAtomOrderingActionPerformed(ActionEvent evt) {
        if (this.coordinateTable != null) {
            this.listenForUndoStart("Correct atom ordering");
            this.maindata.Sort(new int[]{7, 8, 6, 2, 5}, new boolean[]{false, false, false, false, false});
            this.maindata.ResetAtomNumbers();
            this.listenForUndoStop();
            this.coordinateTable.fireTableDataChanged();
        }
    }

    private void jMenuItemEditResNumChainIDActionPerformed(ActionEvent evt) {
        if (this.coordinateTable != null) {
            EditResidueNumberDialog ERND = new EditResidueNumberDialog((Frame)this, false, this.coordinateTable);
            ERND.show();
        }
    }

    private void jMenuItemReduceToCaActionPerformed(ActionEvent evt) {
        if (this.coordinateTable != null) {
            int[] value = this.RunAtomSelectorDialogGetIndicies("Reduce Protein to Ca", 3);
            if (value != null) {
                this.listenForUndoStart("Reduce protein to Ca");
                this.maindata.ReduceProteinResiduesToCa(value);
                this.listenForUndoStop();
                this.coordinateTable.fireTableDataChanged();
                this.StatusLabelChange("Reduced protein to Ca");
            } else {
                this.StatusLabelChange("Cancelled - Reduce protein to Ca");
            }
        }
    }

    private void jMenuItemReduceToPolyALAActionPerformed(ActionEvent evt) {
        if (this.coordinateTable != null) {
            int[] value = this.RunAtomSelectorDialogGetIndicies("Reduce protein to poly Ala", 3);
            if (value != null) {
                this.listenForUndoStart("Reduce protein to poly Ala");
                this.maindata.ReduceProteinResiduesToPolyALA(value);
                this.listenForUndoStop();
                this.coordinateTable.fireTableDataChanged();
                this.StatusLabelChange("Reduced protein to poly Ala");
            } else {
                this.StatusLabelChange("Cancelled - Reduce protein to poly Ala");
            }
        }
    }

    private void jMenuItemInvertSelectionActionPerformed(ActionEvent evt) {
        if (this.coordinateTable != null) {
            this.coordinateTable.invertSelectedRows();
            this.coordinateTable.editingCanceled(null);
        }
    }

    private void jMenuItemCopySpacegroupActionPerformed(ActionEvent evt) {
        if (this.coordinateTable != null && this.maindata.Spacegroup() != null) {
            this.setClipboardContent(this.maindata.Spacegroup().WritePDBSpaceGroupLines());
            this.StatusLabelChange("Copied spacegroup information in PDB format to clipboard");
            this.coordinateTable.editingCanceled(null);
        }
    }

    private void jMenuItemInsertEmptyAtomActionPerformed(ActionEvent evt) {
        if (this.maindata != null) {
            int[] selcols = this.coordinateTable.getSelectedColumns();
            int row = this.coordinateTable.getSelectedRow();
            if (row < 0) {
                row = 0;
            }
            this.maindata.InsertEmptyAtom(row);
            this.coordinateTable.fireTableDataChanged();
            this.coordinateTable.addColumnSelectionIndicies(selcols);
            this.coordinateTable.addRowSelectionInterval(row, row);
            this.coordinateTable.editingCanceled(null);
        }
    }

    private void jToolButtonSaveAsMouseEntered(MouseEvent evt) {
        this.StatusLabelTemporary("Save coordinate file as...");
    }

    private void jToolButtonSaveAsMouseExited(MouseEvent evt) {
        this.StatusLabelTemporaryEnd();
    }

    private void jToolButtonSaveAsActionPerformed(ActionEvent evt) {
        this.jMenuItemSaveAsActionPerformed(evt);
    }

    private void jMenuItemEditAtomConnectivityActionPerformed(ActionEvent evt) {
        if (this.coordinateTable != null) {
            EditConnectivityDialog ECD = new EditConnectivityDialog((Frame)this, false, this.coordinateTable);
            ECD.show();
        }
    }

    private int RunAtomSelectorDialog(String WindowTitle, int DefaultValue) {
        AtomSelectorDialog ASD = new AtomSelectorDialog((Frame)this, true, WindowTitle, DefaultValue);
        ASD.show();
        int value = ASD.Value;
        ASD.dispose();
        return value;
    }

    private int[] RunAtomSelectorDialogGetIndicies(String WindowTitle, int DefaultValue) {
        int value = this.RunAtomSelectorDialog(WindowTitle, DefaultValue);
        int[] selrows = this.coordinateTable.getSelectedRows();
        switch (value) {
            case -1: {
                return null;
            }
            case 3: {
                return Global.GenerateIntegerIndiciesArray(this.maindata.Atoms().size());
            }
            case 0: {
                return selrows;
            }
            case 2: {
                return this.maindata.getChainIndicies(selrows);
            }
            case 1: {
                return this.maindata.getResiduesIndicies(selrows);
            }
        }
        return null;
    }
}

