/*
 * Decompiled with CFR 0.152.
 */
package pdb_editor.dialogs;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import pdb_editor.EditorFrame;
import pdb_editor.coordinate.CoordinateTable;
import pdb_reader.DataSet;
import pdb_reader.data.Atom;
import pdb_reader.data.Connectivity;

public class EditConnectivityDialog
extends JDialog {
    private Stack<Map<Atom, Connectivity>> UndoStack = new Stack();
    private Stack<Map<Atom, Connectivity>> RedoStack = new Stack();
    private EditorFrame Parent = null;
    private CoordinateTable ctable = null;
    private DataSet dataset = null;
    private List<Connectivity> maindata = null;
    private TableModel tablemodel = null;
    private Map<Atom, Connectivity> mainset = null;
    private KeyListener CommonKeyListener = new KeyListener(){

        public void keyTyped(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            int key = e.getKeyCode();
            if (e.isControlDown()) {
                switch (key) {
                    case 73: {
                        EditConnectivityDialog.this.ImportEntry();
                        break;
                    }
                    case 127: {
                        EditConnectivityDialog.this.DeleteEntry();
                        break;
                    }
                    case 90: {
                        EditConnectivityDialog.this.PerformUndo();
                        break;
                    }
                    case 89: {
                        EditConnectivityDialog.this.PerformRedo();
                    }
                }
            } else {
                switch (key) {
                    case 73: {
                        EditConnectivityDialog.this.ImportBonds();
                        break;
                    }
                    case 127: {
                        EditConnectivityDialog.this.DeleteBranch();
                        break;
                    }
                    case 67: {
                        EditConnectivityDialog.this.SetCenter();
                    }
                }
            }
            switch (key) {
                case 27: {
                    EditConnectivityDialog.this.CloseWindow();
                }
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    };
    private JButton jButtonAddBonds;
    private JButton jButtonAddEntry;
    private JButton jButtonClose;
    private JButton jButtonDeleteBonds;
    private JButton jButtonDeleteEntry;
    private JButton jButtonRedo;
    private JButton jButtonSetAsCenter;
    private JButton jButtonUndo;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JTable jTable;
    private JToolBar jToolBar1;

    public EditConnectivityDialog(Frame parent, boolean modal, CoordinateTable cTable) {
        super(parent, modal);
        try {
            this.Parent = (EditorFrame)parent;
        }
        catch (Exception e) {
            // empty catch block
        }
        this.ctable = cTable;
        this.dataset = this.ctable.getMainData();
        this.initData();
        this.tablemodel = new TableModel();
        this.initComponents();
        this.addKeyListener(this.CommonKeyListener);
        this.jTable.addKeyListener(this.CommonKeyListener);
    }

    private void initData() {
        this.dataset.UpdateConnectivityTable();
        this.mainset = this.dataset.ConnectList();
        this.maindata = new ArrayList<Connectivity>(this.mainset.values());
    }

    private void CloseWindow() {
        this.dispose();
    }

    private void SaveUndoData() {
        TreeMap<Atom, Connectivity> r = new TreeMap<Atom, Connectivity>();
        for (Atom a : this.mainset.keySet()) {
            r.put(a, this.mainset.get(a).clone());
        }
        this.UndoStack.push(r);
        this.jButtonUndo.setEnabled(true);
        this.RedoStack.clear();
        this.jButtonRedo.setEnabled(false);
        if (this.Parent != null) {
            this.Parent.dataChangeNotSaved = true;
        }
    }

    private void PerformUndo() {
        if (this.UndoStack.size() > 0) {
            this.RedoStack.push(this.mainset);
            this.jButtonRedo.setEnabled(true);
            this.dataset.ConnectList((TreeMap)this.UndoStack.pop());
            this.UpdateTable();
            if (this.UndoStack.size() == 0) {
                this.jButtonUndo.setEnabled(false);
            }
        }
    }

    private void PerformRedo() {
        if (this.RedoStack.size() > 0) {
            this.UndoStack.push(this.mainset);
            this.jButtonUndo.setEnabled(true);
            this.dataset.ConnectList((TreeMap)this.RedoStack.pop());
            this.UpdateTable();
            if (this.RedoStack.size() == 0) {
                this.jButtonRedo.setEnabled(false);
            }
        }
    }

    private void UpdateTable() {
        this.initData();
        this.tablemodel.fireTableStructureChanged();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable = new JTable();
        this.jButtonClose = new JButton();
        this.jToolBar1 = new JToolBar();
        this.jButtonAddEntry = new JButton();
        this.jButtonAddBonds = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.jButtonSetAsCenter = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jButtonDeleteEntry = new JButton();
        this.jButtonDeleteBonds = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.jButtonUndo = new JButton();
        this.jButtonRedo = new JButton();
        this.jLabel1 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Edit Atom Connectivity");
        this.jTable.setModel(this.tablemodel);
        this.jTable.setCellSelectionEnabled(true);
        this.jScrollPane1.setViewportView(this.jTable);
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditConnectivityDialog.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jToolBar1.setRollover(true);
        this.jToolBar1.setMinimumSize(new Dimension(448, 40));
        this.jButtonAddEntry.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/edit_add24.png")));
        this.jButtonAddEntry.setText("Entry");
        this.jButtonAddEntry.setToolTipText("Import Selected Atoms from Main Window as Entry (Ctrl + I)");
        this.jButtonAddEntry.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jButtonAddEntry.setBorderPainted(false);
        this.jButtonAddEntry.setFocusable(false);
        this.jButtonAddEntry.setPreferredSize(new Dimension(61, 40));
        this.jButtonAddEntry.setVerticalTextPosition(3);
        this.jButtonAddEntry.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditConnectivityDialog.this.jButtonAddEntryActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonAddEntry);
        this.jButtonAddBonds.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/edit_add24.png")));
        this.jButtonAddBonds.setText("Bonds");
        this.jButtonAddBonds.setToolTipText("Import Selected Atoms from Main Window as Bonds to Selected Entry (I)");
        this.jButtonAddBonds.setBorder(BorderFactory.createBevelBorder(0));
        this.jButtonAddBonds.setBorderPainted(false);
        this.jButtonAddBonds.setFocusable(false);
        this.jButtonAddBonds.setVerticalTextPosition(3);
        this.jButtonAddBonds.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditConnectivityDialog.this.jButtonAddBondsActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonAddBonds);
        this.jToolBar1.add(this.jSeparator2);
        this.jButtonSetAsCenter.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/ok24.png")));
        this.jButtonSetAsCenter.setText("Set as Center");
        this.jButtonSetAsCenter.setToolTipText("Set Selected Bond as Center of the Bond (Ctrl + Del)");
        this.jButtonSetAsCenter.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jButtonSetAsCenter.setBorderPainted(false);
        this.jButtonSetAsCenter.setFocusable(false);
        this.jButtonSetAsCenter.setVerticalTextPosition(3);
        this.jButtonSetAsCenter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditConnectivityDialog.this.jButtonSetAsCenterActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonSetAsCenter);
        this.jToolBar1.add(this.jSeparator1);
        this.jButtonDeleteEntry.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/edit_remove24.png")));
        this.jButtonDeleteEntry.setText("Entry");
        this.jButtonDeleteEntry.setToolTipText("Delete Selected Entry Including All Bonds (Ctrl + Del)");
        this.jButtonDeleteEntry.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jButtonDeleteEntry.setBorderPainted(false);
        this.jButtonDeleteEntry.setFocusable(false);
        this.jButtonDeleteEntry.setVerticalTextPosition(3);
        this.jButtonDeleteEntry.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditConnectivityDialog.this.jButtonDeleteEntryActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonDeleteEntry);
        this.jButtonDeleteBonds.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/edit_remove24.png")));
        this.jButtonDeleteBonds.setText("Bonds");
        this.jButtonDeleteBonds.setToolTipText("Delete Selected Bonds (Del)");
        this.jButtonDeleteBonds.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jButtonDeleteBonds.setBorderPainted(false);
        this.jButtonDeleteBonds.setFocusable(false);
        this.jButtonDeleteBonds.setVerticalTextPosition(3);
        this.jButtonDeleteBonds.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditConnectivityDialog.this.jButtonDeleteBondsActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonDeleteBonds);
        this.jToolBar1.add(this.jSeparator3);
        this.jButtonUndo.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/undo24.png")));
        this.jButtonUndo.setText("Undo");
        this.jButtonUndo.setToolTipText("Undo Last Action (Ctrl + Z)");
        this.jButtonUndo.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jButtonUndo.setBorderPainted(false);
        this.jButtonUndo.setEnabled(false);
        this.jButtonUndo.setFocusable(false);
        this.jButtonUndo.setVerticalTextPosition(3);
        this.jButtonUndo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditConnectivityDialog.this.jButtonUndoActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonUndo);
        this.jButtonRedo.setIcon(new ImageIcon(this.getClass().getResource("/pdb_editor/icons/redo24.png")));
        this.jButtonRedo.setText("Redo");
        this.jButtonRedo.setToolTipText("Redo Last Undo (Ctrl + Y)");
        this.jButtonRedo.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jButtonRedo.setBorderPainted(false);
        this.jButtonRedo.setEnabled(false);
        this.jButtonRedo.setFocusable(false);
        this.jButtonRedo.setVerticalTextPosition(3);
        this.jButtonRedo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditConnectivityDialog.this.jButtonRedoActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonRedo);
        this.jLabel1.setText("Atoms are labeled as : ( AtomNumber ) ChainID ResidueNumber - AtomName");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToolBar1, -1, 741, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 721, Short.MAX_VALUE).addComponent(this.jButtonClose)).addContainerGap()).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addContainerGap(364, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jToolBar1, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClose).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void SetCenter() {
        int row = this.jTable.getSelectedRow();
        int col = this.jTable.getSelectedColumn();
        if (col != 0) {
            Connectivity c1 = this.maindata.get(row);
            if (--col < c1.Branch.size()) {
                this.SaveUndoData();
                Atom b1 = c1.Base;
                Set<Atom> s1 = c1.Branch;
                Atom b2 = s1.toArray(new Atom[s1.size()])[col];
                Connectivity c2 = this.mainset.get(b2);
                if (c2 == null) {
                    c2 = new Connectivity(b2, b1);
                    this.mainset.put(b2, c2);
                }
                Set<Atom> s2 = c2.Branch;
                s2.addAll(s1);
                s2.remove(b2);
                for (Atom a : s2) {
                    Connectivity br = this.mainset.get(a);
                    if (br != null) {
                        br.Branch.add(b2);
                        br.Branch.remove(b1);
                    } else {
                        br = new Connectivity(a, b2);
                        this.mainset.put(a, br);
                    }
                    s1.remove(a);
                }
                this.initData();
                this.tablemodel.fireTableStructureChanged();
            }
        }
    }

    private void DeleteBranch() {
        int[] rows = this.jTable.getSelectedRows();
        int[] cols = this.jTable.getSelectedColumns();
        ArrayList<Connectivity> clist = new ArrayList<Connectivity>();
        ArrayList tlist = new ArrayList();
        for (int r : rows) {
            Connectivity conn = this.maindata.get(r);
            Atom[] branchlist = conn.Branch.toArray(new Atom[conn.Branch.size()]);
            ArrayList<Atom> list = new ArrayList<Atom>();
            for (int c : cols) {
                int index;
                if (c == 0 || (index = c - 1) >= branchlist.length) continue;
                list.add(branchlist[index]);
            }
            if (list.size() <= 0) continue;
            clist.add(conn);
            tlist.add(list);
        }
        if (clist.size() > 0) {
            this.SaveUndoData();
        }
        for (int i = 0; i < clist.size(); ++i) {
            Connectivity c = (Connectivity)clist.get(i);
            ArrayList targets = (ArrayList)tlist.get(i);
            Atom base = c.Base;
            Set<Atom> s = c.Branch;
            for (Atom target : targets) {
                Connectivity c2 = this.mainset.get(target);
                s.remove(target);
                if (s.size() == 0) {
                    this.mainset.remove(base);
                }
                if (c2 == null) continue;
                c2.Branch.remove(base);
                if (c2.Branch.size() != 0) continue;
                this.mainset.remove(target);
            }
        }
        this.initData();
        this.tablemodel.fireTableStructureChanged();
    }

    private void DeleteEntry() {
        int[] rows = this.jTable.getSelectedRows();
        Atom[] bases = new Atom[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            bases[i] = this.maindata.get((int)rows[i]).Base;
        }
        if (bases.length > 0) {
            this.SaveUndoData();
        }
        for (Atom base : bases) {
            if (!this.mainset.containsKey(base)) continue;
            Set<Atom> set = this.mainset.get((Object)base).Branch;
            for (Atom br : set) {
                if (!this.mainset.containsKey(br)) continue;
                Set<Atom> branches = this.mainset.get((Object)br).Branch;
                branches.remove(base);
                if (branches.size() != 0) continue;
                this.mainset.remove(br);
            }
            this.mainset.remove(base);
        }
        this.initData();
        this.tablemodel.fireTableStructureChanged();
    }

    private void ImportBonds() {
        int[] selrows = this.ctable.getSelectedRows();
        if (selrows != null && selrows.length > 0) {
            Atom[] selatoms = this.dataset.getAtoms(selrows);
            int[] selconnrows = this.jTable.getSelectedRows();
            Connectivity[] conns = new Connectivity[selconnrows.length];
            for (int i = 0; i < conns.length; ++i) {
                conns[i] = this.maindata.get(selconnrows[i]);
            }
            if (conns.length > 0) {
                this.SaveUndoData();
            }
            for (Connectivity c : conns) {
                Atom base = c.Base;
                for (Atom a : selatoms) {
                    c.Branch.add(a);
                    if (!this.mainset.containsKey(a)) {
                        this.mainset.put(a, new Connectivity(a, base));
                        continue;
                    }
                    this.mainset.get((Object)a).Branch.add(base);
                }
            }
            this.initData();
            this.tablemodel.fireTableStructureChanged();
        }
    }

    private void jButtonAddEntryActionPerformed(ActionEvent evt) {
        this.ImportEntry();
    }

    private void jButtonAddBondsActionPerformed(ActionEvent evt) {
        this.ImportBonds();
    }

    private void jButtonSetAsCenterActionPerformed(ActionEvent evt) {
        this.SetCenter();
    }

    private void jButtonDeleteEntryActionPerformed(ActionEvent evt) {
        this.DeleteEntry();
    }

    private void jButtonDeleteBondsActionPerformed(ActionEvent evt) {
        this.DeleteBranch();
    }

    private void jButtonUndoActionPerformed(ActionEvent evt) {
        this.PerformUndo();
    }

    private void jButtonRedoActionPerformed(ActionEvent evt) {
        this.PerformRedo();
    }

    private void ImportEntry() {
        int[] selrows = this.ctable.getSelectedRows();
        if (selrows != null && selrows.length > 1) {
            Atom[] selatoms = this.dataset.getAtoms(selrows);
            this.SaveUndoData();
            this.mainset.put(selatoms[0], new Connectivity(selatoms));
            boolean first = true;
            for (Atom a : selatoms) {
                if (!first) {
                    if (this.mainset.containsKey(a)) {
                        this.mainset.get((Object)a).Branch.add(selatoms[0]);
                    } else {
                        this.mainset.put(a, new Connectivity(a, selatoms[0]));
                    }
                }
                first = false;
            }
            this.initData();
            this.tablemodel.fireTableStructureChanged();
        }
    }

    private class TableModel
    extends AbstractTableModel {
        private TableModel() {
        }

        public int getRowCount() {
            return EditConnectivityDialog.this.maindata.size();
        }

        public int getColumnCount() {
            int max = 5;
            for (Connectivity c : EditConnectivityDialog.this.mainset.values()) {
                if (c.Branch.size() + 1 <= max) continue;
                max = c.Branch.size() + 1;
            }
            return max;
        }

        public Object getValueAt(int row, int col) {
            Connectivity c = (Connectivity)EditConnectivityDialog.this.maindata.get(row);
            if (col == 0) {
                return this.GenerateAtomLabel(c.Base);
            }
            Atom[] list = c.Branch.toArray(new Atom[c.Branch.size()]);
            if (--col < list.length) {
                return this.GenerateAtomLabel(list[col]);
            }
            return null;
        }

        public String getColumnName(int col) {
            if (col == 0) {
                return "Center";
            }
            return "Bond " + col;
        }

        private String GenerateAtomLabel(Atom a) {
            StringBuilder sb = new StringBuilder();
            sb.append('(');
            sb.append(a.AtomNumber());
            sb.append(")  ");
            if (a.ChainID() != ' ') {
                sb.append(a.ChainID());
            }
            sb.append(a.ResidueNumber());
            sb.append(" - ");
            sb.append(a.AtomType());
            return sb.toString();
        }
    }
}

