/*
 * Decompiled with CFR 0.152.
 */
package pdb_reader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.event.EventListenerList;
import pdb_editor.coordinate.CoordinateTable;
import pdb_reader.DataSetDataChangeEvent;
import pdb_reader.DataSetDataChangeEventListener;
import pdb_reader.Global;
import pdb_reader.data.Atom;
import pdb_reader.data.AtomDataChangeEvent;
import pdb_reader.data.AtomDataChangeEventListener;
import pdb_reader.data.AtomPDB;
import pdb_reader.data.AtomSelector;
import pdb_reader.data.Connectivity;
import pdb_reader.data.spacegroup.SpaceGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSet {
    public static TreeMap<String, String> ResidueTypeDatabase = new TreeMap();
    public static TreeMap<String, TreeMap<String, String>> ResidueAtomElementDatabase = new TreeMap();
    public static TreeMap<String, Character> ResidueSingleLetterCodeDatabase = new TreeMap();
    private AtomDataChangeEventListener ADCEL = new AtomDataChangeEventListener(){

        public void dataChanged(AtomDataChangeEvent e) {
            DataSet.this.fireDataChangeEvent(e);
        }
    };
    private CoordinateTable tablelinked = null;
    private String fileName = null;
    private String[] originalData = null;
    private ArrayListWithEvent<Atom> atoms = null;
    private SpaceGroup spacegroup = null;
    private EventListenerList dataChangeListener = new EventListenerList();
    private TreeMap<Atom, Connectivity> connectivity = null;

    public DataSet() {
        this.fileName = null;
        this.atoms = new ArrayListWithEvent();
    }

    public DataSet(String Filename) {
        this.ReadPDBFile(Filename);
    }

    public CoordinateTable TableLinked() {
        return this.tablelinked;
    }

    public void TableLinked(CoordinateTable t) {
        this.tablelinked = t;
    }

    public String FileName() {
        return this.fileName;
    }

    public ArrayList<Atom> Atoms() {
        return this.atoms;
    }

    public SpaceGroup Spacegroup() {
        return this.spacegroup;
    }

    public TreeMap<Atom, Connectivity> ConnectList() {
        return this.connectivity;
    }

    public String FileName(String Value) {
        this.fileName = Value;
        return this.fileName;
    }

    public SpaceGroup Spacegroup(SpaceGroup Value) {
        for (int i = 0; i < this.atoms.size(); ++i) {
            ((Atom)this.atoms.get(i)).Spacegroup(Value);
        }
        this.spacegroup = Value;
        return this.spacegroup;
    }

    public void Atoms(ArrayList<Atom> Value) {
        this.atoms = (ArrayListWithEvent)Value;
    }

    public TreeMap<Atom, Connectivity> ConnectList(TreeMap<Atom, Connectivity> Value) {
        this.connectivity = Value;
        return this.connectivity;
    }

    public void UpdateConnectivityTable() {
        TreeSet<Connectivity> removelist = new TreeSet<Connectivity>();
        for (Connectivity c : this.connectivity.values()) {
            if (!this.atoms.contains(c.Base)) {
                removelist.add(c);
                continue;
            }
            Set<Atom> list = c.Branch;
            for (Atom a : list) {
                if (this.atoms.contains(a)) continue;
                list.remove(a);
            }
        }
        for (Connectivity c : removelist) {
            this.connectivity.remove(c.Base);
        }
    }

    public void InsertEmptyAtom(int row) {
        Atom a = new Atom(this.spacegroup);
        this.atoms.add(row, a);
    }

    public void ReduceProteinResiduesToCa() {
        for (int i = this.atoms.size() - 1; i >= 0; --i) {
            Atom a = (Atom)this.atoms.get(i);
            if (!ResidueTypeDatabase.containsKey(a.ResidueType()) || !ResidueTypeDatabase.get(a.ResidueType()).equals("Protein") || a.AtomType().equals("CA")) continue;
            this.atoms.remove(i);
        }
    }

    public void ReduceProteinResiduesToCa(int[] selectedIndicies) {
        for (int i = selectedIndicies.length - 1; i >= 0; --i) {
            Atom a = (Atom)this.atoms.get(selectedIndicies[i]);
            if (!ResidueTypeDatabase.containsKey(a.ResidueType()) || !ResidueTypeDatabase.get(a.ResidueType()).equals("Protein") || a.AtomType().equals("CA")) continue;
            this.atoms.remove(i);
        }
    }

    public void ReduceProteinResiduesToPolyALA() {
        int i;
        String[] Keep = new String[]{"N", "C", "O", "CA", "HA", "H", "H1", "H2", "H3", "CB", "HB", "HB1", "HB2", "HB3"};
        String[] AllowedRes = new String[]{"ALA", "GLY"};
        TreeSet<String> KeepAtoms = new TreeSet<String>();
        for (i = 0; i < Keep.length; ++i) {
            KeepAtoms.add(Keep[i]);
        }
        for (i = this.atoms.size() - 1; i >= 0; --i) {
            Atom a = (Atom)this.atoms.get(i);
            if (!ResidueTypeDatabase.containsKey(a.ResidueType()) || !ResidueTypeDatabase.get(a.ResidueType()).equals("Protein")) continue;
            if (!KeepAtoms.contains(a.AtomType())) {
                this.atoms.remove(i);
                continue;
            }
            if (Global.StringArrayContains(AllowedRes, a.ResidueType())) continue;
            a.ResidueType("ALA");
        }
    }

    public void ReduceProteinResiduesToPolyALA(int[] selectedIndicies) {
        int i;
        String[] Keep = new String[]{"N", "C", "O", "CA", "HA", "H", "H1", "H2", "H3", "CB", "HB", "HB1", "HB2", "HB3"};
        String[] AllowedRes = new String[]{"ALA", "GLY"};
        TreeSet<String> KeepAtoms = new TreeSet<String>();
        for (i = 0; i < Keep.length; ++i) {
            KeepAtoms.add(Keep[i]);
        }
        for (i = selectedIndicies.length - 1; i >= 0; --i) {
            Atom a = (Atom)this.atoms.get(selectedIndicies[i]);
            if (!ResidueTypeDatabase.containsKey(a.ResidueType()) || !ResidueTypeDatabase.get(a.ResidueType()).equals("Protein")) continue;
            if (!KeepAtoms.contains(a.AtomType())) {
                this.atoms.remove(i);
                continue;
            }
            if (Global.StringArrayContains(AllowedRes, a.ResidueType())) continue;
            a.ResidueType("ALA");
        }
    }

    public void Sort(final int[] dataIndicies, final boolean[] descending) {
        this.fireDataChangeEvent(new DataSetDataChangeEvent((Object)this, 3));
        Collections.sort(this.atoms, new Comparator<Atom>(){

            @Override
            public int compare(Atom o1, Atom o2) {
                for (int i = 0; i < dataIndicies.length; ++i) {
                    int compvalue;
                    if (dataIndicies[i] >= 35 || (compvalue = Atom.compareAscending(o1, o2, dataIndicies[i])) == 0) continue;
                    if (descending[i]) {
                        compvalue *= -1;
                    }
                    return compvalue;
                }
                return 0;
            }
        });
    }

    public void Sort(final int dataIndex, final boolean descending) {
        this.fireDataChangeEvent(new DataSetDataChangeEvent((Object)this, 3));
        Collections.sort(this.atoms, new Comparator<Atom>(){

            @Override
            public int compare(Atom o1, Atom o2) {
                if (descending) {
                    return Atom.compareAscending(o1, o2, dataIndex) * -1;
                }
                return Atom.compareAscending(o1, o2, dataIndex);
            }
        });
    }

    public int[] MoveTopIndex(int[] selectedIndicies) {
        for (int i = 0; i < selectedIndicies.length; ++i) {
            int index = selectedIndicies[i];
            if (index <= i) continue;
            Atom a = this.atoms.remove(index);
            this.atoms.add(i, a);
            selectedIndicies[i] = i;
        }
        return selectedIndicies;
    }

    public int[] MoveBottomIndex(int[] selectedIndicies) {
        int max = this.atoms.size() - 1;
        for (int i = selectedIndicies.length - 1; i >= 0; --i) {
            int index = selectedIndicies[i];
            if (index < max) {
                Atom a = this.atoms.remove(index);
                this.atoms.add(max, a);
                selectedIndicies[i] = max;
            }
            --max;
        }
        return selectedIndicies;
    }

    public int[] MoveUpIndex(int[] selectedIndicies) {
        for (int i = 0; i < selectedIndicies.length; ++i) {
            int index = selectedIndicies[i];
            if (index <= i) continue;
            Atom a = this.atoms.remove(index);
            this.atoms.add(--index, a);
            selectedIndicies[i] = index;
        }
        return selectedIndicies;
    }

    public int[] MoveDownIndex(int[] selectedIndicies) {
        int max = this.atoms.size() - 1;
        for (int i = selectedIndicies.length - 1; i >= 0; --i) {
            int index = selectedIndicies[i];
            if (index >= max--) continue;
            Atom a = this.atoms.remove(index);
            this.atoms.add(++index, a);
            selectedIndicies[i] = index;
        }
        return selectedIndicies;
    }

    public Atom[] CopyAtoms(boolean AddToDatabase, int[] rows) {
        Atom[] selected = this.getAtoms(rows);
        Atom[] r = new Atom[rows.length];
        int atomnumber = ((Atom)this.atoms.get(this.atoms.size() - 1)).AtomNumber();
        for (int i = 0; i < r.length; ++i) {
            r[i] = selected[i].clone();
            r[i].AtomNumber(++atomnumber);
            if (!AddToDatabase) continue;
            this.atoms.add(r[i]);
        }
        return r;
    }

    public Atom[] CopyAtoms(boolean AddToDatabase, int[] rows, int[] NewValueIndicies, Object[] NewValues) {
        Atom[] selected = this.getAtoms(rows);
        Atom[] r = new Atom[rows.length];
        int atomnumber = ((Atom)this.atoms.get(this.atoms.size() - 1)).AtomNumber();
        for (int i = 0; i < r.length; ++i) {
            r[i] = selected[i].clone();
            r[i].AtomNumber(++atomnumber);
            for (int j = 0; j < NewValueIndicies.length; ++j) {
                r[i].TableData(NewValueIndicies[j], NewValues[j]);
            }
            if (!AddToDatabase) continue;
            this.atoms.add(r[i]);
        }
        return r;
    }

    public void UpdateScaleMatrixChange() {
        for (int i = 0; i < this.atoms.size(); ++i) {
            ((Atom)this.atoms.get(i)).OrthogonalCoordinate(((Atom)this.atoms.get(i)).OrthogonalCoordinate());
        }
    }

    public void TransformAtoms(int[] indicies, double[][] matrix4x4, char newchainid) {
        Atom[] selected = this.getAtoms(indicies);
        Atom[] copied = new Atom[selected.length];
        int atomnumber = ((Atom)this.atoms.get(this.atoms.size() - 1)).AtomNumber();
        for (int i = 0; i < copied.length; ++i) {
            copied[i] = selected[i].clone();
            copied[i].ChainID(newchainid);
            copied[i].AtomNumber(++atomnumber);
            this.atoms.add(copied[i]);
        }
        this.TransformAtoms(copied, matrix4x4);
    }

    public void TransformAtoms(int[] indicies, double[][] matrix4x4) {
        this.TransformAtoms(this.getAtoms(indicies), matrix4x4);
    }

    public void TransformAtoms(Atom[] atoms, double[][] matrix4x4) {
        for (int i = 0; i < atoms.length; ++i) {
            atoms[i].OrthogonalCoordinate(Global.TransformCoordinates(matrix4x4, atoms[i].OrthogonalCoordinate()));
        }
    }

    public TreeMap<String, double[]> calculateStatistics() {
        return this.calculateStatistics(this.atoms.toArray((Atom[])new Atom[this.atoms.size()]));
    }

    public TreeMap<String, double[]> calculateStatistics(int[] rows) {
        Atom[] selected = new Atom[rows.length];
        for (int i = 0; i < selected.length; ++i) {
            selected[i] = (Atom)this.atoms.get(rows[i]);
        }
        return this.calculateStatistics(selected);
    }

    public TreeMap<String, double[]> calculateStatistics(Atom[] list) {
        TreeMap<String, double[]> r = new TreeMap<String, double[]>();
        for (int col = 0; col < 35; ++col) {
            if (!(Atom.DataClass[col].equals(Global.integerclass.getClass()) | Atom.DataClass[col].equals(Global.doubleclass.getClass()))) continue;
            ArrayList<Double> values = new ArrayList<Double>();
            for (int i = 0; i < list.length; ++i) {
                if (list[i].TableData(col) == null) continue;
                if (list[i].TableData(col).getClass().equals(Global.doubleclass.getClass())) {
                    values.add((Double)list[i].TableData(col));
                }
                if (!list[i].TableData(col).getClass().equals(Global.integerclass.getClass())) continue;
                values.add(Double.valueOf(((Integer)list[i].TableData(col)).intValue()));
            }
            if (values.size() <= 0) continue;
            double[] calcstat = Global.calculateAvgSDMaxMin(values.toArray(new Double[values.size()]));
            int maxindex = (int)calcstat[Global.calculateAvgSDMaxMin_MaxRowIndex];
            calcstat[Global.calculateAvgSDMaxMin_MaxRowIndex] = list[maxindex].AtomNumber();
            int minindex = (int)calcstat[Global.calculateAvgSDMaxMin_MinRowIndex];
            calcstat[Global.calculateAvgSDMaxMin_MinRowIndex] = list[minindex].AtomNumber();
            r.put(Atom.DataToolTip[col], calcstat);
        }
        return r;
    }

    public Integer[] getIndicesOfResidueType(String Type2) {
        return this.getIndicesOfResidueType(Type2, 0, this.atoms.size() - 1);
    }

    public Integer[] getIndicesOfResidueType(String Type2, int startindex, int endindex) {
        ArrayList<Integer> r = new ArrayList<Integer>();
        for (int i = startindex; i <= endindex; ++i) {
            String residue = ((Atom)this.atoms.get(i)).ResidueType();
            if (!ResidueTypeDatabase.containsKey(residue) || !ResidueTypeDatabase.get(residue).equals(Type2)) continue;
            r.add(i);
        }
        return r.toArray(new Integer[r.size()]);
    }

    public Integer[] getIndicesOfUnclassifiedType() {
        return this.getIndicesOfUnclassifiedType(0, this.atoms.size() - 1);
    }

    public Integer[] getIndicesOfUnclassifiedType(int startindex, int endindex) {
        ArrayList<Integer> r = new ArrayList<Integer>();
        for (int i = startindex; i <= endindex; ++i) {
            String residue = ((Atom)this.atoms.get(i)).ResidueType();
            if (ResidueTypeDatabase.containsKey(residue)) continue;
            r.add(i);
        }
        return r.toArray(new Integer[r.size()]);
    }

    public Integer[] fixElementInformation() {
        ArrayList<Integer> changedindicies = new ArrayList<Integer>();
        for (int i = 0; i < this.atoms.size(); ++i) {
            String type;
            Atom a = (Atom)this.atoms.get(i);
            String r = a.ResidueType();
            String t = a.AtomType();
            String e = a.Element();
            if (ResidueAtomElementDatabase.containsKey(r) && ResidueAtomElementDatabase.get(r).containsKey(t)) {
                boolean fix = false;
                if (e != null) {
                    if (!e.equals(ResidueAtomElementDatabase.get(r).get(t))) {
                        fix = true;
                    }
                } else {
                    fix = true;
                }
                if (!fix) continue;
                a.Element(ResidueAtomElementDatabase.get(r).get(t));
                changedindicies.add(i);
                continue;
            }
            if (!ResidueTypeDatabase.containsKey(r) || !(type = ResidueTypeDatabase.get(r)).equals("Protein") && !type.equals("DNA") && !type.equals("RNA")) continue;
            if (Character.isLetter(t.charAt(0))) {
                a.Element("" + t.charAt(0));
            } else {
                a.Element("" + t.charAt(1));
            }
            changedindicies.add(i);
        }
        if (changedindicies.size() > 0) {
            return changedindicies.toArray(new Integer[changedindicies.size()]);
        }
        return null;
    }

    public int deleteAlternateConformation() {
        int count = 0;
        for (int j = this.atoms.size() - 1; j >= 0; --j) {
            Atom b = (Atom)this.atoms.get(j);
            if (b.AlternateLocation() == 'A') {
                b.AlternateLocation(' ');
                b.Occupancy(1.0);
            }
            if (!(b.AlternateLocation() != ' ' & b.AlternateLocation() != 'A')) continue;
            this.atoms.remove(j);
            ++count;
        }
        return count;
    }

    public int deleteAlternateConformation(int[] indicies) {
        int i;
        int count = 0;
        Atom[] selected = new Atom[indicies.length];
        for (i = 0; i < indicies.length; ++i) {
            selected[i] = (Atom)this.atoms.get(indicies[i]);
        }
        for (i = 0; i < selected.length; ++i) {
            Atom b = selected[i];
            if (b.AlternateLocation() == 'A') {
                b.AlternateLocation(' ');
                b.Occupancy(1.0);
            }
            if (!(b.AlternateLocation() != ' ' & b.AlternateLocation() != 'A')) continue;
            this.atoms.remove(b);
            ++count;
        }
        return count;
    }

    public Atom[] getAtoms(int[] indicies) {
        Atom[] r = new Atom[indicies.length];
        for (int i = 0; i < indicies.length; ++i) {
            r[i] = (Atom)this.atoms.get(indicies[i]);
        }
        return r;
    }

    public int[] getChainIndicies(int[] indicies) {
        HashSet<Character> list = new HashSet<Character>();
        for (int i = 0; i < indicies.length; ++i) {
            list.add(Character.valueOf(((Atom)this.atoms.get(indicies[i])).ChainID()));
        }
        ArrayList<Integer> r = new ArrayList<Integer>();
        for (int i = 0; i < this.atoms.size(); ++i) {
            if (!list.contains(Character.valueOf(((Atom)this.atoms.get(i)).ChainID()))) continue;
            r.add(i);
        }
        int[] result = new int[r.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Integer)r.get(i);
        }
        return result;
    }

    public int[] getResiduesIndicies(int[] indicies) {
        TreeSet<Integer> found = new TreeSet<Integer>();
        for (int i = 0; i < indicies.length; ++i) {
            Integer[] residue = this.getResidueIndicies((Atom)this.atoms.get(indicies[i]));
            for (int j = 0; j < residue.length; ++j) {
                found.add(residue[j]);
            }
        }
        return Global.ConvertIntegerArrayToIntArray(found.toArray(new Integer[found.size()]));
    }

    public Atom[] getResidue(int index) {
        return this.getResidue((Atom)this.atoms.get(index));
    }

    public Atom[] getResidue(Atom a) {
        ArrayList<Atom> found = new ArrayList<Atom>();
        for (int i = 0; i < this.atoms.size(); ++i) {
            Atom b = (Atom)this.atoms.get(i);
            if (!this.CheckSameResidue(a, b)) continue;
            found.add(b);
        }
        return found.toArray(new Atom[found.size()]);
    }

    public Integer[] getResidueIndicies(Atom a) {
        ArrayList<Integer> found = new ArrayList<Integer>();
        for (int i = 0; i < this.atoms.size(); ++i) {
            Atom b = (Atom)this.atoms.get(i);
            if (!this.CheckSameResidue(a, b)) continue;
            found.add(i);
        }
        return found.toArray(new Integer[found.size()]);
    }

    public int deleteSelectorAtoms(AtomSelector selector) {
        return this.deleteSelectorAtoms(selector, 0, this.atoms.size() - 1);
    }

    public int deleteSelectorAtoms(AtomSelector selector, int startindex, int endindex) {
        int[] indicies = new int[endindex - startindex + 1];
        int j = 0;
        int i = startindex;
        while (i <= endindex) {
            indicies[j++] = i++;
        }
        return this.deleteSelectorAtoms(selector, indicies);
    }

    public int deleteSelectorAtoms(AtomSelector selector, int[] indicies) {
        int count = 0;
        for (int i = indicies.length - 1; i >= 0; --i) {
            if (!selector.selectAtom((Atom)this.atoms.get(indicies[i]))) continue;
            ++count;
            this.atoms.remove(indicies[i]);
        }
        return count;
    }

    public String getReadingError() {
        StringBuilder sb = new StringBuilder();
        String coordinateErrors = this.GenerateAtomReadingErrorMessage();
        if (!coordinateErrors.equals("")) {
            sb.append("Could not process following coordinate records :\n");
            sb.append(coordinateErrors);
        }
        return sb.toString();
    }

    public int findIndex(int AtomNumber) {
        for (int i = 0; i < this.atoms.size(); ++i) {
            if (((Atom)this.atoms.get(i)).AtomNumber() != AtomNumber) continue;
            return i;
        }
        return -1;
    }

    public String SaveFile(String FileName) {
        this.fileName = FileName;
        return this.SaveFile();
    }

    public String SaveFile() {
        try {
            Global.SaveTextFile(this.fileName, this.GetFullPDBText());
            return null;
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public void ReadPDBFile(String Filename) {
        this.fileName = Filename;
        this.ReadPDBFile();
    }

    public void DeleteAtoms(int[] records) {
        for (int i = records.length - 1; i >= 0; --i) {
            this.atoms.remove(records[i]);
        }
    }

    public void ResetAtomNumbers() {
        int i = 1;
        Iterator e = this.atoms.iterator();
        while (e.hasNext()) {
            ((Atom)e.next()).AtomNumber(i++);
        }
    }

    public int AppendPDBInformation(String s, int insertindex) {
        ArrayListWithEvent<Atom> l = this.ExtractAtomInformation(s);
        if (l != null && l.size() > 0) {
            int j = 0;
            Iterator i = l.iterator();
            while (i.hasNext()) {
                this.atoms.add(insertindex + j++, (Atom)i.next());
            }
            this.UpdateAssociatedTable();
            return l.size();
        }
        return 0;
    }

    private boolean CheckSameResidue(Atom a, Atom b) {
        Object[] criteria = new Object[]{Character.valueOf(a.ChainID()), a.ResidueNumber(), a.ResidueType()};
        Object[] search = new Object[]{Character.valueOf(b.ChainID()), b.ResidueNumber(), b.ResidueType()};
        for (int j = 0; j < criteria.length; ++j) {
            if (criteria[j].equals(search[j])) continue;
            return false;
        }
        return true;
    }

    private void UpdateAssociatedTable() {
        if (this.tablelinked != null) {
            this.tablelinked.fireTableDataChanged();
        }
    }

    private String GetFullPDBText() {
        StringBuilder sb = new StringBuilder();
        boolean DidCoordinates = false;
        boolean DidSpaceGroup = false;
        boolean DidConnectivity = false;
        if (this.originalData != null) {
            for (int i = 0; i < this.originalData.length; ++i) {
                if (this.originalData[i] != null && this.originalData[i].length() > 6) {
                    if (this.CheckPDBSpaceGroupLine(this.originalData[i])) {
                        if (DidSpaceGroup) continue;
                        sb.append(this.spacegroup.WritePDBSpaceGroupLines());
                        DidSpaceGroup = true;
                        continue;
                    }
                    if (this.CheckPDBAtomLine(this.originalData[i]) || this.CheckPDBAtomAppendingLine(this.originalData[i]) || this.CheckPDBAtomIgnoreLine(this.originalData[i])) {
                        if (DidCoordinates) continue;
                        if (!DidSpaceGroup) {
                            sb.append(this.spacegroup.WritePDBSpaceGroupLines());
                            DidSpaceGroup = true;
                        }
                        sb.append(this.GetPDBCoordinates());
                        DidCoordinates = true;
                        continue;
                    }
                    if (this.CheckPDBConnectivityLine(this.originalData[i])) {
                        if (DidConnectivity) continue;
                        if (!DidSpaceGroup) {
                            sb.append(this.spacegroup.WritePDBSpaceGroupLines());
                            DidSpaceGroup = true;
                        }
                        if (!DidCoordinates) {
                            sb.append(this.GetPDBCoordinates());
                            DidCoordinates = true;
                        }
                        sb.append(this.WritePDBConnectivityLines());
                        DidConnectivity = true;
                        continue;
                    }
                }
                if (this.CheckPDBSkipLine(this.originalData[i])) continue;
                sb.append(this.originalData[i] + '\n');
            }
        }
        if (!DidSpaceGroup) {
            sb.append(this.spacegroup.WritePDBSpaceGroupLines());
        }
        if (!DidCoordinates) {
            sb.append(this.GetPDBCoordinates());
        }
        if (!DidConnectivity) {
            sb.append(this.WritePDBConnectivityLines());
        }
        sb.append("END");
        return sb.toString();
    }

    private boolean CheckPDBSkipLine(String line) {
        String[] list = new String[]{"MASTER", "END"};
        if (line != null) {
            for (String s : list) {
                if (line.length() <= s.length() || !line.substring(0, s.length()).equals(s)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean CheckPDBConnectivityLine(String line) {
        return line.substring(0, Connectivity.PDBHeader.length()).equals(Connectivity.PDBHeader);
    }

    private String WritePDBConnectivityLines() {
        StringBuilder sb = new StringBuilder();
        this.UpdateConnectivityTable();
        for (Connectivity c : this.connectivity.values()) {
            sb.append(c.WritePDBLine());
            sb.append('\n');
        }
        return sb.toString();
    }

    private String GetPDBCoordinates() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.atoms.size(); ++i) {
            AtomPDB a = ((Atom)this.atoms.get(i)).GetPDBAtomOfThis();
            sb.append(a.WritePDBLine());
            if (i + 1 < this.atoms.size() && ((Atom)this.atoms.get(i + 1)).ChainID() == a.ChainID()) continue;
            sb.append(a.WritePDBTerLine());
        }
        return sb.toString();
    }

    private void ReadPDBFile() {
        String[] lines = Global.ReadTextFile(this.fileName);
        this.originalData = lines;
        this.spacegroup = this.ExtractSpaceGroupInformation(lines);
        this.atoms = this.ExtractAtomInformation(lines);
        this.connectivity = this.ExtractConnectivity(lines);
    }

    private TreeMap<Atom, Connectivity> ExtractConnectivity(String[] lines) {
        TreeMap<Atom, Connectivity> r = new TreeMap<Atom, Connectivity>();
        HashSet base = new HashSet();
        for (String s : lines) {
            if (s == null || s.length() <= 6 || !s.substring(0, 6).equals(Connectivity.PDBHeader)) continue;
            Connectivity c = new Connectivity(s, this.atoms);
            if (!r.containsKey(c.Base)) {
                r.put(c.Base, c);
                continue;
            }
            r.get((Object)c.Base).Branch.addAll(c.Branch);
        }
        return r;
    }

    private SpaceGroup ExtractSpaceGroupInformation(String[] lines) {
        SpaceGroup result = new SpaceGroup();
        result.ReadFromPDBLines(lines);
        return result;
    }

    private ArrayListWithEvent<Atom> ExtractAtomInformation(String text) {
        String[] lines = text.split("\\n");
        return this.ExtractAtomInformation(lines);
    }

    private ArrayListWithEvent<Atom> ExtractAtomInformation(String[] lines) {
        ArrayListWithEvent<Atom> result = new ArrayListWithEvent<Atom>();
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i].length() < 6 || !this.CheckPDBAtomLine(lines[i])) continue;
            AtomPDB a = new AtomPDB(lines[i], this.spacegroup);
            while (i + 1 < lines.length && lines[i + 1].length() >= 6 && this.CheckPDBAtomAppendingLine(lines[i + 1])) {
                a.AppendPDBInformation(lines[++i]);
            }
            result.add(a);
        }
        return result;
    }

    private boolean CheckPDBSpaceGroupLine(String line) {
        return Global.StringArrayContains(SpaceGroup.Headers, line.substring(0, 5));
    }

    private boolean CheckPDBAtomLine(String line) {
        return Global.StringArrayContains(AtomPDB.Headers, line.substring(0, 6));
    }

    private boolean CheckPDBAtomAppendingLine(String line) {
        return Global.StringArrayContains(AtomPDB.ContinueHeaders, line.substring(0, 6));
    }

    private boolean CheckPDBAtomIgnoreLine(String line) {
        return Global.StringArrayContains(AtomPDB.IgnoreHeaders, line.substring(0, 6));
    }

    private String GenerateAtomReadingErrorMessage() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.atoms.size(); ++i) {
            Atom a = (Atom)this.atoms.get(i);
            boolean[] errors = a.getReadingErrorRecords();
            if (!errors[35]) continue;
            sb.append(a.AtomNumber());
            sb.append(" : ");
            for (int j = 0; j < errors.length - 1; ++j) {
                if (!errors[j]) continue;
                sb.append(Atom.DataToolTip[j] + ' ');
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public void addDataChangeListener(DataSetDataChangeEventListener listener) {
        this.dataChangeListener.add(DataSetDataChangeEventListener.class, listener);
    }

    public void removeDataChangeListener(DataSetDataChangeEventListener listener) {
        this.dataChangeListener.remove(DataSetDataChangeEventListener.class, listener);
    }

    private void fireDataChangeEvent(AtomDataChangeEvent e) {
        DataSetDataChangeEvent event = new DataSetDataChangeEvent((Object)this, e);
        this.fireDataChangeEvent(event);
    }

    private void fireDataAddEvent(Atom AtomAdded, int Index) {
        DataSetDataChangeEvent event = new DataSetDataChangeEvent(this, 1, AtomAdded, Index);
        this.fireDataChangeEvent(event);
    }

    private void fireDataAddEvent(Atom AtomAdded) {
        DataSetDataChangeEvent event = new DataSetDataChangeEvent(this, 1, AtomAdded);
        this.fireDataChangeEvent(event);
    }

    private void fireDataDeleteEvent(Atom AtomDeleted, int lastIndex) {
        DataSetDataChangeEvent event = new DataSetDataChangeEvent(this, 2, AtomDeleted, lastIndex);
        this.fireDataChangeEvent(event);
    }

    public void fireDataChangeEvent(DataSetDataChangeEvent event) {
        Object[] listeners = this.dataChangeListener.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != DataSetDataChangeEventListener.class) continue;
            ((DataSetDataChangeEventListener)listeners[i + 1]).dataChanged(event);
        }
    }

    public static void initializeResidueTypeDatabase() {
        String[] s = Global.ReadTextResource("/pdb_editor/data/ResidueTypes.txt");
        for (int i = 0; i < s.length; ++i) {
            String[] entry = s[i].split("\t");
            if (entry.length != 2) continue;
            ResidueTypeDatabase.put(entry[0], entry[1]);
        }
    }

    public static void initializeResidueAtomElementDatabase() {
        String[] s = Global.ReadTextResource("/pdb_editor/data/ResidueAtomElementList.txt");
        for (int i = 0; i < s.length; ++i) {
            String[] entry = s[i].split("\t");
            if (entry.length != 3) continue;
            if (!ResidueAtomElementDatabase.containsKey(entry[0])) {
                ResidueAtomElementDatabase.put(entry[0], new TreeMap());
            }
            ResidueAtomElementDatabase.get(entry[0]).put(entry[1], entry[2]);
        }
    }

    public static void initializeResidueSingleLetterCodeDatabase() {
        String[] s = Global.ReadTextResource("/pdb_editor/data/ResidueSingleLetterCodes.txt");
        for (int i = 0; i < s.length; ++i) {
            String[] entry = s[i].split("\t");
            ResidueSingleLetterCodeDatabase.put(entry[0], Character.valueOf(entry[1].charAt(0)));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ArrayListWithEvent<T>
    extends ArrayList<T> {
        private ArrayListWithEvent() {
        }

        @Override
        public boolean add(T value) {
            ((Atom)value).addAtomDataChangeListener(DataSet.this.ADCEL);
            boolean rv = super.add(value);
            DataSet.this.fireDataAddEvent((Atom)value);
            return rv;
        }

        @Override
        public void add(int index, T value) {
            ((Atom)value).addAtomDataChangeListener(DataSet.this.ADCEL);
            super.add(index, value);
            DataSet.this.fireDataAddEvent((Atom)value, index);
        }

        @Override
        public T remove(int index) {
            DataSet.this.fireDataDeleteEvent((Atom)this.get(index), index);
            return (T)super.remove(index);
        }

        @Override
        public boolean remove(Object o) {
            DataSet.this.fireDataDeleteEvent((Atom)o, this.indexOf(o));
            return super.remove(o);
        }
    }
}

