/*
 * Decompiled with CFR 0.152.
 */
package pdb_reader;

import java.util.HashMap;
import java.util.LinkedList;
import pdb_reader.Global;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormulaEvaluator {
    private static char[] AllowedInstructions = new char[]{'(', ')', '^', '*', '/', '+', '-'};
    private static char[] AllowedNumbers = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static String[] AllowedFunctions = new String[]{"ABS", "SIN", "COS", "TAN", "LOG", "EXP", "ASIN", "ACOS", "ATAN", "LOG10", "SQRT"};
    private String Formula = null;
    private LinkedList Instructions = null;
    private HashMap<String, Double> Variables = null;
    private Double LastResult = null;

    public FormulaEvaluator(String formula) {
        this.setFormula(formula);
        this.generateInstructions();
    }

    public FormulaEvaluator(String formula, HashMap<String, Double> variables) {
        this.setFormula(formula);
        this.generateInstructions();
        this.evaluateExpression(variables);
    }

    public double evaluateExpression() {
        LinkedList Ins = (LinkedList)this.Instructions.clone();
        this.substituteVariables(Ins);
        this.LastResult = this.evaluateExpression(Ins);
        return this.LastResult;
    }

    public double evaluateExpression(HashMap<String, Double> Vars) {
        this.Variables = Vars;
        return this.evaluateExpression();
    }

    public String getFormula() {
        return this.Formula;
    }

    public String setFormula(String Value) {
        this.Formula = Value;
        return this.Formula;
    }

    public HashMap<String, Double> getVariables() {
        return this.Variables;
    }

    public HashMap<String, Double> setVariables(HashMap<String, Double> Value) {
        this.Variables = Value;
        return this.Variables;
    }

    public Double getLastResult() {
        return this.LastResult;
    }

    private void generateInstructions() {
        this.Instructions = new LinkedList();
        this.Variables = new HashMap();
        boolean readingNumber = false;
        boolean readingName = false;
        StringBuilder Current = null;
        for (int i = 0; i < this.Formula.length(); ++i) {
            char c = this.Formula.charAt(i);
            if (c == ' ') {
                if (readingNumber) {
                    this.Instructions.addLast(Double.parseDouble(Current.toString()));
                }
                if (readingName) {
                    this.processName(Current.toString());
                }
                readingNumber = false;
                readingName = false;
                continue;
            }
            int FunctionIndex = Global.CharArrayFindIndex(AllowedInstructions, c);
            if (FunctionIndex != -1) {
                if (readingNumber) {
                    this.Instructions.addLast(Double.parseDouble(Current.toString()));
                }
                if (readingName) {
                    this.processName(Current.toString());
                }
                readingNumber = false;
                readingName = false;
                if (FunctionIndex == 6) {
                    if ((this.Instructions.size() == 0 || this.Instructions.getLast().getClass().equals(Global.integerclass.getClass())) && Global.CharArrayContains(AllowedNumbers, this.Formula.charAt(i + 1))) {
                        readingNumber = true;
                        Current = new StringBuilder();
                        Current.append(c);
                        continue;
                    }
                    if (this.Instructions.size() == 0 || this.Instructions.getLast().getClass().equals(Global.integerclass.getClass())) {
                        this.Instructions.addLast(-1.0);
                        this.Instructions.addLast(3);
                        continue;
                    }
                }
                this.Instructions.addLast(FunctionIndex);
                continue;
            }
            if (readingNumber || readingName) {
                Current.append(c);
                continue;
            }
            if (Global.CharArrayContains(AllowedNumbers, c)) {
                readingNumber = true;
                readingName = false;
                Current = new StringBuilder();
                Current.append(c);
                continue;
            }
            if (readingName) continue;
            readingName = true;
            Current = new StringBuilder();
            Current.append(c);
        }
        if (readingNumber) {
            this.Instructions.addLast(Double.parseDouble(Current.toString()));
        }
        if (readingName) {
            this.processName(Current.toString());
        }
    }

    private void processName(String Value) {
        int functionIndex = Global.StringArrayFindIndex(AllowedFunctions, Value.toUpperCase());
        if (functionIndex != -1) {
            this.Instructions.addLast((functionIndex + 1) * -1);
        } else {
            this.Variables.put(Value, null);
            this.Instructions.addLast(Value);
        }
    }

    private double evaluateExpression(LinkedList Ins) {
        this.processParanthesis(Ins);
        this.processFunctions(Ins);
        this.processMathOperations(Ins);
        return (Double)Ins.get(0);
    }

    private void processFunctions(LinkedList Ins) {
        for (int i = 0; i < Ins.size(); ++i) {
            int fcode;
            Object o = Ins.get(i);
            if (o.getClass() != Global.integerclass.getClass() || (fcode = ((Integer)o).intValue()) >= 0) continue;
            this.evluateFunction(Ins, i, fcode);
            i = 0;
        }
    }

    private void evluateFunction(LinkedList Ins, int index, int funccode) {
        double d = (Double)Ins.get(index + 1);
        Ins.remove(index);
        Ins.remove(index);
        double eval = 0.0;
        switch (funccode) {
            case -1: {
                eval = Math.abs(d);
                break;
            }
            case -2: {
                eval = Math.sin(Math.toRadians(d));
                break;
            }
            case -3: {
                eval = Math.cos(Math.toRadians(d));
                break;
            }
            case -4: {
                eval = Math.tan(Math.toRadians(d));
                break;
            }
            case -5: {
                eval = Math.log(d);
                break;
            }
            case -6: {
                eval = Math.exp(d);
                break;
            }
            case -7: {
                eval = Math.toDegrees(Math.asin(d));
                break;
            }
            case -8: {
                eval = Math.toDegrees(Math.acos(d));
                break;
            }
            case -9: {
                eval = Math.toDegrees(Math.atan(d));
                break;
            }
            case -10: {
                eval = Math.log10(d);
                break;
            }
            case -11: {
                eval = Math.sqrt(d);
            }
        }
        Ins.add(index, eval);
    }

    private void substituteVariables(LinkedList Ins) {
        for (int i = 0; i < Ins.size(); ++i) {
            Object o = Ins.get(i);
            if (o.getClass() != Global.stringclass.getClass() || !this.Variables.containsKey((String)o)) continue;
            Ins.remove(i);
            Ins.add(i, this.Variables.get((String)o));
        }
    }

    private void processParanthesis(LinkedList Ins) {
        int parenthesisCount = 0;
        LinkedList innerFormula = new LinkedList();
        for (int i = 0; i < Ins.size(); ++i) {
            int inst;
            Object o = Ins.get(i);
            if (parenthesisCount > 0) {
                if (o.getClass() == Global.integerclass.getClass()) {
                    inst = (Integer)o;
                    switch (inst) {
                        case 0: {
                            ++parenthesisCount;
                            break;
                        }
                        case 1: {
                            --parenthesisCount;
                        }
                    }
                }
                if (parenthesisCount == 0) {
                    Ins.remove(i);
                    Ins.add(i, this.evaluateExpression(innerFormula));
                    innerFormula = new LinkedList();
                    continue;
                }
                innerFormula.addLast(o);
                Ins.remove(i--);
                continue;
            }
            if (o.getClass() != Global.integerclass.getClass() || (inst = ((Integer)o).intValue()) != 0) continue;
            parenthesisCount = 1;
            Ins.remove(i--);
        }
    }

    private void processMathOperations(LinkedList Ins) {
        for (int j = 2; j < AllowedInstructions.length; ++j) {
            for (int i = 0; i < Ins.size(); ++i) {
                int inst;
                Object o = Ins.get(i);
                if (o.getClass() != Global.integerclass.getClass() || (inst = ((Integer)o).intValue()) != j) continue;
                this.evaluteMathOperation(Ins, i, inst);
                i = 0;
            }
        }
    }

    private void evaluteMathOperation(LinkedList Ins, int i, int op) {
        double d1 = (Double)Ins.get(i - 1);
        Ins.remove(i-- - 1);
        double d2 = (Double)Ins.get(i + 1);
        Ins.remove(i);
        Ins.remove(i);
        switch (op) {
            case 2: {
                Ins.add(i, Math.pow(d1, d2));
                break;
            }
            case 3: {
                Ins.add(i, d1 * d2);
                break;
            }
            case 4: {
                Ins.add(i, d1 / d2);
                break;
            }
            case 5: {
                Ins.add(i, d1 + d2);
                break;
            }
            case 6: {
                Ins.add(i, d1 - d2);
            }
        }
    }
}

