/*
 * Decompiled with CFR 0.152.
 */
package pdb_reader.data.spacegroup;

import pdb_reader.data.spacegroup.SpaceGroup;

public class CrystalSystemChecker {
    public static CrystalSystemChecker GetChecker(String System) {
        if (System.equals("TRICLINIC")) {
            return CrystalSystemChecker.TRICLINIC();
        }
        if (System.equals("MONOCLINIC")) {
            return CrystalSystemChecker.MONOCLINIC();
        }
        if (System.equals("ORTHORHOMBIC")) {
            return CrystalSystemChecker.ORTHORHOMBIC();
        }
        if (System.equals("TETRAGONAL")) {
            return CrystalSystemChecker.TETRAGONAL();
        }
        if (System.equals("TRIGONAL")) {
            return CrystalSystemChecker.TRIGONAL();
        }
        if (System.equals("CUBIC")) {
            return CrystalSystemChecker.CUBIC();
        }
        if (System.equals("HEXAGONAL")) {
            return CrystalSystemChecker.HEXAGONAL();
        }
        return null;
    }

    public static CrystalSystemChecker TRICLINIC() {
        return new CrystalSystemChecker(){

            public String InformationText() {
                return "Triclinic : No restriction";
            }

            public boolean CheckCell(SpaceGroup sg) {
                return true;
            }

            public SpaceGroup Correct(SpaceGroup sg) {
                return sg;
            }
        };
    }

    public static CrystalSystemChecker MONOCLINIC() {
        return new CrystalSystemChecker(){

            public String InformationText() {
                return "Monoclinic : alpha = gamma = 90";
            }

            public boolean CheckCell(SpaceGroup sg) {
                if (sg.alpha() != 90.0) {
                    return false;
                }
                return sg.gamma() == 90.0;
            }

            public SpaceGroup Correct(SpaceGroup sg) {
                sg.alpha(90.0);
                sg.gamma(90.0);
                return sg;
            }
        };
    }

    public static CrystalSystemChecker ORTHORHOMBIC() {
        return new CrystalSystemChecker(){

            public String InformationText() {
                return "Orthorhombic : alpha = beta = gamma = 90";
            }

            public boolean CheckCell(SpaceGroup sg) {
                if (sg.alpha() != 90.0) {
                    return false;
                }
                if (sg.beta() != 90.0) {
                    return false;
                }
                return sg.gamma() == 90.0;
            }

            public SpaceGroup Correct(SpaceGroup sg) {
                sg.alpha(90.0);
                sg.beta(90.0);
                sg.gamma(90.0);
                return sg;
            }
        };
    }

    public static CrystalSystemChecker TETRAGONAL() {
        return new CrystalSystemChecker(){

            public String InformationText() {
                return "Trigonal : a = b\n  alpha = beta = gamma = 90";
            }

            public boolean CheckCell(SpaceGroup sg) {
                if (sg.a() != sg.b()) {
                    return false;
                }
                if (sg.alpha() != 90.0) {
                    return false;
                }
                if (sg.beta() != 90.0) {
                    return false;
                }
                return sg.gamma() == 90.0;
            }

            public SpaceGroup Correct(SpaceGroup sg) {
                sg.b(sg.a());
                sg.alpha(90.0);
                sg.beta(90.0);
                sg.gamma(90.0);
                return sg;
            }
        };
    }

    public static CrystalSystemChecker CUBIC() {
        return new CrystalSystemChecker(){

            public String InformationText() {
                return "Cubic : a = b = c\n  alpha = beta = gamma = 90";
            }

            public boolean CheckCell(SpaceGroup sg) {
                if (sg.a() != sg.b() & sg.a() != sg.c()) {
                    return false;
                }
                if (sg.alpha() != 90.0) {
                    return false;
                }
                if (sg.beta() != 90.0) {
                    return false;
                }
                return sg.gamma() == 90.0;
            }

            public SpaceGroup Correct(SpaceGroup sg) {
                sg.b(sg.a());
                sg.c(sg.a());
                sg.alpha(90.0);
                sg.beta(90.0);
                sg.gamma(90.0);
                return sg;
            }
        };
    }

    public static CrystalSystemChecker HEXAGONAL() {
        return new CrystalSystemChecker(){

            public String InformationText() {
                return "Hexagonal : a = b\n  alpha = beta = 90\n  gamma = 120";
            }

            public boolean CheckCell(SpaceGroup sg) {
                if (sg.a() != sg.b()) {
                    return false;
                }
                if (sg.alpha() != 90.0) {
                    return false;
                }
                if (sg.beta() != 90.0) {
                    return false;
                }
                return sg.gamma() == 120.0;
            }

            public SpaceGroup Correct(SpaceGroup sg) {
                sg.b(sg.a());
                sg.alpha(90.0);
                sg.beta(90.0);
                sg.gamma(120.0);
                return sg;
            }
        };
    }

    public static CrystalSystemChecker TRIGONAL() {
        return new CrystalSystemChecker(){

            public String InformationText() {
                String text = "Hexagonal : a = b\n";
                text = text + "  alpha = beta = 90; gamma = 120\n";
                text = text + "Rhombohedral : a = b = c\n";
                text = text + "  alpha = beta = gamma";
                return text;
            }

            public boolean CheckCell(SpaceGroup sg) {
                boolean hexagonal = true;
                if (sg.name().charAt(0) == 'R') {
                    hexagonal = false;
                }
                if (hexagonal) {
                    if (sg.a() != sg.b()) {
                        return false;
                    }
                    if (sg.alpha() != 90.0) {
                        return false;
                    }
                    if (sg.beta() != 90.0) {
                        return false;
                    }
                    if (sg.gamma() != 120.0) {
                        return false;
                    }
                } else {
                    if (sg.a() != sg.b() & sg.a() != sg.c()) {
                        return false;
                    }
                    if (sg.alpha() != sg.beta() & sg.alpha() != sg.gamma()) {
                        return false;
                    }
                }
                return true;
            }

            public SpaceGroup Correct(SpaceGroup sg) {
                boolean hexagonal = true;
                if (sg.name().charAt(0) == 'R') {
                    hexagonal = false;
                }
                if (hexagonal) {
                    sg.b(sg.a());
                    sg.alpha(90.0);
                    sg.beta(90.0);
                    sg.gamma(120.0);
                } else {
                    sg.b(sg.a());
                    sg.c(sg.a());
                    sg.beta(sg.alpha());
                    sg.gamma(sg.alpha());
                }
                return sg;
            }
        };
    }

    public String InformationText() {
        return null;
    }

    public boolean CheckCell(SpaceGroup sg) {
        return true;
    }

    public SpaceGroup Correct(SpaceGroup sg) {
        return sg;
    }
}

