/*
 * Decompiled with CFR 0.152.
 */
package pdb_editor.coordinate;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.TreeSet;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import pdb_editor.EditorFrame;
import pdb_reader.DataSet;
import pdb_reader.Global;
import pdb_reader.data.Atom;
import pdb_reader.data.AtomPDB;

public class CoordinateTable
extends JTable {
    private static final long serialVersionUID = 1L;
    private EditorFrame parent = null;
    private DataSet maindata = null;
    private DataModel tabledata = null;
    private int[] columnWidth = (int[])Atom.DataTextSize.clone();

    public CoordinateTable(EditorFrame Parent, DataSet MainData) {
        this.maindata = MainData;
        this.parent = Parent;
        this.InitializeCommon();
        this.SetColumnWidth();
        this.maindata.TableLinked(this);
    }

    private void InitializeCommon() {
        this.tabledata = new DataModel(this.maindata, this);
        this.addKeyListener(new CommonKeyListener());
        this.setModel(this.tabledata);
        this.setColumnSelectionAllowed(true);
        this.setRowSelectionAllowed(true);
        this.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            public void columnSelectionChanged(ListSelectionEvent e) {
                if (CoordinateTable.this.parent != null) {
                    CoordinateTable.this.parent.StatusLabelReportCellSelectionChange();
                }
            }

            public void columnAdded(TableColumnModelEvent e) {
            }

            public void columnRemoved(TableColumnModelEvent e) {
            }

            public void columnMoved(TableColumnModelEvent e) {
            }

            public void columnMarginChanged(ChangeEvent e) {
            }
        });
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (CoordinateTable.this.parent != null) {
                    CoordinateTable.this.parent.StatusLabelReportCellSelectionChange();
                }
            }
        });
    }

    public void fireTableDataChanged() {
        this.tabledata.fireTableDataChanged();
    }

    public void addRowSelectionIndicies(int[] indicies) {
        for (int i = 0; i < indicies.length; ++i) {
            this.addRowSelectionInterval(indicies[i], indicies[i]);
        }
    }

    public void addColumnSelectionIndicies(int[] indicies) {
        for (int i = 0; i < indicies.length; ++i) {
            this.addColumnSelectionInterval(indicies[i], indicies[i]);
        }
    }

    public DataSet getMainData() {
        return this.maindata;
    }

    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){

            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int index = this.columnModel.getColumnIndexAtX(p.x);
                int realIndex = this.columnModel.getColumn(index).getModelIndex();
                return Atom.DataToolTip[CoordinateTable.this.tabledata.getColumnIndex()[realIndex]];
            }
        };
    }

    private void SetColumnWidth() {
        TableColumn column = null;
        for (int i = 0; i < this.tabledata.getColumnCount(); ++i) {
            column = this.getColumnModel().getColumn(i);
            column.setPreferredWidth(this.columnWidth[this.tabledata.getColumnIndex()[i]]);
        }
    }

    public void scrollToCenterOnFirstSelectedCell() {
        if (this.getSelectedRowCount() > 0 && this.getSelectedColumnCount() > 0) {
            this.scrollToCenterOnCell(this.getSelectedRow(), this.getSelectedColumn());
        }
    }

    public void scrollToCenterOnCell(int rowIndex, int vColIndex) {
        CoordinateTable table = this;
        if (!(table.getParent() instanceof JViewport)) {
            return;
        }
        JViewport viewport = (JViewport)table.getParent();
        Rectangle rect = table.getCellRect(rowIndex, vColIndex, true);
        Rectangle viewRect = viewport.getViewRect();
        int dx = rect.x - viewRect.x;
        int dy = rect.y - viewRect.y;
        rect.setLocation(dx, dy);
        int centerX = (viewRect.width - rect.width) / 2;
        int centerY = (viewRect.height - rect.height) / 2;
        if (rect.x < centerX) {
            centerX = -centerX;
        }
        if (rect.y < centerY) {
            centerY = -centerY;
        }
        rect.translate(centerX, centerY);
        viewport.scrollRectToVisible(rect);
    }

    public String GetPDBTextFromSelectedRows() {
        int[] rows = this.getSelectedRows();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < rows.length; ++i) {
            AtomPDB a = this.maindata.Atoms().get(rows[i]).GetPDBAtomOfThis();
            sb.append(a.WritePDBLine());
        }
        return sb.toString();
    }

    public int GetColumnIndex(int ColumnTypeNumber) {
        return this.tabledata.getColumnIndex()[ColumnTypeNumber];
    }

    public int GetAtomTableIndexOfColumn(int ColumnNumber) {
        int[] data = this.tabledata.getColumnIndex();
        for (int i = 0; i < data.length; ++i) {
            if (data[i] != ColumnNumber) continue;
            return i;
        }
        return -1;
    }

    public String[] ListColumnDisplayed() {
        int[] inds = this.tabledata.getColumnIndex();
        ArrayList<String> r = new ArrayList<String>();
        for (int i = 0; i < inds.length; ++i) {
            if (inds[i] < 0) continue;
            r.add(Atom.DataToolTip[inds[i]]);
        }
        return r.toArray(new String[r.size()]);
    }

    public void setColumnIndex(int[] ColumnIndicies) {
        this.UpdateTableWidth();
        this.tabledata = new DataModel(this.maindata, this, ColumnIndicies);
        this.setModel(this.tabledata);
        this.SetColumnWidth();
    }

    private void UpdateTableWidth() {
        TableColumn column = null;
        for (int i = 0; i < this.tabledata.getColumnCount(); ++i) {
            column = this.getColumnModel().getColumn(i);
            this.columnWidth[this.tabledata.getColumnIndex()[i]] = column.getWidth();
        }
    }

    public int[] getColumnWidths() {
        this.UpdateTableWidth();
        return this.columnWidth;
    }

    public void PasteText(String s) {
        String[][] in = Global.TabulateStringByLineTab(s);
        int[] selcols = this.getSelectedColumns();
        int[] selrows = this.getSelectedRows();
        this.clearSelection();
        int row = 0;
        int col = 0;
        int rowos = 1;
        for (int i = 0; i < in.length; ++i) {
            row = i < selrows.length ? selrows[i] : selrows[selrows.length - 1] + rowos++;
            if (row >= this.maindata.Atoms().size()) continue;
            int colos = 1;
            for (int j = 0; j < in[i].length; ++j) {
                col = j < selcols.length ? selcols[j] : selcols[selcols.length - 1] + colos++;
                if (col >= this.tabledata.getColumnCount()) continue;
                try {
                    Object o = Global.ConvertString(in[i][j], Atom.DataClass[this.GetColumnIndex(col)]);
                    if (o != null) {
                        this.maindata.Atoms().get(row).TableData(this.GetColumnIndex(col), o);
                        this.addColumnSelectionInterval(col, col);
                        this.addRowSelectionInterval(row, row);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.tabledata.fireTableRowsUpdated(row, row);
            }
        }
    }

    public void fireTableRowUpdated(int rowstart, int rowend) {
        this.tabledata.fireTableRowsUpdated(rowstart, rowend);
    }

    public void invertSelectedRows() {
        int i;
        int[] selrows = this.getSelectedRows();
        int[] selcols = this.getSelectedColumns();
        TreeSet<Integer> list = new TreeSet<Integer>();
        for (i = 0; i < this.getRowCount(); ++i) {
            list.add(i);
        }
        for (i = 0; i < selrows.length; ++i) {
            list.remove(selrows[i]);
        }
        this.clearSelection();
        this.addRowSelectionIndicies(Global.ConvertIntegerArrayToIntArray(list.toArray(new Integer[list.size()])));
        this.addColumnSelectionIndicies(selcols);
    }

    class DataModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private int[] ColumnIndex = null;
        private DataSet maindata = null;
        private JTable table = null;

        public DataModel(DataSet MainData, JTable Table) {
            this.maindata = MainData;
            this.table = Table;
            this.InitializeDefault();
        }

        public DataModel(DataSet MainData, JTable Table, int[] columnIndex) {
            this.ColumnIndex = columnIndex;
            this.maindata = MainData;
            this.table = Table;
        }

        private void InitializeDefault() {
            int i;
            this.ColumnIndex = new int[Atom.DataList.length];
            int Limit = Atom.DataList.length;
            for (i = 0; i < Limit; ++i) {
                this.ColumnIndex[i] = i;
            }
            for (i = Limit; i < Atom.DataList.length; ++i) {
                this.ColumnIndex[i] = -1;
            }
        }

        public int[] getColumnIndex() {
            return this.ColumnIndex;
        }

        public void setColumnIndex(int[] columnIndex) {
            this.ColumnIndex = columnIndex;
        }

        public int getColumnCount() {
            return this.ColumnIndex.length;
        }

        public int getRowCount() {
            return this.maindata.Atoms().size();
        }

        public String getColumnName(int col) {
            return Atom.DataList[this.ColumnIndex[col]];
        }

        public Object getValueAt(int row, int col) {
            Object Value = this.maindata.Atoms().get(row).TableData(this.ColumnIndex[col]);
            return Value;
        }

        public void setValueAt(Object value, int row, int col) {
            CoordinateTable.this.parent.listenForUndoStart("Cell value edit");
            int[] selrows = this.table.getSelectedRows();
            for (int i = 0; i < selrows.length; ++i) {
                this.maindata.Atoms().get(selrows[i]).TableData(this.ColumnIndex[col], value);
                this.fireTableCellUpdated(selrows[i], col);
            }
            CoordinateTable.this.parent.listenForUndoStop();
        }

        public Class getColumnClass(int col) {
            Class<?> c = Atom.DataClass[this.ColumnIndex[col]];
            if (c == Global.charclass.getClass()) {
                c = Global.stringclass.getClass();
            }
            return c;
        }

        public boolean isCellEditable(int row, int col) {
            return true;
        }

        private int ColumnDisplayedCount() {
            int result = 0;
            for (int i = 0; i < this.ColumnIndex.length; ++i) {
                if (this.ColumnIndex[i] < 0) continue;
                ++result;
            }
            return result;
        }

        class TML
        implements TableModelListener {
            TML() {
            }

            public void tableChanged(TableModelEvent e) {
            }
        }
    }

    class CommonKeyListener
    implements KeyListener {
        CommonKeyListener() {
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            if (CoordinateTable.this.parent != null) {
                if (e.isControlDown()) {
                    if (e.getKeyCode() == 127) {
                        CoordinateTable.this.parent.DeleteRecord();
                        CoordinateTable.this.clearSelection();
                        CoordinateTable.this.fireTableDataChanged();
                    }
                    if (e.getKeyCode() == 86) {
                        CoordinateTable.this.parent.PasteToCoordinateTable();
                    }
                    if (e.getKeyCode() == 88) {
                        CoordinateTable.this.parent.CutAsPDBAtom();
                    }
                    if (e.getKeyCode() == 38) {
                        CoordinateTable.this.parent.MoveUpSelectedAtoms();
                    }
                    if (e.getKeyCode() == 40) {
                        CoordinateTable.this.parent.MoveDownSelectedAtoms();
                    }
                }
                if (e.isControlDown() && e.isShiftDown()) {
                    if (e.getKeyCode() == 38) {
                        CoordinateTable.this.parent.MoveTopSelectedAtoms();
                    }
                    if (e.getKeyCode() == 40) {
                        CoordinateTable.this.parent.MoveBottomSelectedAtoms();
                    }
                }
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    }
}

