/*
 * Decompiled with CFR 0.152.
 */
package pdb_editor.coordinate;

import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import pdb_reader.DataSet;
import pdb_reader.Global;
import pdb_reader.data.Atom;

class DataModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private int[] ColumnIndex = null;
    private DataSet maindata = null;
    private JTable table = null;

    public DataModel(DataSet MainData, JTable Table) {
        this.maindata = MainData;
        this.table = Table;
        this.InitializeDefault();
    }

    public DataModel(DataSet MainData, JTable Table, int[] columnIndex) {
        this.ColumnIndex = columnIndex;
        this.maindata = MainData;
        this.table = Table;
    }

    private void InitializeDefault() {
        int i;
        this.ColumnIndex = new int[Atom.DataList.length];
        int Limit = Atom.DataList.length;
        for (i = 0; i < Limit; ++i) {
            this.ColumnIndex[i] = i;
        }
        for (i = Limit; i < Atom.DataList.length; ++i) {
            this.ColumnIndex[i] = -1;
        }
    }

    public int[] getColumnIndex() {
        return this.ColumnIndex;
    }

    public void setColumnIndex(int[] columnIndex) {
        this.ColumnIndex = columnIndex;
    }

    public int getColumnCount() {
        return this.ColumnIndex.length;
    }

    public int getRowCount() {
        return this.maindata.Atoms().size();
    }

    public String getColumnName(int col) {
        return Atom.DataList[this.ColumnIndex[col]];
    }

    public Object getValueAt(int row, int col) {
        Object Value = this.maindata.Atoms().get(row).TableData(this.ColumnIndex[col]);
        return Value;
    }

    public void setValueAt(Object value, int row, int col) {
        int[] selrows = this.table.getSelectedRows();
        for (int i = 0; i < selrows.length; ++i) {
            this.maindata.Atoms().get(selrows[i]).TableData(this.ColumnIndex[col], value);
            this.fireTableCellUpdated(selrows[i], col);
        }
    }

    public Class getColumnClass(int col) {
        Class<?> c = Atom.DataClass[this.ColumnIndex[col]];
        if (c == Global.charclass.getClass()) {
            c = Global.stringclass.getClass();
        }
        return c;
    }

    public boolean isCellEditable(int row, int col) {
        return true;
    }

    private int ColumnDisplayedCount() {
        int result = 0;
        for (int i = 0; i < this.ColumnIndex.length; ++i) {
            if (this.ColumnIndex[i] < 0) continue;
            ++result;
        }
        return result;
    }

    class TML
    implements TableModelListener {
        TML() {
        }

        public void tableChanged(TableModelEvent e) {
        }
    }
}

