/*
 * Decompiled with CFR 0.152.
 */
package pdb_editor.coordinate;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import pdb_editor.EditorFrame;
import pdb_editor.coordinate.CoordinateTable;
import pdb_reader.DataSet;
import pdb_reader.Global;
import pdb_reader.data.Atom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchSelectDialog
extends JDialog {
    private static char[] operators = new char[]{'|', '&', '^', '(', ')', '=', '!', '>', '<'};
    private EditorFrame Parent = null;
    private CommonKeyListener commonKeyListener = new CommonKeyListener();
    private DefaultComboBoxModel dataTypeCombo = new DefaultComboBoxModel<String>(Atom.DataToolTip);
    private String[] CondTypes = new String[]{"OR", "AND", "XOR"};
    private JCheckBox[] selectColumnCheckboxes = null;
    private ArrayList<JComboBox> searchCondCombos = new ArrayList();
    private ArrayList<JComboBox> searchTypeCombos = new ArrayList();
    private ArrayList<JTextField> searchFields = new ArrayList();
    private DataModel fCTData = new DataModel();
    private Integer[] foundCoordinateIndicies = new Integer[0];
    private Integer[] usedColumnsIndicies = null;
    private CoordinateTable cTable = null;
    private DataSet maindata = null;
    private boolean searchOnly = false;
    private int focusIndex = 0;
    private JButton jButton2;
    private JButton jButtonAllColumns;
    private JButton jButtonClose;
    private JButton jButtonGoto;
    private JButton jButtonHelp;
    private JButton jButtonNext;
    private JButton jButtonNoColumns;
    private JButton jButtonPrev;
    private JButton jButtonSearch;
    private JComboBox jComboBoxMain;
    private JDialog jDialog1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanelSearch;
    private JPanel jPanelSelectColumns;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JTabbedPane jTabbedPane1;
    private JTable jTableFound;
    private JTextArea jTextArea1;
    private JTextField jTextFieldMain;

    public Integer[] getFoundCoordinateIndicies() {
        return this.foundCoordinateIndicies;
    }

    public SearchSelectDialog(Frame parent, boolean modal, CoordinateTable TableIn) {
        super(parent, modal);
        try {
            this.Parent = (EditorFrame)parent;
        }
        catch (Exception e) {
            // empty catch block
        }
        this.initComponents();
        this.jTextFieldMain.getDocument().addDocumentListener(new inputListener());
        this.cTable = TableIn;
        this.maindata = this.cTable.getMainData();
        this.jTextFieldMain.addKeyListener(this.commonKeyListener);
        this.initSelectColumns();
        this.setFocusButtonVisibility(false);
    }

    public SearchSelectDialog(Frame parent, boolean modal, String Name, CoordinateTable TableIn, boolean SearchOnly) {
        super(parent, modal);
        this.initComponents();
        this.jTextFieldMain.getDocument().addDocumentListener(new inputListener());
        this.cTable = TableIn;
        this.maindata = this.cTable.getMainData();
        this.jTextFieldMain.addKeyListener(this.commonKeyListener);
        this.initSelectColumns();
        this.searchOnly = SearchOnly;
        this.setTitle("Search and " + Name);
        for (int i = 0; i < this.selectColumnCheckboxes.length; ++i) {
            this.selectColumnCheckboxes[i].setEnabled(false);
        }
        this.jTabbedPane1.setTitleAt(1, "Coordinate " + Name);
        this.setFocusButtonVisibility(false);
    }

    private void setFocusButtonVisibility(boolean setting) {
        this.jButtonNext.setVisible(setting);
        this.jButtonPrev.setVisible(setting);
        this.jButtonGoto.setVisible(setting);
    }

    private void addSearchField() {
        int gridy = this.searchCondCombos.size() + 2;
        JComboBox<String> ccb = new JComboBox<String>();
        ccb.setModel(new DefaultComboBoxModel<String>(this.CondTypes));
        ccb.setPreferredSize(new Dimension(60, 20));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = gridy;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(5, 0, 1, 5);
        this.jPanelSearch.add(ccb, gridBagConstraints);
        this.searchCondCombos.add(ccb);
        JComboBox<String> tcb = new JComboBox<String>();
        tcb.setModel(new DefaultComboBoxModel<String>(Atom.DataToolTip));
        tcb.setPreferredSize(new Dimension(135, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = gridy;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(5, 0, 1, 5);
        this.jPanelSearch.add(tcb, gridBagConstraints);
        this.searchTypeCombos.add(tcb);
        JTextField tf = new JTextField();
        tf.setPreferredSize(new Dimension(270, 20));
        tf.getDocument().addDocumentListener(new inputListener());
        tf.addKeyListener(this.commonKeyListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = gridy;
        gridBagConstraints.gridwidth = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(5, 0, 1, 0);
        this.jPanelSearch.add((Component)tf, gridBagConstraints);
        this.searchFields.add(tf);
        this.pack();
    }

    private void initSelectColumns() {
        this.selectColumnCheckboxes = new JCheckBox[35];
        for (int i = 0; i < this.selectColumnCheckboxes.length; ++i) {
            this.selectColumnCheckboxes[i] = new JCheckBox(Atom.DataList[i], true);
            this.selectColumnCheckboxes[i].setToolTipText(Atom.DataToolTip[i]);
            this.jPanelSelectColumns.add(this.selectColumnCheckboxes[i]);
        }
    }

    private void checkSelectColumnCheckBoxes(boolean value) {
        for (int i = 0; i < this.selectColumnCheckboxes.length; ++i) {
            this.selectColumnCheckboxes[i].setSelected(value);
        }
    }

    private void selectSelectedColumns() {
        for (int i = 0; i < this.selectColumnCheckboxes.length; ++i) {
            if (!this.selectColumnCheckboxes[i].isSelected() || this.cTable.GetAtomTableIndexOfColumn(i) == -1) continue;
            this.cTable.addColumnSelectionInterval(this.cTable.GetAtomTableIndexOfColumn(i), this.cTable.GetAtomTableIndexOfColumn(i));
        }
    }

    private void selectSelectedRows(Integer[] indicies) {
        for (int i = 0; i < indicies.length; ++i) {
            this.cTable.addRowSelectionInterval(indicies[i], indicies[i]);
        }
    }

    private void Run() {
        if (this.searchFields.size() != 0 | !this.jTextFieldMain.getText().trim().equals("")) {
            this.searchCoordinates();
        }
    }

    private void searchCoordinates() {
        this.foundCoordinateIndicies = null;
        this.usedColumnsIndicies = null;
        ArrayList<String> texts = new ArrayList<String>();
        ArrayList<Integer> types = new ArrayList<Integer>();
        ArrayList<Integer> conds = new ArrayList<Integer>();
        this.getSearchCriteria(types, conds, texts);
        this.interpretSearchCondition(types, conds, texts);
        this.updateCoordinateFoundTable();
        if (this.searchOnly) {
            this.jTabbedPane1.setSelectedIndex(1);
        } else {
            this.highlightCoordinateTable();
        }
    }

    private void updateCoordinateFoundTable() {
        this.fCTData = new DataModel();
        this.jTableFound.setModel(this.fCTData);
        this.fCTData.SetColumnWidth();
        if (!this.searchOnly && this.fCTData.getRowCount() > 0) {
            this.focusIndex = 0;
            this.setFocusOnParent(this.focusIndex);
            this.setFocusButtonVisibility(true);
        }
    }

    private void setFocusOnParent(int selectedCFTrow) {
        this.cTable.scrollToCenterOnCell(this.foundCoordinateIndicies[selectedCFTrow], this.getFocusableParentColumnIndex());
    }

    private int getFocusableParentColumnIndex() {
        int first = this.cTable.GetColumnIndex(this.usedColumnsIndicies[0]);
        if (first != -1) {
            return first;
        }
        return 0;
    }

    private void highlightCoordinateTable() {
        this.cTable.clearSelection();
        this.selectSelectedColumns();
        this.selectSelectedRows(this.foundCoordinateIndicies);
    }

    private void interpretSearchCondition(ArrayList<Integer> cols, ArrayList<Integer> conds, ArrayList<String> texts) {
        LinkedList s = new LinkedList();
        for (int i = 0; i < texts.size(); ++i) {
            this.generateSearchCondition(s, conds.get(i), cols.get(i), texts.get(i));
        }
        this.foundCoordinateIndicies = this.searchCoordinates(s);
    }

    private Integer[] searchCoordinates(LinkedList s) {
        ArrayList<Integer> matches = new ArrayList<Integer>();
        DataSet dataset = this.maindata;
        try {
            for (int i = 0; i < dataset.Atoms().size(); ++i) {
                if (!this.searchCoordinate(dataset.Atoms().get(i), (LinkedList)s.clone())) continue;
                matches.add(i);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error searching", 0);
        }
        return matches.toArray(new Integer[matches.size()]);
    }

    private boolean searchCoordinate(Atom a, LinkedList s) throws Exception {
        this.getVariables(a, s);
        return this.evaluateExpression(s);
    }

    private boolean evaluateExpression(LinkedList s) throws Exception {
        this.processParanthesis(s);
        this.evaluateComparisons(s);
        boolean value = this.evaluateConditions(s);
        return value;
    }

    private void evaluateComparisons(LinkedList s) throws Exception {
        String compvalue = null;
        boolean readingc = false;
        LinkedList<Object> compf = new LinkedList<Object>();
        for (int i = 0; i < s.size(); ++i) {
            Object o = s.get(i);
            if (o.getClass().equals(Global.stringclass.getClass())) {
                String str = (String)o;
                String corrected = str.substring(1, str.length() - 1);
                if (!readingc) {
                    compvalue = corrected;
                } else {
                    compf.addFirst(compvalue);
                    compf.addLast(corrected);
                    readingc = false;
                    boolean value = this.evaluateComparison(compf);
                    s.add(i + 1, value);
                    compf = new LinkedList();
                }
                s.remove(i--);
                continue;
            }
            if (o.getClass().equals(Global.doubleclass.getClass())) {
                if (!readingc) {
                    compvalue = (String)o;
                } else {
                    compf.addFirst(compvalue);
                    compf.addLast(o);
                    readingc = false;
                    boolean value = this.evaluateComparison(compf);
                    s.add(i + 1, value);
                    compf = new LinkedList();
                }
                s.remove(i--);
                continue;
            }
            if (!o.getClass().equals(Global.integerclass.getClass())) continue;
            int opindex = (Integer)o;
            if (opindex >= 0 && opindex <= 2) {
                if (!readingc) continue;
                throw new Exception("Syntax error");
            }
            compf.add(opindex);
            readingc = true;
            s.remove(i--);
        }
    }

    private boolean evaluateComparison(LinkedList s) throws Exception {
        Object lead = s.pollFirst();
        Object tail = s.pollLast();
        if (lead.getClass().equals(tail.getClass())) {
            boolean strings = false;
            if (lead.getClass().equals(Global.stringclass.getClass())) {
                strings = true;
            }
            for (int i = 0; i < s.size(); ++i) {
                int opindex = (Integer)s.get(i);
                boolean value = false;
                if (strings) {
                    switch (opindex) {
                        case 5: {
                            value = ((String)lead).equals((String)tail);
                            break;
                        }
                        case 6: {
                            value = !((String)lead).equals((String)tail);
                            break;
                        }
                        case 7: {
                            throw new Exception("> cannot be used to compare strings");
                        }
                        case 8: {
                            throw new Exception("< cannot be used to compare strings");
                        }
                    }
                } else {
                    double d1 = (Double)lead;
                    double d2 = (Double)tail;
                    switch (opindex) {
                        case 5: {
                            value = d1 == d2;
                            break;
                        }
                        case 6: {
                            value = d1 != d2;
                            break;
                        }
                        case 7: {
                            value = d1 > d2;
                            break;
                        }
                        case 8: {
                            boolean bl = value = d1 < d2;
                        }
                    }
                }
                if (!value) continue;
                return true;
            }
        } else {
            throw new Exception(lead.toString() + " cannot be compared with " + tail.toString());
        }
        return false;
    }

    private boolean evaluateConditions(LinkedList s) {
        boolean value = (Boolean)s.pollFirst();
        while (!s.isEmpty()) {
            Object o = s.pollFirst();
            if (!o.getClass().equals(Global.integerclass.getClass())) continue;
            int opindex = (Integer)o;
            boolean comp = (Boolean)s.pollFirst();
            switch (opindex) {
                case 0: {
                    value |= comp;
                    break;
                }
                case 1: {
                    value &= comp;
                    break;
                }
                case 2: {
                    value ^= comp;
                }
            }
        }
        return value;
    }

    private void processParanthesis(LinkedList Ins) {
        int parenthesisCount = 0;
        LinkedList innerFormula = new LinkedList();
        for (int i = 0; i < Ins.size(); ++i) {
            int inst;
            Object o = Ins.get(i);
            if (parenthesisCount > 0) {
                if (o.getClass() == Global.integerclass.getClass()) {
                    int inst2 = (Integer)o;
                    switch (inst2) {
                        case 3: {
                            ++parenthesisCount;
                            break;
                        }
                        case 4: {
                            --parenthesisCount;
                        }
                    }
                }
                if (parenthesisCount == 0) {
                    Ins.remove(i);
                    try {
                        Ins.add(i, this.evaluateExpression(innerFormula));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    innerFormula = new LinkedList();
                    continue;
                }
                innerFormula.addLast(o);
                Ins.remove(i--);
                continue;
            }
            if (o.getClass() != Global.integerclass.getClass() || (inst = ((Integer)o).intValue()) != 3) continue;
            parenthesisCount = 1;
            Ins.remove(i--);
        }
    }

    private void getVariables(Atom a, LinkedList s) throws Exception {
        boolean error = false;
        String errornames = "";
        TreeSet<Integer> searchedColumnIndicies = null;
        if (this.usedColumnsIndicies == null) {
            searchedColumnIndicies = new TreeSet<Integer>();
            searchedColumnIndicies.add(1);
            searchedColumnIndicies.add(2);
            searchedColumnIndicies.add(7);
            searchedColumnIndicies.add(8);
            searchedColumnIndicies.add(6);
        }
        for (int i = 0; i < s.size(); ++i) {
            Object o = s.get(i);
            if (!o.getClass().equals(Global.stringclass.getClass())) continue;
            int dataindex = Global.StringArrayFindIndex(Atom.DataList, (String)o);
            if (dataindex != -1) {
                s.remove(o);
                s.add(i, this.formatVariables(a.TableData(dataindex)));
                if (searchedColumnIndicies == null) continue;
                searchedColumnIndicies.add(dataindex);
                continue;
            }
            String name = (String)o;
            if (!(name.charAt(0) != '\"' | name.charAt(name.length() - 1) != '\"')) continue;
            error = true;
            errornames = errornames + name + " ";
        }
        if (error) {
            Exception e = new Exception("Unrecognized column name : " + errornames);
            throw e;
        }
        if (searchedColumnIndicies != null) {
            this.usedColumnsIndicies = searchedColumnIndicies.toArray(new Integer[searchedColumnIndicies.size()]);
        }
    }

    private Object formatVariables(Object input) {
        if (input.getClass().equals(Global.stringclass.getClass())) {
            String str = '\"' + (String)input + '\"';
            return str;
        }
        if (input.getClass().equals(Global.charclass.getClass())) {
            String str = '\"' + input.toString() + '\"';
            return str;
        }
        if (input.getClass().equals(Global.integerclass.getClass())) {
            int i = (Integer)input;
            return (double)i;
        }
        if (input.getClass().equals(Global.doubleclass.getClass())) {
            return (Double)input;
        }
        if (input.getClass().equals(Global.booleanclass.getClass())) {
            boolean b = (Boolean)input;
            if (b) {
                return "\"TRUE\"";
            }
            return "\"FALSE\"";
        }
        return null;
    }

    private void generateSearchCondition(LinkedList s, int condcode, int maintype, String text) {
        if (condcode != -1) {
            s.add(condcode);
        }
        s.add(new Integer(3));
        s.add(Atom.DataList[maintype]);
        boolean readingnumber = false;
        boolean readingtext = false;
        boolean readingname = false;
        String currentread = "";
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\"') {
                if (readingtext) {
                    currentread = currentread + c;
                    s.add(currentread);
                    readingtext = false;
                    continue;
                }
                readingtext = true;
                currentread = "\"";
                continue;
            }
            if (readingtext) {
                currentread = currentread + c;
                continue;
            }
            if (c == ' ' && !readingtext) {
                if (readingnumber) {
                    readingnumber = false;
                    s.add(Double.parseDouble(currentread));
                }
                if (!readingname) continue;
                readingname = false;
                s.add(currentread);
                continue;
            }
            int opindex = Global.CharArrayFindIndex(operators, c);
            if (opindex != -1) {
                if (readingnumber) {
                    readingnumber = false;
                    s.add(Double.parseDouble(currentread));
                }
                if (readingname) {
                    readingname = false;
                    s.add(currentread);
                }
                s.add(opindex);
                if (opindex != 3) continue;
                s.add(Atom.DataList[maintype]);
                continue;
            }
            if (Character.isDigit(c) || readingnumber && c == '.' || !readingnumber && c == '-') {
                if (!readingnumber) {
                    readingnumber = true;
                    currentread = "";
                }
                currentread = currentread + c;
                continue;
            }
            if (!readingname) {
                readingname = true;
                currentread = "";
            }
            currentread = currentread + c;
        }
        if (readingnumber) {
            s.add(Double.parseDouble(currentread));
        }
        s.add(new Integer(4));
    }

    private void getSearchCriteria(ArrayList<Integer> cols, ArrayList<Integer> conds, ArrayList<String> texts) {
        if (!this.jTextFieldMain.getText().trim().equals("")) {
            texts.add(this.jTextFieldMain.getText().trim());
            cols.add(this.jComboBoxMain.getSelectedIndex());
            conds.add(-1);
        }
        for (int i = 0; i < this.searchCondCombos.size(); ++i) {
            if (this.searchFields.get(i).getText().trim().equals("")) continue;
            texts.add(this.searchFields.get(i).getText().trim());
            cols.add(this.searchTypeCombos.get(i).getSelectedIndex());
            conds.add(this.searchCondCombos.get(i).getSelectedIndex());
        }
    }

    private void initComponents() {
        this.jDialog1 = new JDialog();
        this.jScrollPane3 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jButton2 = new JButton();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jPanelSearch = new JPanel();
        this.jComboBoxMain = new JComboBox();
        this.jTextFieldMain = new JTextField();
        this.jButtonSearch = new JButton();
        this.jButtonClose = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel2 = new JPanel();
        this.jPanelSelectColumns = new JPanel();
        this.jButtonAllColumns = new JButton();
        this.jButtonNoColumns = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jTableFound = new JTable();
        this.jButtonHelp = new JButton();
        this.jButtonNext = new JButton();
        this.jButtonPrev = new JButton();
        this.jButtonGoto = new JButton();
        this.jDialog1.setTitle("Search and Select Help");
        this.jDialog1.setMinimumSize(new Dimension(400, 600));
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setRows(5);
        this.jTextArea1.setText("Search Select Conditions\n\nParanthesis are allowed (, )\n\n= : Equal\n! : Not equal\n> : Less than (Only applies to numbers)\n< : Greater than (Only applies to numbers)\n\n| : OR\n& : AND\n^ : XOR\n\n\"TRUE\" : checked for HeteroAtom\n\"FALSE\" : not checked for HeteroAtom\n\nExample,\nSelecting HeteroAtom\nand typing \n=\"TRUE\"\nwill search and select all atoms checked with hetero atom\n\nAll the names written residue names can be used for making conditions\nExample,\nEven if HeteroAtom is selected\nTyping\nResNum =255 | =257 & ChainID = \"A\"\nwill search and select all atom with residue number 255 and 257 in Chain A");
        this.jTextArea1.setWrapStyleWord(true);
        this.jScrollPane3.setViewportView(this.jTextArea1);
        this.jButton2.setText("Close");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchSelectDialog.this.jButton2ActionPerformed(evt);
            }
        });
        GroupLayout jDialog1Layout = new GroupLayout(this.jDialog1.getContentPane());
        this.jDialog1.getContentPane().setLayout(jDialog1Layout);
        jDialog1Layout.setHorizontalGroup(jDialog1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jDialog1Layout.createSequentialGroup().addContainerGap().addGroup(jDialog1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane3, GroupLayout.Alignment.LEADING, -1, 380, Short.MAX_VALUE).addComponent(this.jButton2)).addContainerGap()));
        jDialog1Layout.setVerticalGroup(jDialog1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jDialog1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane3, -1, 252, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2).addContainerGap()));
        this.setDefaultCloseOperation(2);
        this.setTitle("Search and Select ...");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent evt) {
                SearchSelectDialog.this.formWindowClosed(evt);
            }

            public void windowClosing(WindowEvent evt) {
                SearchSelectDialog.this.formWindowClosing(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Search Parameters"));
        this.jScrollPane1.setBorder(null);
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jPanelSearch.setLayout(new GridBagLayout());
        this.jComboBoxMain.setModel(this.dataTypeCombo);
        this.jComboBoxMain.setPreferredSize(new Dimension(200, 20));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(0, 0, 1, 5);
        this.jPanelSearch.add((Component)this.jComboBoxMain, gridBagConstraints);
        this.jTextFieldMain.setPreferredSize(new Dimension(270, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        this.jPanelSearch.add((Component)this.jTextFieldMain, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.jPanelSearch);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 487, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 100, Short.MAX_VALUE));
        this.jButtonSearch.setText("Search & Select");
        this.jButtonSearch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchSelectDialog.this.jButtonSearchActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchSelectDialog.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jPanelSelectColumns.setBorder(BorderFactory.createTitledBorder("Select Columns"));
        this.jPanelSelectColumns.setLayout(new GridLayout(7, 1));
        this.jButtonAllColumns.setText("All Columns");
        this.jButtonAllColumns.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchSelectDialog.this.jButtonAllColumnsActionPerformed(evt);
            }
        });
        this.jButtonNoColumns.setText("No Columns");
        this.jButtonNoColumns.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchSelectDialog.this.jButtonNoColumnsActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelSelectColumns, GroupLayout.Alignment.TRAILING, -1, 478, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.jButtonAllColumns).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonNoColumns))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jPanelSelectColumns, -2, 226, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonNoColumns).addComponent(this.jButtonAllColumns)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Select Columns", null, this.jPanel2, "Choose columns to be selected when coordinates are found");
        this.jTableFound.setModel(this.fCTData);
        this.jTableFound.setAutoResizeMode(0);
        this.jTableFound.setColumnSelectionAllowed(true);
        this.jScrollPane2.setViewportView(this.jTableFound);
        this.jTabbedPane1.addTab("Coordinates Found", this.jScrollPane2);
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchSelectDialog.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonNext.setText("Next");
        this.jButtonNext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchSelectDialog.this.jButtonNextActionPerformed(evt);
            }
        });
        this.jButtonPrev.setText("Prev");
        this.jButtonPrev.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchSelectDialog.this.jButtonPrevActionPerformed(evt);
            }
        });
        this.jButtonGoto.setText("Goto");
        this.jButtonGoto.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchSelectDialog.this.jButtonGotoActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonNext).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonPrev).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonGoto).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 91, Short.MAX_VALUE).addComponent(this.jButtonSearch).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClose).addGap(4, 4, 4)).addComponent(this.jTabbedPane1, -1, 503, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGap(11, 11, 11).addComponent(this.jTabbedPane1, -1, 291, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonSearch).addComponent(this.jButtonClose).addComponent(this.jButtonHelp).addComponent(this.jButtonNext).addComponent(this.jButtonPrev).addComponent(this.jButtonGoto)).addContainerGap()));
        this.jTabbedPane1.getAccessibleContext().setAccessibleName("Select Columns");
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonAllColumnsActionPerformed(ActionEvent evt) {
        this.checkSelectColumnCheckBoxes(true);
    }

    private void jButtonNoColumnsActionPerformed(ActionEvent evt) {
        this.checkSelectColumnCheckBoxes(false);
    }

    private void jButtonSearchActionPerformed(ActionEvent evt) {
        this.Run();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        this.jDialog1.show();
    }

    private void formWindowClosed(WindowEvent evt) {
        this.jDialog1.dispose();
    }

    private void formWindowClosing(WindowEvent evt) {
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.jDialog1.hide();
    }

    private void jButtonNextActionPerformed(ActionEvent evt) {
        if (this.focusIndex < this.foundCoordinateIndicies.length - 1) {
            ++this.focusIndex;
        }
        this.setFocusOnParent(this.focusIndex);
    }

    private void jButtonPrevActionPerformed(ActionEvent evt) {
        if (this.focusIndex > 0) {
            --this.focusIndex;
        }
        this.setFocusOnParent(this.focusIndex);
    }

    private void jButtonGotoActionPerformed(ActionEvent evt) {
        if (this.jTableFound.getSelectedRow() != -1) {
            this.focusIndex = this.jTableFound.getSelectedRow();
            this.setFocusOnParent(this.focusIndex);
        }
    }

    class CommonKeyListener
    implements KeyListener {
        CommonKeyListener() {
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                SearchSelectDialog.this.dispose();
            }
            if (e.getKeyCode() == 10) {
                SearchSelectDialog.this.Run();
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    }

    class inputListener
    implements DocumentListener {
        private boolean addnew = false;

        inputListener() {
        }

        public void insertUpdate(DocumentEvent e) {
            if (!this.addnew) {
                SearchSelectDialog.this.addSearchField();
            }
            this.addnew = true;
        }

        public void removeUpdate(DocumentEvent e) {
        }

        public void changedUpdate(DocumentEvent e) {
        }
    }

    class DataModel
    extends AbstractTableModel {
        private int[] columnWidth = null;

        public DataModel() {
            if (SearchSelectDialog.this.cTable != null) {
                this.columnWidth = SearchSelectDialog.this.cTable.getColumnWidths();
            }
        }

        public int getRowCount() {
            if (SearchSelectDialog.this.foundCoordinateIndicies != null) {
                return SearchSelectDialog.this.foundCoordinateIndicies.length;
            }
            return 0;
        }

        public int getColumnCount() {
            if (SearchSelectDialog.this.usedColumnsIndicies != null) {
                return SearchSelectDialog.this.usedColumnsIndicies.length;
            }
            return 0;
        }

        public String getColumnName(int col) {
            return Atom.DataList[SearchSelectDialog.this.usedColumnsIndicies[col]];
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            return SearchSelectDialog.this.maindata.Atoms().get(SearchSelectDialog.this.foundCoordinateIndicies[rowIndex]).TableData(SearchSelectDialog.this.usedColumnsIndicies[columnIndex]);
        }

        public Class getColumnClass(int col) {
            return Atom.DataClass[SearchSelectDialog.this.usedColumnsIndicies[col]];
        }

        public void setValueAt(Object value, int row, int col) {
            if (SearchSelectDialog.this.Parent != null) {
                SearchSelectDialog.this.Parent.listenForUndoStart("Select dialog edit");
            }
            int[] selrows = SearchSelectDialog.this.jTableFound.getSelectedRows();
            for (int i = 0; i < selrows.length; ++i) {
                SearchSelectDialog.this.maindata.Atoms().get(SearchSelectDialog.this.foundCoordinateIndicies[selrows[i]]).TableData(SearchSelectDialog.this.usedColumnsIndicies[col], value);
                this.fireTableCellUpdated(SearchSelectDialog.this.foundCoordinateIndicies[selrows[i]], col);
                SearchSelectDialog.this.cTable.fireTableRowUpdated(SearchSelectDialog.this.foundCoordinateIndicies[selrows[i]], SearchSelectDialog.this.foundCoordinateIndicies[selrows[i]]);
            }
            if (SearchSelectDialog.this.Parent != null) {
                SearchSelectDialog.this.Parent.listenForUndoStop();
            }
        }

        public boolean isCellEditable(int row, int col) {
            return !SearchSelectDialog.this.searchOnly;
        }

        public void SetColumnWidth() {
            TableColumn column = null;
            for (int i = 0; i < this.getColumnCount(); ++i) {
                column = SearchSelectDialog.this.jTableFound.getColumnModel().getColumn(i);
                column.setPreferredWidth(this.columnWidth[SearchSelectDialog.this.usedColumnsIndicies[i]]);
            }
        }
    }
}

