/*
 * Decompiled with CFR 0.152.
 */
package pdb_editor.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import pdb_editor.EditorFrame;
import pdb_editor.coordinate.CoordinateTable;
import pdb_reader.DataSet;
import pdb_reader.Global;
import pdb_reader.data.Atom;
import pdb_reader.data.Sequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditResidueNumberDialog
extends JDialog {
    private EditorFrame Parent = null;
    private CoordinateTable cTable = null;
    private DataSet maindata = null;
    private Sequence sequence = null;
    private ArrayList<ArrayList<Atom>> residuelist = null;
    private Object[][] changelist = null;
    private TableData tabledata = null;
    private TableRenderer tablecellrenderer = new TableRenderer();
    private ButtonGroup buttonGroupOptChainID;
    private ButtonGroup buttonGroupOptResNum;
    private JButton jButtonApply;
    private JButton jButtonClose;
    private JCheckBox jCheckBoxChainIDSynchronize;
    private JCheckBox jCheckBoxNumberSynchronizeChains;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JRadioButton jRadioButtonChainIgnore;
    private JRadioButton jRadioButtonChainMove;
    private JRadioButton jRadioButtonChainShift;
    private JRadioButton jRadioButtonNumberIgnoreConflict;
    private JRadioButton jRadioButtonNumberResolveAutomatic;
    private JRadioButton jRadioButtonNumberSynchronize;
    private JScrollPane jScrollPane1;
    private JTable jTable;

    public EditResidueNumberDialog(Frame parent, boolean modal, CoordinateTable ctable) {
        super(parent, modal);
        try {
            this.Parent = (EditorFrame)parent;
        }
        catch (Exception e) {
            // empty catch block
        }
        this.cTable = ctable;
        this.maindata = this.cTable.getMainData();
        this.initData();
        this.initComponents();
        this.buttonGroupOptChainID.add(this.jRadioButtonChainIgnore);
        this.buttonGroupOptChainID.add(this.jRadioButtonChainMove);
        this.buttonGroupOptChainID.add(this.jRadioButtonChainShift);
        this.buttonGroupOptResNum.add(this.jRadioButtonNumberIgnoreConflict);
        this.buttonGroupOptResNum.add(this.jRadioButtonNumberResolveAutomatic);
        this.buttonGroupOptResNum.add(this.jRadioButtonNumberSynchronize);
    }

    private void initData() {
        this.sequence = new Sequence(this.maindata.Atoms());
        this.residuelist = this.sequence.getLinearList();
        this.changelist = new Object[this.residuelist.size()][4];
        this.tabledata = new TableData();
        if (this.jTable != null) {
            this.jTable.setModel(this.tabledata);
        }
    }

    private void ApplyChanges() {
        if (this.Parent != null) {
            this.Parent.listenForUndoStart("Edit ResNum / ChainID");
        }
        int row = 0;
        Iterator<ArrayList<Atom>> i = this.residuelist.iterator();
        while (i.hasNext()) {
            for (Atom a : i.next()) {
                if (this.changelist[row][0] != null) {
                    a.ChainID(((Character)this.changelist[row][0]).charValue());
                }
                if (this.changelist[row][1] == null) continue;
                a.ResidueNumber((Integer)this.changelist[row][1]);
            }
            ++row;
        }
        if (this.Parent != null) {
            this.Parent.listenForUndoStop();
        }
        this.cTable.fireTableDataChanged();
        this.initData();
    }

    private void UpdateDataChange() {
        this.ResetPreviousOptionChanges();
        this.ApplyResidueNumberOptions();
        this.ApplyChainIDOptions();
        this.tabledata.fireTableDataChanged();
    }

    private void ResetPreviousOptionChanges() {
        for (int i = 0; i < this.changelist.length; ++i) {
            if (this.changelist[i][2] == null) {
                this.changelist[i][0] = null;
            }
            if (this.changelist[i][3] != null) continue;
            this.changelist[i][1] = null;
        }
    }

    private void ApplyChainIDOptions() {
        if (this.jRadioButtonChainMove.isSelected()) {
            this.ResolveByChainMove();
        }
        if (this.jRadioButtonChainShift.isSelected()) {
            this.ResolveByChainShift();
        }
        if (this.jCheckBoxChainIDSynchronize.isSelected()) {
            this.SynchronizeChainIDChange();
        }
    }

    private void ResolveByChainMove() {
        TreeSet<Character> targets = this.FindConflictingChain();
        TreeSet<Character> used = new TreeSet<Character>(this.sequence.data().keySet());
        TreeMap<Character, Character> correction = new TreeMap<Character, Character>();
        Iterator<Character> i = targets.iterator();
        while (i.hasNext()) {
            char c;
            char original = c = i.next().charValue();
            while (used.contains(Character.valueOf(c))) {
                c = (char)(c + '\u0001');
            }
            correction.put(Character.valueOf(original), Character.valueOf(c));
            used.add(Character.valueOf(c));
        }
        this.RecordChainCorrection(correction);
    }

    private void RecordChainCorrection(TreeMap<Character, Character> input) {
        for (int i = 0; i < this.changelist.length; ++i) {
            Atom a = this.residuelist.get(i).get(0);
            char c = a.ChainID();
            if (!input.containsKey(Character.valueOf(c)) || this.changelist[i][2] != null) continue;
            this.changelist[i][0] = input.get(Character.valueOf(c));
        }
    }

    private TreeSet<Character> FindConflictingChain() {
        TreeSet<Character> result = new TreeSet<Character>();
        for (int i = 0; i < this.changelist.length; ++i) {
            if (this.changelist[i][2] == null) continue;
            Atom a = this.residuelist.get(i).get(0);
            char chain = ((Character)this.changelist[i][0]).charValue();
            int resnum = a.ResidueNumber();
            if (this.changelist[i][1] != null) {
                resnum = (Integer)this.changelist[i][1];
            }
            if (!this.sequence.checkResidueExist(chain, resnum)) continue;
            result.add(Character.valueOf(chain));
        }
        return result;
    }

    private TreeSet<Character> FindForbiddenChain() {
        TreeSet<Character> result = new TreeSet<Character>();
        for (int i = 0; i < this.changelist.length; ++i) {
            if (this.changelist[i][2] == null) continue;
            Atom a = this.residuelist.get(i).get(0);
            char chain = ((Character)this.changelist[i][0]).charValue();
            int resnum = a.ResidueNumber();
            if (this.changelist[i][1] != null) {
                resnum = (Integer)this.changelist[i][1];
            }
            result.add(Character.valueOf(a.ChainID()));
            result.add(Character.valueOf(chain));
        }
        return result;
    }

    private void ResolveByChainShift() {
        TreeSet<Character> targets = this.FindConflictingChain();
        TreeSet<Character> used = new TreeSet<Character>(this.sequence.data().keySet());
        TreeMap<Character, Character> correction = new TreeMap<Character, Character>();
        TreeSet<Character> forbidden = this.FindForbiddenChain();
        used.removeAll(forbidden);
        used.addAll(targets);
        Iterator<Character> i = used.iterator();
        while (i.hasNext()) {
            char c;
            char original = c = i.next().charValue();
            while (forbidden.contains(Character.valueOf(c))) {
                c = (char)(c + '\u0001');
            }
            if (original != c) {
                correction.put(Character.valueOf(original), Character.valueOf(c));
            }
            forbidden.add(Character.valueOf(c));
        }
        this.RecordChainCorrection(correction);
    }

    private void SynchronizeChainIDChange() {
        TreeSet<Character> changed = new TreeSet<Character>();
        for (int i = 0; i < this.changelist.length; ++i) {
            char targetchain;
            if (this.changelist[i][2] == null || changed.contains(Character.valueOf(targetchain = this.residuelist.get(i).get(0).ChainID()))) continue;
            char newchainid = ((Character)this.changelist[i][0]).charValue();
            Iterator<ArrayList<Atom>> j = this.residuelist.iterator();
            int counter = 0;
            while (j.hasNext()) {
                Atom a = j.next().get(0);
                if (a.ChainID() == targetchain && this.changelist[counter][2] == null) {
                    this.changelist[counter][0] = Character.valueOf(newchainid);
                }
                ++counter;
            }
            changed.add(Character.valueOf(targetchain));
        }
    }

    private void ApplyResidueNumberOptions() {
        if (this.jRadioButtonNumberResolveAutomatic.isSelected()) {
            this.ResolveResNumAutomatically();
        }
        if (this.jRadioButtonNumberSynchronize.isSelected()) {
            this.SynchronizeResNumChange();
        }
        if (this.jCheckBoxNumberSynchronizeChains.isSelected()) {
            this.SynchronizeResidueNumberChangeBetweenChains();
        }
    }

    private void ResolveResNumAutomatically() {
        char c;
        Atom a;
        int i;
        TreeMap<Character, TreeMap<Integer, Integer[]>> usedlist = new TreeMap<Character, TreeMap<Integer, Integer[]>>();
        for (i = 0; i < this.residuelist.size(); ++i) {
            a = this.residuelist.get(i).get(0);
            c = a.ChainID();
            int n = a.ResidueNumber();
            if (this.changelist[i][3] != null) {
                n = -i;
            }
            if (!usedlist.containsKey(Character.valueOf(c))) {
                usedlist.put(Character.valueOf(c), new TreeMap());
            }
            ((TreeMap)usedlist.get(Character.valueOf(c))).put(n, new Integer[]{n, i, null});
        }
        for (i = 0; i < this.changelist.length; ++i) {
            if (this.changelist[i][3] == null) continue;
            a = this.residuelist.get(i).get(0);
            c = a.ChainID();
            int newn = (Integer)this.changelist[i][1];
            ((Integer[])((TreeMap)usedlist.get((Object)Character.valueOf((char)c))).get((Object)Integer.valueOf((int)(-i))))[2] = 1;
            this.CorrectResNumConflict(usedlist, c, -i, newn);
        }
        for (TreeMap d : usedlist.values()) {
            Iterator j = d.keySet().iterator();
            while (j.hasNext()) {
                int value = (Integer)j.next();
                Integer[] data = (Integer[])d.get(value);
                if (value == ((Integer[])d.get(value))[0]) continue;
                int index = ((Integer[])d.get(value))[1];
                this.changelist[index][1] = value;
            }
        }
    }

    private void CorrectResNumConflict(TreeMap<Character, TreeMap<Integer, Integer[]>> usedlist, char c, int oldn, int newn) {
        boolean cont;
        if (usedlist.get(Character.valueOf(c)).containsKey(newn)) {
            int nextnum = newn;
            TreeMap<Integer, Integer[]> map = usedlist.get(Character.valueOf(c));
            cont = true;
            while (cont) {
                cont = false;
                if (!map.containsKey(++nextnum) || map.get(nextnum)[2] == null) continue;
                cont = true;
            }
            this.CorrectResNumConflict(usedlist, c, newn, nextnum);
        }
        TreeMap<Integer, Integer[]> map = usedlist.get(Character.valueOf(c));
        Integer[] data = map.get(oldn);
        cont = false;
        if (data[2] == null) {
            cont = true;
        }
        if (data[2] != null && data[2] != 2) {
            cont = true;
        }
        if (cont) {
            if (data[2] != null && data[2] == 1) {
                data[2] = 2;
            }
            map.remove(oldn);
            map.put(newn, data);
        }
    }

    private void SynchronizeResNumChange() {
        TreeSet<Character> changed = new TreeSet<Character>();
        for (int i = 0; i < this.changelist.length; ++i) {
            Atom a;
            if (this.changelist[i][3] == null || changed.contains(Character.valueOf((a = this.residuelist.get(i).get(0)).ChainID()))) continue;
            int diff = (Integer)this.changelist[i][1] - a.ResidueNumber();
            for (int j = 0; j < this.residuelist.size(); ++j) {
                Atom b = this.residuelist.get(j).get(0);
                if (b.ChainID() != a.ChainID()) continue;
                if (b.ResidueNumber() + diff < 0) break;
                if (this.changelist[j][3] != null) continue;
                this.changelist[j][1] = b.ResidueNumber() + diff;
            }
            changed.add(Character.valueOf(a.ChainID()));
        }
    }

    private void SynchronizeResidueNumberChangeBetweenChains() {
        Atom a;
        int i;
        TreeMap<Integer, Object[]> changemap = new TreeMap<Integer, Object[]>();
        for (i = 0; i < this.changelist.length; ++i) {
            if (this.changelist[i][1] == null) continue;
            a = this.residuelist.get(i).get(0);
            changemap.put(a.ResidueNumber(), new Object[]{a.ResidueType(), this.changelist[i][1]});
        }
        for (i = 0; i < this.changelist.length; ++i) {
            a = this.residuelist.get(i).get(0);
            if (!changemap.containsKey(a.ResidueNumber()) || !a.ResidueType().equals(((Object[])changemap.get(a.ResidueNumber()))[0]) || this.changelist[i][3] != null) continue;
            this.changelist[i][1] = ((Object[])changemap.get(a.ResidueNumber()))[1];
        }
    }

    private void initComponents() {
        this.buttonGroupOptChainID = new ButtonGroup();
        this.buttonGroupOptResNum = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.jTable = new JTable(){

            public TableCellRenderer getCellRenderer(int row, int column) {
                return EditResidueNumberDialog.this.tablecellrenderer;
            }
        };
        this.jPanel1 = new JPanel();
        this.jRadioButtonNumberResolveAutomatic = new JRadioButton();
        this.jRadioButtonNumberSynchronize = new JRadioButton();
        this.jRadioButtonNumberIgnoreConflict = new JRadioButton();
        this.jCheckBoxNumberSynchronizeChains = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.jCheckBoxChainIDSynchronize = new JCheckBox();
        this.jRadioButtonChainIgnore = new JRadioButton();
        this.jRadioButtonChainMove = new JRadioButton();
        this.jRadioButtonChainShift = new JRadioButton();
        this.jButtonClose = new JButton();
        this.jButtonApply = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Edit Residue Number");
        this.jTable.setModel(this.tabledata);
        this.jTable.setCellSelectionEnabled(true);
        this.jScrollPane1.setViewportView(this.jTable);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Residue Number Edit Option"));
        this.jRadioButtonNumberResolveAutomatic.setSelected(true);
        this.jRadioButtonNumberResolveAutomatic.setText("Resolve conflicts by increasing residue numbers");
        this.jRadioButtonNumberResolveAutomatic.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditResidueNumberDialog.this.jRadioButtonNumberResolveAutomaticActionPerformed(evt);
            }
        });
        this.jRadioButtonNumberSynchronize.setText("Synchronize change in the chain (1 to 5 will make all residues change by +4)");
        this.jRadioButtonNumberSynchronize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditResidueNumberDialog.this.jRadioButtonNumberResolveAutomaticActionPerformed(evt);
            }
        });
        this.jRadioButtonNumberIgnoreConflict.setText("Change one residue at a time (Ignore conflicts)");
        this.jRadioButtonNumberIgnoreConflict.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditResidueNumberDialog.this.jRadioButtonNumberResolveAutomaticActionPerformed(evt);
            }
        });
        this.jCheckBoxNumberSynchronizeChains.setText("Synchronize residue number change to other chains if residue is same");
        this.jCheckBoxNumberSynchronizeChains.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditResidueNumberDialog.this.jRadioButtonNumberResolveAutomaticActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonNumberResolveAutomatic).addComponent(this.jRadioButtonNumberIgnoreConflict).addComponent(this.jRadioButtonNumberSynchronize).addComponent(this.jCheckBoxNumberSynchronizeChains)).addContainerGap(47, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jRadioButtonNumberResolveAutomatic).addGap(3, 3, 3).addComponent(this.jRadioButtonNumberSynchronize, -2, 15, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonNumberIgnoreConflict).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxNumberSynchronizeChains)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Chain ID Edit Option"));
        this.jCheckBoxChainIDSynchronize.setSelected(true);
        this.jCheckBoxChainIDSynchronize.setText("Synchronize chain ID change to all residues in the chain");
        this.jCheckBoxChainIDSynchronize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditResidueNumberDialog.this.jRadioButtonNumberResolveAutomaticActionPerformed(evt);
            }
        });
        this.jRadioButtonChainIgnore.setSelected(true);
        this.jRadioButtonChainIgnore.setText("Ignore conflicts");
        this.jRadioButtonChainIgnore.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditResidueNumberDialog.this.jRadioButtonNumberResolveAutomaticActionPerformed(evt);
            }
        });
        this.jRadioButtonChainMove.setText("Resolve conflicts by changing affected chain ID automatically to available one");
        this.jRadioButtonChainMove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditResidueNumberDialog.this.jRadioButtonNumberResolveAutomaticActionPerformed(evt);
            }
        });
        this.jRadioButtonChainShift.setText("Resolve conflicts by shifting all affected chain IDs");
        this.jRadioButtonChainShift.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditResidueNumberDialog.this.jRadioButtonNumberResolveAutomaticActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonChainIgnore).addComponent(this.jRadioButtonChainMove).addComponent(this.jRadioButtonChainShift).addComponent(this.jCheckBoxChainIDSynchronize)).addContainerGap(39, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jRadioButtonChainIgnore).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonChainMove).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonChainShift).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxChainIDSynchronize, -2, 23, -2)));
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditResidueNumberDialog.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonApply.setText("Apply Changes");
        this.jButtonApply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditResidueNumberDialog.this.jButtonApplyActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 458, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButtonApply).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClose))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 295, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonApply).addComponent(this.jButtonClose)).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonApplyActionPerformed(ActionEvent evt) {
        this.ApplyChanges();
    }

    private void jRadioButtonNumberResolveAutomaticActionPerformed(ActionEvent evt) {
        this.UpdateDataChange();
    }

    private class TableRenderer
    extends DefaultTableCellRenderer {
        private TableRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            super.getTableCellRendererComponent(jTable, value, isSelected, hasFocus, row, col);
            if (col == 3 || col == 4) {
                if (EditResidueNumberDialog.this.changelist[row][col - 3] != null) {
                    if (EditResidueNumberDialog.this.changelist[row][col - 1] == null) {
                        if (isSelected) {
                            this.setBackground(Color.GREEN);
                        } else {
                            this.setBackground(Color.ORANGE);
                        }
                        return this;
                    }
                    return this.IsSelectedDefault(isSelected);
                }
                return this.IsSelectedDefault(isSelected);
            }
            return this.IsSelectedDefault(isSelected);
        }

        private Component IsSelectedDefault(boolean isit) {
            if (isit) {
                return this;
            }
            this.setBackground(Color.WHITE);
            return this;
        }
    }

    private class TableData
    extends AbstractTableModel {
        private TableData() {
        }

        public int getRowCount() {
            return EditResidueNumberDialog.this.residuelist.size();
        }

        public int getColumnCount() {
            return 5;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return Atom.DataToolTip[7];
                }
                case 1: {
                    return Atom.DataToolTip[8];
                }
                case 2: {
                    return Atom.DataToolTip[6];
                }
                case 3: {
                    return "New " + Atom.DataToolTip[7];
                }
                case 4: {
                    return "New " + Atom.DataToolTip[8];
                }
            }
            return "";
        }

        public Class getColumnClass(int col) {
            switch (col) {
                case 0: {
                    return Global.stringclass.getClass();
                }
                case 1: {
                    return Global.stringclass.getClass();
                }
                case 2: {
                    return Global.stringclass.getClass();
                }
                case 3: {
                    return Global.stringclass.getClass();
                }
                case 4: {
                    return Atom.DataClass[8];
                }
            }
            return null;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Character.valueOf(((Atom)((ArrayList)EditResidueNumberDialog.this.residuelist.get(rowIndex)).get(0)).ChainID());
                }
                case 1: {
                    return ((Atom)((ArrayList)EditResidueNumberDialog.this.residuelist.get(rowIndex)).get(0)).ResidueNumber();
                }
                case 2: {
                    return ((Atom)((ArrayList)EditResidueNumberDialog.this.residuelist.get(rowIndex)).get(0)).ResidueType();
                }
                case 3: {
                    return EditResidueNumberDialog.this.changelist[rowIndex][0];
                }
                case 4: {
                    return EditResidueNumberDialog.this.changelist[rowIndex][1];
                }
            }
            return null;
        }

        public boolean isCellEditable(int row, int col) {
            switch (col) {
                case 3: {
                    return true;
                }
                case 4: {
                    return true;
                }
            }
            return false;
        }

        public void setValueAt(Object value, int row, int col) {
            String s;
            int[] selrows = EditResidueNumberDialog.this.jTable.getSelectedRows();
            if (col == 3 && (s = (String)value) != null) {
                value = s.length() > 0 ? Character.valueOf(s.charAt(0)) : null;
            }
            if (col == 4 && value != null) {
                int index = Global.IntegerArrayFindIndex(selrows, row);
                value = (Integer)value - index;
            }
            for (int i = 0; i < selrows.length; ++i) {
                Atom a = (Atom)((ArrayList)EditResidueNumberDialog.this.residuelist.get(selrows[i])).get(0);
                if (value != null) {
                    if (col == 3 && value.equals(Character.valueOf(a.ChainID()))) {
                        value = null;
                    }
                    if (col == 4 && value.equals(a.ResidueNumber())) {
                        value = null;
                    }
                }
                ((EditResidueNumberDialog)EditResidueNumberDialog.this).changelist[selrows[i]][col - 3] = value;
                ((EditResidueNumberDialog)EditResidueNumberDialog.this).changelist[selrows[i]][col - 1] = value != null ? Boolean.valueOf(true) : null;
                this.fireTableCellUpdated(selrows[i], col);
                if (col != 4 || value == null) continue;
                value = (Integer)value + 1;
            }
            EditResidueNumberDialog.this.UpdateDataChange();
        }
    }
}

