/*
 * Decompiled with CFR 0.152.
 */
package pdb_editor.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import pdb_editor.EditorFrame;
import pdb_reader.DataSet;
import pdb_reader.Global;
import pdb_reader.data.spacegroup.SpaceGroup;

public class EditSpacegroupDialog
extends JDialog {
    private DataSet maindata = null;
    private SpaceGroup sg = null;
    private EditorFrame Parent = null;
    private JButton jButtonCancel;
    private JButton jButtonCorrectCellParameters;
    private JButton jButtonOK;
    private JButton jButtonRevertAll;
    private JButton jButtonRevertScale;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabela;
    private JLabel jLabelalpha;
    private JLabel jLabelb;
    private JLabel jLabelbeta;
    private JLabel jLabelc;
    private JLabel jLabelgamma;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextArea jTextAreaScale;
    private JTextArea jTextAreaSpaceGroupInformation;
    private JTextField jTextFieldNumber;
    private JTextField jTextFieldSpacegroup;
    private JTextField jTextFielda;
    private JTextField jTextFieldalpha;
    private JTextField jTextFieldb;
    private JTextField jTextFieldbeta;
    private JTextField jTextFieldc;
    private JTextField jTextFieldgamma;

    public EditSpacegroupDialog(Frame parent, boolean modal, DataSet MainData) {
        super(parent, modal);
        try {
            this.Parent = (EditorFrame)parent;
        }
        catch (Exception e) {
            // empty catch block
        }
        this.initComponents();
        this.maindata = MainData;
        if (this.maindata.Spacegroup() != null) {
            this.sg = this.maindata.Spacegroup().clone();
        } else {
            this.sg = new SpaceGroup();
            this.sg.scale(new double[4][4]);
        }
        this.initTextFields();
    }

    public EditSpacegroupDialog(Frame parent, boolean modal, DataSet MainData, SpaceGroup newsg) {
        super(parent, modal);
        this.initComponents();
        this.maindata = MainData;
        this.sg = newsg;
        this.initTextFields();
    }

    private void initTextFields() {
        if (this.sg != null) {
            this.jTextFieldSpacegroup.setText(this.sg.name());
            this.jTextFieldNumber.setText("" + this.sg.number());
            this.jTextFielda.setText("" + this.sg.a());
            this.jTextFieldb.setText("" + this.sg.b());
            this.jTextFieldc.setText("" + this.sg.c());
            this.jTextFieldalpha.setText("" + this.sg.alpha());
            this.jTextFieldbeta.setText("" + this.sg.beta());
            this.jTextFieldgamma.setText("" + this.sg.gamma());
            this.initScaleMatrix();
            this.jTextAreaSpaceGroupInformation.setText(this.sg.SpaceGroupInformation());
        } else {
            this.jButtonRevertScale.setEnabled(false);
            this.jButtonRevertAll.setEnabled(false);
        }
    }

    private void initScaleMatrix() {
        double[][] scale = null;
        scale = this.sg.scale();
        if (scale == null) {
            scale = this.sg.scale(Global.GenerateScaleMatrix(this.GetCurrentUnitcellParameters()));
        }
        this.DisplayFormattedMatrix(scale);
    }

    private void DisplayFormattedMatrix(double[][] matrix4x4) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 3; ++i) {
            sb.append("[ ");
            for (int j = 0; j < 4; ++j) {
                sb.append(String.format("%-16.9f", matrix4x4[i][j]));
                sb.append(' ');
            }
            if (i != 2) {
                sb.append("]\n");
                continue;
            }
            sb.append(']');
        }
        this.jTextAreaScale.setText(sb.toString());
    }

    private boolean UpdateInformation() {
        try {
            this.sg.name(this.jTextFieldSpacegroup.getText());
            this.sg.number(Integer.parseInt(this.jTextFieldNumber.getText()));
            this.sg.a(Double.parseDouble(this.jTextFielda.getText()));
            this.sg.b(Double.parseDouble(this.jTextFieldb.getText()));
            this.sg.c(Double.parseDouble(this.jTextFieldc.getText()));
            this.sg.alpha(Double.parseDouble(this.jTextFieldalpha.getText()));
            this.sg.beta(Double.parseDouble(this.jTextFieldbeta.getText()));
            this.sg.gamma(Double.parseDouble(this.jTextFieldgamma.getText()));
        }
        catch (Exception e) {
            return false;
        }
        try {
            this.sg.scale(Global.GenerateTransformationMatrix(Global.ExtractAllNumbers(this.jTextAreaScale.getText())));
        }
        catch (Exception e) {
            this.sg.scale(Global.GenerateScaleMatrix(this.GetCurrentUnitcellParameters()));
        }
        return true;
    }

    private void WriteFinalInformation() {
        if (this.maindata.Spacegroup() == null) {
            this.maindata.Spacegroup(new SpaceGroup());
        }
        SpaceGroup d = this.maindata.Spacegroup();
        d.name(this.sg.name());
        d.number(this.sg.number());
        d.a(this.sg.a());
        d.b(this.sg.b());
        d.c(this.sg.c());
        d.alpha(this.sg.alpha());
        d.beta(this.sg.beta());
        d.gamma(this.sg.gamma());
        d.scale(this.sg.scale());
        this.maindata.UpdateScaleMatrixChange();
    }

    private double[] GetCurrentUnitcellParameters() {
        return new double[]{Double.parseDouble(this.jTextFielda.getText()), Double.parseDouble(this.jTextFieldb.getText()), Double.parseDouble(this.jTextFieldc.getText()), Double.parseDouble(this.jTextFieldalpha.getText()), Double.parseDouble(this.jTextFieldbeta.getText()), Double.parseDouble(this.jTextFieldgamma.getText())};
    }

    private void CheckCellParametersUpdateMatrix() {
        if (this.UpdateInformation()) {
            this.ReportCellParameterError(!this.sg.isfCellParametersCorrect());
            this.sg.scale(Global.GenerateScaleMatrix(this.GetCurrentUnitcellParameters()));
            this.DisplayFormattedMatrix(this.sg.scale());
        } else {
            this.ReportCellParameterError(true);
        }
    }

    private void CheckCellParameters() {
        if (this.UpdateInformation()) {
            this.ReportCellParameterError(!this.sg.isfCellParametersCorrect());
        } else {
            this.ReportCellParameterError(true);
        }
    }

    private void ReportCellParameterError(boolean error) {
        if (error) {
            this.jLabela.setForeground(Color.RED);
            this.jLabelb.setForeground(Color.RED);
            this.jLabelc.setForeground(Color.RED);
            this.jLabelalpha.setForeground(Color.RED);
            this.jLabelbeta.setForeground(Color.RED);
            this.jLabelgamma.setForeground(Color.RED);
        } else {
            this.jLabela.setForeground(Color.BLACK);
            this.jLabelb.setForeground(Color.BLACK);
            this.jLabelc.setForeground(Color.BLACK);
            this.jLabelalpha.setForeground(Color.BLACK);
            this.jLabelbeta.setForeground(Color.BLACK);
            this.jLabelgamma.setForeground(Color.BLACK);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextFieldSpacegroup = new JTextField();
        this.jLabel2 = new JLabel();
        this.jTextFieldNumber = new JTextField();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaScale = new JTextArea();
        this.jButtonRevertScale = new JButton();
        this.jPanel3 = new JPanel();
        this.jLabela = new JLabel();
        this.jLabelalpha = new JLabel();
        this.jLabelbeta = new JLabel();
        this.jLabelb = new JLabel();
        this.jLabelc = new JLabel();
        this.jLabelgamma = new JLabel();
        this.jTextFielda = new JTextField();
        this.jTextFieldc = new JTextField();
        this.jTextFieldb = new JTextField();
        this.jTextFieldgamma = new JTextField();
        this.jTextFieldalpha = new JTextField();
        this.jTextFieldbeta = new JTextField();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonRevertAll = new JButton();
        this.jPanel4 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jTextAreaSpaceGroupInformation = new JTextArea();
        this.jButtonCorrectCellParameters = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Edit Spacegroup & Unit Cell");
        this.setResizable(false);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Space Group"));
        this.jLabel1.setText("Spacegroup :");
        this.jTextFieldSpacegroup.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                EditSpacegroupDialog.this.jTextFieldSpacegroupFocusLost(evt);
            }
        });
        this.jLabel2.setText("Number :");
        this.jTextFieldNumber.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                EditSpacegroupDialog.this.jTextFieldNumberFocusLost(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldSpacegroup, -2, 80, -2).addGap(28, 28, 28).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldNumber, -2, 56, -2).addContainerGap(86, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldSpacegroup, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.jTextFieldNumber, -2, -1, -2).addComponent(this.jLabel1)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Scale Matrix"));
        this.jTextAreaScale.setColumns(20);
        this.jTextAreaScale.setRows(4);
        this.jScrollPane1.setViewportView(this.jTextAreaScale);
        this.jButtonRevertScale.setText("Revert Matrix");
        this.jButtonRevertScale.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditSpacegroupDialog.this.jButtonRevertScaleActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 376, Short.MAX_VALUE).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jButtonRevertScale).addContainerGap(277, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 77, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonRevertScale)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Unitcell Parameters"));
        this.jPanel3.setPreferredSize(new Dimension(80, 20));
        this.jPanel3.setLayout(new GridBagLayout());
        this.jLabela.setText("a ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 8, 7, 8);
        this.jPanel3.add((Component)this.jLabela, gridBagConstraints);
        this.jLabelalpha.setText("alpha");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 8, 0, 8);
        this.jPanel3.add((Component)this.jLabelalpha, gridBagConstraints);
        this.jLabelbeta.setText("beta");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 8, 0, 8);
        this.jPanel3.add((Component)this.jLabelbeta, gridBagConstraints);
        this.jLabelb.setText("b");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 8, 7, 8);
        this.jPanel3.add((Component)this.jLabelb, gridBagConstraints);
        this.jLabelc.setText("c");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 8, 7, 8);
        this.jPanel3.add((Component)this.jLabelc, gridBagConstraints);
        this.jLabelgamma.setText("gamma");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 8, 0, 8);
        this.jPanel3.add((Component)this.jLabelgamma, gridBagConstraints);
        this.jTextFielda.setPreferredSize(new Dimension(80, 20));
        this.jTextFielda.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                EditSpacegroupDialog.this.jTextFieldaKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 7, 0);
        this.jPanel3.add((Component)this.jTextFielda, gridBagConstraints);
        this.jTextFieldc.setPreferredSize(new Dimension(80, 20));
        this.jTextFieldc.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                EditSpacegroupDialog.this.jTextFieldcKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 7, 0);
        this.jPanel3.add((Component)this.jTextFieldc, gridBagConstraints);
        this.jTextFieldb.setPreferredSize(new Dimension(80, 20));
        this.jTextFieldb.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                EditSpacegroupDialog.this.jTextFieldbKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 7, 0);
        this.jPanel3.add((Component)this.jTextFieldb, gridBagConstraints);
        this.jTextFieldgamma.setPreferredSize(new Dimension(80, 20));
        this.jTextFieldgamma.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                EditSpacegroupDialog.this.jTextFieldgammaKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.jPanel3.add((Component)this.jTextFieldgamma, gridBagConstraints);
        this.jTextFieldalpha.setPreferredSize(new Dimension(80, 20));
        this.jTextFieldalpha.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                EditSpacegroupDialog.this.jTextFieldalphaKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.jPanel3.add((Component)this.jTextFieldalpha, gridBagConstraints);
        this.jTextFieldbeta.setPreferredSize(new Dimension(80, 20));
        this.jTextFieldbeta.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                EditSpacegroupDialog.this.jTextFieldbetaKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.jPanel3.add((Component)this.jTextFieldbeta, gridBagConstraints);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditSpacegroupDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditSpacegroupDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonRevertAll.setText("Revert All");
        this.jButtonRevertAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditSpacegroupDialog.this.jButtonRevertAllActionPerformed(evt);
            }
        });
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("Space Group Information"));
        this.jTextAreaSpaceGroupInformation.setColumns(20);
        this.jTextAreaSpaceGroupInformation.setEditable(false);
        this.jTextAreaSpaceGroupInformation.setRows(5);
        this.jScrollPane2.setViewportView(this.jTextAreaSpaceGroupInformation);
        this.jButtonCorrectCellParameters.setText("Correct Cell Parameters");
        this.jButtonCorrectCellParameters.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditSpacegroupDialog.this.jButtonCorrectCellParametersActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jButtonCorrectCellParameters)).addComponent(this.jScrollPane2, -1, 376, Short.MAX_VALUE));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addComponent(this.jScrollPane2, -1, 161, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCorrectCellParameters)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel4, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, GroupLayout.Alignment.LEADING, -1, 392, Short.MAX_VALUE).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jButtonRevertAll).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 171, Short.MAX_VALUE).addComponent(this.jButtonOK, -2, 69, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel).addGap(2, 2, 2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addGap(3, 3, 3).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonRevertAll).addComponent(this.jButtonOK).addComponent(this.jButtonCancel)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.UpdateInformation()) {
            this.WriteFinalInformation();
            this.maindata.UpdateScaleMatrixChange();
            if (this.Parent != null) {
                this.Parent.dataChangeNotSaved = true;
            }
            this.dispose();
        } else {
            JOptionPane.showMessageDialog(this, "Error in input", "Error", 0);
        }
    }

    private void jButtonRevertScaleActionPerformed(ActionEvent evt) {
        this.initScaleMatrix();
    }

    private void jButtonRevertAllActionPerformed(ActionEvent evt) {
        this.sg = this.maindata.Spacegroup().clone();
        this.initTextFields();
    }

    private void jButtonCorrectCellParametersActionPerformed(ActionEvent evt) {
        this.UpdateInformation();
        this.sg.CorrectCellParameters();
        this.initTextFields();
        this.CheckCellParametersUpdateMatrix();
    }

    private void jTextFieldSpacegroupFocusLost(FocusEvent evt) {
        String sgname = this.jTextFieldSpacegroup.getText().trim();
        if (sgname != null && sgname.length() > 1) {
            sgname = Character.toUpperCase(sgname.charAt(0)) + sgname.substring(1);
            this.jTextFieldSpacegroup.setText(sgname);
        }
        if (SpaceGroup.SpaceGroupTableByName.containsKey(sgname)) {
            this.jTextFieldNumber.setText("" + SpaceGroup.SpaceGroupTableByName.get((Object)sgname).CCP4Number);
            this.UpdateInformation();
            this.initTextFields();
            this.CheckCellParameters();
        } else {
            JOptionPane.showMessageDialog(this, "Unrecognized space group", "Error", 0);
        }
    }

    private void jTextFieldaKeyReleased(KeyEvent evt) {
        this.CheckCellParameters();
    }

    private void jTextFieldNumberFocusLost(FocusEvent evt) {
        int sgnum = Integer.parseInt(this.jTextFieldNumber.getText());
        if (SpaceGroup.SpaceGroupTableByNumber.containsKey(sgnum)) {
            this.jTextFieldSpacegroup.setText(SpaceGroup.SpaceGroupTableByNumber.get((Object)Integer.valueOf((int)sgnum)).Name);
            this.UpdateInformation();
            this.initTextFields();
            this.CheckCellParameters();
        } else {
            JOptionPane.showMessageDialog(this, "Unrecognized space group", "Error", 0);
        }
    }

    private void jTextFieldbKeyReleased(KeyEvent evt) {
        this.CheckCellParametersUpdateMatrix();
    }

    private void jTextFieldcKeyReleased(KeyEvent evt) {
        this.CheckCellParametersUpdateMatrix();
    }

    private void jTextFieldalphaKeyReleased(KeyEvent evt) {
        this.CheckCellParametersUpdateMatrix();
    }

    private void jTextFieldbetaKeyReleased(KeyEvent evt) {
        this.CheckCellParametersUpdateMatrix();
    }

    private void jTextFieldgammaKeyReleased(KeyEvent evt) {
        this.CheckCellParametersUpdateMatrix();
    }
}

