/*
 * Decompiled with CFR 0.152.
 */
package pdb_editor.dialogs;

import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import pdb_editor.coordinate.CoordinateTable;
import pdb_reader.DataSet;
import pdb_reader.Global;
import pdb_reader.data.Atom;
import pdb_reader.data.Sequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractSequenceDialog
extends JDialog {
    private CoordinateTable maintable = null;
    private DataSet maindata = null;
    private Sequence sequence = null;
    private boolean OPTskipline = false;
    private int OPTskiplinenumber = 50;
    private boolean OPTskipspace = false;
    private int OPTskipspacenumber = 5;
    private boolean OPTfillskip = false;
    private String OPTfillskipcode = "---";
    private boolean OPTdisplayresnum = false;
    private boolean OPTnotconvertsingle = false;
    private boolean OPTrangelimit = false;
    private int OPTrangestart = 0;
    private int OPTrangeend = 0;
    private JButton jButtonClose;
    private JCheckBox jCheckBoxFillResidue;
    private JCheckBox jCheckBoxProteinThreeLetterCode;
    private JCheckBox jCheckBoxRange;
    private JCheckBox jCheckBoxShowResidueNumber;
    private JCheckBox jCheckBoxSkipLine;
    private JCheckBox jCheckBoxSkipSpace;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea;
    private JTextField jTextFieldFillCode;
    private JTextField jTextFieldRangeEnd;
    private JTextField jTextFieldRangeStart;
    private JTextField jTextFieldSkipLine;
    private JTextField jTextFieldSkipSpace;

    public ExtractSequenceDialog(Frame parent, boolean modal, CoordinateTable ctable) {
        super(parent, modal);
        this.initComponents();
        this.maintable = ctable;
        this.maindata = this.maintable.getMainData();
        this.sequence = new Sequence(this.maindata.Atoms());
        this.updateDisplay();
    }

    private void updateDisplay() {
        this.getOptions();
        this.jTextArea.setText(this.GetAllSequence());
    }

    private void getOptions() {
        try {
            this.OPTskiplinenumber = Integer.parseInt(this.jTextFieldSkipLine.getText());
        }
        catch (Exception e) {
            this.jCheckBoxSkipLine.setSelected(false);
        }
        try {
            this.OPTskipspacenumber = Integer.parseInt(this.jTextFieldSkipSpace.getText());
        }
        catch (Exception e) {
            this.jCheckBoxSkipSpace.setSelected(false);
        }
        try {
            this.OPTrangestart = Integer.parseInt(this.jTextFieldRangeStart.getText());
        }
        catch (Exception e) {
            this.jCheckBoxRange.setSelected(false);
        }
        try {
            this.OPTrangeend = Integer.parseInt(this.jTextFieldRangeEnd.getText());
        }
        catch (Exception e) {
            this.jCheckBoxRange.setSelected(false);
        }
        if (this.OPTrangestart > this.OPTrangeend) {
            int i = this.OPTrangeend;
            this.OPTrangeend = this.OPTrangestart;
            this.OPTrangestart = i;
        }
        this.OPTfillskipcode = this.jTextFieldFillCode.getText();
        if (this.OPTfillskipcode.length() > 3) {
            this.OPTfillskipcode = this.OPTfillskipcode.substring(0, 3);
        }
        this.OPTdisplayresnum = this.jCheckBoxShowResidueNumber.isSelected();
        this.OPTfillskip = this.jCheckBoxFillResidue.isSelected();
        this.OPTnotconvertsingle = this.jCheckBoxProteinThreeLetterCode.isSelected();
        this.OPTskipline = this.jCheckBoxSkipLine.isSelected();
        this.OPTskipspace = this.jCheckBoxSkipSpace.isSelected();
        this.OPTrangelimit = this.jCheckBoxRange.isSelected();
    }

    private String GetAllSequence() {
        StringBuilder sb = new StringBuilder();
        TreeMap<Character, TreeMap<Integer, TreeMap<String, ArrayList<Atom>>>> d = this.sequence.data();
        Iterator<Character> l1c = d.keySet().iterator();
        while (l1c.hasNext()) {
            sb.append(this.GetChainSequence(l1c.next().charValue()));
            sb.append('\n');
        }
        return sb.toString();
    }

    private String GetChainSequence(char index) {
        StringBuilder sb = new StringBuilder();
        TreeMap<Integer, TreeMap<String, ArrayList<Atom>>> d = this.sequence.data().get(Character.valueOf(index));
        int writecount = 0;
        int resnum = d.firstKey();
        int endres = d.lastKey();
        if (this.OPTrangelimit) {
            resnum = this.OPTrangestart;
            if (this.OPTrangeend < endres) {
                endres = this.OPTrangeend;
            }
        }
        boolean writenum = true;
        int maxnumberlength = (int)Math.log10(d.lastKey().intValue()) + 1;
        sb.append(">Chain_" + index + '\n');
        while (resnum <= endres) {
            boolean wrote = false;
            if (this.OPTdisplayresnum && writenum && (d.containsKey(resnum) || this.OPTfillskip)) {
                sb.append(Global.ExtendStringLength("" + resnum, maxnumberlength, ' ') + " - ");
                writenum = false;
            }
            if (d.containsKey(resnum)) {
                sb.append(this.getResidue(d.get(resnum)));
                wrote = true;
            } else if (this.OPTfillskip) {
                sb.append(this.getResidue(this.OPTfillskipcode));
                wrote = true;
            }
            if (wrote) {
                if (this.OPTskipspace && ++writecount % this.OPTskipspacenumber == 0) {
                    sb.append(' ');
                }
                if (this.OPTskipline && writecount % this.OPTskiplinenumber == 0) {
                    sb.append('\n');
                    writenum = true;
                }
            }
            ++resnum;
        }
        sb.append('\n');
        if (writecount > 0) {
            return sb.toString();
        }
        return "";
    }

    private String getResidue(TreeMap<String, ArrayList<Atom>> d) {
        return this.getResidue(d.firstKey());
    }

    private String getResidue(String s) {
        if (this.OPTnotconvertsingle) {
            if (s.length() == 3) {
                return s + ' ';
            }
            return Global.ExtendStringLength(s, 4, ' ');
        }
        if (s.equals(this.OPTfillskipcode)) {
            return "" + this.OPTfillskipcode.charAt(0);
        }
        if (DataSet.ResidueSingleLetterCodeDatabase.containsKey(s)) {
            return "" + DataSet.ResidueSingleLetterCodeDatabase.get(s);
        }
        return "*";
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea = new JTextArea();
        this.jPanel1 = new JPanel();
        this.jCheckBoxFillResidue = new JCheckBox();
        this.jCheckBoxSkipSpace = new JCheckBox();
        this.jCheckBoxSkipLine = new JCheckBox();
        this.jCheckBoxShowResidueNumber = new JCheckBox();
        this.jTextFieldSkipSpace = new JTextField();
        this.jTextFieldSkipLine = new JTextField();
        this.jCheckBoxProteinThreeLetterCode = new JCheckBox();
        this.jTextFieldFillCode = new JTextField();
        this.jCheckBoxRange = new JCheckBox();
        this.jTextFieldRangeStart = new JTextField();
        this.jTextFieldRangeEnd = new JTextField();
        this.jButtonClose = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Extract Sequence Result");
        this.jTextArea.setColumns(20);
        this.jTextArea.setFont(new Font("Courier New", 0, 11));
        this.jTextArea.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextArea);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Options"));
        this.jCheckBoxFillResidue.setText("Fill residue number skips with");
        this.jCheckBoxFillResidue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExtractSequenceDialog.this.jCheckBoxSkipLineActionPerformed(evt);
            }
        });
        this.jCheckBoxSkipSpace.setText("Skip space on every");
        this.jCheckBoxSkipSpace.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExtractSequenceDialog.this.jCheckBoxSkipLineActionPerformed(evt);
            }
        });
        this.jCheckBoxSkipLine.setSelected(true);
        this.jCheckBoxSkipLine.setText("Skip line on every");
        this.jCheckBoxSkipLine.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExtractSequenceDialog.this.jCheckBoxSkipLineActionPerformed(evt);
            }
        });
        this.jCheckBoxShowResidueNumber.setText("Display residue number for first residue on each line");
        this.jCheckBoxShowResidueNumber.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExtractSequenceDialog.this.jCheckBoxSkipLineActionPerformed(evt);
            }
        });
        this.jTextFieldSkipSpace.setText("5");
        this.jTextFieldSkipLine.setText("50");
        this.jCheckBoxProteinThreeLetterCode.setText("Do not convert PDB three letter codes into single letter codes");
        this.jCheckBoxProteinThreeLetterCode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExtractSequenceDialog.this.jCheckBoxSkipLineActionPerformed(evt);
            }
        });
        this.jTextFieldFillCode.setText("---");
        this.jCheckBoxRange.setText("Extract only from residue number ranges ");
        this.jCheckBoxRange.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExtractSequenceDialog.this.jCheckBoxSkipLineActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jCheckBoxFillResidue).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldFillCode, -2, 26, -2)).addGroup(jPanel1Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxSkipSpace).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldSkipSpace, -2, 30, -2)).addComponent(this.jCheckBoxProteinThreeLetterCode).addComponent(this.jCheckBoxShowResidueNumber).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jCheckBoxSkipLine).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldSkipLine, -2, 28, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jCheckBoxRange).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldRangeStart, -2, 56, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldRangeEnd, -2, 58, -2))).addGap(64, 64, 64)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldSkipLine, -2, -1, -2).addComponent(this.jCheckBoxSkipLine)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldSkipSpace, -2, -1, -2).addComponent(this.jCheckBoxSkipSpace)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxFillResidue, -2, 23, -2).addComponent(this.jTextFieldFillCode, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxShowResidueNumber).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxProteinThreeLetterCode).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxRange).addComponent(this.jTextFieldRangeStart, -2, -1, -2).addComponent(this.jTextFieldRangeEnd, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExtractSequenceDialog.this.jButtonCloseActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, 433, Short.MAX_VALUE).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 433, Short.MAX_VALUE).addComponent(this.jButtonClose, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 299, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, 181, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClose).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jCheckBoxSkipLineActionPerformed(ActionEvent evt) {
        this.updateDisplay();
    }
}

