/*
 * Decompiled with CFR 0.152.
 */
package pdb_editor.dialogs;

import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import pdb_editor.EditorFrame;
import pdb_editor.coordinate.CoordinateTable;
import pdb_reader.DataSet;
import pdb_reader.Global;
import pdb_reader.data.Coordinate;

public class RotateTranslateAtomsDialog
extends JDialog {
    private static String DeterminantLabelText = "Determinant of Transformation Matrix = ";
    CoordinateTable ctable = null;
    DataSet maindata = null;
    EditorFrame Parent = null;
    private ButtonGroup buttonGroupAngleSelection;
    private ButtonGroup buttonGroupAtomSelection;
    private JButton jButtonClose;
    private JButton jButtonTransform;
    private JCheckBox jCheckBoxFractionalCoordinate;
    private JCheckBox jCheckBoxGenerateNewAtoms;
    private JCheckBox jCheckBoxInvert;
    private JLabel jLabel1;
    private JLabel jLabel12Numbers;
    private JLabel jLabel3Numbers;
    private JLabel jLabel6;
    private JLabel jLabel6Numbers;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9Numbers;
    private JLabel jLabelDeterminant;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JRadioButton jRadioButtonEulerAngle;
    private JRadioButton jRadioButtonPolarAngle;
    private JRadioButton jRadioButtonSelectedAll;
    private JRadioButton jRadioButtonSelectedAtoms;
    private JRadioButton jRadioButtonSelectedChain;
    private JRadioButton jRadioButtonTranslationOnly;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextArea jTextAreaInput;
    private JTextArea jTextAreaMatrixOutput;
    private JTextField jTextFieldNewChainID;

    public RotateTranslateAtomsDialog(Frame parent, boolean modal, CoordinateTable tablein) {
        super(parent, modal);
        try {
            this.Parent = (EditorFrame)parent;
        }
        catch (Exception e) {
            // empty catch block
        }
        this.initComponents();
        this.initButtonGroups();
        this.ctable = tablein;
        this.maindata = tablein.getMainData();
        this.jCheckBoxFractionalCoordinate.setEnabled(false);
        if (this.maindata.Spacegroup() != null && this.maindata.Spacegroup().scale() != null) {
            this.jCheckBoxFractionalCoordinate.setEnabled(true);
        }
    }

    private void initButtonGroups() {
        this.buttonGroupAngleSelection.add(this.jRadioButtonEulerAngle);
        this.buttonGroupAngleSelection.add(this.jRadioButtonPolarAngle);
        this.buttonGroupAngleSelection.add(this.jRadioButtonTranslationOnly);
        this.buttonGroupAtomSelection.add(this.jRadioButtonSelectedAll);
        this.buttonGroupAtomSelection.add(this.jRadioButtonSelectedAtoms);
        this.buttonGroupAtomSelection.add(this.jRadioButtonSelectedChain);
        this.jRadioButtonEulerAngle.setSelected(true);
        this.jRadioButtonSelectedAll.setSelected(true);
    }

    private void Run() {
        if (this.Parent != null) {
            this.Parent.listenForUndoStart("Rotate / translate atom");
        }
        double[][] matrix = this.GetTransformationMatrix();
        int[] selectedrows = this.GetSelectedAtomIndicies();
        if (selectedrows != null) {
            if (!this.jCheckBoxGenerateNewAtoms.isSelected()) {
                this.maindata.TransformAtoms(selectedrows, matrix);
                this.ctable.fireTableDataChanged();
            } else {
                this.maindata.TransformAtoms(selectedrows, matrix, this.GetNewChainID());
                this.ctable.fireTableDataChanged();
            }
        }
        if (this.Parent != null) {
            this.Parent.listenForUndoStop();
        }
    }

    private double[][] GetInput() {
        double[] input = Global.ExtractAllNumbers(this.jTextAreaInput.getText());
        if (input.length == 12 | input.length == 16) {
            this.HighlightTypeInput(0);
            return Global.GenerateTransformationMatrix(input);
        }
        if (input.length == 9) {
            this.HighlightTypeInput(1);
            return Global.GenerateTransformationFromRotationMatrix(input);
        }
        if (input.length == 6) {
            this.HighlightTypeInput(2);
            double[][] m1 = this.GetRotationMatrix(input);
            double[][] m2 = this.GetTranslationMatrix(new double[]{input[3], input[4], input[5]});
            return Global.MultiplyMatrix(m2, m1);
        }
        if (input.length == 3) {
            this.HighlightTypeInput(3);
            return this.GetRotationMatrix(input);
        }
        this.HighlightTypeInput(-1);
        return null;
    }

    private double[][] GetTranslationMatrix(double[] input) {
        if (this.jCheckBoxFractionalCoordinate.isSelected()) {
            Coordinate c = new Coordinate(input[0], input[1], input[2]);
            Coordinate d = Global.TransformCoordinates(this.maindata.Spacegroup().scaleInverse(), c);
            input[0] = d.x();
            input[1] = d.y();
            input[2] = d.z();
        }
        return Global.GenerateTranformationMatrixFromTranslation(input);
    }

    private double[][] GetRotationMatrix(double[] input) {
        if (this.jRadioButtonEulerAngle.isSelected()) {
            return Global.GenerateTranformationMatrixFromEulerAngles(input);
        }
        if (this.jRadioButtonPolarAngle.isSelected()) {
            return Global.GenerateTranformationMatrixFromPolarAngles(input);
        }
        if (this.jRadioButtonTranslationOnly.isSelected()) {
            return this.GetTranslationMatrix(input);
        }
        return null;
    }

    private void HighlightTypeInput(int type) {
        this.jLabel12Numbers.setForeground(Color.BLACK);
        this.jLabel9Numbers.setForeground(Color.BLACK);
        this.jLabel6Numbers.setForeground(Color.BLACK);
        this.jLabel3Numbers.setForeground(Color.BLACK);
        switch (type) {
            case 0: {
                this.jLabel12Numbers.setForeground(Color.RED);
                break;
            }
            case 1: {
                this.jLabel9Numbers.setForeground(Color.RED);
                break;
            }
            case 2: {
                this.jLabel6Numbers.setForeground(Color.RED);
                break;
            }
            case 3: {
                this.jLabel3Numbers.setForeground(Color.RED);
            }
        }
    }

    private void DisplayFormattedMatrix(double[][] matrix4x4) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            sb.append("[ ");
            for (int j = 0; j < 4; ++j) {
                sb.append(String.format("%-16.9f", matrix4x4[i][j]));
                sb.append(' ');
            }
            if (i != 3) {
                sb.append("]\n");
                continue;
            }
            sb.append(']');
        }
        this.jTextAreaMatrixOutput.setText(sb.toString());
        this.jLabelDeterminant.setText(DeterminantLabelText + Global.Determinant4x4Matrix(matrix4x4));
    }

    private char GetNewChainID() {
        String s = this.jTextFieldNewChainID.getText().trim();
        if (s.equals("")) {
            return ' ';
        }
        return s.charAt(0);
    }

    private int[] GetSelectedAtomIndicies() {
        if (this.jRadioButtonSelectedAll.isSelected()) {
            return Global.GenerateIntegerIndiciesArray(this.maindata.Atoms().size());
        }
        if (this.jRadioButtonSelectedChain.isSelected()) {
            return this.maindata.getChainIndicies(this.ctable.getSelectedRows());
        }
        if (this.jRadioButtonSelectedAtoms.isSelected()) {
            return this.ctable.getSelectedRows();
        }
        return null;
    }

    private double[][] GetTransformationMatrix() {
        try {
            return Global.GenerateTransformationMatrix(Global.ExtractAllNumbers(this.jTextAreaMatrixOutput.getText()));
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error reading transformation matrix", "Error Transofmration", 0);
            return null;
        }
    }

    private void UpdateCalculatedTransformationMatrix() {
        double[][] m = this.GetInput();
        if (m != null) {
            this.DisplayFormattedMatrix(m);
        }
    }

    private void initComponents() {
        this.buttonGroupAtomSelection = new ButtonGroup();
        this.buttonGroupAngleSelection = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jRadioButtonSelectedAtoms = new JRadioButton();
        this.jRadioButtonSelectedChain = new JRadioButton();
        this.jRadioButtonSelectedAll = new JRadioButton();
        this.jCheckBoxGenerateNewAtoms = new JCheckBox();
        this.jTextFieldNewChainID = new JTextField();
        this.jPanel2 = new JPanel();
        this.jRadioButtonEulerAngle = new JRadioButton();
        this.jRadioButtonPolarAngle = new JRadioButton();
        this.jRadioButtonTranslationOnly = new JRadioButton();
        this.jLabel1 = new JLabel();
        this.jLabel12Numbers = new JLabel();
        this.jLabel9Numbers = new JLabel();
        this.jLabel6Numbers = new JLabel();
        this.jLabel3Numbers = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jCheckBoxFractionalCoordinate = new JCheckBox();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaInput = new JTextArea();
        this.jPanel3 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jTextAreaMatrixOutput = new JTextArea();
        this.jCheckBoxInvert = new JCheckBox();
        this.jLabelDeterminant = new JLabel();
        this.jButtonClose = new JButton();
        this.jButtonTransform = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Rotate / Translate Atoms");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Atoms to be Transformed"));
        this.jRadioButtonSelectedAtoms.setText("Selected Atoms");
        this.jRadioButtonSelectedChain.setText("Selected Chain");
        this.jRadioButtonSelectedAll.setText("All Atoms");
        this.jCheckBoxGenerateNewAtoms.setText("Generate new atoms into chain :");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jRadioButtonSelectedAll).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonSelectedChain).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonSelectedAtoms)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jCheckBoxGenerateNewAtoms).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldNewChainID, -2, 32, -2))).addContainerGap(142, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonSelectedAll).addComponent(this.jRadioButtonSelectedChain).addComponent(this.jRadioButtonSelectedAtoms)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxGenerateNewAtoms).addComponent(this.jTextFieldNewChainID, -2, -1, -2)).addGap(23, 23, 23)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Rotation / Translation Setting"));
        this.jRadioButtonEulerAngle.setSelected(true);
        this.jRadioButtonEulerAngle.setText("Euler Angle");
        this.jRadioButtonEulerAngle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RotateTranslateAtomsDialog.this.jRadioButtonEulerAngleActionPerformed(evt);
            }
        });
        this.jRadioButtonPolarAngle.setText("Polar Angles");
        this.jRadioButtonPolarAngle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RotateTranslateAtomsDialog.this.jRadioButtonPolarAngleActionPerformed(evt);
            }
        });
        this.jRadioButtonTranslationOnly.setText("Translation Only");
        this.jRadioButtonTranslationOnly.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RotateTranslateAtomsDialog.this.jRadioButtonTranslationOnlyActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Type in transformation matrix, or angles + translation, or angles");
        this.jLabel12Numbers.setText("Inputting 12 numbers will assumed as 4 x 3 transformation matrix");
        this.jLabel9Numbers.setText("Inputting 9 numbers will be assumed as 3 x 3 rotation matrix");
        this.jLabel6Numbers.setText("Inputting 6 numbers will be assumed as 3 angles followed by 3 translation");
        this.jLabel3Numbers.setText("Inputting 3 numbers will be assumed as 3 angles or translation by option");
        this.jLabel6.setText("Euler : Alpha, Beta, Gamma, X, Y, Z");
        this.jLabel7.setText("Polar : Omega, Phi, Kappa, X, Y, Z");
        this.jLabel8.setText("Numbers do not have to be formatted but least separated by a space");
        this.jCheckBoxFractionalCoordinate.setText("Translations in Fractional Coordinate");
        this.jCheckBoxFractionalCoordinate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RotateTranslateAtomsDialog.this.jCheckBoxFractionalCoordinateActionPerformed(evt);
            }
        });
        this.jTextAreaInput.setColumns(20);
        this.jTextAreaInput.setRows(4);
        this.jTextAreaInput.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                RotateTranslateAtomsDialog.this.jTextAreaInputKeyPressed(evt);
            }

            public void keyReleased(KeyEvent evt) {
                RotateTranslateAtomsDialog.this.jTextAreaInputKeyReleased(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTextAreaInput);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxFractionalCoordinate).addGroup(jPanel2Layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jLabel8)).addComponent(this.jLabel1).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jRadioButtonEulerAngle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonPolarAngle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonTranslationOnly)).addComponent(this.jLabel12Numbers).addComponent(this.jLabel9Numbers).addComponent(this.jLabel6Numbers, -1, 387, Short.MAX_VALUE).addComponent(this.jLabel3Numbers).addGroup(jPanel2Layout.createSequentialGroup().addGap(10, 10, 10).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7).addComponent(this.jLabel6))).addComponent(this.jScrollPane1, -1, 387, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel12Numbers).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel9Numbers).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6Numbers).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6).addGap(5, 5, 5).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3Numbers).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonEulerAngle).addComponent(this.jRadioButtonPolarAngle).addComponent(this.jRadioButtonTranslationOnly)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxFractionalCoordinate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1).addGap(23, 23, 23)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Calculated Transformation Matrix"));
        this.jTextAreaMatrixOutput.setColumns(20);
        this.jTextAreaMatrixOutput.setRows(4);
        this.jScrollPane2.setViewportView(this.jTextAreaMatrixOutput);
        this.jCheckBoxInvert.setText("Invert Transformation Matrix");
        this.jCheckBoxInvert.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RotateTranslateAtomsDialog.this.jCheckBoxInvertActionPerformed(evt);
            }
        });
        this.jLabelDeterminant.setText("Determinant of Transformation Matrix = ");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxInvert).addComponent(this.jScrollPane2, -1, 387, Short.MAX_VALUE).addComponent(this.jLabelDeterminant)).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jScrollPane2, -2, 81, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelDeterminant, -1, 14, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxInvert).addGap(12, 12, 12)));
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RotateTranslateAtomsDialog.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonTransform.setText("Transform");
        this.jButtonTransform.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RotateTranslateAtomsDialog.this.jButtonTransformActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButtonTransform).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClose).addGap(12, 12, 12)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, 79, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonClose).addComponent(this.jButtonTransform)).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonTransformActionPerformed(ActionEvent evt) {
        this.Run();
    }

    private void jCheckBoxInvertActionPerformed(ActionEvent evt) {
        double[][] m = this.GetTransformationMatrix();
        if (m != null) {
            this.DisplayFormattedMatrix(Global.Inverse4x4Matrix(m));
        } else {
            this.jCheckBoxInvert.setSelected(!this.jCheckBoxInvert.isSelected());
        }
    }

    private void jTextAreaInputKeyPressed(KeyEvent evt) {
    }

    private void jTextAreaInputKeyReleased(KeyEvent evt) {
        this.UpdateCalculatedTransformationMatrix();
    }

    private void jRadioButtonEulerAngleActionPerformed(ActionEvent evt) {
        this.UpdateCalculatedTransformationMatrix();
    }

    private void jRadioButtonPolarAngleActionPerformed(ActionEvent evt) {
        this.UpdateCalculatedTransformationMatrix();
    }

    private void jRadioButtonTranslationOnlyActionPerformed(ActionEvent evt) {
        this.UpdateCalculatedTransformationMatrix();
    }

    private void jCheckBoxFractionalCoordinateActionPerformed(ActionEvent evt) {
        this.UpdateCalculatedTransformationMatrix();
    }
}

