/*
 * Decompiled with CFR 0.152.
 */
package pdb_editor.dialogs;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import pdb_editor.EditorFrame;
import pdb_editor.coordinate.CoordinateTable;
import pdb_reader.DataSet;
import pdb_reader.data.Atom;

public class SortAtomsDialog
extends JDialog {
    private DataSet maindata = null;
    private CoordinateTable cTable = null;
    private EditorFrame Parent = null;
    private ArrayList<Criteria> criterias = new ArrayList();
    private ItemListener criteriaChangeListener = new ItemListener(){

        public void itemStateChanged(ItemEvent e) {
            boolean cont = true;
            for (int i = 0; i < SortAtomsDialog.this.criterias.size(); ++i) {
                if (((Criteria)((SortAtomsDialog)SortAtomsDialog.this).criterias.get((int)i)).type.getSelectedIndex() != 35) continue;
                cont = false;
            }
            if (cont) {
                SortAtomsDialog.this.addNewCriteria();
            }
        }
    };
    private JButton jButton1;
    private JButton jButton2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;

    public SortAtomsDialog(Frame parent, boolean modal, CoordinateTable ctable) {
        super(parent, modal);
        this.initComponents();
        try {
            this.Parent = (EditorFrame)parent;
        }
        catch (Exception e) {
            // empty catch block
        }
        this.cTable = ctable;
        this.maindata = ctable.getMainData();
        this.addNewCriteria();
        this.addNewCriteria();
        this.addNewCriteria();
    }

    private void Run() {
        int[] indicies = this.getCriteriaIndicies();
        boolean[] descending = this.getCriteriaDescending();
        if (this.Parent != null) {
            this.Parent.listenForUndoStart("Sort atoms with multiple criterias");
        }
        this.maindata.Sort(indicies, descending);
        if (this.Parent != null) {
            this.Parent.listenForUndoStop();
        }
        this.cTable.fireTableDataChanged();
    }

    private int[] getCriteriaIndicies() {
        int[] indicies = new int[this.criterias.size()];
        for (int i = 0; i < this.criterias.size(); ++i) {
            Criteria c = this.criterias.get(i);
            indicies[i] = c.type.getSelectedIndex();
        }
        return indicies;
    }

    private boolean[] getCriteriaDescending() {
        boolean[] descending = new boolean[this.criterias.size()];
        for (int i = 0; i < this.criterias.size(); ++i) {
            Criteria c = this.criterias.get(i);
            descending[i] = c.descending.isSelected();
        }
        return descending;
    }

    private void addNewCriteria() {
        int RIGHTINSETSPACE = 5;
        int DOWNINSETSPACE = 3;
        int GRIDY = this.criterias.size();
        Criteria c = new Criteria();
        c.type.addItemListener(this.criteriaChangeListener);
        this.criterias.add(c);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = GRIDY;
        gridBagConstraints.insets = new Insets(DOWNINSETSPACE, 0, DOWNINSETSPACE, RIGHTINSETSPACE);
        this.jPanel1.add((Component)c.name, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = GRIDY;
        gridBagConstraints.insets = new Insets(DOWNINSETSPACE, 0, DOWNINSETSPACE, RIGHTINSETSPACE);
        this.jPanel1.add((Component)c.type, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = GRIDY;
        gridBagConstraints.insets = new Insets(DOWNINSETSPACE, 0, DOWNINSETSPACE, RIGHTINSETSPACE);
        this.jPanel1.add((Component)c.ascending, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = GRIDY;
        gridBagConstraints.insets = new Insets(DOWNINSETSPACE, 0, DOWNINSETSPACE, RIGHTINSETSPACE);
        this.jPanel1.add((Component)c.descending, gridBagConstraints);
        this.pack();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Sort Atoms");
        this.setResizable(false);
        this.jScrollPane1.setHorizontalScrollBar(null);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jScrollPane1.setViewportView(this.jPanel1);
        this.jButton1.setText("Close");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SortAtomsDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("Sort");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SortAtomsDialog.this.jButton2ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1)).addComponent(this.jScrollPane1, -1, 455, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 130, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jButton2)).addContainerGap()));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.Run();
    }

    private class Criteria {
        public JLabel name = new JLabel();
        public JComboBox type = new JComboBox();
        public JRadioButton ascending = new JRadioButton();
        public JRadioButton descending = new JRadioButton();
        private ButtonGroup bgroup = new ButtonGroup();

        public Criteria() {
            for (int i = 0; i < 35; ++i) {
                this.type.addItem(Atom.DataToolTip[i]);
            }
            this.type.setSelectedIndex(0);
            if (SortAtomsDialog.this.criterias.size() == 0) {
                this.name.setText("Main criteria : ");
            } else {
                this.name.setText("Subcriteria " + SortAtomsDialog.this.criterias.size() + " : ");
                this.type.addItem("IGNORE");
                this.type.setSelectedIndex(35);
            }
            this.ascending.setText("Ascending");
            this.descending.setText("Descending");
            this.bgroup.add(this.ascending);
            this.bgroup.add(this.descending);
            this.ascending.setSelected(true);
        }
    }
}

