/*
 * Decompiled with CFR 0.152.
 */
package pdb_reader.data;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import pdb_reader.data.Atom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Connectivity
implements Comparable {
    public static String PDBHeader = "CONECT";
    public Atom Base = null;
    public Set<Atom> Branch = new TreeSet<Atom>();

    public Connectivity() {
    }

    public Connectivity(Atom base, Atom branch) {
        this.Base = base;
        this.Branch.add(branch);
    }

    public Connectivity(Atom base, Atom[] branch) {
        this.Base = base;
        for (int i = 0; i < branch.length; ++i) {
            this.Branch.add(branch[i]);
        }
    }

    public Connectivity(Atom[] base_branch) {
        this.Base = base_branch[0];
        for (int i = 1; i < base_branch.length; ++i) {
            this.Branch.add(base_branch[i]);
        }
    }

    public Connectivity(String PDBLine, List<Atom> AtomList) {
        this.ReadPDBLine(PDBLine, AtomList);
    }

    public void ReadPDBLine(String line, List<Atom> atomlist) {
        if (line != null && line.length() > 6 && line.substring(0, 6).equals(PDBHeader)) {
            TreeSet<Integer> list = new TreeSet<Integer>();
            int base = -1;
            try {
                base = Integer.parseInt(line.substring(6, 11).trim());
                for (int i = 11; i < line.length(); i += 5) {
                    String s = line.substring(i, i + 5).trim();
                    if (s.length() <= 0) continue;
                    list.add(Integer.parseInt(s));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (base != -1) {
                this.Base = this.FindAtomNumber(atomlist, base);
                this.Branch = this.FindAtomList(atomlist, list);
            }
        }
    }

    public String WritePDBLine() {
        StringBuilder sb = new StringBuilder();
        TreeSet<Integer> list = this.GetBranchNumbers();
        sb.append(PDBHeader);
        sb.append(String.format("%5d", this.Base.AtomNumber()));
        int count = 0;
        for (int i : list) {
            if (count != 0 && count % 4 == 0) {
                sb.append('\n');
                sb.append(PDBHeader);
                sb.append(String.format("%5d", this.Base.AtomNumber()));
            }
            sb.append(String.format("%5d", i));
            ++count;
        }
        return sb.toString();
    }

    private TreeSet<Integer> GetBranchNumbers() {
        TreeSet<Integer> r = new TreeSet<Integer>();
        for (Atom a : this.Branch) {
            r.add(a.AtomNumber());
        }
        return r;
    }

    private Atom FindAtomNumber(List<Atom> list, int number) {
        for (Atom a : list) {
            if (a.AtomNumber() != number) continue;
            return a;
        }
        return null;
    }

    private Set<Atom> FindAtomList(List<Atom> list, TreeSet<Integer> targets) {
        TreeSet<Atom> r = new TreeSet<Atom>();
        for (Atom a : list) {
            if (!targets.contains(a.AtomNumber())) continue;
            r.add(a);
        }
        return r;
    }

    public int compareTo(Object o) {
        try {
            Connectivity c = (Connectivity)o;
            int diff_baseatom = this.Base.compareTo(c.Base);
            if (diff_baseatom != 0) {
                return diff_baseatom;
            }
            int diff_branchsize = this.Branch.size() - c.Branch.size();
            if (diff_branchsize != 0) {
                return diff_branchsize;
            }
            Iterator<Atom> i = this.Branch.iterator();
            Iterator<Atom> j = c.Branch.iterator();
            while (i.hasNext() && j.hasNext()) {
                Atom b;
                Atom a = i.next();
                int diff_branch = a.compareTo(b = j.next());
                if (diff_branch == 0) continue;
                return diff_branch;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public Connectivity clone() {
        Connectivity c = new Connectivity();
        c.Base = this.Base;
        c.Branch = new TreeSet<Atom>(this.Branch);
        return c;
    }
}

