/*
 * Decompiled with CFR 0.152.
 */
package pdb_reader.data;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import pdb_reader.data.Atom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sequence {
    private TreeMap<Character, TreeMap<Integer, TreeMap<String, ArrayList<Atom>>>> data = new TreeMap();

    public Sequence() {
    }

    public Sequence(List<Atom> listin) {
        this.processList(listin);
    }

    public TreeMap<Character, TreeMap<Integer, TreeMap<String, ArrayList<Atom>>>> data() {
        return this.data;
    }

    public void processList(List<Atom> listin) {
        for (Atom a : listin) {
            this.addAtom(a);
        }
    }

    public void addAtom(Atom a) {
        String s;
        TreeMap<String, ArrayList<Atom>> subsubdata;
        int n;
        TreeMap<Integer, TreeMap<String, ArrayList<Atom>>> subdata;
        char c = a.ChainID();
        if (!this.data.containsKey(Character.valueOf(c))) {
            this.data.put(Character.valueOf(c), new TreeMap());
        }
        if (!(subdata = this.data.get(Character.valueOf(c))).containsKey(n = a.ResidueNumber())) {
            subdata.put(n, new TreeMap());
        }
        if (!(subsubdata = subdata.get(n)).containsKey(s = a.ResidueType())) {
            subsubdata.put(s, new ArrayList());
        }
        subsubdata.get(s).add(a);
    }

    public void removeAtom(Atom a) {
        ArrayList<Atom> list;
        String s;
        TreeMap<String, ArrayList<Atom>> subsubdata;
        int n;
        TreeMap<Integer, TreeMap<String, ArrayList<Atom>>> subdata;
        char c = a.ChainID();
        if (this.data.containsKey(Character.valueOf(c)) && (subdata = this.data.get(Character.valueOf(c))).containsKey(n = a.ResidueNumber()) && (subsubdata = subdata.get(n)).containsKey(s = a.ResidueType()) && (list = subsubdata.get(s)).contains(a)) {
            list.remove(a);
            if (list.size() == 0) {
                subsubdata.remove(s);
            }
            if (subsubdata.size() == 0) {
                subdata.remove(n);
            }
            if (subdata.size() == 0) {
                this.data.remove(Character.valueOf(c));
            }
        }
    }

    public ArrayList<ArrayList<Atom>> getLinearList() {
        ArrayList<ArrayList<Atom>> linearlist = new ArrayList<ArrayList<Atom>>();
        for (TreeMap<Integer, TreeMap<String, ArrayList<Atom>>> d : this.data().values()) {
            for (TreeMap<String, ArrayList<Atom>> d2 : d.values()) {
                for (ArrayList<Atom> d3 : d2.values()) {
                    linearlist.add(d3);
                }
            }
        }
        return linearlist;
    }

    public boolean checkResidueExist(char chain, int resnum) {
        return this.data.containsKey(Character.valueOf(chain)) && this.data.get(Character.valueOf(chain)).containsKey(resnum);
    }
}

