/*
 * Decompiled with CFR 0.152.
 */
package pdb_reader.data.spacegroup;

import java.util.ArrayList;
import java.util.TreeMap;
import pdb_reader.Global;
import pdb_reader.data.spacegroup.CrystalSystemChecker;
import pdb_reader.data.spacegroup.SpaceGroupInformation;

public class SpaceGroup {
    public static final int CRYST_INDEX = 0;
    public static final int ORIGX_INDEX = 1;
    public static final int SCALE_INDEX = 2;
    public static final String[] Headers = new String[]{"CRYST", "ORIGX", "SCALE"};
    public static TreeMap<String, SpaceGroupInformation> SpaceGroupTableByName = null;
    public static TreeMap<Integer, SpaceGroupInformation> SpaceGroupTableByNumber = null;
    private double a = 0.0;
    private double b = 0.0;
    private double c = 0.0;
    private double alpha = 0.0;
    private double beta = 0.0;
    private double gamma = 0.0;
    private String name = null;
    private int number = 0;
    private String[][] symmetryOperators = null;
    private double[][] scale = null;
    private double[][] scaleInverse = null;
    private double[][] origx = null;
    private double[][] origxInverse = null;
    private boolean isOrigxIdentity = true;
    private double[] translationVector = null;
    private double[][][] NCSmatrix = null;
    private CrystalSystemChecker cellChecker = null;

    public static void initSpaceGroupTable() {
        String[] lines = Global.ReadTextResource("/pdb_reader/data/spacegroup/SymmOp.lib");
        SpaceGroupTableByName = new TreeMap();
        SpaceGroupTableByNumber = new TreeMap();
        ArrayList<String> sgline = null;
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i].charAt(0) != ' ') {
                if (sgline != null) {
                    SpaceGroupInformation sgi = new SpaceGroupInformation(sgline.toArray(new String[sgline.size()]));
                    if (!SpaceGroupTableByName.containsKey(sgi.Name)) {
                        SpaceGroupTableByName.put(sgi.Name, sgi);
                    }
                    if (!SpaceGroupTableByName.containsKey(sgi.Name2)) {
                        SpaceGroupTableByName.put(sgi.Name2, sgi);
                    }
                    SpaceGroupTableByNumber.put(sgi.CCP4Number, sgi);
                }
                sgline = new ArrayList<String>();
            }
            sgline.add(lines[i]);
        }
    }

    public SpaceGroup() {
    }

    public SpaceGroup(String[] PDBLines) {
        this.ReadFromPDBLines(PDBLines);
    }

    public SpaceGroup(String PDBLines) {
        this.ReadFromPDBLines(PDBLines.split("\\n"));
    }

    public double a() {
        return this.a;
    }

    public double b() {
        return this.b;
    }

    public double c() {
        return this.c;
    }

    public double alpha() {
        return this.alpha;
    }

    public double beta() {
        return this.beta;
    }

    public double gamma() {
        return this.gamma;
    }

    public String name() {
        return this.name;
    }

    public int number() {
        return this.number;
    }

    public double[][] scale() {
        return this.scale;
    }

    public double[][] scaleInverse() {
        return this.scaleInverse;
    }

    public double[][] origx() {
        return this.origx;
    }

    public double[][] origxInverse() {
        return this.origxInverse;
    }

    public boolean isOrigxIdentity() {
        return this.isOrigxIdentity;
    }

    public double[] translationVector() {
        return this.translationVector;
    }

    public String[][] symmetryOperators() {
        return this.symmetryOperators;
    }

    public String crystalSystemText() {
        return this.cellChecker.InformationText();
    }

    public double a(double Value) {
        this.a = Value;
        return this.a;
    }

    public double b(double Value) {
        this.b = Value;
        return this.b;
    }

    public double c(double Value) {
        this.c = Value;
        return this.c;
    }

    public double alpha(double Value) {
        this.alpha = Value;
        return this.alpha;
    }

    public double beta(double Value) {
        this.beta = Value;
        return this.beta;
    }

    public double gamma(double Value) {
        this.gamma = Value;
        return this.gamma;
    }

    public String name(String Value) {
        this.GetSpaceGroupInformation(Value);
        return this.name;
    }

    public int number(int Value) {
        this.GetSpaceGroupInformation(Value);
        return this.number;
    }

    public double[][] scale(double[][] Value) {
        this.scale = Value;
        this.scaleInverse = Global.Inverse4x4Matrix(this.scale);
        return this.scale;
    }

    public double[][] scaleInverse(double[][] Value) {
        this.scaleInverse = Value;
        this.scale = Global.Inverse4x4Matrix(this.scaleInverse);
        return this.scaleInverse;
    }

    public double[][] origx(double[][] Value) {
        this.origx = Value;
        this.origxInverse = Global.Inverse4x4Matrix(this.origx);
        this.isOrigxIdentity = Global.IsIdentityMatrix(this.origx);
        return this.origx;
    }

    public double[][] origxInverse(double[][] Value) {
        this.origxInverse = Value;
        this.origx = Global.Inverse4x4Matrix(this.origxInverse);
        this.isOrigxIdentity = Global.IsIdentityMatrix(this.origx);
        return this.origxInverse;
    }

    public double[] translationVector(double[] Value) {
        this.translationVector = Value;
        return Value;
    }

    public SpaceGroup clone() {
        SpaceGroup r = new SpaceGroup();
        r.a = this.a;
        r.b = this.b;
        r.c = this.c;
        r.alpha = this.alpha;
        r.beta = this.beta;
        r.gamma = this.gamma;
        r.name = this.name;
        r.number = this.number;
        if (this.symmetryOperators != null) {
            r.symmetryOperators = this.symmetryOperators;
        }
        if (this.scale != null) {
            r.scale = (double[][])this.scale.clone();
        }
        if (this.scaleInverse != null) {
            r.scaleInverse = (double[][])this.scaleInverse.clone();
        }
        if (this.origx != null) {
            r.origx = (double[][])this.origx.clone();
        }
        if (this.origxInverse != null) {
            r.origxInverse = (double[][])this.origxInverse.clone();
        }
        r.isOrigxIdentity = this.isOrigxIdentity;
        if (this.translationVector != null) {
            r.translationVector = (double[])this.translationVector.clone();
        }
        if (this.NCSmatrix != null) {
            r.NCSmatrix = (double[][][])this.NCSmatrix.clone();
        }
        r.cellChecker = this.cellChecker;
        return r;
    }

    public String SpaceGroupInformation() {
        StringBuilder sb = new StringBuilder();
        try {
            SpaceGroupInformation sgi = SpaceGroupTableByName.get(this.name);
            sb.append(this.crystalSystemText());
            sb.append("\n\n");
            sb.append("Space Group : " + sgi.Name);
            sb.append('\n');
            sb.append("Other allowed name : " + sgi.Name2);
            sb.append('\n');
            sb.append("Symmetry operators : " + this.symmetryOperators.length);
            sb.append('\n');
            for (int i = 0; i < this.symmetryOperators.length; ++i) {
                sb.append(' ');
                for (int j = 0; j < 3; ++j) {
                    sb.append(this.symmetryOperators[i][j]);
                    sb.append("  ");
                }
                sb.append('\n');
            }
        }
        catch (Exception e) {
            return "Space group : " + this.name + "\nNo information available";
        }
        return sb.toString();
    }

    public boolean isfCellParametersCorrect() {
        return this.cellChecker.CheckCell(this);
    }

    public boolean CorrectCellParameters() {
        boolean value = this.cellChecker.CheckCell(this);
        this.cellChecker.Correct(this);
        return value;
    }

    public void GetSpaceGroupInformation(String Value) {
        this.GetSpaceGroupInformation(SpaceGroupTableByName.get(Value));
    }

    public void GetSpaceGroupInformation(int Value) {
        this.GetSpaceGroupInformation(SpaceGroupTableByNumber.get(Value));
    }

    public void GetSpaceGroupInformation(SpaceGroupInformation sgi) {
        this.symmetryOperators = sgi.Operators;
        this.name = sgi.Name;
        this.number = sgi.CCP4Number;
        this.cellChecker = CrystalSystemChecker.GetChecker(sgi.System);
    }

    public void ReadFromPDBLines(String[] Lines) {
        for (int i = 0; i < Lines.length; ++i) {
            if (Lines[i].length() <= 5) continue;
            if (Lines[i].subSequence(0, 6).equals("CRYST1")) {
                this.GetPDBCRYST1Information(Lines[i]);
            }
            if (Lines[i].subSequence(0, 5).equals("ORIGX")) {
                this.GetPDBORIGXSCALEInformation(Lines[i]);
            }
            if (!Lines[i].subSequence(0, 5).equals("SCALE")) continue;
            this.GetPDBORIGXSCALEInformation(Lines[i]);
        }
    }

    public String WritePDBSpaceGroupLines() {
        StringBuilder sb = new StringBuilder();
        if (this.name != null) {
            sb.append(this.WritePDBCRYSTLine());
        }
        if (this.origx != null) {
            sb.append(this.WriteORIGXLines());
        }
        if (this.scale != null) {
            sb.append(this.WriteSCALELines());
        }
        return sb.toString();
    }

    public String WritePDBCRYSTLine() {
        StringBuilder sb = new StringBuilder();
        sb.append("CRYST1");
        sb.append(String.format("%9.3f", this.a));
        sb.append(String.format("%9.3f", this.b));
        sb.append(String.format("%9.3f", this.c));
        sb.append(String.format("%7.2f", this.alpha));
        sb.append(String.format("%7.2f", this.beta));
        sb.append(String.format("%7.2f", this.gamma));
        sb.append(' ');
        sb.append(String.format("%-11s", this.name));
        sb.append('\n');
        return sb.toString();
    }

    public String WriteORIGXLines() {
        return this.WritePDBMatrix(this.origx, "ORIGX");
    }

    public String WriteSCALELines() {
        return this.WritePDBMatrix(this.scale, "SCALE");
    }

    public String WritePDBMatrix(double[][] matrix, String MName) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 3; ++i) {
            sb.append(MName + (i + 1));
            sb.append("    ");
            sb.append(String.format("%10.6f", matrix[i][0]));
            sb.append(String.format("%10.6f", matrix[i][1]));
            sb.append(String.format("%10.6f", matrix[i][2]));
            sb.append("     ");
            sb.append(String.format("%10.5f", matrix[i][3]));
            sb.append('\n');
        }
        return sb.toString();
    }

    private void GetPDBCRYST1Information(String Line) {
        String s = null;
        s = Global.GetSubstring(Line, 6, 15);
        if (s != null) {
            this.a = Double.parseDouble(s);
            s = Global.GetSubstring(Line, 15, 24);
            if (s != null) {
                this.b = Double.parseDouble(s);
                s = Global.GetSubstring(Line, 24, 33);
                if (s != null) {
                    this.c = Double.parseDouble(s);
                    s = Global.GetSubstring(Line, 33, 40);
                    if (s != null) {
                        this.alpha = Double.parseDouble(s);
                        s = Global.GetSubstring(Line, 40, 47);
                        if (s != null) {
                            this.beta = Double.parseDouble(s);
                            s = Global.GetSubstring(Line, 47, 54);
                            if (s != null) {
                                this.gamma = Double.parseDouble(s);
                                s = Global.GetSubstring(Line, 55, 66);
                                if (s != null) {
                                    this.name(s.trim());
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private void GetPDBORIGXSCALEInformation(String Line) {
        double[][] Matrix = null;
        boolean isOrigx = false;
        if (Line.subSequence(0, 5).equals("ORIGX")) {
            Matrix = this.origx;
            isOrigx = true;
        }
        if (Line.subSequence(0, 5).equals("SCALE")) {
            Matrix = this.scale;
        }
        if (Matrix == null) {
            Matrix = new double[4][4];
            Matrix[3][0] = 0.0;
            Matrix[3][1] = 0.0;
            Matrix[3][2] = 0.0;
            Matrix[3][3] = 1.0;
        }
        int i = -1;
        if (Line.length() > 6) {
            if (Line.substring(5, 6).equals("1")) {
                i = 0;
            }
            if (Line.substring(5, 6).equals("2")) {
                i = 1;
            }
            if (Line.substring(5, 6).equals("3")) {
                i = 2;
            }
            if (i != -1) {
                try {
                    Matrix[i][0] = Double.parseDouble(Line.substring(10, 20));
                    Matrix[i][1] = Double.parseDouble(Line.substring(20, 30));
                    Matrix[i][2] = Double.parseDouble(Line.substring(30, 40));
                    Matrix[i][3] = Double.parseDouble(Line.substring(45, 55));
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (isOrigx) {
                    this.origx = Matrix;
                } else {
                    this.scale = Matrix;
                }
                if (i == 2) {
                    if (isOrigx) {
                        this.origx = Matrix;
                        this.origxInverse = Global.Inverse4x4Matrix(Matrix);
                        this.isOrigxIdentity = Global.IsIdentityMatrix(Matrix);
                    } else {
                        this.scale = Matrix;
                        this.scaleInverse = Global.Inverse4x4Matrix(Matrix);
                    }
                }
            }
        }
    }
}

