/*
 * Decompiled with CFR 0.152.
 */
package pdb_editor.coordinate;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import pdb_editor.EditorFrame;
import pdb_editor.coordinate.CoordinateTable;
import pdb_reader.DataSet;
import pdb_reader.FormulaEvaluator;
import pdb_reader.Global;
import pdb_reader.data.Atom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditCoordinateDialog
extends JDialog {
    private DataSet maindata = null;
    private CoordinateTable coordinateTable = null;
    private EditorFrame Parent = null;
    private JCheckBox[] checkBoxes = null;
    private JTextField[] valueFields = null;
    private JButton buttonOk = null;
    private JButton buttonCancel = null;
    private JButton buttonHelp = null;
    private CommonKeyListener commonKeyListener = new CommonKeyListener();
    private JButton jButtonHelpClose;
    private JDialog jDialogHelp;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JScrollPane jScrollPane1;
    private JTextArea jTextAreaHelp;

    public EditCoordinateDialog(EditorFrame parent, boolean modal, CoordinateTable cTable) {
        super((Frame)parent, modal);
        this.Parent = parent;
        this.coordinateTable = cTable;
        this.maindata = cTable.getMainData();
        this.addKeyListener(this.commonKeyListener);
        this.initComponents();
        this.GenerateEntryFields();
    }

    private void ProcessChange() {
        String[] Inputs = this.getUserInputs();
        Object[] processedInputs = this.processInputs(Inputs);
        if (processedInputs != null) {
            this.Parent.listenForUndoStart("Edit selected cells");
            this.changeValues(processedInputs);
            this.Parent.listenForUndoStop();
        }
    }

    private void changeValues(Object[] inputs) {
        int[] rows = this.coordinateTable.getSelectedRows();
        Object[][] outputs = null;
        boolean cont = true;
        try {
            outputs = this.generateOutputs(inputs);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error in user input", "Error Editing", 0);
            cont = false;
        }
        if (cont) {
            for (int i = 0; i < outputs.length; ++i) {
                if (outputs[i][0] == null) continue;
                for (int j = 0; j < rows.length; ++j) {
                    this.maindata.Atoms().get(rows[j]).TableData(i, outputs[i][j]);
                }
            }
            for (int j = 0; j < rows.length; ++j) {
                this.coordinateTable.fireTableRowUpdated(rows[j], rows[j]);
            }
        }
    }

    private void getVariables(FormulaEvaluator f, int row, int column) {
        HashMap<String, Double> v = f.getVariables();
        String[] vlist = v.keySet().toArray(new String[v.keySet().size()]);
        for (int i = 0; i < vlist.length; ++i) {
            v.put(vlist[i], this.getVariable(vlist[i], row, column, v));
        }
    }

    private Double getVariable(String name, int row, int column, HashMap<String, Double> v) {
        String[] comp = name.split(":");
        for (int i = 0; i < comp.length; ++i) {
            if (comp[i].equals("L") && --row < 0) {
                row = 0;
            }
            if (comp[i].equals("N") && ++row >= this.maindata.Atoms().size()) {
                row = this.maindata.Atoms().size() - 1;
            }
            if (comp[i].equals("X")) {
                column = 10;
            }
            if (comp[i].equals("Y")) {
                column = 11;
            }
            if (comp[i].equals("Z")) {
                column = 12;
            }
            if (comp[i].equals("x")) {
                column = 32;
            }
            if (comp[i].equals("y")) {
                column = 33;
            }
            if (comp[i].equals("z")) {
                column = 34;
            }
            if (comp[i].equals("B")) {
                column = 13;
            }
            if (comp[i].equals("O")) {
                column = 14;
            }
            if (comp[i].equals("U11")) {
                column = 15;
            }
            if (comp[i].equals("U12")) {
                column = 18;
            }
            if (comp[i].equals("U13")) {
                column = 19;
            }
            if (comp[i].equals("U22")) {
                column = 16;
            }
            if (comp[i].equals("U23")) {
                column = 20;
            }
            if (comp[i].equals("U33")) {
                column = 17;
            }
            if (comp[i].equals("sX")) {
                column = 21;
            }
            if (comp[i].equals("sY")) {
                column = 22;
            }
            if (comp[i].equals("sZ")) {
                column = 23;
            }
            if (comp[i].equals("sB")) {
                column = 24;
            }
            if (comp[i].equals("sO")) {
                column = 25;
            }
            if (comp[i].equals("sU11")) {
                column = 26;
            }
            if (comp[i].equals("sU12")) {
                column = 29;
            }
            if (comp[i].equals("sU13")) {
                column = 30;
            }
            if (comp[i].equals("sU22")) {
                column = 27;
            }
            if (comp[i].equals("sU23")) {
                column = 31;
            }
            if (comp[i].equals("sU33")) {
                column = 28;
            }
            if (comp[i].charAt(0) != 'A') continue;
            if (v.get(name) == null) {
                row = this.maindata.findIndex(Integer.parseInt(comp[i].substring(1)));
                continue;
            }
            return v.get(name);
        }
        return this.getVariable(row, column);
    }

    private Object[][] generateOutputs(Object[] inputs) {
        int[] rows = this.coordinateTable.getSelectedRows();
        Object[][] r = new Object[inputs.length][rows.length];
        boolean numbercolumn = false;
        FormulaEvaluator f = null;
        for (int i = 0; i < inputs.length; ++i) {
            if (inputs[i] == null) continue;
            if (Atom.DataClass[i].equals(Global.doubleclass.getClass()) || Atom.DataClass[i].equals(Global.integerclass.getClass())) {
                numbercolumn = true;
                f = (FormulaEvaluator)inputs[i];
            }
            for (int j = 0; j < rows.length; ++j) {
                if (numbercolumn) {
                    this.getVariables(f, rows[j], i);
                    double value = f.evaluateExpression();
                    if (Atom.DataClass[i].equals(Global.integerclass.getClass())) {
                        r[i][j] = (int)value;
                        continue;
                    }
                    r[i][j] = value;
                    continue;
                }
                r[i][j] = inputs[i];
            }
        }
        return r;
    }

    private Double getVariable(int row, int column) {
        if (Atom.DataClass[column].equals(Global.integerclass.getClass())) {
            return (double)((Integer)this.maindata.Atoms().get(row).TableData(column));
        }
        return (Double)this.maindata.Atoms().get(row).TableData(column);
    }

    private Object[] processInputs(String[] Inputs) {
        Object[] result = new Object[Inputs.length];
        for (int i = 0; i < Inputs.length; ++i) {
            if (Inputs[i] != null) {
                Class c = Atom.DataClass[i];
                try {
                    result[i] = c.equals(Global.integerclass.getClass()) || c.equals(Global.doubleclass.getClass()) ? new FormulaEvaluator(Inputs[i]) : Global.ConvertString(Inputs[i], c);
                    if (result[i] != null) continue;
                    throw new Exception(Inputs[i] + " is not in " + Atom.DataClass[i].getName() + " format");
                }
                catch (Exception e) {
                    String ErrorMessage = "Error Processing " + Atom.DataToolTip[i] + " text:\n" + e.getMessage();
                    JOptionPane.showMessageDialog(this, ErrorMessage, "Error Processing Inputs", 0);
                    return null;
                }
            }
            result[i] = null;
        }
        return result;
    }

    private String[] getUserInputs() {
        String[] result = new String[this.checkBoxes.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.checkBoxes[i].isSelected() ? this.valueFields[i].getText() : null;
        }
        return result;
    }

    private void GenerateHelpText() {
        StringBuilder sb = new StringBuilder();
        sb.append("This is used to change values of all the selected rows in column checked to edit\n");
        sb.append("Text columns can only chnage to a value you input\n");
        sb.append("\n");
        sb.append("Number columns allow following arithmetic operations : +, -, *, /, (, ) \n");
        sb.append("Number columns can extract numbers from other rows and columns\n");
        sb.append("  Example : \"L:x + 1/3\" is equivalent as set the all the selected rows to last row's fractional coordinate x of current row plus 1/3   \n");
        sb.append("\n");
        sb.append("Row selection Keywords\n");
        sb.append("L = Go to last row\n");
        sb.append("N = Go to next row\n");
        sb.append("A#### = Go to atom number ####\n");
        sb.append("\n");
        sb.append("Data selection Keywords\n");
        sb.append("X, Y, Z = Orthogonal coordinate X, Y, Z respectively\n");
        sb.append("x, y, z = Fractional coordinate x, y, z respectively\n");
        sb.append("B = Temperature factor\n");
        sb.append("O = Occupancy\n");
        sb.append("U11, U12, U13, U22, U23, U33 = Anisotropic temperature factors\n");
        sb.append("sX, sY, sZ = Sigma orthogonal coordinate X, Y, Z respectively\n");
        sb.append("sx, sy, sz = Sigma fractional coordinate x, y, z respectively\n");
        sb.append("sB = Sigma temperature factor\n");
        sb.append("sO = Sigma occupancy\n");
        sb.append("sU11, sU12, sU13, sU22, sU23, sU33 = Sigma anisotropic temperature factors\n");
        this.jTextAreaHelp.setText(sb.toString());
    }

    private void GenerateEntryFields() {
        GridBagConstraints gridBagConstraints;
        this.checkBoxes = new JCheckBox[Atom.DataList.length];
        this.valueFields = new JTextField[Atom.DataList.length];
        int splitpoint = Atom.DataToolTip.length / 2;
        int j = 0;
        for (int i = 0; i < this.checkBoxes.length; ++i) {
            this.checkBoxes[i] = new JCheckBox();
            this.checkBoxes[i].setText(Atom.DataToolTip[i]);
            this.checkBoxes[i].addKeyListener(this.commonKeyListener);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = i <= splitpoint ? 0 : 12;
            gridBagConstraints.gridwidth = 5;
            gridBagConstraints.gridy = j + 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 0, 0, 12);
            this.getContentPane().add((Component)this.checkBoxes[i], gridBagConstraints);
            this.valueFields[i] = new JTextField();
            this.valueFields[i].setPreferredSize(new Dimension(100, 20));
            class InputListener
            implements DocumentListener {
                private JCheckBox associatedCB = null;

                public InputListener(JCheckBox in) {
                    this.associatedCB = in;
                }

                public void insertUpdate(DocumentEvent e) {
                    this.associatedCB.setSelected(true);
                }

                public void removeUpdate(DocumentEvent e) {
                    if (e.getDocument().getLength() == 0) {
                        this.associatedCB.setSelected(false);
                    }
                }

                public void changedUpdate(DocumentEvent e) {
                    this.associatedCB.setSelected(true);
                    if (e.getDocument().getLength() == 0) {
                        this.associatedCB.setSelected(false);
                    }
                }
            }
            this.valueFields[i].getDocument().addDocumentListener(new InputListener(this.checkBoxes[i]));
            this.valueFields[i].addKeyListener(this.commonKeyListener);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = i <= splitpoint ? 5 : 17;
            gridBagConstraints.gridy = j + 1;
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.fill = 3;
            this.getContentPane().add((Component)this.valueFields[i], gridBagConstraints);
            if (i == this.checkBoxes.length - 1 || ++j <= splitpoint) continue;
            j = 0;
        }
        this.buttonOk = new JButton();
        this.buttonOk.setText("Apply");
        this.buttonOk.setPreferredSize(new Dimension(90, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 14;
        gridBagConstraints.gridy = splitpoint + 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.getContentPane().add((Component)this.buttonOk, gridBagConstraints);
        this.buttonOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditCoordinateDialog.this.ProcessChange();
            }
        });
        this.buttonCancel = new JButton();
        this.buttonCancel.setText("Close");
        this.buttonCancel.setPreferredSize(new Dimension(90, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 17;
        gridBagConstraints.gridy = splitpoint + 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.getContentPane().add((Component)this.buttonCancel, gridBagConstraints);
        this.buttonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditCoordinateDialog.this.dispose();
            }
        });
        this.buttonHelp = new JButton();
        this.buttonHelp.setText("Help");
        this.buttonHelp.setPreferredSize(new Dimension(90, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = splitpoint + 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.getContentPane().add((Component)this.buttonHelp, gridBagConstraints);
        this.jDialogHelp.setSize(new Dimension(500, 400));
        this.GenerateHelpText();
        this.buttonHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditCoordinateDialog.this.jDialogHelp.show();
            }
        });
    }

    private void initComponents() {
        this.jDialogHelp = new JDialog();
        this.jButtonHelpClose = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaHelp = new JTextArea();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jDialogHelp.setTitle("Edit Coordinate Help");
        this.jDialogHelp.setResizable(false);
        this.jButtonHelpClose.setText("Close");
        this.jButtonHelpClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditCoordinateDialog.this.jButtonHelpCloseActionPerformed(evt);
            }
        });
        this.jTextAreaHelp.setColumns(20);
        this.jTextAreaHelp.setLineWrap(true);
        this.jTextAreaHelp.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextAreaHelp);
        GroupLayout jDialogHelpLayout = new GroupLayout(this.jDialogHelp.getContentPane());
        this.jDialogHelp.getContentPane().setLayout(jDialogHelpLayout);
        jDialogHelpLayout.setHorizontalGroup(jDialogHelpLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialogHelpLayout.createSequentialGroup().addContainerGap().addGroup(jDialogHelpLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 466, Short.MAX_VALUE).addComponent(this.jButtonHelpClose, GroupLayout.Alignment.TRAILING, -2, 127, -2)).addContainerGap()));
        jDialogHelpLayout.setVerticalGroup(jDialogHelpLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialogHelpLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 287, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelpClose).addContainerGap(-1, Short.MAX_VALUE)));
        this.setDefaultCloseOperation(2);
        this.setTitle("Edit Coordinates");
        this.setMinimumSize(new Dimension(540, 530));
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent evt) {
                EditCoordinateDialog.this.formWindowClosed(evt);
            }

            public void windowClosing(WindowEvent evt) {
                EditCoordinateDialog.this.formWindowClosing(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.jLabel2.setText("Column");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText("New Value");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        this.getContentPane().add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setText("Column");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel5.setText("New Value");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 17;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jLabel5, gridBagConstraints);
        this.pack();
    }

    private void jButtonHelpCloseActionPerformed(ActionEvent evt) {
        this.jDialogHelp.hide();
    }

    private void formWindowClosed(WindowEvent evt) {
        this.jDialogHelp.dispose();
    }

    private void formWindowClosing(WindowEvent evt) {
    }

    class CommonKeyListener
    implements KeyListener {
        CommonKeyListener() {
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                EditCoordinateDialog.this.dispose();
            }
            if (e.getKeyCode() == 10) {
                EditCoordinateDialog.this.ProcessChange();
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    }
}

